/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.window;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.task.*;
import com.aibonware.viewnaver.view.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.content.message.*;

@SuppressWarnings("serial")
public class WriteMessageWindow extends JDialog implements ChildWindow {
	public WriteMessageView writeMessageView;

	JButton okButton = new JButton();
	JButton cancelButton = new JButton("Cancel");

	AbstractAction okAction = new AbstractAction("OK") {
		public void actionPerformed(ActionEvent e) {
			final String receiver = writeMessageView.receiverText.getText();
			final Country country = (Country)writeMessageView.countryCombo.getSelectedItem();
			final String messageText = writeMessageView.messageTextView.getText();
			final boolean saveServer = writeMessageView.saveServerCheck.isSelected();

			if(messageText.length() > 400) {
				System.out.println("bZ[Wl𒴂Ă܂");
			}

			TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();

			taskFlow.addStatusReceiver(createTaskStatusReceiver(taskFlow));
			
			taskFlow.execute(new WorkerTask() {
				public void exec() {
					try {
						ViewNaver.println("bZ[WMJn..");

						ViewNaver.instance.naverSession.sendMessage(
								receiver, 
								country, 
								messageText, 
								saveServer);

						ViewNaver.println("bZ[WMIB");

						WriteMessageWindow.this.dispose();

						taskFlow.execute(new GUITask() {
							public void exec() {
								ViewNaver.instance.mainWindow.containerView.update(SentMessageContent.getConstantCategory());
							} 
						});

					} catch(NetException e) {
						ViewNaver.err(e);
					}
				}
			});
		}
	};

	public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
		return new TaskStatusReceiver() {
			public void statusChanged(int status) {
				if(status == RUNNING) {
					okButton.setAction(new AbstractAction("~") {
						public void actionPerformed(ActionEvent e) {
							taskFlow.cancel();
						}
					});

					cancelButton.setEnabled(false);
					
				}  else if(status == FINISHED) {
					okButton.setAction(okAction);
					cancelButton.setEnabled(true);
				}
			}
		};
	}
	
	public WriteMessageWindow(JFrame parent, String receiver, Country country, String initialText) {
		super(parent);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		
		this.setTitle(receiver + " ւ̃bZ[WM");

		writeMessageView = new WriteMessageView();

		writeMessageView.receiverText.setText(receiver);
		writeMessageView.countryCombo.setSelectedItem(country);
		writeMessageView.messageTextView.setText(initialText);

		writeMessageView.setReceiverEditable(false);

		Box buttonBox = new Box(BoxLayout.LINE_AXIS);

		buttonBox.add(Box.createGlue());
		buttonBox.add(okButton);
		buttonBox.add(cancelButton);

		add(writeMessageView, BorderLayout.CENTER);
		add(buttonBox, BorderLayout.SOUTH);

		setBounds(200, 200, 500, 400);

		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				WriteMessageWindow.this.dispose();
			}
		});

		okButton.setAction(okAction);

		ViewNaver.instance.childWindowActivator.addChildWindow(this);
	}
}
