/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "stdafx.h"

#include <atlbase.h>
#include <atlcom.h>
#include <atldef.h>
#include <mshtml.h>
#define _ATL_DLL_IMPL
#include <atliface.h>
#include <exdisp.h>
#include <exdispid.h>

class SecurityManager;
class BrowserInfo;

DWORD ThreadID = 0;
JNIEnv *jnienv = NULL;
jclass jniclass = NULL;

void ThrowJavaException(JNIEnv *env, const char *format, ...)
{
	va_list valist;
	va_start(valist, format);

	char errorMessage[1000];
	vsprintf(errorMessage, format, valist);

	jclass exceptionClass = env->FindClass("java/lang/Exception");
	env->ThrowNew(exceptionClass, errorMessage);

	va_end(valist);
}

void sendlog(const char *format, ...) 
{
	va_list valist;
	va_start(valist, format);

//	char message[1000];
//	WCHAR wmessage[2000];

//	vprintf(format, valist);
//	printf("\n");
//	vsprintf(message, format, valist);
/*
	MultiByteToWideChar(CP_ACP, 0, message, -1, wmessage, 1000);

	jstring jmessage = jnienv->NewString(wmessage, lstrlenW(wmessage));

	jmethodID methodid = jnienv->GetStaticMethodID(jniclass, "receiveLog", "(Ljava/lang/String;)V");
	jboolean mustContinue = jnienv->CallStaticBooleanMethod(jniclass, methodid, jmessage);

	jnienv->ReleaseStringChars(jmessage, wmessage);
*/
	va_end(valist);
}


class ATL_NO_VTABLE SecurityManager:
	public CComObjectRootEx<CComSingleThreadModel>,
	public IInternetSecurityManager, IServiceProvider
{
public:
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(SecurityManager)
  COM_INTERFACE_ENTRY(IInternetSecurityManager)
  COM_INTERFACE_ENTRY(IServiceProvider)
END_COM_MAP()

	int policyNum;
	DWORD *policies;

	HRESULT FinalConstruct( )
	{
		policyNum = 0;
		policies = NULL;
		return S_OK;
	}

	HRESULT FinalRelease() {
		if(policies != NULL) {
			SecureZeroMemory(policies, sizeof(int) * policyNum);
			free(policies);
		}

		return S_OK;
	}

	STDMETHOD(GetSecurityId)(
		LPCWSTR pwszUrl,
		BYTE *pbSecurityId,
		DWORD *pcbSecurityId,
		DWORD_PTR dwReserved)
	{
		return INET_E_DEFAULT_ACTION;
	}

	STDMETHOD(GetSecuritySite)(
		IInternetSecurityMgrSite **ppSite)
	{
		return INET_E_DEFAULT_ACTION;
	}

	STDMETHOD(GetZoneMappings)(
		DWORD dwZone,
		IEnumString **ppenumString,
		DWORD dwFlags)
	{
		return INET_E_DEFAULT_ACTION;
	}

	STDMETHOD(MapUrlToZone)(
		LPCWSTR pwszUrl,
		DWORD *pdwZone,
		DWORD dwFlags)
	{
		return INET_E_DEFAULT_ACTION;
//		*pdwZone = URLZONE_LOCAL_MACHINE;
//		*pdwZone = URLZONE_INTRANET;
//		return S_OK;
	}

	STDMETHOD(QueryCustomPolicy)(
		LPCWSTR pwszUrl,
		REFGUID guidKey,
		BYTE **ppPolicy,
		DWORD *pcbPolicy,
		BYTE *pContext,
		DWORD cbContext,
		DWORD dwReserved)
	{
		return INET_E_DEFAULT_ACTION;
	}

	STDMETHOD(SetSecuritySite)(
		IInternetSecurityMgrSite *pSite)
	{
		return INET_E_DEFAULT_ACTION;
	}

	STDMETHOD(SetZoneMapping)(
		DWORD dwZone,
		LPCWSTR lpszPattern,
		DWORD dwFlags)
	{
		return INET_E_DEFAULT_ACTION;
	}

	STDMETHOD(ProcessUrlAction)(
		LPCWSTR pwszUrl,
		DWORD dwAction,
		BYTE *pPolicy,
		DWORD cbPolicy,
		BYTE *pContext,
		DWORD cbContext,
		DWORD dwFlags,
		DWORD dwReserved)
	{
		if(policies == NULL) {
			sendlog("browser: policies == NULL");

			ZeroMemory(pPolicy, cbPolicy);
			*pPolicy = URLPOLICY_DISALLOW;
			return E_FAIL;
		}

		for(int i=0; i<policyNum; i++) {
			DWORD minAction = policies[i*3];
			DWORD maxAction = policies[i*3+1];
			DWORD policy = policies[i*3+2];

			if(minAction <= dwAction && dwAction <= maxAction) {
				memcpy(pPolicy, &policy, cbPolicy);

				sendlog("browser: action=%08x, min=%08x, max=%08x, policy=%08x", dwAction, minAction, maxAction, policy);
				return (policy == URLPOLICY_ALLOW ? S_OK : E_FAIL);
			}
		}

		sendlog("browser: unmatch action: %08x", dwAction);

		ZeroMemory(pPolicy, cbPolicy);
		*pPolicy = URLPOLICY_DISALLOW;
		return E_FAIL;
/*
		ZeroMemory(pPolicy, cbPolicy);
		*pPolicy = URLPOLICY_ALLOW;
		return S_OK;
*/	}

	STDMETHOD(QueryService)(
		REFGUID guidService,
		REFIID riid,
		void **ppv)
	{
		if(guidService == IID_IInternetSecurityManager) {
			this->QueryInterface(riid, ppv);
			return S_OK;
		} else {
			return E_NOINTERFACE;
		}
	}
};

class ATL_NO_VTABLE BrowserSink:
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispEventImpl<0, BrowserSink, &DIID_DWebBrowserEvents2, &LIBID_SHDocVw, 1, 0>
{
public:
BEGIN_COM_MAP(BrowserSink)
	COM_INTERFACE_ENTRY_IID(DIID_DWebBrowserEvents2, BrowserSink)
END_COM_MAP()

BEGIN_SINK_MAP(BrowserSink)
	SINK_ENTRY_EX(0, DIID_DWebBrowserEvents2, DISPID_BEFORENAVIGATE2, BeforeNavigate2)
END_SINK_MAP()

	BrowserInfo *pBrowserInfo;

	BrowserSink() {}

	void _stdcall BeforeNavigate2(
		IDispatch *pDisp,
		VARIANT *url,
		VARIANT *Flags,
		VARIANT *TargetFrameName,
		VARIANT *PostData,
		VARIANT *Headers,
		VARIANT_BOOL *Cancel) 
	{
		CComBSTR burl;

		jstring jurl = jnienv->NewString(url->bstrVal, lstrlenW(url->bstrVal));
		jint hBrowser = (jint)pBrowserInfo;

		jmethodID methodid = jnienv->GetStaticMethodID(jniclass, "beforeNavigate2", "(ILjava/lang/String;)Z");
		jboolean mustContinue = jnienv->CallStaticBooleanMethod(jniclass, methodid, hBrowser, jurl);

		jnienv->ReleaseStringChars(jurl, url->bstrVal);

		if(!mustContinue) {
			*Cancel = VARIANT_TRUE;
		} else {
			*Cancel = VARIANT_FALSE;
		}
	}
};

class BrowserInfo {
public:
	HWND hParentWnd;
	HWND hBrowserWnd;
	CComQIPtr<IWebBrowser2> comBrowser;
	CComObject<BrowserSink> *sink;

	BrowserInfo(HWND hParentWnd, HWND hBrowserWnd, IWebBrowser2 *piBrowser) {
		this->hParentWnd = hParentWnd;
		this->hBrowserWnd = hBrowserWnd;
		comBrowser = piBrowser;

		CComObject<BrowserSink>::CreateInstance(&sink);
		sink->pBrowserInfo = this;
		sink->AddRef();
		sink->DispEventAdvise(comBrowser);
	}

	virtual ~BrowserInfo() {
		sink->DispEventUnadvise(comBrowser);
		sink->Release();
	}
};

class BrowserList {
public:
	BrowserInfo *list[10000];
	int num;

	BrowserList() {
		num = 0;
	}

	void add(BrowserInfo *info) {
		list[num++] = info;
	}

	int indexOf(BrowserInfo *info) {
		for(int i=0; i<num; i++) {
			if(list[i] == info) return i;
		}

		return -1;
	}

	void remove(BrowserInfo *info) {
		int pos = indexOf(info);

		if(pos == -1) return;

		if(pos == num-1) {
			num--;
			return;
		}

		memmove(&list[pos], &list[pos+1], sizeof(BrowserInfo *) * (num-pos-1));
	}

	BrowserInfo *findByHWnd(HWND hWnd) {
		for(int i=0; i<num; i++) {
//			printf("check %08x %08x", hWnd, list[i]->hBrowserWnd);
			if(list[i]->hBrowserWnd == hWnd) {
				return list[i];
			}
		}

		return NULL;
	}

	BrowserInfo *findAncestor(HWND hCurWnd) {
		for(;;) {
			hCurWnd = GetParent(hCurWnd);
			if(hCurWnd == NULL) return NULL;

			BrowserInfo *pBrowserInfo = findByHWnd(hCurWnd);

			if(pBrowserInfo != NULL) return pBrowserInfo;
		}
	}
};

BrowserList browsers;

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_messageLoop
  (JNIEnv *env, jclass clazz)
{
	ThreadID = GetCurrentThreadId();
	jnienv = env;
	jniclass = clazz;
	HRESULT hr;
	BrowserInfo *pBrowserInfo = NULL;

	MSG msg;

	while (GetMessage(&msg, NULL, NULL, NULL) != 0) {
		switch(msg.message) {
		case WM_KEYDOWN:
			pBrowserInfo = browsers.findAncestor(msg.hwnd);

			if(pBrowserInfo != NULL) {
				CComQIPtr<IOleInPlaceActiveObject, &IID_IOleInPlaceActiveObject> pOleInPlaceActiveObject(pBrowserInfo->comBrowser);

				if(pOleInPlaceActiveObject != NULL) {
					hr = pOleInPlaceActiveObject->TranslateAccelerator(&msg);

					if(SUCCEEDED(hr)) {
						TranslateMessage(&msg);
						continue;
					}
				}
			}
			break;

		case MSG_EXEC_COMMAND:
			switch(msg.wParam) {
			case CMD_EXIT_LOOP:
				goto EXIT;
			default:
				continue;
			}
		}

		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

EXIT:;
}

/*
		case WM_MOUSEMOVE:
			hParentWnd = ::GetParent(msg.hwnd);

			if(hParentWnd != NULL) {
				PostThreadMessage(
					GetWindowThreadProcessId(hParentWnd, NULL),
					msg.message,
					msg.wParam,
					msg.lParam);
			}

			// continue to default...
*/

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_postMessage
  (JNIEnv *env, jclass clazz, jint msg, jint wparam, jint lparam)
{
	PostThreadMessage(ThreadID, msg, wparam, lparam);
}

JNIEXPORT jint JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_createBrowser
  (JNIEnv *env, jclass clazz, jobject canvas, jintArray jpolicies)
{
    JAWT awt;
    JAWT_DrawingSurface* ds;
    JAWT_DrawingSurfaceInfo* dsi;
	JAWT_Win32DrawingSurfaceInfo* dsi_win32;
    jint lock = JAWT_LOCK_ERROR;
	BrowserInfo *pBrowserInfo = NULL;
	CComPtr<IWebBrowser2> comBrowser;
	IUnknown *pUnk = NULL, *pUnk2 = NULL;
	HWND hBrowserWnd;
	CComVariant ve;
	CComVariant vurl("about:blank");
	HRESULT hr;
	CComPtr<IObjectWithSite> comSite;
	jsize policyNum;
	jint *policies = NULL;
	CComObject<SecurityManager> *secmgr;

	policyNum = env->GetArrayLength(jpolicies);
	policies = env->GetIntArrayElements(jpolicies, NULL);

	if(!AtlAxWinInit()) {
		ThrowJavaException(env, "AtlAxWinInit(%08x)", GetLastError());
		goto Exit;
	}

	awt.version = JAWT_VERSION_1_3;

	if(JAWT_GetAWT(env, &awt) == JNI_FALSE) {
		ThrowJavaException(env, "JAWT_GetAWT == JNI_FALSE", GetLastError());
		goto Exit;
	}

	ds = awt.GetDrawingSurface(env, canvas);

	if(ds == NULL) {
		ThrowJavaException(env, "GetDrawingSurface == NULL", GetLastError());
		goto Exit;
	}

	lock = ds->Lock(ds);

	if((lock & JAWT_LOCK_ERROR) != 0) {
		ThrowJavaException(env, "JAWT_DrawingSurface::Lock == JAWT_LOCK_ERROR", GetLastError());
		goto Exit;
	}

	dsi = ds->GetDrawingSurfaceInfo(ds);

	if(dsi == NULL) {
		ThrowJavaException(env, "JAWT_DrawingSurface::GetDrawingSurfaceInfo == NULL", GetLastError());
		goto Exit;
	}

	dsi_win32 = (JAWT_Win32DrawingSurfaceInfo *)dsi->platformInfo;

	hBrowserWnd = ::CreateWindow("AtlAxWin", "Shell.Explorer.1", 
		WS_CHILD | WS_VISIBLE, 0, 0, 0, 0, dsi_win32->hwnd, NULL, ::GetModuleHandle(NULL), NULL);

	if(hBrowserWnd == NULL && GetLastError() == ERROR_CANNOT_FIND_WND_CLASS) {
		hBrowserWnd = ::CreateWindow("AtlAxWin7", "Shell.Explorer.1", 
			WS_CHILD | WS_VISIBLE, 0, 0, 0, 0, dsi_win32->hwnd, NULL, ::GetModuleHandle(NULL), NULL);
	}

	if(hBrowserWnd == NULL && GetLastError() == ERROR_CANNOT_FIND_WND_CLASS) {
		hBrowserWnd = ::CreateWindow("AtlAxWin71", "Shell.Explorer.1", 
			WS_CHILD | WS_VISIBLE, 0, 0, 0, 0, dsi_win32->hwnd, NULL, ::GetModuleHandle(NULL), NULL);
	}

	if(hBrowserWnd == NULL) {
		ThrowJavaException(env, "CreateWindow(%d), parent=%08x", GetLastError(), dsi_win32->hwnd);
		goto Exit;
	}

	hr = AtlAxGetControl(hBrowserWnd, &pUnk);

	if(pUnk == NULL) {
		ThrowJavaException(env, "AtlAxGetControl(%08x)", hr);
		goto Exit;
	}

	hr = pUnk->QueryInterface(IID_IWebBrowser2, (void**)&comBrowser);

	if(comBrowser == NULL) {
		ThrowJavaException(env, "QueryInterface(IID_IWebBrowser2)(%08x)", hr);
		goto Exit;
	}

	hr = AtlAxGetHost(hBrowserWnd, &pUnk2);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "AtlAxGetHost (%08x)", hr);
		goto Exit;
	}

	hr = pUnk2->QueryInterface(IID_IObjectWithSite, (void **)&comSite);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "QueryInterface(IID_IObjectWithSite) (%08x)", hr);
		goto Exit;
	}

	hr = CComObject<SecurityManager>::CreateInstance(&secmgr);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "CComObject<SecurityManager>::CreateInstance (%08x)", hr);
		goto Exit;
	}

	secmgr->AddRef();
	secmgr->policyNum = policyNum;
	secmgr->policies =(DWORD *)malloc(sizeof(DWORD) * policyNum);
	memcpy(secmgr->policies, policies, sizeof(DWORD) * policyNum);

	IUnknown *punksecmgr;
	secmgr->QueryInterface(&punksecmgr);

	hr = comSite->SetSite(punksecmgr);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "SetSize (%08x)", hr);
		goto Exit;
	}

	hr = comBrowser->put_Visible(VARIANT_TRUE);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "put_Visible (%08x)", hr);
		goto Exit;
	}

	hr = comBrowser->Navigate2(&vurl, &ve, &ve, &ve, &ve);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "Navigate2 %08x", hr);
		goto Exit;
	}

	pBrowserInfo = new BrowserInfo(dsi_win32->hwnd, hBrowserWnd, comBrowser);

	browsers.add(pBrowserInfo);

Exit:
	if((lock & JAWT_LOCK_ERROR) == 0) ds->Unlock(ds);
	if(ds != NULL) awt.FreeDrawingSurface(ds);
	env->ReleaseIntArrayElements(jpolicies, policies, 0);

	return (jint)pBrowserInfo;
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_writeDocHtml
  (JNIEnv *env, jclass clazz, jint hBrowser, jstring jhtml)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	HRESULT hr;

	const jchar *uni;

	uni = env->GetStringChars(jhtml, NULL);

	int len = lstrlenW(uni);

	BSTR bstr = SysAllocString(uni);

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	VARIANT *param;
	SAFEARRAY *array;

	uni = env->GetStringChars(jhtml, NULL);
	bstr = SysAllocString(uni);

	array = SafeArrayCreateVector(VT_VARIANT, 0, 1);
	SafeArrayAccessData(array, (void **)&param);
	param->vt = VT_BSTR;
	param->bstrVal = bstr;
	SafeArrayUnaccessData(array);

	hr = doc->write(array);

	SysFreeString(bstr);

	SafeArrayAccessData(array, (void **)&param);
	param->vt = VT_EMPTY;
	param->bstrVal = NULL;
	SafeArrayUnaccessData(array);

	SafeArrayDestroy(array);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->write %08x", hr);
	}
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_closeDocHtml
  (JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	HRESULT hr;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	hr = doc->close();

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->close %08x", hr);
	}
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_clearDocHtml
  (JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	HRESULT hr;

	CComBSTR emptyStr(L"");

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	VARIANT *param;
	SAFEARRAY *array;

	hr = doc->close();

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->close %08x", hr);
		goto Exit;
	}

	array = SafeArrayCreateVector(VT_VARIANT, 0, 1);
	SafeArrayAccessData(array, (void **)&param);
	param->vt = VT_BSTR;
	param->bstrVal = emptyStr;
	SafeArrayUnaccessData(array);

	hr = doc->write(array);

	SafeArrayAccessData(array, (void **)&param);
	param->vt = VT_EMPTY;
	param->bstrVal = NULL;
	SafeArrayUnaccessData(array);

	SafeArrayDestroy(array);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->write %08x", hr);
	}

Exit:;
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_destroyBrowser
  (JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	DestroyWindow(pBrowserInfo->hBrowserWnd);
	browsers.remove(pBrowserInfo);
	delete pBrowserInfo;
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_resizeBrowser
  (JNIEnv *env, jclass clazz, jint hBrowser, jint width, jint height)
{
    RECT rc;

	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	HWND hParentWnd = pBrowserInfo->hParentWnd;

    if(hParentWnd != NULL) {
        GetWindowRect(hParentWnd, &rc);
        HWND hwndChild = GetWindow(hParentWnd, GW_CHILD);

        SetWindowPos(
			hwndChild, NULL,
			0, 0, rc.right-rc. left, rc.bottom-rc.top,
			SWP_NOZORDER | SWP_NOACTIVATE | SWP_SHOWWINDOW | SWP_NOMOVE);
	}
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setBodyHtml
  (JNIEnv *env, jclass clazz, jint hBrowser, jstring jhtml)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	CComPtr<IHTMLElement> body;
	HRESULT hr;

	const jchar *uni;

	uni = env->GetStringChars(jhtml, NULL);
	BSTR bstr = SysAllocString(uni);

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	hr = doc->get_body(&body);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->get_body %08x", hr);
		return;
	}

	hr = body->put_innerHTML(bstr);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "body->put_innerHTML %08x", hr);
		return;
	}

	SysFreeString(bstr);	
	env->ReleaseStringChars(jhtml, uni);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_insertBodyHtml
  (JNIEnv *env, jclass clazz, jint hBrowser, jstring jtagid, jstring jhtml)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	CComPtr<IHTMLElement> body;
	CComQIPtr<IHTMLElementCollection> col;
	CComQIPtr<IHTMLElementCollection3> col3;
	CComQIPtr<IHTMLElementCollection> results;
	CComQIPtr<IHTMLElement> elem;
	HRESULT hr;

	const jchar *utagid = env->GetStringChars(jtagid, NULL);
	const jchar *uhtml = env->GetStringChars(jhtml, NULL);

	BSTR btagid = SysAllocString(utagid);
	BSTR bhtml = SysAllocString(uhtml);
	BSTR bwhere = SysAllocString(OLESTR("afterEnd"));

	pBrowserInfo->comBrowser->get_Document(&disp);

	doc = disp;

	hr = doc->get_all(&col);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->get_all %08x", hr);
		return;
	}	

	col3 = col;
	disp = NULL;

	hr = col3->namedItem(btagid, &disp);

	results = disp;

	if(results != NULL) {
		long len;
		results->get_length(&len);

		if(len > 0) {
			CComVariant vIndex(len-1);
			hr = results->item(vIndex, vIndex, &disp);
			elem = disp;
		}
	} else {
		elem = disp;
	}

	if(elem != NULL) {
		hr = elem->insertAdjacentHTML(bwhere, bhtml);

		if(!SUCCEEDED(hr)) {
			ThrowJavaException(env, "elem->insertAdjacentHTML %08x", hr);
			return;
		}	
	}

	SysFreeString(bwhere);
	SysFreeString(btagid);
	SysFreeString(bhtml);

	env->ReleaseStringChars(jtagid, utagid);
	env->ReleaseStringChars(jhtml, uhtml);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_replaceBodyHtml
  (JNIEnv *env, jclass clazz, jint hBrowser, jstring jtagid, jstring jhtml)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	CComPtr<IHTMLElement> body;
	CComQIPtr<IHTMLElementCollection> col;
	CComQIPtr<IHTMLElementCollection3> col3;
	CComQIPtr<IHTMLElementCollection> results;
	CComQIPtr<IHTMLElement> elem;
	HRESULT hr;

	const jchar *utagid = env->GetStringChars(jtagid, NULL);
	const jchar *uhtml = env->GetStringChars(jhtml, NULL);

	BSTR btagid = SysAllocString(utagid);
	BSTR bhtml = SysAllocString(uhtml);
	BSTR bwhere = SysAllocString(OLESTR("afterEnd"));

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;
	doc->get_all(&col);
	col3 = col;
	disp = NULL;

	col3->namedItem(btagid, &disp);

	results = disp;

	if(results != NULL) {
		long len;
		results->get_length(&len);

		if(len > 0) {
			CComVariant vIndex(len-1);
			hr = results->item(vIndex, vIndex, &disp);
			elem = disp;
		}
	} else {
		elem = disp;
	}

	if(disp != NULL) {
		hr = elem->put_innerHTML(bhtml);

		if(!SUCCEEDED(hr)) {
			ThrowJavaException(env, "elem->put_innerHTML %08x", hr);
			return;
		}	
	}

	SysFreeString(bwhere);
	SysFreeString(btagid);
	SysFreeString(bhtml);

	env->ReleaseStringChars(jtagid, utagid);
	env->ReleaseStringChars(jhtml, uhtml);
}

JNIEXPORT jstring JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_getBodyHtml
  (JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	CComPtr<IHTMLElement> body;
	HRESULT hr;

	BSTR bstr;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;
	doc->get_body(&body);

	hr = body->get_innerHTML(&bstr);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "body->get_innerHTML %08x", hr);
		return NULL;
	}	

	jstring jhtml = env->NewString(bstr, lstrlenW(bstr));
	
	SysFreeString(bstr);
	return jhtml;
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setEditable
  (JNIEnv *env, jclass clazz, jint hBrowser, jboolean editable)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	CComBSTR bon(L"On");
	CComBSTR boff(L"Off");
	HRESULT hr;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	if(editable) {
		hr = doc->put_designMode(bon);
	} else {
		hr = doc->put_designMode(boff);
	}

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->put_designMode %08x", hr);
		return;
	}	
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_toggleBold
  (JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	CComBSTR boldCmd(L"Bold");
	CComVariant ve;

	doc->execCommand(boldCmd, VARIANT_TRUE, ve, NULL);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_insertHR
  (JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	CComVariant ve;
	CComBSTR hrCmd(L"InsertHorizontalRule");

	doc->execCommand(hrCmd, VARIANT_TRUE, ve, NULL);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_toggleItalic
  (JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	CComVariant ve;
	CComBSTR italicCmd(L"Italic");

	doc->execCommand(italicCmd, VARIANT_TRUE, ve, NULL);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_toggleUnderLine
  (JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	CComVariant ve;
	CComBSTR underLineCmd(L"Underline");

	doc->execCommand(underLineCmd, VARIANT_TRUE, ve, NULL);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setFontName
  (JNIEnv *env, jclass clazz, jint hBrowser, jstring jfontName)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	const jchar *ufontName = env->GetStringChars(jfontName, NULL);

	CComVariant vfontName(ufontName);
	CComBSTR fontNameCmd(L"FontName");

	doc->execCommand(fontNameCmd, VARIANT_FALSE, vfontName, NULL);

	env->ReleaseStringChars(jfontName, ufontName);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setFontSize
  (JNIEnv *env, jclass clazz, jint hBrowser, jstring jfontSize)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	const jchar *ufontSize = env->GetStringChars(jfontSize, NULL);

	CComVariant vfontSize(ufontSize);
	CComBSTR fontSizeCmd(L"FontSize");

	doc->execCommand(fontSizeCmd, VARIANT_FALSE, vfontSize, NULL);

	env->ReleaseStringChars(jfontSize, ufontSize);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_setColor
  (JNIEnv *env, jclass clazz, jint hBrowser, jstring jcolor)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	const jchar *ucolor = env->GetStringChars(jcolor, NULL);

	CComVariant vcolor(ucolor);
	CComBSTR colorCmd(L"ForeColor");

	doc->execCommand(colorCmd, VARIANT_FALSE, vcolor, NULL);

	env->ReleaseStringChars(jcolor, ucolor);
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_scrollTop
	(JNIEnv *env, jclass clazz, jint hBrowser, jstring jtagid)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	CComPtr<IHTMLElement> body;
	CComQIPtr<IHTMLElementCollection> col;
	CComQIPtr<IHTMLElementCollection3> col3;
	CComQIPtr<IHTMLElementCollection> results;
	CComQIPtr<IHTMLElement> elem;
	HRESULT hr;

	const jchar *utagid = env->GetStringChars(jtagid, NULL);
	BSTR btagid = SysAllocString(utagid);

	pBrowserInfo->comBrowser->get_Document(&disp);

	doc = disp;

	hr = doc->get_all(&col);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->get_all %08x", hr);
		return;
	}	

	col3 = col;
	disp = NULL;

	hr = col3->namedItem(btagid, &disp);

	results = disp;

	if(results != NULL) {
		long len;
		results->get_length(&len);

		if(len > 0) {
			CComVariant vIndex(len-1);
			hr = results->item(vIndex, vIndex, &disp);
			elem = disp;
		}
	} else {
		elem = disp;
	}

	if(elem != NULL) {
		CComVariant vTrue(true);

		hr = elem->scrollIntoView(vTrue);

		if(!SUCCEEDED(hr)) {
			ThrowJavaException(env, "elem->scrollIntoView %08x", hr);
			return;
		}	
	}

	SysFreeString(btagid);

	env->ReleaseStringChars(jtagid, utagid);

}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_refreshBrowser
	(JNIEnv *env, jclass clazz, jint hBrowser)
{
	HRESULT hr;
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;

	CComVariant vLevel(REFRESH_NORMAL);

	hr = pBrowserInfo->comBrowser->Refresh2(&vLevel);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "pBrowserInfo->comBrowser->Refresh2 %08x", hr);
		return;
	}
}

JNIEXPORT void JNICALL Java_com_aibonware_viewnaver_browser_win32_Win32BrowserThread_resetBrowser
	(JNIEnv *env, jclass clazz, jint hBrowser)
{
	BrowserInfo *pBrowserInfo = (BrowserInfo *)hBrowser;
	CComPtr<IDispatch> disp;
	CComQIPtr<IHTMLDocument2> doc;
	CComQIPtr<IHTMLElementCollection> col;
	HRESULT hr;
	CComVariant vHtmlTag(L"HTML");
	CComQIPtr<IHTMLElement> elem;


	BSTR bstr;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	if(doc == NULL) {
		ThrowJavaException(env, "doc == NULL");
		return;
	}

	hr = doc->get_all(&col);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->get_all(&col) %08x", hr);
		return;
	}

	disp = NULL;
	hr = col->tags(vHtmlTag, &disp);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, " col->tags(vHtmlTag, &disp) %08x", hr);
		return;
	}

	col = disp;

	if(col == NULL) {
		ThrowJavaException(env, "col == NULL");
		return;
	}

	disp = NULL;
	CComVariant vZero(0L);

	hr = col->item(vZero, vZero, &disp);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "col->item(vZero, vZero, &disp) %08x", hr);
		return;
	}
	
	elem = disp;

	if(elem == NULL) {
		ThrowJavaException(env, "elem == NULL");
		return;
	}

	hr = elem->get_outerHTML(&bstr);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "docElem->get_outerHTML %08x", hr);
		return;
	}

	CComVariant ve;
	CComVariant vurl("about:blank");
/*
	hr = pBrowserInfo->comBrowser->Navigate2(&vurl, &ve, &ve, &ve, &ve);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "comBrowser->Navigate2 %08x", hr);
		return;
	}
*/
	disp = NULL;

	pBrowserInfo->comBrowser->get_Document(&disp);
	doc = disp;

	hr = doc->close();
	
	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->close() %08x", hr);
		return;
	}

	SAFEARRAY *array;
	VARIANT *param;

	array = SafeArrayCreateVector(VT_VARIANT, 0, 1);
	SafeArrayAccessData(array, (void **)&param);
	param->vt = VT_BSTR;
	param->bstrVal = bstr;
	SafeArrayUnaccessData(array);

	hr = doc->write(array);

	if(!SUCCEEDED(hr)) {
		ThrowJavaException(env, "doc->write %08x", hr);
		return;
	}

	SysFreeString(bstr);	

	SafeArrayAccessData(array, (void **)&param);
	param->vt = VT_EMPTY;
	param->bstrVal = NULL;
	SafeArrayUnaccessData(array);
	
	SafeArrayDestroy(array);
}
