/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.Serve;
import Acme.Serve.ServeInputStream;
import Acme.Serve.ServeOutputStream;
import Acme.Serve.ServeUtils;
import Acme.Serve.servlet.Servlet;
import Acme.Serve.servlet.ServletException;
import Acme.Serve.servlet.ServletInputStream;
import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.Cookie;
import Acme.Serve.servlet.http.HttpServlet;
import Acme.Serve.servlet.http.HttpServletRequest;
import Acme.Serve.servlet.http.HttpServletResponse;
import Acme.Serve.servlet.http.HttpSession;
import Acme.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class ServeConnection
implements Runnable,
HttpServletRequest,
HttpServletResponse {
    private Socket socket;
    private Serve serve;
    private ServletInputStream in;
    private ServletOutputStream out;
    private Vector cookies = new Vector();
    private String reqMethod = null;
    private String reqUriPath = null;
    private String reqProtocol = null;
    private boolean oneOne;
    private boolean reqMime;
    String reqQuery = null;
    private Vector reqHeaderNames = new Vector();
    private Vector reqHeaderValues = new Vector();
    Vector queryNames = null;
    Vector queryValues = null;
    private int resCode = -1;
    private String resMessage = null;
    private Vector resHeaderNames = new Vector();
    private Vector resHeaderValues = new Vector();
    private static final String[] weekdays = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private boolean headersWritten = false;

    public ServeConnection(Socket socket, Serve serve) {
        this.socket = socket;
        this.serve = serve;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        try {
            this.in = new ServeInputStream(this.socket.getInputStream());
            this.out = new ServeOutputStream(this.socket.getOutputStream(), this);
        }
        catch (IOException e) {
            this.problem("Getting streams: " + e.getMessage(), 400);
        }
        this.parseRequest();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseRequest() {
        byte[] lineBytes = new byte[4096];
        try {
            String host;
            int len = this.in.readLine(lineBytes, 0, lineBytes.length);
            if (len == -1 || len == 0) {
                this.problem("Empty request", 400);
                return;
            }
            String line = new String(lineBytes, 0, len, "Shift_JIS");
            String[] tokens = Utils.splitStr(line);
            switch (tokens.length) {
                case 2: {
                    this.reqProtocol = "HTTP/0.9";
                    this.oneOne = false;
                    this.reqMime = false;
                    break;
                }
                case 3: {
                    this.reqProtocol = tokens[2];
                    this.oneOne = !this.reqProtocol.toUpperCase().equals("HTTP/1.0");
                    this.reqMime = true;
                    while ((len = this.in.readLine(lineBytes, 0, lineBytes.length)) != -1 && len != 0) {
                        line = new String(lineBytes, 0, len, "Shift_JIS");
                        int colonBlank = line.indexOf(": ");
                        if (colonBlank == -1) continue;
                        String name = line.substring(0, colonBlank);
                        String value = line.substring(colonBlank + 2);
                        this.reqHeaderNames.addElement(name.toLowerCase());
                        this.reqHeaderValues.addElement(value);
                    }
                    break;
                }
                default: {
                    this.problem("Malformed request line", 400);
                    return;
                }
            }
            this.reqMethod = tokens[0];
            this.reqUriPath = tokens[1];
            if (this.oneOne && (host = this.getHeader("host")) == null) {
                this.problem("Host header missing on HTTP/1.1 request", 400);
                return;
            }
            int qmark = this.reqUriPath.indexOf(63);
            if (qmark != -1) {
                this.reqQuery = this.reqUriPath.substring(qmark + 1);
                this.reqUriPath = this.reqUriPath.substring(0, qmark);
            }
            this.reqUriPath = this.decode(this.reqUriPath);
            Servlet servlet = (Servlet)this.serve.registry.get(this.reqUriPath);
            if (servlet != null) {
                this.runServlet((HttpServlet)servlet);
            }
        }
        catch (IOException e) {
            this.problem("Reading request: " + e.getMessage(), 400);
        }
    }

    private void runServlet(HttpServlet servlet) {
        this.setStatus(200);
        this.setDateHeader("Date", System.currentTimeMillis());
        this.setHeader("Server", "Acme.Serve/v1.7 of 13nov96");
        this.setHeader("Connection", "close");
        try {
            servlet.service(this, this);
        }
        catch (IOException e) {
            this.problem("IO problem running servlet: " + e.toString(), 400);
        }
        catch (ServletException e) {
            this.problem("problem running servlet: " + e.toString(), 400);
        }
        catch (Exception e) {
            this.problem("unexpected problem running servlet: " + e.toString(), 500);
        }
    }

    private void problem(String logMessage, int resCode) {
        this.serve.log(logMessage);
        try {
            this.sendError(resCode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String decode(String str) {
        StringBuffer result = new StringBuffer();
        int l = str.length();
        int i = 0;
        while (i < l) {
            char c = str.charAt(i);
            if (c == '%' && i + 2 < l) {
                char c1 = str.charAt(i + 1);
                char c2 = str.charAt(i + 2);
                if (this.isHexit(c1) && this.isHexit(c2)) {
                    result.append((char)(this.hexit(c1) * 16 + this.hexit(c2)));
                    i += 2;
                } else {
                    result.append(c);
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private boolean isHexit(char c) {
        String legalChars = "0123456789abcdefABCDEF";
        return legalChars.indexOf(c) != -1;
    }

    private int hexit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return 0;
    }

    public int getContentLength() {
        return this.getIntHeader("content-length", -1);
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public String getProtocol() {
        return this.reqProtocol;
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public int getServerPort() {
        return this.socket.getLocalPort();
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().toString();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getRealPath(String path) {
        return this.serve.getRealPath(path);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.in;
    }

    public BufferedReader getReader() {
        return null;
    }

    public Enumeration getParameterNames() {
        if (this.queryNames == null) {
            this.queryNames = new Vector();
            this.queryValues = new Vector();
            String qs = this.getQueryString();
            if (qs != null) {
                StringTokenizer en = new StringTokenizer(qs, "&");
                while (en.hasMoreElements()) {
                    String value;
                    String name;
                    String nv = (String)en.nextElement();
                    int eq = nv.indexOf(61);
                    if (eq == -1) {
                        name = nv;
                        value = "";
                    } else {
                        name = nv.substring(0, eq);
                        value = nv.substring(eq + 1);
                    }
                    this.queryNames.addElement(name);
                    this.queryValues.addElement(value);
                }
            }
        }
        return this.queryNames.elements();
    }

    public String getParameter(String name) {
        Enumeration en = this.getParameterNames();
        int i = this.queryNames.indexOf(name);
        if (i == -1) {
            return null;
        }
        return (String)this.queryValues.elementAt(i);
    }

    public String[] getParameterValues(String name) {
        Vector v = new Vector();
        Enumeration en = this.getParameterNames();
        int i = 0;
        while (i < this.queryNames.size()) {
            String n = (String)this.queryNames.elementAt(i);
            if (name.equals(n)) {
                v.addElement(this.queryValues.elementAt(i));
            }
            ++i;
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] vArray = new String[v.size()];
        v.copyInto(vArray);
        return vArray;
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Cookie[] getCookies() {
        Object[] cookieArray = new Cookie[this.cookies.size()];
        this.cookies.copyInto(cookieArray);
        return cookieArray;
    }

    public String getMethod() {
        return this.reqMethod;
    }

    public String getRequestURI() {
        String portPart = "";
        int port = this.getServerPort();
        if (port != 80) {
            portPart = ":" + port;
        }
        String queryPart = "";
        String queryString = this.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            queryPart = "?" + queryString;
        }
        return "http://" + this.getServerName() + portPart + this.reqUriPath + queryPart;
    }

    public String getServletPath() {
        return this.reqUriPath;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.reqQuery;
    }

    public String getRemoteUser() {
        return null;
    }

    public String getAuthType() {
        return null;
    }

    public String getHeader(String name) {
        int i = this.reqHeaderNames.indexOf(name.toLowerCase());
        if (i == -1) {
            return null;
        }
        return (String)this.reqHeaderValues.elementAt(i);
    }

    public int getIntHeader(String name, int def) {
        String val = this.getHeader(name);
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return def;
        }
    }

    public long getLongHeader(String name, long def) {
        String val = this.getHeader(name);
        if (val == null) {
            return def;
        }
        try {
            return Long.parseLong(val);
        }
        catch (Exception e) {
            return def;
        }
    }

    public long getDateHeader(String name, long def) {
        String val = this.getHeader(name);
        if (val == null) {
            return def;
        }
        try {
            return DateFormat.getDateInstance().parse(val).getTime();
        }
        catch (Exception e) {
            return def;
        }
    }

    public Enumeration getHeaderNames() {
        return this.reqHeaderNames.elements();
    }

    public HttpSession getSession(boolean create) {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public void setContentLength(int length) {
        this.setIntHeader("Content-Length", length);
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public ServletOutputStream getOutputStream() {
        return this.out;
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.addElement(cookie);
    }

    public boolean containsHeader(String name) {
        return this.resHeaderNames.contains(name);
    }

    public void setStatus(int resCode, String resMessage) {
        this.resCode = resCode;
        this.resMessage = resMessage;
    }

    public void setStatus(int resCode) {
        switch (resCode) {
            case 100: {
                this.setStatus(resCode, "Continue");
                break;
            }
            case 101: {
                this.setStatus(resCode, "Switching protocols");
                break;
            }
            case 200: {
                this.setStatus(resCode, "Ok");
                break;
            }
            case 201: {
                this.setStatus(resCode, "Created");
                break;
            }
            case 202: {
                this.setStatus(resCode, "Accepted");
                break;
            }
            case 203: {
                this.setStatus(resCode, "Non-authoritative");
                break;
            }
            case 204: {
                this.setStatus(resCode, "No content");
                break;
            }
            case 205: {
                this.setStatus(resCode, "Reset content");
                break;
            }
            case 206: {
                this.setStatus(resCode, "Partial content");
                break;
            }
            case 300: {
                this.setStatus(resCode, "Multiple choices");
                break;
            }
            case 301: {
                this.setStatus(resCode, "Moved permanentently");
                break;
            }
            case 302: {
                this.setStatus(resCode, "Moved temporarily");
                break;
            }
            case 303: {
                this.setStatus(resCode, "See other");
                break;
            }
            case 304: {
                this.setStatus(resCode, "Not modified");
                break;
            }
            case 305: {
                this.setStatus(resCode, "Use proxy");
                break;
            }
            case 400: {
                this.setStatus(resCode, "Bad request");
                break;
            }
            case 401: {
                this.setStatus(resCode, "Unauthorized");
                break;
            }
            case 402: {
                this.setStatus(resCode, "Payment required");
                break;
            }
            case 403: {
                this.setStatus(resCode, "Forbidden");
                break;
            }
            case 404: {
                this.setStatus(resCode, "Not found");
                break;
            }
            case 405: {
                this.setStatus(resCode, "Method not allowed");
                break;
            }
            case 406: {
                this.setStatus(resCode, "Not acceptable");
                break;
            }
            case 407: {
                this.setStatus(resCode, "Proxy auth required");
                break;
            }
            case 408: {
                this.setStatus(resCode, "Request timeout");
                break;
            }
            case 409: {
                this.setStatus(resCode, "Conflict");
                break;
            }
            case 410: {
                this.setStatus(resCode, "Gone");
                break;
            }
            case 411: {
                this.setStatus(resCode, "Length required");
                break;
            }
            case 412: {
                this.setStatus(resCode, "Precondition failed");
                break;
            }
            case 413: {
                this.setStatus(resCode, "Request entity too large");
                break;
            }
            case 414: {
                this.setStatus(resCode, "Request URI too large");
                break;
            }
            case 415: {
                this.setStatus(resCode, "Unsupported media type");
                break;
            }
            case 500: {
                this.setStatus(resCode, "Internal server error");
                break;
            }
            case 501: {
                this.setStatus(resCode, "Not implemented");
                break;
            }
            case 502: {
                this.setStatus(resCode, "Bad gateway");
                break;
            }
            case 503: {
                this.setStatus(resCode, "Service unavailable");
                break;
            }
            case 504: {
                this.setStatus(resCode, "Gateway timeout");
                break;
            }
            case 505: {
                this.setStatus(resCode, "HTTP version not supported");
                break;
            }
            default: {
                this.setStatus(resCode, "");
            }
        }
    }

    public void setHeader(String name, String value) {
        this.resHeaderNames.addElement(name);
        this.resHeaderValues.addElement(value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, Integer.toString(value));
    }

    public void setLongHeader(String name, long value) {
        this.setHeader(name, Long.toString(value));
    }

    public void setDateHeader(String name, long value) {
        this.setHeader(name, ServeConnection.to1123String(new Date(value)));
    }

    private static String to1123String(Date date) {
        int blank;
        int localDay = date.getDay();
        int localDate = date.getDate();
        String gmtStr = date.toGMTString();
        int gmtDate = Integer.parseInt(gmtStr.substring(0, blank = gmtStr.indexOf(32)));
        int gmtDay = gmtDate > localDate || gmtDate < localDate && gmtDate == 1 ? (localDay + 1) % 7 : (localDate > gmtDate || localDate < gmtDate && localDate == 1 ? (localDay + 6) % 7 : localDay);
        return String.valueOf(weekdays[gmtDay]) + (gmtDate < 10 ? ", 0" : ", ") + gmtStr;
    }

    void writeHeaders() throws IOException {
        if (this.headersWritten) {
            return;
        }
        this.headersWritten = true;
        if (this.reqMime) {
            this.out.println(String.valueOf(this.reqProtocol) + " " + this.resCode + " " + this.resMessage);
            int i = 0;
            while (i < this.resHeaderNames.size()) {
                String name = (String)this.resHeaderNames.elementAt(i);
                String value = (String)this.resHeaderValues.elementAt(i);
                if (value != null) {
                    this.out.println(String.valueOf(name) + ": " + value);
                }
                ++i;
            }
            this.out.println("");
            this.out.flush();
        }
    }

    public void sendError(int resCode, String resMessage) throws IOException {
        this.setStatus(resCode, resMessage);
        this.realSendError();
    }

    public void sendError(int resCode) throws IOException {
        this.setStatus(resCode);
        this.realSendError();
    }

    private void realSendError() throws IOException {
        this.setContentType("text/html");
        this.out.println("<HTML><HEAD>");
        this.out.println("<TITLE>" + this.resCode + " " + this.resMessage + "</TITLE>");
        this.out.println("</HEAD><BODY BGCOLOR=\"#99cc99\">");
        this.out.println("<H2>" + this.resCode + " " + this.resMessage + "</H2>");
        String ua = this.getHeader("user-agent");
        if (ua != null && Utils.match("*MSIE*", ua)) {
            this.out.println("<!--");
            int i = 0;
            while (i < 6) {
                this.out.println("Padding so that MSIE deigns to show this error instead of its own canned one.");
                ++i;
            }
            this.out.println("-->");
        }
        this.out.println("<HR>");
        ServeUtils.writeAddress(this.out);
        this.out.println("</BODY></HTML>");
        this.out.flush();
    }

    public void sendRedirect(String location) throws IOException {
        this.setHeader("Location", location);
        this.sendError(302);
    }

    public String encodeUrl(String url) {
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }
}

