/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.component;

import com.aibonware.viewnaver.component.PageLayout;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class PagePanel
extends JPanel {
    private PageLayout pageLayout = new PageLayout();

    public PagePanel() {
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setLayout(this.pageLayout);
    }

    public PagePanel(Object ... objects) {
        this();
        this.addLine(objects);
    }

    public void insertNewLine() {
        this.add(this.pageLayout.createNewLine());
    }

    public void insertTab() {
        this.add(this.pageLayout.createTab());
    }

    public void insertIndent(int indent) {
        this.add(this.pageLayout.createHorizonSpace(indent * 10));
    }

    public void setBorder(Border newBorder) {
        super.setBorder(new CompoundBorder(newBorder, new EmptyBorder(2, 2, 2, 2)));
    }

    public static PageLayout.Glue glue(Component comp) {
        return new PageLayout.Glue(comp);
    }

    public static PageLayout.Glue glue() {
        return new PageLayout.Glue(new PageLayout.EmptyGlueComponent());
    }

    public Component add(PageLayout.Glue glue) {
        return this.add("GLUE", glue.comp);
    }

    public Component newline(int distance) {
        return this.pageLayout.createNewLine(distance);
    }

    public final void addLine(Object ... objects) {
        Object[] objectArray = objects;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            Object obj = objectArray[n];
            if (obj instanceof PageLayout.Glue) {
                this.add("GLUE", ((PageLayout.Glue)obj).comp);
            } else if (obj instanceof String) {
                String s = (String)obj;
                int indent = 0;
                while (s.length() > 0 && s.charAt(0) == ' ') {
                    ++indent;
                    s = s.substring(1);
                }
                if (indent > 0) {
                    this.insertIndent(indent);
                }
                StringTokenizer tokens = new StringTokenizer(s, "\n\t", true);
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    if (token.equals("\n")) {
                        this.add(this.pageLayout.createNewLine());
                        continue;
                    }
                    if (token.equals("\t")) {
                        this.add(this.pageLayout.createTab());
                        continue;
                    }
                    this.add(new JLabel(token));
                }
            } else {
                this.add((Component)obj);
            }
            ++n;
        }
        this.add(this.pageLayout.createNewLine());
    }

    private int indexOf(Component comp) {
        Component[] comps = this.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (comps[i] == comp) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setLineEnabled(boolean b, Component main) {
        Component[] comps = this.getComponents();
        int pos = this.indexOf(main);
        if (pos == -1) {
            return;
        }
        int i = pos;
        while (--i >= 0 && !(comps[i] instanceof PageLayout.NewLine)) {
            comps[i].setEnabled(b);
        }
        i = pos;
        do {
            comps[i].setEnabled(b);
        } while (++i < comps.length && !(comps[i] instanceof PageLayout.NewLine));
    }
}

