/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.config.ArticleTemplateConfig;
import com.aibonware.viewnaver.config.BoardConfig;
import com.aibonware.viewnaver.config.CapacityConfig;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigUser;
import com.aibonware.viewnaver.config.EmptyConfigItem;
import com.aibonware.viewnaver.config.FavoritePersonConfig;
import com.aibonware.viewnaver.config.FilterConfig;
import com.aibonware.viewnaver.config.NetworkConfig;
import com.aibonware.viewnaver.config.SearchConfig;
import com.aibonware.viewnaver.model.Country;
import com.aibonware.viewnaver.model.Poster;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Config
extends ConfigItem {
    private Vector<ConfigUser> clients = new Vector();
    public String httpAgentName = "viewNVR beta version - enjoyKOREA Browser";
    public NetworkConfig network = new NetworkConfig();
    public ArticleTemplateConfig articleTemplate;
    public FilterConfig filterConfig;
    public FavoritePersonConfig favoritePersonConfig;
    public CapacityConfig capacityConfig;
    public SearchConfig searchConfig;
    public BoardConfig boardConfig;

    public Config() {
        super("Configuration");
        this.addChild(this.network);
        this.articleTemplate = new ArticleTemplateConfig();
        this.addChild(this.articleTemplate);
        this.filterConfig = new FilterConfig();
        this.addChild(this.filterConfig);
        this.favoritePersonConfig = new FavoritePersonConfig();
        this.addChild(this.favoritePersonConfig);
        this.capacityConfig = new CapacityConfig();
        this.addChild(this.capacityConfig);
        this.boardConfig = new BoardConfig();
        this.addChild(this.boardConfig);
        this.searchConfig = new SearchConfig();
        this.addChild(this.searchConfig);
    }

    public void loadFile(String fileName) {
        FileInputStream in;
        try {
            in = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            ViewNaver.println("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            this.fireConfigureChanged();
            return;
        }
        try {
            ViewNaver.println("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u4e2d...");
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.parse(new BufferedInputStream(in));
            Element root = doc.getDocumentElement();
            this.loadConfigTree(root);
            this.fireConfigureChanged();
            ViewNaver.println("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u5b8c\u4e86\u3002");
        }
        catch (IOException e) {
            ViewNaver.err(e);
        }
        catch (ParserConfigurationException e) {
            ViewNaver.err(e);
        }
        catch (SAXException e) {
            ViewNaver.err(e);
        }
    }

    public void saveFile(String fileName) {
        try {
            ViewNaver.println("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u51fa\u3057\u4e2d...");
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(this.configName);
            doc.appendChild(root);
            this.saveConfigTree(root);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(root.getOwnerDocument()), new StreamResult("config.xml"));
            ViewNaver.println("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u51fa\u3057\u5b8c\u4e86\u3002");
        }
        catch (ParserConfigurationException e) {
            ViewNaver.err(e);
        }
        catch (TransformerConfigurationException e) {
            ViewNaver.err(e);
        }
        catch (TransformerException e) {
            ViewNaver.err(e);
        }
    }

    public void fireConfigureChanged() {
        int i = 0;
        while (i < this.clients.size()) {
            this.clients.elementAt(i).configChanged(this);
            ++i;
        }
    }

    public void addConfigUser(ConfigUser client) {
        this.clients.addElement(client);
    }

    public ConfigItem getAncestor(String configPath) {
        String token;
        ConfigItem curConfig = this;
        StringTokenizer tokens = new StringTokenizer(configPath, ".");
        if (tokens.hasMoreTokens() && (curConfig = this.getChildByName(token = tokens.nextToken())) == null) {
            ViewNaver.println("\u4e0d\u6b63\u306a\u8a2d\u5b9a\u9805\u76ee\u30d1\u30b9\uff1a " + configPath);
            return null;
        }
        return curConfig;
    }

    public void addAncestor(String configPath, ConfigItem item) {
        ConfigItem cur = this;
        StringTokenizer tokens = new StringTokenizer(configPath, ".");
        if (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            ConfigItem next = this.getChildByName(token);
            if (next == null) {
                next = new EmptyConfigItem(token);
                cur.addChild(next);
            }
            cur = next;
        }
        cur.addChild(item);
    }

    public static int getIntConfig(Element root, String configName, int defaultValue) {
        if (root == null) {
            return defaultValue;
        }
        NodeList children = root.getElementsByTagName(configName);
        if (children.getLength() == 0) {
            return defaultValue;
        }
        String valueText = children.item(0).getTextContent();
        try {
            return Integer.parseInt(valueText);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static void setIntConfig(Element root, String configName, int value) {
        Element elem;
        NodeList children = root.getElementsByTagName(configName);
        if (children.getLength() == 0) {
            Document doc = root.getOwnerDocument();
            elem = doc.createElement(configName);
            root.appendChild(elem);
        } else {
            elem = (Element)children.item(0);
        }
        elem.setTextContent(String.valueOf(value));
    }

    public static String getStringConfig(Element root, String configName, String defaultValue) {
        if (root == null) {
            return defaultValue;
        }
        NodeList children = root.getElementsByTagName(configName);
        if (children.getLength() == 0) {
            return defaultValue;
        }
        return children.item(0).getTextContent();
    }

    public static void setStringConfig(Element root, String configName, String value) {
        Element elem;
        NodeList children = root.getElementsByTagName(configName);
        if (children.getLength() == 0) {
            Document doc = root.getOwnerDocument();
            elem = doc.createElement(configName);
            root.appendChild(elem);
        } else {
            elem = (Element)children.item(0);
        }
        elem.setTextContent(value);
    }

    public static boolean getBooleanConfig(Element root, String configName, boolean defaultValue) {
        if (root == null) {
            return defaultValue;
        }
        NodeList children = root.getElementsByTagName(configName);
        if (children.getLength() == 0) {
            return defaultValue;
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(children.item(0).getTextContent());
    }

    public static void setBooleanConfig(Element root, String configName, boolean value) {
        Element elem;
        NodeList children = root.getElementsByTagName(configName);
        if (children.getLength() == 0) {
            Document doc = root.getOwnerDocument();
            elem = doc.createElement(configName);
            root.appendChild(elem);
        } else {
            elem = (Element)children.item(0);
        }
        elem.setTextContent(Boolean.toString(value));
    }

    public static Poster getPosterConfig(Element root, String configName) {
        Poster broken = new Poster("broken configuration", Country.UNKNOWN);
        if (root == null) {
            return broken;
        }
        NodeList children = root.getElementsByTagName(configName);
        if (children.getLength() == 0) {
            return broken;
        }
        Element posterElem = (Element)children.item(0);
        String name = Config.getStringConfig(posterElem, "Name", broken.name);
        String countryText = Config.getStringConfig(posterElem, "Country", broken.country.name());
        return new Poster(name, Country.valueOf(countryText));
    }

    public static void setPosterConfig(Element root, String configName, Poster value) {
        Element posterElem = Config.makeSureElement(root, configName);
        Element nameElem = Config.makeSureElement(posterElem, "Name");
        Element countryElem = Config.makeSureElement(posterElem, "Country");
        nameElem.setTextContent(value.name);
        countryElem.setTextContent(value.country.name());
    }

    private static Element makeSureElement(Element parent, String elementName) {
        Element elem;
        NodeList children = parent.getElementsByTagName(elementName);
        if (children.getLength() == 0) {
            Document doc = parent.getOwnerDocument();
            elem = doc.createElement(elementName);
            parent.appendChild(elem);
        } else {
            elem = (Element)children.item(0);
        }
        return elem;
    }
}

