/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.config;

import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigException;
import com.aibonware.viewnaver.config.ConfigItem;
import com.aibonware.viewnaver.config.ConfigItemView;
import javax.swing.JCheckBox;
import org.w3c.dom.Element;

public abstract class ThreadListConfig
extends ConfigItem {
    public boolean showImage = true;
    public boolean showDispId = true;
    public boolean showNid = false;
    public boolean showCountry = true;
    public boolean showTitle = true;
    public boolean showArticleNum = true;
    public boolean showPoster = true;
    public boolean showDate;
    public boolean showViewNum = true;
    public boolean showTotalPages;
    private boolean defaultShowDate;
    private boolean defaultShowTotalPages;

    public ThreadListConfig(String configName, boolean showDate, boolean defaultShowtotalPages) {
        super(configName);
        this.showDate = this.defaultShowDate = showDate;
        this.showTotalPages = this.defaultShowTotalPages = defaultShowtotalPages;
        this.loadConfig(null);
    }

    public void loadConfig(Element elem) {
        this.showImage = Config.getBooleanConfig(elem, "ShowImage", true);
        this.showDispId = Config.getBooleanConfig(elem, "ShowDispID", true);
        this.showNid = Config.getBooleanConfig(elem, "ShowNID", false);
        this.showCountry = Config.getBooleanConfig(elem, "ShowCountry", true);
        this.showTitle = Config.getBooleanConfig(elem, "ShowTitle", true);
        this.showArticleNum = Config.getBooleanConfig(elem, "ShowArticleNum", true);
        this.showPoster = Config.getBooleanConfig(elem, "ShowPoster", true);
        this.showDate = Config.getBooleanConfig(elem, "ShowDate", this.defaultShowDate);
        this.showViewNum = Config.getBooleanConfig(elem, "ShowViewNum", true);
        this.showTotalPages = Config.getBooleanConfig(elem, "ShowTotalPages", this.defaultShowTotalPages);
    }

    public void saveConfig(Element elem) {
        Config.setBooleanConfig(elem, "ShowImage", this.showImage);
        Config.setBooleanConfig(elem, "ShowDispID", this.showDispId);
        Config.setBooleanConfig(elem, "ShowNID", this.showNid);
        Config.setBooleanConfig(elem, "ShowCountry", this.showCountry);
        Config.setBooleanConfig(elem, "ShowTitle", this.showTitle);
        Config.setBooleanConfig(elem, "ShowArticleNum", this.showArticleNum);
        Config.setBooleanConfig(elem, "ShowPoster", this.showPoster);
        Config.setBooleanConfig(elem, "ShowDate", this.showDate);
        Config.setBooleanConfig(elem, "ShowViewNum", this.showViewNum);
        Config.setBooleanConfig(elem, "ShowTotalPages", this.showTotalPages);
    }

    public String getDispPath() {
        return "\u30b9\u30ec\u30c3\u30c9\u30ea\u30b9\u30c8";
    }

    protected static class BoardConfigView
    extends ConfigItemView {
        JCheckBox showImageCheck = new JCheckBox("\u7e2e\u5c0f\u753b\u50cf");
        JCheckBox showDispIdCheck = new JCheckBox("ID");
        JCheckBox showNidCheck = new JCheckBox("nid");
        JCheckBox showCountryCheck = new JCheckBox("\u56fd\u7a2e\u5225");
        JCheckBox showTitleCheck = new JCheckBox("\u30bf\u30a4\u30c8\u30eb");
        JCheckBox showArticleNumCheck = new JCheckBox("\u30ec\u30b9\u6570");
        JCheckBox showPosterCheck = new JCheckBox("\u6295\u7a3f\u8005");
        JCheckBox showDateCheck = new JCheckBox("\u6295\u7a3f\u65e5");
        JCheckBox showViewNumCheck = new JCheckBox("\u95b2\u89a7\u6570");
        JCheckBox showTotalPagesCheck = new JCheckBox("\u7dcf\u30da\u30fc\u30b8\u6570");
        private ThreadListConfig boardConfig;

        public BoardConfigView(String configName) {
            this.addLine(configName);
            this.addLine("  ", this.showImageCheck, "\t", "  ", this.showDispIdCheck, "\n", "  ", this.showNidCheck, "\t", "  ", this.showCountryCheck, "\n", "  ", this.showTitleCheck, "\t", "  ", this.showArticleNumCheck, "\n", "  ", this.showPosterCheck, "\t", "  ", this.showDateCheck, "\n", "  ", this.showViewNumCheck, "\n", "  ", this.showTotalPagesCheck);
        }

        public void setConfig(ConfigItem config) {
            this.boardConfig = (ThreadListConfig)config;
            this.showImageCheck.setSelected(this.boardConfig.showImage);
            this.showDispIdCheck.setSelected(this.boardConfig.showDispId);
            this.showNidCheck.setSelected(this.boardConfig.showNid);
            this.showCountryCheck.setSelected(this.boardConfig.showCountry);
            this.showTitleCheck.setSelected(this.boardConfig.showTitle);
            this.showArticleNumCheck.setSelected(this.boardConfig.showArticleNum);
            this.showPosterCheck.setSelected(this.boardConfig.showPoster);
            this.showDateCheck.setSelected(this.boardConfig.showDate);
            this.showViewNumCheck.setSelected(this.boardConfig.showViewNum);
            this.showTotalPagesCheck.setSelected(this.boardConfig.showTotalPages);
        }

        public void applyConfig() throws ConfigException {
            this.boardConfig.showImage = this.showImageCheck.isSelected();
            this.boardConfig.showDispId = this.showDispIdCheck.isSelected();
            this.boardConfig.showNid = this.showNidCheck.isSelected();
            this.boardConfig.showCountry = this.showCountryCheck.isSelected();
            this.boardConfig.showTitle = this.showTitleCheck.isSelected();
            this.boardConfig.showArticleNum = this.showArticleNumCheck.isSelected();
            this.boardConfig.showPoster = this.showPosterCheck.isSelected();
            this.boardConfig.showDate = this.showDateCheck.isSelected();
            this.boardConfig.showViewNum = this.showViewNumCheck.isSelected();
            this.boardConfig.showTotalPages = this.showTotalPagesCheck.isSelected();
        }
    }
}

