/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.thread;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.browser.BrowserListener;
import com.aibonware.viewnaver.command.DefaultPosterSelection;
import com.aibonware.viewnaver.command.OpenURLCommand;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.favorite.FavoriteContent;
import com.aibonware.viewnaver.content.thread.ThreadContent;
import com.aibonware.viewnaver.format.DefaultFormatter;
import com.aibonware.viewnaver.model.Article;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.Country;
import com.aibonware.viewnaver.model.FavoriteThread;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.Poster;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.PostArticleView;
import com.aibonware.viewnaver.window.ModifyThreadWindow;
import com.aibonware.viewnaver.window.PublishableThreadWindow;
import com.aibonware.viewnaver.window.ReplyArticleWindow;
import com.aibonware.viewnaver.window.ReplyThreadWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class ThreadView
extends TabContentView {
    public PostArticleView postArticleView;
    ReplyArticleWindow replyArticleWindow;
    public Browser browser;
    private ThreadContent clientContent = null;
    public CompositeThread compositeThread = null;
    private Article selectedArticle = null;
    private DefaultPosterSelection posterSelection = new DefaultPosterSelection();
    public JButton replyThreadButton = new JButton("\u8fd4\u4fe1\u30b9\u30ec");
    public JButton modifyThreadButton = new JButton("\u30b9\u30ec\u4fee\u6b63");
    public JButton deleteThreadButton = new JButton("\u30b9\u30ec\u524a\u9664");
    public JButton favoriteButton = new JButton("\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0");
    public JButton moveNewButton = new JButton("\u65b0\u7740\u306b\u79fb\u52d5");
    public JButton publishButton = new JButton("\u516c\u958b\u7528\u8868\u793a");
    JButton updateButton = new JButton("\u66f4\u65b0");
    JButton closeButton = new JButton("\u9589\u3058\u308b");
    JMenuItem deleteArticleMenu;
    private DefaultFormatter threadFormatter = new DefaultFormatter();
    AbstractAction updateAction = new AbstractAction("\u66f4\u65b0"){

        public void actionPerformed(ActionEvent e) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(ThreadView.this.compositeThread.boardName, ThreadView.this.compositeThread.thread.nid);
            taskFlow.addStatusReceiver(ThreadView.this.createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(this){
                final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void exec() {
                    ThreadView.access$0(1.access$0(this.this$1));
                }
            });
        }

        static /* synthetic */ ThreadView access$0(1 var0) {
            return var0.ThreadView.this;
        }
    };

    public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
        return new TaskStatusReceiver(){

            public void statusChanged(int status) {
                if (status == 0) {
                    ThreadView.this.updateButton.setAction(new AbstractAction(this, "\u4e2d\u6b62", taskFlow){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ TaskFlow val$taskFlow;
                        {
                            this.this$1 = var1_1;
                            this.val$taskFlow = taskFlow;
                            super($anonymous0);
                        }

                        public void actionPerformed(ActionEvent e) {
                            this.val$taskFlow.cancel();
                        }
                    });
                    ThreadView.this.replyThreadButton.setEnabled(false);
                    ThreadView.this.modifyThreadButton.setEnabled(false);
                    ThreadView.this.deleteThreadButton.setEnabled(false);
                    ThreadView.this.favoriteButton.setEnabled(false);
                    ThreadView.this.moveNewButton.setEnabled(false);
                    ThreadView.this.closeButton.setEnabled(false);
                    ThreadView.this.publishButton.setEnabled(false);
                } else if (status == 1) {
                    ThreadView.this.updateButton.setAction(ThreadView.this.updateAction);
                    ThreadView.this.replyThreadButton.setEnabled(true);
                    ThreadView.this.modifyThreadButton.setEnabled(true);
                    ThreadView.this.deleteThreadButton.setEnabled(true);
                    ThreadView.this.favoriteButton.setEnabled(true);
                    ThreadView.this.moveNewButton.setEnabled(true);
                    ThreadView.this.closeButton.setEnabled(true);
                    ThreadView.this.publishButton.setEnabled(true);
                }
            }
        };
    }

    public ThreadView(TabContentCategory category) {
        super(category);
        this.setLayout(new BorderLayout());
        this.postArticleView = new PostArticleView(new Runnable(){

            public void run() {
                ThreadView.this.updateThread();
            }
        }, false);
        this.replyArticleWindow = new ReplyArticleWindow(ViewNaver.instance.threadWindow, new Runnable(){

            public void run() {
                ThreadView.this.updateThread();
            }
        });
        this.replyArticleWindow.setSize(600, 120);
        this.browser = ViewNaver.instance.getBrowserFactory().createBrowser();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new BevelBorder(1));
        panel.add(this.browser.getComponent());
        this.updateButton.addActionListener(this.updateAction);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewNaver.instance.threadWindow.container.removeContent(ThreadView.this.clientContent);
            }
        });
        this.replyThreadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReplyThreadWindow replyThreadWindow = new ReplyThreadWindow(ViewNaver.instance.mainWindow, ThreadView.this.compositeThread.boardName, ThreadView.this.compositeThread.thread, ThreadView.this.compositeThread.contents);
                replyThreadWindow.setVisible(true);
            }
        });
        this.modifyThreadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModifyThreadWindow modifyThreadWindow = new ModifyThreadWindow(ViewNaver.instance.mainWindow, ThreadView.this.compositeThread.boardName, ThreadView.this.compositeThread.thread, ThreadView.this.compositeThread.contents);
                modifyThreadWindow.setVisible(true);
            }
        });
        this.deleteThreadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int confirm = JOptionPane.showConfirmDialog(ThreadView.this, "\u30b9\u30ec\u30c3\u30c9\u3092\u524a\u9664\u3057\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b?", "\u78ba\u8a8d", 0);
                if (confirm != 0) {
                    return;
                }
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(ThreadView.this.compositeThread.boardName, ThreadView.this.compositeThread.thread.nid);
                taskFlow.addStatusReceiver(ThreadView.this.createTaskStatusReceiver(taskFlow));
                taskFlow.execute(new WorkerTask(this){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void exec() {
                        try {
                            ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u524a\u9664\u958b\u59cb..");
                            ViewNaver.instance.naverSession.deleteThread(10.access$0(this.this$1).compositeThread.boardName, 10.access$0(this.this$1).compositeThread.thread.nid);
                        }
                        catch (NetException e) {
                            ViewNaver.err(e);
                        }
                    }
                });
            }

            static /* synthetic */ ThreadView access$0(10 var0) {
                return var0.ThreadView.this;
            }
        });
        this.favoriteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ViewNaver.instance.favoriteThreads.exists(ThreadView.this.compositeThread.boardName, ThreadView.this.compositeThread.thread.nid)) {
                    return;
                }
                ViewNaver.instance.favoriteThreads.addThread(new FavoriteThread(ThreadView.this.compositeThread.boardName, ThreadView.this.compositeThread.thread.nid, ThreadView.this.compositeThread.thread.poster, ThreadView.this.compositeThread.thread.country, ThreadView.this.compositeThread.thread.createDate, ThreadView.this.compositeThread.thread.title));
                ViewNaver.instance.favoriteThreads.save("favorite.xml");
                ViewNaver.println("'" + ThreadView.this.compositeThread.thread.poster + ": " + ThreadView.this.compositeThread.thread.title + "'\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002");
                TabContainerView containerView = ViewNaver.instance.mainWindow.containerView;
                TabContentCategory category = FavoriteContent.getConstantCategory();
                containerView.update(category);
            }
        });
        this.moveNewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Article art = null;
                int i = 0;
                while (i < ThreadView.this.compositeThread.articleList.getArticleCount()) {
                    FilterType filter;
                    Article a = ThreadView.this.compositeThread.articleList.getArticle(i);
                    if (a.isNew && ((filter = ViewNaver.instance.config.filterConfig.filters.get(new Poster(a.author, a.country))) == null || !filter.equals((Object)FilterType.Hidden))) {
                        art = a;
                        break;
                    }
                    ++i;
                }
                if (art != null) {
                    ThreadView.this.browser.scrollTop("comment:" + art.articleId);
                } else {
                    int lastIndex = ThreadView.this.compositeThread.articleList.getArticleCount() - 1;
                    if (lastIndex >= 0) {
                        ThreadView.this.browser.scrollTop("comment:" + ThreadView.this.compositeThread.articleList.getArticle((int)lastIndex).articleId);
                    }
                }
            }
        });
        this.publishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PublishableThreadWindow publishWindow = new PublishableThreadWindow(ViewNaver.instance.mainWindow, ThreadView.this.compositeThread);
                publishWindow.setVisible(true);
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.updateButton);
        toolbar.add(this.moveNewButton);
        toolbar.addSeparator();
        toolbar.add(this.closeButton);
        toolbar.addSeparator();
        toolbar.add(this.replyThreadButton);
        toolbar.add(this.modifyThreadButton);
        toolbar.add(this.deleteThreadButton);
        toolbar.addSeparator();
        toolbar.add(this.favoriteButton);
        toolbar.add(this.publishButton);
        toolbar.setFloatable(false);
        this.add((Component)toolbar, "North");
        this.add((Component)panel, "Center");
        this.add((Component)this.postArticleView, "South");
        final JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(new AbstractAction("\u3053\u306e\uff9a\uff7d\uff8c\uff9e\uff9b\uff6f\uff78\u306b\u8fd4\u4fe1"){

            public void actionPerformed(ActionEvent e) {
                Point mousePoint = MouseInfo.getPointerInfo().getLocation();
                ThreadView.this.replyArticleWindow.setLocation(mousePoint.x - 100, mousePoint.y);
                ThreadView.this.replyArticleWindow.setVisible(true);
                ThreadView.this.replyArticleWindow.replyArticleView.articleText.requestFocusInWindow();
            }
        }));
        this.deleteArticleMenu = new JMenuItem(new AbstractAction("\uff9a\uff7d\u524a\u9664"){

            public void actionPerformed(ActionEvent e) {
                if (ViewNaver.instance.naverSession == null) {
                    ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                    return;
                }
                int confirm = JOptionPane.showConfirmDialog(ThreadView.this, "\uff9a\uff7d\u3092\u524a\u9664\u3057\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b?", "\u78ba\u8a8d", 0);
                if (confirm != 0) {
                    return;
                }
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getArticleFlow(ThreadView.this.compositeThread.boardName, ThreadView.this.compositeThread.thread.nid, ((ThreadView)ThreadView.this).selectedArticle.articleId);
                taskFlow.addStatusReceiver(ThreadView.this.createTaskStatusReceiver(taskFlow));
                taskFlow.execute(new WorkerTask(this){
                    final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void exec() {
                        try {
                            ViewNaver.println("\uff9a\uff7d\u524a\u9664...");
                            ViewNaver.instance.naverSession.deleteArticle(16.access$0(this.this$1).compositeThread.boardName, 16.access$0(this.this$1).compositeThread.thread.nid, ThreadView.access$2((ThreadView)16.access$0(this.this$1)).articleId);
                            ThreadView.access$0(16.access$0(this.this$1));
                        }
                        catch (NetException e) {
                            ViewNaver.println(e.getMessage());
                        }
                    }
                });
            }

            static /* synthetic */ ThreadView access$0(16 var0) {
                return var0.ThreadView.this;
            }
        });
        popup.add(this.deleteArticleMenu);
        popup.addSeparator();
        ViewNaver.instance.posterMenuItemCreator.addPosterMenuItems(this, this.posterSelection, popup);
        popup.addSeparator();
        popup.add(new JMenuItem(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
            }
        }));
        this.browser.addBrowserListener(new BrowserListener(){

            public boolean beforeNavigate(String url) {
                if (url.startsWith("comment:")) {
                    int artId = Integer.valueOf(url.substring("comment:".length()));
                    ThreadView.this.selectedArticle = ThreadView.this.compositeThread.articleList.getArticle(ThreadView.this.compositeThread.articleList.getArticleIndexByArticleID(artId));
                    SwingUtilities.invokeLater(new Runnable(this, popup){
                        final /* synthetic */ 19 this$1;
                        private final /* synthetic */ JPopupMenu val$popup;
                        {
                            this.this$1 = var1_1;
                            this.val$popup = jPopupMenu;
                        }

                        public void run() {
                            ThreadView.access$4(19.access$0(this.this$1)).setCurrentPoster(new Poster(ThreadView.access$2((ThreadView)19.access$0(this.this$1)).author, ThreadView.access$2((ThreadView)19.access$0(this.this$1)).country));
                            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
                            Point compPoint = 19.access$0(this.this$1).browser.getComponent().getLocationOnScreen();
                            this.val$popup.show(19.access$0(this.this$1).browser.getComponent(), mousePoint.x - compPoint.x, mousePoint.y - compPoint.y);
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(this){
                        final /* synthetic */ 19 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            19.access$0(this.this$1).postArticleView.setSelectedArticle(ThreadView.access$2(19.access$0(this.this$1)));
                            19.access$0(this.this$1).replyArticleWindow.setSelectedArticle(ThreadView.access$2(19.access$0(this.this$1)));
                            if (ViewNaver.instance.naverSession != null && ViewNaver.instance.naverSession.getUserName().equals(ThreadView.access$2((ThreadView)19.access$0(this.this$1)).author) && ThreadView.access$2((ThreadView)19.access$0(this.this$1)).country.equals((Object)((Object)Country.JAPAN))) {
                                19.access$0(this.this$1).deleteArticleMenu.setEnabled(true);
                            } else {
                                19.access$0(this.this$1).deleteArticleMenu.setEnabled(false);
                            }
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(this, url){
                        final /* synthetic */ 19 this$1;
                        private final /* synthetic */ String val$url;
                        {
                            this.this$1 = var1_1;
                            this.val$url = string;
                        }

                        public void run() {
                            new OpenURLCommand(19.access$0(this.this$1), this.val$url, false).run();
                        }
                    });
                }
                return false;
            }

            static /* synthetic */ ThreadView access$0(19 var0) {
                return var0.ThreadView.this;
            }
        });
    }

    public void setClientContent(TabContent content) {
        this.clientContent = (ThreadContent)content;
        CompositeThread newWebThreadContents = (CompositeThread)this.clientContent.target;
        if (this.compositeThread != null) {
            this.updateThread(newWebThreadContents);
        } else {
            this.postArticleView.compositeThread = this.compositeThread = newWebThreadContents;
            this.replyArticleWindow.replyArticleView.compositeThread = this.compositeThread;
            this.browser.beginDocWriting();
            this.browser.writeDocHtml(this.threadFormatter.formatThreadContent(this.compositeThread));
            this.browser.writeDocHtml(this.threadFormatter.formatThreadContentFooter(this.compositeThread));
            this.browser.writeDocHtml(this.threadFormatter.formatArticleList(this.compositeThread));
            this.browser.writeDocHtml(this.threadFormatter.formatArticleFooter(this.compositeThread));
            this.browser.endDocWriting();
        }
    }

    private void updateThread() {
        CompositeThread newThread;
        if (this.replyArticleWindow.isVisible()) {
            this.replyArticleWindow.setVisible(false);
        }
        if ((newThread = ViewNaver.instance.cache.getCompositeThread(this.compositeThread.boardName, this.compositeThread.thread.nid, true)) != null) {
            this.updateThread(newThread);
        }
    }

    private void updateThread(CompositeThread newThread) {
        this.browser.replaceBodyHtml("thread:header", this.threadFormatter.formatThreadHeader(newThread));
        if (!this.compositeThread.contents.equals(newThread.contents)) {
            this.compositeThread.contents = newThread.contents;
            this.browser.replaceBodyHtml("thread:content", ViewNaver.instance.threadDecorator.decorate(newThread.contents));
        }
        this.compositeThread.articleList.merge(newThread.articleList);
        ViewNaver.instance.cache.putCompositeThread(this.compositeThread);
        ViewNaver.instance.threadStorage.storeThread(this.compositeThread);
        int lastVisibleSno = -1;
        int i = 0;
        while (i < this.compositeThread.articleList.getArticleCount()) {
            Article art = this.compositeThread.articleList.getArticle(i);
            FilterType filterType = ViewNaver.instance.config.filterConfig.filters.get(new Poster(art.author, art.country));
            if (filterType == null) {
                filterType = FilterType.NOAction;
            }
            boolean isFavoritePerson = ViewNaver.instance.config.favoritePersonConfig.persons.contains(new Poster(art.author, art.country));
            int prevId = -1;
            if (i > 0) {
                prevId = this.compositeThread.articleList.getArticle((int)(i - 1)).articleId;
            }
            if (art.isNew) {
                String articleHtml = this.threadFormatter.formatArticle(lastVisibleSno, art, filterType, isFavoritePerson);
                this.browser.insertBodyHtml("comment:" + prevId, articleHtml);
            } else if (art.prevIsNew || art.isDeleted) {
                this.browser.replaceBodyHtml("comment:" + art.articleId, this.threadFormatter.formatInnerArticle(lastVisibleSno, art, filterType, isFavoritePerson));
            }
            if (!filterType.equals((Object)FilterType.Hidden)) {
                lastVisibleSno = art.sno;
            }
            ++i;
        }
    }

    public void refreshContent() {
    }

    static /* synthetic */ DefaultPosterSelection access$4(ThreadView threadView) {
        return threadView.posterSelection;
    }
}

