/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.model;

import com.aibonware.viewnaver.model.BoardType;
import com.aibonware.viewnaver.model.NThread;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
implements Iterable<NThread> {
    public final String boardName;
    public final String dispName;
    public final BoardType boardType;
    public final int pageNo;
    public final int totalPages;
    private Vector<NThread> threads = new Vector();

    public Board(String boardName, String dispName, BoardType boardType, int pageNo, int totalPages) {
        this.boardName = boardName;
        this.dispName = dispName;
        this.boardType = boardType;
        this.pageNo = pageNo;
        this.totalPages = totalPages;
    }

    public void addTitle(NThread thread) {
        this.threads.addElement(thread);
    }

    public NThread getTitle(int index) {
        return this.threads.elementAt(index);
    }

    public void removeTitle(int index) {
        this.threads.removeElementAt(index);
    }

    public int getThreadCount() {
        return this.threads.size();
    }

    public NThread getTitleByNid(int nid) {
        int i = 0;
        while (i < this.getThreadCount()) {
            NThread header = this.getTitle(i);
            if (header.nid == nid) {
                return header;
            }
            ++i;
        }
        throw new RuntimeException("invalid nid " + nid);
    }

    @Override
    public Iterator<NThread> iterator() {
        return this.threads.iterator();
    }

    public String toString() {
        return this.dispName;
    }
}

