/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.model;

import com.aibonware.viewnaver.model.MessageTitle;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class MessageTitleList {
    public final int receivedNum;
    public final int preReceivedNum;
    public final int sendNum;
    private Vector<MessageTitle> messages = new Vector();

    public MessageTitleList(int receivedNum, int preReceivedNum, int sendNum) {
        this.receivedNum = receivedNum;
        this.preReceivedNum = preReceivedNum;
        this.sendNum = sendNum;
    }

    public void addMessageTitle(MessageTitle message) {
        this.messages.addElement(message);
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public MessageTitle getMessageTitle(int index) {
        return this.messages.elementAt(index);
    }

    public MessageTitle getMessageTitleByMessageId(int messageId) {
        int i = 0;
        while (i < this.messages.size()) {
            MessageTitle title = this.messages.elementAt(i);
            if (title.messageId == messageId) {
                return title;
            }
            ++i;
        }
        return null;
    }

    public void replace(MessageTitle oldTitle, MessageTitle newTitle) {
        this.messages.setElementAt(newTitle, this.messages.indexOf(oldTitle));
    }

    public void sort() {
        Collections.sort(this.messages, new Comparator<MessageTitle>(){

            @Override
            public int compare(MessageTitle src, MessageTitle dest) {
                return dest.messageId - src.messageId;
            }
        });
    }

    public void merge(MessageTitleList newTitles) {
        int i = 0;
        while (i < newTitles.getMessageCount()) {
            MessageTitle newTitle = newTitles.getMessageTitle(i);
            MessageTitle oldTitle = this.getMessageTitleByMessageId(newTitle.messageId);
            if (oldTitle != null) {
                this.replace(oldTitle, newTitle);
            } else {
                this.addMessageTitle(newTitle);
            }
            ++i;
        }
    }
}

