/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.model;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.BoardType;
import com.aibonware.viewnaver.model.FoundThreads;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.ParsingException;
import com.aibonware.viewnaver.parser.SearchThreadParser;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SearchType {
    SearchByTitle(new SearchExecutor(){

        public FoundThreads execSearch(String boardName, String dispName, BoardType boardType, String keyword, int pageNo, SearchType searchType) {
            String encodedKeyword = "";
            try {
                byte[] keywordBytes = keyword.getBytes("UTF-8");
                int i = 0;
                while (i < keywordBytes.length) {
                    Formatter formatter = new Formatter();
                    encodedKeyword = String.valueOf(encodedKeyword) + "%" + formatter.format("%02x", keywordBytes[i]);
                    ++i;
                }
            }
            catch (UnsupportedEncodingException e) {
                encodedKeyword = keyword;
            }
            System.out.println(encodedKeyword);
            String url = pageNo <= 1 ? "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" + boardName + "&st=title&sw=" + encodedKeyword + "&ty=" : "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" + boardName + "&st=title&sw=" + encodedKeyword + "&ty=&page=" + pageNo;
            SearchThreadParser parser = new SearchThreadParser(url);
            try {
                ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u691c\u7d22\u4e2d..");
                FoundThreads threads = parser.parse(boardName, dispName, boardType, pageNo, searchType, keyword);
                ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u691c\u7d22\u5b8c\u4e86\u3002");
                return threads;
            }
            catch (NetException e) {
                ViewNaver.err(e);
                return null;
            }
            catch (ParsingException e) {
                ViewNaver.err(e);
                return null;
            }
        }
    }),
    SearchByPoster(new SearchExecutor(){

        public FoundThreads execSearch(String boardName, String dispName, BoardType boardType, String keyword, int pageNo, SearchType searchType) {
            String url = pageNo <= 1 ? "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" + boardName + "&st=writer_id&sw=" + keyword + "&ty=" : "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" + boardName + "&st=writer_id&sw=" + keyword + "&ty=&page=" + pageNo;
            SearchThreadParser parser = new SearchThreadParser(url);
            try {
                ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u691c\u7d22\u4e2d..");
                FoundThreads threads = parser.parse(boardName, dispName, boardType, pageNo, searchType, keyword);
                ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u691c\u7d22\u5b8c\u4e86\u3002");
                return threads;
            }
            catch (NetException e) {
                ViewNaver.err(e);
                return null;
            }
            catch (ParsingException e) {
                ViewNaver.err(e);
                return null;
            }
        }
    }),
    SearchByNo(new SearchExecutor(){

        public FoundThreads execSearch(String boardName, String dispName, BoardType boardType, String keyword, int pageNo, SearchType searchType) {
            int sno = Integer.parseInt(keyword);
            String url = pageNo <= 1 ? "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" + boardName + "&st=sno&sw=" + sno + "&ty=" : "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" + boardName + "&st=sno&sw=" + sno + "&ty=&page=" + pageNo;
            SearchThreadParser parser = new SearchThreadParser(url);
            try {
                ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u691c\u7d22\u4e2d..");
                FoundThreads threads = parser.parse(boardName, dispName, boardType, pageNo, searchType, keyword);
                ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u691c\u7d22\u5b8c\u4e86\u3002");
                return threads;
            }
            catch (NetException e) {
                ViewNaver.err(e);
                return null;
            }
            catch (ParsingException e) {
                ViewNaver.err(e);
                return null;
            }
        }
    });

    private final SearchExecutor executor;

    private SearchType(SearchExecutor executor) {
        this.executor = executor;
    }

    public FoundThreads execSearch(String boardName, String dispName, BoardType boardType, String keyword, int pageNo) {
        return this.executor.execSearch(boardName, dispName, boardType, keyword, pageNo, this);
    }

    private static interface SearchExecutor {
        public FoundThreads execSearch(String var1, String var2, BoardType var3, String var4, int var5, SearchType var6);
    }
}

