/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.net;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.ArticleList;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.ParsingException;
import com.aibonware.viewnaver.parser.ThreadParser;
import java.io.BufferedReader;
import java.io.IOException;

public class RemoteSite {
    public void close() {
    }

    public CompositeThread queryWebThreadContents(String boardName, int nid, NThread templateThread) throws ParsingException, NetException {
        String url = this.getThreadUrl(boardName, nid, true);
        BufferedReader reader = ViewNaver.instance.naverSession.open(url);
        ThreadParser parser = new ThreadParser(reader, templateThread);
        parser.parse();
        ArticleList articleList = parser.getResultArticleList();
        articleList.sort();
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("URL\u30af\u30ed\u30fc\u30ba\u5931\u6557", e);
        }
        return new CompositeThread(boardName, parser.getResultRawContents(), articleList, parser.getResultThread());
    }

    public String getSiteUrl() {
        return "http://bbs.enjoykorea.jp/";
    }

    public String getBoardUrl(String boardName) {
        return String.valueOf(this.getSiteUrl()) + "tbbs/list.php?board_id=" + boardName;
    }

    public String getBoardPageUrl(String boardName, int pageNo) {
        if (pageNo == 1) {
            return this.getBoardUrl(boardName);
        }
        return String.valueOf(this.getBoardUrl(boardName)) + "&page=" + pageNo;
    }

    public String getThreadUrl(String boardName, int nid) {
        return String.valueOf(this.getSiteUrl()) + "tbbs/read.php?board_id=" + boardName + "&nid=" + nid;
    }

    private String getThreadUrl(String boardName, int nid, boolean showPoll) {
        String url = String.valueOf(this.getSiteUrl()) + "tbbs/read.php?board_id=" + boardName + "&nid=" + nid;
        if (showPoll) {
            url = String.valueOf(url) + "&chk_poll=YES";
        }
        return url;
    }

    public static String text(String s) {
        StringBuffer buf = new StringBuffer(s.length() * 2);
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case ' ': {
                    buf.append("&nbsp;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

