/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.parser;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.Country;
import com.aibonware.viewnaver.model.DenyEntry;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.ParsingContext;
import com.aibonware.viewnaver.parser.ParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenyListParser {
    String urlString;

    public DenyListParser(String urlString) {
        this.urlString = urlString;
    }

    public Vector<DenyEntry> parse() throws NetException, ParsingException {
        BufferedReader reader = ViewNaver.instance.naverSession.open(this.urlString, "UTF8");
        Vector<DenyEntry> result = this.parse(reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("URL\u30af\u30ed\u30fc\u30ba\u5931\u6557", e);
        }
        return result;
    }

    public Vector<DenyEntry> parse(BufferedReader reader) throws ParsingException, NetException {
        ParsingContext ct = new ParsingContext(reader);
        Vector<DenyEntry> denyList = new Vector<DenyEntry>();
        try {
            ct.seek("<!-- List -->");
            while (ct.seek("nidA[]", "<!-- //List -->")) {
                String nidText = ct.cut("value='", "'");
                ct.seek("ico_message02.gif");
                String countryText = ct.cut("http://static.naver.com/enjoyjapan/tbbs/img_09/ico_", ".gif");
                String receiver = ct.cut(">", "</td>").trim();
                int nid = Integer.parseInt(nidText);
                Country country = countryText.equals("jpn") ? Country.JAPAN : (countryText.equals("kor") ? Country.KOREA : Country.UNKNOWN);
                DenyEntry deny = new DenyEntry(receiver, country, nid);
                denyList.addElement(deny);
            }
            return denyList;
        }
        catch (NumberFormatException e) {
            throw new ParsingException(e, ct.text.toString());
        }
    }
}

