/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.movie;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.parser.ParsingContext;
import com.aibonware.viewnaver.server.UserSession;
import com.aibonware.viewnaver.server.movie.Movie;
import com.aibonware.viewnaver.server.movie.MovieServlet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.Formatter;

public class MovieWorker
extends Thread {
    public static final int STATUS_INIT = 0;
    public static final int STATUS_DOWNLOAD = 1;
    public static final int STATUS_ENCODE = 2;
    public static final int STATUS_FINISH = 3;
    public static final int STATUS_IMCOMPLETE = 4;
    private volatile int status;
    private UserSession user;
    private Movie movie;
    public volatile int processedBytes = 0;

    public MovieWorker(UserSession user, Movie movie) {
        this.movie = movie;
        this.user = user;
        this.status = 0;
    }

    public int getStatus() {
        return this.status;
    }

    public void run() {
        try {
            int len;
            String url = this.isYoutubeUrl(this.movie.srcUrl) ? this.getRealYoutubeMovieUrl(this.movie.srcUrl) : this.movie.srcUrl;
            String cacheFileName = this.getCacheFileName(this.movie.srcUrl, "mcs");
            if (!new File(cacheFileName).exists()) {
                int len2;
                this.status = 1;
                BufferedInputStream in = new BufferedInputStream(ViewNaver.instance.server.outerSession.openStream(url, true));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(cacheFileName));
                byte[] buf = new byte[1000];
                this.processedBytes = 0;
                while ((len2 = in.read(buf)) != -1) {
                    out.write(buf, 0, len2);
                    this.processedBytes += len2;
                }
                in.close();
                out.close();
            }
            this.status = 2;
            String reencFileName = this.getCacheFileName(url, "mcd");
            String cmdline = this.getReencodeCommand(cacheFileName, reencFileName);
            Process process = Runtime.getRuntime().exec(cmdline);
            final BufferedInputStream stderr = new BufferedInputStream(process.getErrorStream());
            StringWriter sout = new StringWriter();
            final PrintWriter procout = new PrintWriter(sout);
            Thread errHandler = new Thread(){

                public void run() {
                    try {
                        String line;
                        BufferedReader errreader = new BufferedReader(new InputStreamReader(stderr));
                        while ((line = errreader.readLine()) != null) {
                            procout.println(line);
                        }
                        stderr.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace(procout);
                    }
                }
            };
            errHandler.start();
            process.waitFor();
            errHandler.join();
            int exitCode = process.exitValue();
            procout.println("exit code: " + exitCode);
            if (exitCode != 0) {
                this.status = 4;
                return;
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(reencFileName));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1000];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            this.movie.contents = out.toByteArray();
            this.movie.msg = sout.toString();
            new File(reencFileName).delete();
            this.status = 3;
            this.user.addOnceMessage("<a href=\"" + MovieServlet.createUrl(this.user, this.movie.no) + "\">" + this.movie.getCaption() + "</a><br>");
        }
        catch (Exception e) {
            this.status = 4;
            StringWriter sout = new StringWriter();
            PrintWriter pout = new PrintWriter(sout);
            e.printStackTrace(pout);
            this.movie.msg = ViewNaver.strToHtml(sout.toString());
            this.user.addOnceMessage("<a href=\"" + MovieServlet.createUrl(this.user, this.movie.no) + "\">" + this.movie.getCaption() + "</a><br>");
        }
    }

    private String getReencodeCommand(String src, String dest) {
        StringBuffer buf = new StringBuffer();
        Formatter formatter = new Formatter(buf);
        formatter.format(ViewNaver.instance.server.movieShrinkerCommandLine, src, dest);
        return buf.toString();
    }

    private String getCacheFileName(String url, String ex) throws Exception {
        ViewNaver.makeSureDir("temp");
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(url.getBytes());
        byte[] bytes = md.digest();
        StringBuffer buf = new StringBuffer();
        Formatter formatter = new Formatter(buf);
        int i = 0;
        while (i < bytes.length) {
            formatter.format("%02x", bytes[i]);
            ++i;
        }
        return "temp" + File.separator + buf.toString() + "." + ex;
    }

    private boolean isYoutubeUrl(String url) {
        return url.toLowerCase().startsWith("http://www.youtube.com/v/");
    }

    private String getRealYoutubeMovieUrl(String orgUrl) throws Exception {
        String movieid = orgUrl.substring("http://www.youtube.com/v/".length());
        String url = "http://www.youtube.com/watch?v=" + movieid;
        BufferedReader reader = ViewNaver.instance.server.outerSession.open(url, true);
        ParsingContext ct = new ParsingContext(reader);
        String dest = ct.cut("new SWFObject(\"/player2.swf?hl=en&video_id=", "\",");
        return "http://www.youtube.com/get_video?video_id=" + dest;
    }

    public void cancel() {
        throw new RuntimeException("not implement");
    }
}

