/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.view;

import com.aibonware.viewnaver.view.NavigationListener;
import com.aibonware.viewnaver.view.Navigator;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class NavigationView
extends JTree {
    private HashMap<Navigator, DefaultMutableTreeNode> nodeCache = new HashMap();
    private NavigationListener navigationListner = new NavigationListener(){

        public void childAdded(Navigator child) {
            DefaultMutableTreeNode parentNode = NavigationView.this.getTreeNode(child.getParent());
            DefaultMutableTreeNode childNode = NavigationView.this.getTreeNode(child);
            parentNode.add(childNode);
        }

        public void childRemoved(Navigator child) {
            DefaultMutableTreeNode parentNode = NavigationView.this.getTreeNode(child.getParent());
            DefaultMutableTreeNode childNode = NavigationView.this.getTreeNode(child);
            parentNode.remove(childNode);
        }
    };

    public NavigationView() {
        this.setRootVisible(false);
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        cellRenderer.setLeafIcon(null);
        this.setCellRenderer(cellRenderer);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)NavigationView.this.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object userObject = node.getUserObject();
                if (userObject == null) {
                    return;
                }
                if (!(userObject instanceof Navigator)) {
                    return;
                }
                Navigator navigator = (Navigator)node.getUserObject();
                if (event.getClickCount() == 1) {
                    navigator.select();
                } else if (event.getClickCount() == 2) {
                    navigator.navigate();
                }
            }
        });
    }

    public Navigator getSelectedNavigator() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject == null) {
            return null;
        }
        if (!(userObject instanceof Navigator)) {
            return null;
        }
        return (Navigator)node.getUserObject();
    }

    private DefaultMutableTreeNode getTreeNode(final Navigator navigator) {
        DefaultMutableTreeNode node = this.nodeCache.get(navigator);
        if (node != null) {
            return node;
        }
        node = new DefaultMutableTreeNode(navigator){

            public String toString() {
                return navigator.name;
            }
        };
        navigator.addListener(this.navigationListner);
        this.nodeCache.put(navigator, node);
        int i = 0;
        while (i < navigator.getChildCount()) {
            node.add(this.getTreeNode(navigator.getChildAt(i)));
            ++i;
        }
        return node;
    }

    public void setNavigator(Navigator root) {
        for (Navigator old : this.nodeCache.keySet()) {
            old.removeListener(this.navigationListner);
        }
        this.nodeCache.clear();
        if (root != null) {
            DefaultTreeModel treeModel = new DefaultTreeModel(this.getTreeNode(root));
            this.setModel(treeModel);
            this.expandRow(0);
        } else {
            this.setModel(null);
        }
    }
}

