/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.window;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.window.MainWindow;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ChildWindowActivator {
    private final MainWindow mainWindow;
    private Vector<Window> children = new Vector();
    private Object nowClosingChild = null;
    ChildWindowListener childWindowListener = new ChildWindowListener();

    public ChildWindowActivator(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.mainWindow.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                if (ChildWindowActivator.this.nowClosingChild != null) {
                    int i = 0;
                    while (i < ChildWindowActivator.this.children.size()) {
                        Window childWindow = (Window)ChildWindowActivator.this.children.elementAt(i);
                        if (childWindow != ChildWindowActivator.this.nowClosingChild && childWindow.isVisible()) {
                            childWindow.toFront();
                            break;
                        }
                        ++i;
                    }
                    ChildWindowActivator.this.nowClosingChild = null;
                } else {
                    int i = 0;
                    while (i < ChildWindowActivator.this.children.size()) {
                        Window childWindow = (Window)ChildWindowActivator.this.children.elementAt(i);
                        if (childWindow.isVisible()) {
                            childWindow.setVisible(false);
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public void addChildWindow(Window childWindow) {
        this.children.addElement(childWindow);
        childWindow.addComponentListener(this.childWindowListener);
        childWindow.addWindowListener(this.childWindowListener);
        childWindow.addWindowFocusListener(this.childWindowListener);
    }

    public void activateChildren() {
        Window childWindow;
        int i = this.children.size() - 1;
        while (i >= 0) {
            childWindow = this.children.elementAt(i);
            if (!childWindow.isVisible()) {
                childWindow.setVisible(true);
            }
            --i;
        }
        i = 0;
        while (i < this.children.size()) {
            childWindow = this.children.elementAt(i);
            if (childWindow.isVisible()) {
                childWindow.toFront();
                break;
            }
            ++i;
        }
    }

    public void setClosingChild(Object child) {
        this.nowClosingChild = child;
    }

    private class ChildWindowListener
    implements ComponentListener,
    WindowListener,
    WindowFocusListener {
        ChildWindowListener() {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowLostFocus(WindowEvent e) {
        }

        private void changeShowChildWindowButton() {
            int i = 0;
            while (i < ChildWindowActivator.this.children.size()) {
                if (!((Window)ChildWindowActivator.this.children.elementAt(i)).isVisible()) {
                    ViewNaver.instance.mainWindow.showChildWindowButton.setSelected(false);
                    return;
                }
                ++i;
            }
            ViewNaver.instance.mainWindow.showChildWindowButton.setSelected(true);
        }

        public void componentHidden(ComponentEvent e) {
            this.changeShowChildWindowButton();
        }

        public void componentShown(ComponentEvent e) {
            this.changeShowChildWindowButton();
        }

        public void windowClosed(WindowEvent e) {
            Window childWindow = e.getWindow();
            ChildWindowActivator.this.children.removeElement(childWindow);
            childWindow.removeComponentListener(this);
            childWindow.removeWindowListener(this);
            childWindow.removeWindowFocusListener(this);
        }

        public void windowGainedFocus(WindowEvent e) {
            Window childWindow = e.getWindow();
            ChildWindowActivator.this.children.removeElement(childWindow);
            ChildWindowActivator.this.children.insertElementAt(childWindow, 0);
        }

        public void windowClosing(WindowEvent e) {
            ChildWindowActivator.this.nowClosingChild = e.getWindow();
        }
    }
}

