/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.window;

import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.command.BoardNavigator;
import com.aibonware.viewnaver.command.DenyListNavigator;
import com.aibonware.viewnaver.command.FavoriteNavigator;
import com.aibonware.viewnaver.command.OpenURLCommand;
import com.aibonware.viewnaver.command.ReceivedMessageNavigator;
import com.aibonware.viewnaver.command.SentMessageNavigator;
import com.aibonware.viewnaver.component.StatusBar;
import com.aibonware.viewnaver.config.Config;
import com.aibonware.viewnaver.config.ConfigUser;
import com.aibonware.viewnaver.config.MainWindowConfig;
import com.aibonware.viewnaver.content.DefaultTabContentOrder;
import com.aibonware.viewnaver.content.TabContainer;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.board.BoardContent;
import com.aibonware.viewnaver.content.board.BoardViewFactory;
import com.aibonware.viewnaver.content.board.FoundThreadsContent;
import com.aibonware.viewnaver.content.board.FoundThreadsViewFactory;
import com.aibonware.viewnaver.content.favorite.FavoriteContent;
import com.aibonware.viewnaver.content.favorite.FavoriteContentViewFactory;
import com.aibonware.viewnaver.content.localsearch.LocalFoundContent;
import com.aibonware.viewnaver.content.localsearch.LocalFoundContentViewFactory;
import com.aibonware.viewnaver.content.message.DenyListContent;
import com.aibonware.viewnaver.content.message.DenyListContentViewFactory;
import com.aibonware.viewnaver.content.message.ReceivedMessageContent;
import com.aibonware.viewnaver.content.message.ReceivedMessageContentViewFactory;
import com.aibonware.viewnaver.content.message.SentMessageContent;
import com.aibonware.viewnaver.content.message.SentMessageContentViewFactory;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.BoardTitlesGroup;
import com.aibonware.viewnaver.model.BoardType;
import com.aibonware.viewnaver.net.NetException;
import com.aibonware.viewnaver.parser.GoyakuJitenParser;
import com.aibonware.viewnaver.parser.IDJitenParser;
import com.aibonware.viewnaver.parser.ParsingException;
import com.aibonware.viewnaver.storage.StorageException;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.LogView;
import com.aibonware.viewnaver.view.NavigationView;
import com.aibonware.viewnaver.view.Navigator;
import com.aibonware.viewnaver.window.ConfigDialog;
import com.aibonware.viewnaver.window.MiniServerDialog;
import com.aibonware.viewnaver.window.SearchLocalThreadDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class MainWindow
extends JFrame
implements ConfigUser {
    public LogView logView;
    JSplitPane vertPane;
    JSplitPane horiPane;
    public JToggleButton showChildWindowButton;
    public BoardTitlesGroup textBoardTitlesGroup;
    public BoardTitlesGroup imageBoardTitlesGroup;
    public StatusBar statusBar;
    public NavigationView navigationView;
    public TabContainerView containerView;
    public TabContainer container;
    public MainWindowConfig mainWindowConfig;
    private boolean firstVisible = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    private Navigator createNavigator(BoardTitle boardTitle) {
        return new BoardNavigator(boardTitle);
    }

    private Navigator createNavigator(BoardTitlesGroup boardGroup) {
        Navigator navigator = new Navigator(boardGroup.groupName);
        int i = 0;
        while (i < boardGroup.getBoardCount()) {
            navigator.addChild(this.createNavigator(boardGroup.getBoardTitle(i)));
            ++i;
        }
        return navigator;
    }

    public MainWindow() {
        this.setTitle("viewNVR beta version");
        this.setJMenuBar(this.createMenuBar());
        Navigator rootNavigator = new Navigator("");
        rootNavigator.addChild(new MainNavigators());
        rootNavigator.addChild(new MessageNavigators());
        this.textBoardTitlesGroup = new BoardTitlesGroup("text", ViewNaver.instance.boardTitles.getBoardTitles(BoardType.Text));
        this.imageBoardTitlesGroup = new BoardTitlesGroup("image", ViewNaver.instance.boardTitles.getBoardTitles(BoardType.Image));
        rootNavigator.addChild(this.createNavigator(this.textBoardTitlesGroup));
        rootNavigator.addChild(this.createNavigator(this.imageBoardTitlesGroup));
        this.logView = new LogView();
        this.navigationView = new NavigationView();
        this.navigationView.setNavigator(rootNavigator);
        this.containerView = new TabContainerView();
        this.container = new TabContainer(ViewNaver.instance.defaultCategoryComparator);
        this.containerView.setClientContainer(this.container);
        this.containerView.addFactory(BoardContent.class, new BoardViewFactory());
        this.containerView.addFactory(ReceivedMessageContent.class, new ReceivedMessageContentViewFactory());
        this.containerView.addFactory(SentMessageContent.class, new SentMessageContentViewFactory());
        this.containerView.addFactory(DenyListContent.class, new DenyListContentViewFactory());
        this.containerView.addFactory(FoundThreadsContent.class, new FoundThreadsViewFactory());
        this.containerView.addFactory(FavoriteContent.class, new FavoriteContentViewFactory());
        this.containerView.addFactory(LocalFoundContent.class, new LocalFoundContentViewFactory());
        DefaultTabContentOrder comparator = ViewNaver.instance.defaultCategoryComparator;
        comparator.add(ReceivedMessageContent.class);
        comparator.add(SentMessageContent.class);
        comparator.add(DenyListContent.class);
        comparator.add(FavoriteContent.class);
        comparator.add(BoardContent.class);
        comparator.add(FoundThreadsContent.class);
        comparator.add(LocalFoundContent.class);
        this.showChildWindowButton = new JToggleButton("\u5b50\u753b\u9762\u8868\u793a");
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.showChildWindowButton);
        toolbar.setFloatable(false);
        this.vertPane = new JSplitPane(0, true);
        this.horiPane = new JSplitPane(1, true);
        this.vertPane.setTopComponent(this.horiPane);
        this.vertPane.setBottomComponent(new JScrollPane(this.logView));
        this.vertPane.setDividerSize(4);
        this.vertPane.setResizeWeight(1.0);
        this.horiPane.setLeftComponent(new JScrollPane(this.navigationView));
        this.horiPane.setRightComponent(this.containerView);
        this.horiPane.setDividerSize(4);
        this.horiPane.setDividerLocation(130);
        JPanel panel = new JPanel(new BorderLayout());
        this.statusBar = new StatusBar(this);
        panel.add((Component)toolbar, "North");
        panel.add((Component)this.vertPane, "Center");
        this.add((Component)panel, "Center");
        this.add((Component)this.statusBar, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ViewNaver.instance.exit();
            }
        });
        this.showChildWindowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ViewNaver.instance.mainWindow.showChildWindowButton.isSelected()) {
                    ViewNaver.instance.childWindowActivator.activateChildren();
                }
            }
        });
        this.mainWindowConfig = new MainWindowConfig();
        ViewNaver.instance.config.addChild(this.mainWindowConfig);
        ViewNaver.instance.config.addConfigUser(this);
        this.addComponentListener(new ComponentAdapter(){

            private void updateBounds() {
                Rectangle r = MainWindow.this.getBounds();
                MainWindow.this.mainWindowConfig.left = r.x;
                MainWindow.this.mainWindowConfig.top = r.y;
                MainWindow.this.mainWindowConfig.width = r.width;
                MainWindow.this.mainWindowConfig.height = r.height;
            }

            public void componentMoved(ComponentEvent e) {
                this.updateBounds();
            }

            public void componentResized(ComponentEvent e) {
                this.updateBounds();
            }
        });
    }

    public void configChanged(Config config) {
        if ((this.getExtendedState() & 7) != 0) {
            return;
        }
        this.mainWindowConfig = (MainWindowConfig)config.getAncestor("MainWindow");
        Rectangle r = new Rectangle(this.mainWindowConfig.left, this.mainWindowConfig.top, this.mainWindowConfig.width, this.mainWindowConfig.height);
        if (!r.equals(this.getBounds())) {
            this.setBounds(r);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.firstVisible) {
            this.vertPane.setDividerLocation(0.8);
            this.firstVisible = false;
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu(new MenuAction("File", 70));
        JMenu edit = new JMenu(new MenuAction("Edit", 69));
        JMenu tool = new JMenu(new MenuAction("Tool", 84));
        JMenu devel = new JMenu(new MenuAction("Devel", 68));
        JMenuItem test = new JMenuItem(new MenuAction("test", 84){

            public void actionPerformed(ActionEvent e) {
                try {
                    String cmdline = "C:\\work\\ffmtest\\ffmpeg.exe -y -i C:\\work\\ffmtest\\test2.flv -b 2000 -ar 8000 -ac 1 -s 128x96 -r 10 -f 3gp -";
                    Process process = Runtime.getRuntime().exec(cmdline);
                    BufferedInputStream stderr = new BufferedInputStream(process.getErrorStream());
                    BufferedInputStream stdin = new BufferedInputStream(process.getInputStream());
                    new Thread(this, stderr){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ BufferedInputStream val$stderr;
                        {
                            this.this$1 = var1_1;
                            this.val$stderr = bufferedInputStream;
                        }

                        public void run() {
                            try {
                                String line;
                                BufferedReader errreader = new BufferedReader(new InputStreamReader(this.val$stderr));
                                while ((line = errreader.readLine()) != null) {
                                    ViewNaver.println(line);
                                }
                                this.val$stderr.close();
                            }
                            catch (Exception e) {
                                ViewNaver.err(e);
                            }
                        }
                    }.start();
                    new Thread(this, stdin){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ BufferedInputStream val$stdin;
                        {
                            this.this$1 = var1_1;
                            this.val$stdin = bufferedInputStream;
                        }

                        public void run() {
                            try {
                                int len;
                                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream("c:\\work\\ffmtest\\vnout.3gp"));
                                byte[] buf = new byte[1000];
                                while ((len = this.val$stdin.read(buf)) != -1) {
                                    out.write(buf, 0, len);
                                }
                                out.close();
                                this.val$stdin.close();
                            }
                            catch (Exception e) {
                                ViewNaver.err(e);
                            }
                        }
                    }.start();
                    process.waitFor();
                    ViewNaver.println("exit code: " + process.exitValue());
                }
                catch (Exception ex) {
                    ViewNaver.err(ex);
                }
            }
        });
        JMenuItem miniServer = new JMenuItem(new MenuAction("Remote Control...", 82){

            public void actionPerformed(ActionEvent e) {
                if (!ViewNaver.instance.naverSession.nowLogin()) {
                    ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                    return;
                }
                if (ViewNaver.instance.server != null) {
                    ViewNaver.println("Remote Control\u306f\u65e2\u306b\u6709\u52b9\u306b\u306a\u3063\u3066\u3044\u307e\u3059\u3002");
                    return;
                }
                MiniServerDialog dialog = new MiniServerDialog(MainWindow.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem exit = new JMenuItem(new MenuAction("Exit", 88){

            public void actionPerformed(ActionEvent e) {
                ViewNaver.instance.exit();
            }
        });
        JMenuItem config = new JMenuItem(new MenuAction("\u8a2d\u5b9a...", 67){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog dialog = new ConfigDialog(MainWindow.this, ViewNaver.instance.config);
                dialog.setVisible(true);
            }
        });
        JMenuItem searchLocalThread = new JMenuItem(new MenuAction("\u30ed\u30b0\u691c\u7d22...", 83){

            public void actionPerformed(ActionEvent e) {
                SearchLocalThreadDialog dialog = new SearchLocalThreadDialog(MainWindow.this);
                dialog.setVisible(true);
            }
        });
        JMenuItem readGoyaku = new JMenuItem(new MenuAction("\u8aa4\u8a33\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f(einsamkeit)", 71){

            public void actionPerformed(ActionEvent event) {
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
                taskFlow.execute(new WorkerTask(this){
                    final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void exec() {
                        try {
                            ViewNaver.println("\u8aa4\u8a33\u8f9e\u5178\u306e\u8aad\u8fbc\u958b\u59cb...");
                            GoyakuJitenParser parser = new GoyakuJitenParser("http://einsamkeit.hp.infoseek.co.jp/naver_goyaku.htm");
                            ViewNaver.instance.goyakuList = parser.parse();
                            ViewNaver.println("\u8aa4\u8a33\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                        }
                        catch (NetException e) {
                            ViewNaver.err(e);
                        }
                        catch (ParsingException e) {
                            ViewNaver.err(e);
                        }
                    }
                });
            }
        });
        JMenuItem readIDJiten = new JMenuItem(new MenuAction("ID\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f(enjoyid)", 48){

            public void actionPerformed(ActionEvent event) {
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
                taskFlow.execute(new WorkerTask(this){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void exec() {
                        try {
                            ViewNaver.println("ID\u8f9e\u5178\u306e\u8aad\u8fbc\u958b\u59cb...");
                            IDJitenParser parser = new IDJitenParser("http://enjoyid.net/xml?mode=main");
                            ViewNaver.instance.idJiten = parser.parse();
                            ViewNaver.println("ID\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f\u7d42\u4e86\u3002");
                        }
                        catch (NetException e) {
                            ViewNaver.err(e);
                        }
                        catch (ParsingException e) {
                            ViewNaver.err(e);
                        }
                    }
                });
            }
        });
        JMenuItem wikiGoyaku = new JMenuItem("\u8aa4\u8a33\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f(uwakina-honeypie)");
        JMenuItem wikiIDJiten = new JMenuItem("ID\u8f9e\u5178\u306e\u8aad\u307f\u8fbc\u307f(uwakina-honeypie)");
        JMenuItem links = new JMenuItem("\u30ea\u30f3\u30af\u96c6\u306e\u8aad\u307f\u8fbc\u307f(Naver2ch)");
        wikiGoyaku.setEnabled(false);
        wikiIDJiten.setEnabled(false);
        links.setEnabled(false);
        JMenuItem openUrl = new JMenuItem(new MenuAction("Open Url...", 79){

            public void actionPerformed(ActionEvent event) {
                String urlText = JOptionPane.showInputDialog(ViewNaver.instance.mainWindow, (Object)"\u30b9\u30ec\u30c3\u30c9\u307e\u305f\u306f\u677f\u306eURL\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\uff1a");
                ViewNaver.instance.childWindowActivator.setClosingChild(new Object());
                if (urlText == null) {
                    return;
                }
                if (urlText == null || urlText.trim().equals("")) {
                    ViewNaver.println("\u7a7a\u306eURL\u3067\u3059\u3002");
                    return;
                }
                new OpenURLCommand(MainWindow.this, urlText, true).run();
            }
        });
        JMenuItem save = new JMenuItem(new MenuAction("Save...", 83){

            public void actionPerformed(ActionEvent event) {
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
                taskFlow.execute(new WorkerTask(this){
                    final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void exec() {
                        try {
                            ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u51fa\u529b\u958b\u59cb...");
                            int num = ViewNaver.instance.threadStorage.flash();
                            ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u30ed\u30b0\u51fa\u529b\u7d42\u4e86(" + num + "\u30b9\u30ec\u30c3\u30c9\u4fdd\u5b58)");
                        }
                        catch (StorageException e) {
                            ViewNaver.err(e);
                        }
                        ViewNaver.instance.config.saveFile("config.xml");
                    }
                });
            }
        });
        bar.add(file);
        bar.add(edit);
        bar.add(tool);
        bar.add(devel);
        file.add(openUrl);
        file.addSeparator();
        file.add(save);
        file.addSeparator();
        file.add(exit);
        edit.add(searchLocalThread);
        tool.add(readGoyaku);
        tool.add(readIDJiten);
        tool.add(wikiGoyaku);
        tool.add(wikiIDJiten);
        tool.add(links);
        tool.addSeparator();
        tool.add(config);
        devel.add(test);
        devel.add(miniServer);
        return bar;
    }

    private static class MessageNavigators
    extends Navigator {
        public MessageNavigators() {
            super("\u30e1\u30c3\u30bb\u30fc\u30b8");
            this.addChild(new ReceivedMessageNavigator());
            this.addChild(new SentMessageNavigator());
            this.addChild(new DenyListNavigator());
        }
    }

    private static class MainNavigators
    extends Navigator {
        public MainNavigators() {
            super("\u30e1\u30a4\u30f3");
            this.addChild(new FavoriteNavigator());
        }
    }

    private static class MenuAction
    extends AbstractAction {
        public MenuAction(String name, int mnemonic) {
            super(name);
            this.putValue("MnemonicKey", mnemonic);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }
}

