/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.tablib;

import com.aibonware.tablib.TabCategory;
import com.aibonware.tablib.TabFrame;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.TreeMap;
import javax.swing.JTabbedPane;

public class TabListView {
    private JTabbedPane tabPane;
    private TreeMap<TabCategory, TabFrame> frames;

    public TabListView(Comparator<? super TabCategory> tabOrder) {
        this.frames = tabOrder != null ? new TreeMap(tabOrder) : new TreeMap();
        this.tabPane = new JTabbedPane(){

            @Override
            protected void processMouseEvent(MouseEvent event) {
                try {
                    super.processMouseEvent(event);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }

            @Override
            protected void processMouseMotionEvent(MouseEvent event) {
                try {
                    super.processMouseMotionEvent(event);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        };
    }

    public JTabbedPane getComponent() {
        return this.tabPane;
    }

    private int getFramePos(TabCategory cat) {
        return this.frames.subMap(this.frames.firstKey(), cat).size();
    }

    public TabFrame createTabFrame(TabCategory cat, String title) {
        if (this.hasTab(cat)) {
            throw new RuntimeException("\u3059\u3067\u306b\u5b58\u5728\u3059\u308b\u30bf\u30d6\u3092\u518d\u4f5c\u6210\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        TabFrame frame = new TabFrame();
        frame.setTitle(title);
        this.frames.put(cat, frame);
        this.tabPane.insertTab(title, null, frame.getComponent(), null, this.getFramePos(cat));
        frame.added();
        return frame;
    }

    public TabFrame getTabFrame(TabCategory cat) {
        return this.frames.get(cat);
    }

    public boolean hasTab(TabCategory cat) {
        return this.frames.containsKey(cat);
    }

    public void removeTabFrame(TabCategory cat) {
        TabFrame frame = this.frames.get(cat);
        this.tabPane.removeTabAt(this.getFramePos(cat));
        this.frames.remove(cat);
        frame.disposed();
    }

    public void activateTabFrame(TabCategory cat) {
        this.tabPane.setSelectedComponent(this.frames.get(cat).getComponent());
    }
}

