/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.command;

import com.aibonware.nvrlib.model.Poster;
import com.aibonware.nvrlib.model.SearchType;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.command.BoardTitleProvider;
import com.aibonware.viewnaver.command.PosterSelection;
import com.aibonware.viewnaver.command.PosterSelectionListener;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.board.FoundThreadsContent;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.IDJitenList;
import com.aibonware.viewnaver.window.IDJitenWindow;
import com.aibonware.viewnaver.window.WriteMessageWindow;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PosterMenuItemCreator {
    private Window searchParentWindow(Container container) {
        while (!((container = container.getParent()) instanceof Window)) {
        }
        return (Window)container;
    }

    public void addPosterMenuItems(final TabContentView contentView, final PosterSelection posterSelection, JPopupMenu popup, final BoardTitleProvider boardTitleProvider) {
        JMenuItem sendMessageMenu = new JMenuItem(new AbstractAction("\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                WriteMessageWindow messageWindow = new WriteMessageWindow(ViewNaver.instance.mainWindow, poster.name, poster.country, "");
                messageWindow.setVisible(true);
            }
        });
        final JMenuItem idJitenMenu = new JMenuItem(new AbstractAction("ID\u8f9e\u5178..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                IDJitenList idJiten = ViewNaver.instance.idJiten;
                if (idJiten == null) {
                    return;
                }
                String explain = idJiten.getExplain(poster);
                if (explain != null) {
                    IDJitenWindow idwindow = IDJitenWindow.createIDJitenWindow(PosterMenuItemCreator.this.searchParentWindow(contentView), poster.name, explain);
                    idwindow.setLocation(100, 100);
                    idwindow.setVisible(true);
                }
            }
        });
        JMenuItem favMenu = new JMenuItem(new AbstractAction("\u304a\u6c17\u306b\u5165\u308aID\u306b\u8ffd\u52a0"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.getFavoritePersonConfig().persons.add(poster);
                contentView.refreshContent();
            }
        });
        JMenuItem filterMenu = new JMenuItem(new AbstractAction("\uff8c\uff68\uff99\uff80\uff98\uff9d\uff78\uff9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.getFilterConfig().filters.put(new Poster(poster.name, poster.country), FilterType.Visible);
                contentView.refreshContent();
            }
        });
        JMenuItem hiddenFilterMenu = new JMenuItem(new AbstractAction("\u900f\u660e\uff8c\uff68\uff99\uff80\uff98\uff9d\uff78\uff9e"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                ViewNaver.instance.config.getFilterConfig().filters.put(new Poster(poster.name, poster.country), FilterType.Hidden);
                contentView.refreshContent();
            }
        });
        JMenuItem searchMenu = new JMenuItem(new AbstractAction("\uff7d\uff9a\u691c\u7d22"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Poster poster = posterSelection.getCurrentPoster();
                if (poster == null) {
                    return;
                }
                BoardTitle boardTitle = boardTitleProvider.getBoardTitle();
                TabContainerView containerView = ViewNaver.instance.mainWindow.containerView;
                TabContentCategory category = FoundThreadsContent.getConstantCategory(boardTitle, SearchType.SearchByPoster, poster.name);
                containerView.update(category);
            }
        });
        idJitenMenu.setEnabled(false);
        popup.add(sendMessageMenu);
        popup.add(idJitenMenu);
        popup.add(favMenu);
        popup.add(filterMenu);
        popup.add(hiddenFilterMenu);
        popup.add(searchMenu);
        posterSelection.addPosterSelectionListener(new PosterSelectionListener(){

            @Override
            public void selected(Poster poster) {
                IDJitenList idJiten;
                if (poster == null) {
                    idJitenMenu.setEnabled(false);
                }
                if ((idJiten = ViewNaver.instance.idJiten) == null || idJiten.getExplain(poster) == null) {
                    idJitenMenu.setEnabled(false);
                } else {
                    idJitenMenu.setEnabled(true);
                }
            }
        });
    }
}

