/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.message;

import com.aibonware.nvrlib.model.MessageTitle;
import com.aibonware.nvrlib.model.MessageTitleList;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.ParsingException;
import com.aibonware.nvrlib.parser.ReplyMessageParser;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.browser.BrowserListener;
import com.aibonware.viewnaver.command.OpenURLCommand;
import com.aibonware.viewnaver.component.ButtonBar;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.message.MessageContent;
import com.aibonware.viewnaver.content.message.MessageListView;
import com.aibonware.viewnaver.net.SessionListener;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public abstract class MessageContentView
extends TabContentView {
    private JLabel infoLabel = new JLabel(" ");
    protected final MessageListView messageListView;
    private Browser messageArea;
    private JLabel messageHeader;
    protected MessageContent messageContent;
    protected ButtonBar toolbar;
    protected JButton closeButton;
    protected JButton updateButton;
    protected JButton serverButton;
    JPopupMenu serverPopup = new JPopupMenu();
    AbstractAction serverAction = new AbstractAction("\u30b5\u30fc\u30d0\u5074\u64cd\u4f5c..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            MessageContentView.this.serverPopup.show(MessageContentView.this.serverButton, 0, MessageContentView.this.serverButton.getHeight());
        }
    };
    AbstractAction updateAction = new AbstractAction("\u66f4\u65b0"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewNaver.instance.mainWindow.containerView.update(MessageContentView.this.messageContent.getCategory());
        }
    };

    public MessageContentView(TabContentCategory category, String messageUrlBase, MessageListView.MessageAdapter messageSaver) {
        super(category);
        String initialHtml = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html\"></head><body></body></html>";
        this.messageArea = ViewNaver.instance.getBrowserFactory().createBrowser(initialHtml);
        this.messageHeader = new JLabel(" ");
        this.messageHeader.setOpaque(true);
        this.messageListView = new MessageListView(this, this.messageArea, messageUrlBase, this.messageHeader, messageSaver);
        JSplitPane split = new JSplitPane(0);
        split.setTopComponent(new JScrollPane(this.messageListView, 20, 31){
            {
                this.getViewport().setBackground(Color.WHITE);
            }
        });
        split.setBottomComponent(new JPanel(new BorderLayout()){
            {
                this.add((Component)MessageContentView.this.messageHeader, "North");
                this.add((Component)new JPanel(new BorderLayout()){
                    {
                        this.setBorder(new BevelBorder(1));
                        this.add(MessageContentView.this.messageArea.getComponent());
                    }
                }, "Center");
            }
        });
        this.messageArea.addBrowserListener(new BrowserListener(){

            @Override
            public boolean beforeNavigate(final String url) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new OpenURLCommand(MessageContentView.this, url, false).run();
                    }
                });
                return false;
            }
        });
        split.setDividerSize(5);
        split.setResizeWeight(0.0);
        this.add((Component)split, "Center");
        this.add((Component)this.infoLabel, "South");
        split.setDividerLocation(100);
        this.toolbar = new ButtonBar();
        this.updateButton = new JButton();
        this.closeButton = new JButton("\u9589\u3058\u308b");
        this.serverButton = new JButton();
        JMenuItem saveServerMenu = new JMenuItem("\u30b5\u30fc\u30d0\u306b\u9577\u671f\u4fdd\u7ba1");
        JMenuItem deleteServerMenu = new JMenuItem("\u30b5\u30fc\u30d0\u304b\u3089\u524a\u9664");
        this.serverButton.setAction(this.serverAction);
        saveServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final int[] messageIdList = MessageContentView.this.messageListView.getSelectedMessageIdList();
                if (messageIdList.length == 0) {
                    ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return;
                }
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageListFlow();
                MessageContentView.this.beginTask(MessageContentView.this.serverButton, taskFlow);
                taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        try {
                            ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u30b5\u30fc\u30d0\u5074\u4fdd\u5b58\u958b\u59cb..");
                            MessageContentView.this.saveServerMessage(messageIdList);
                            ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u30b5\u30fc\u30d0\u5074\u4fdd\u5b58\u7d42\u4e86\u3002");
                            this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                                @Override
                                public void exec() {
                                    ViewNaver.instance.mainWindow.containerView.update(((this).this).MessageContentView.this.messageContent.getCategory());
                                }
                            });
                        }
                        catch (NetException e) {
                            ViewNaver.err((Exception)((Object)e));
                        }
                    }
                });
            }
        });
        deleteServerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final int[] messageIdList = MessageContentView.this.messageListView.getSelectedMessageIdList();
                if (messageIdList.length == 0) {
                    ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return;
                }
                TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getMessageListFlow();
                MessageContentView.this.beginTask(MessageContentView.this.serverButton, taskFlow);
                taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                    @Override
                    public void exec() {
                        try {
                            ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u30b5\u30fc\u30d0\u5074\u524a\u9664\u958b\u59cb..");
                            MessageContentView.this.deleteServerMessage(messageIdList);
                            ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u30b5\u30fc\u30d0\u5074\u524a\u9664\u7d42\u4e86\u3002");
                            this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                                @Override
                                public void exec() {
                                    ViewNaver.instance.mainWindow.containerView.update(((this).this).MessageContentView.this.messageContent.getCategory());
                                }
                            });
                        }
                        catch (NetException e) {
                            ViewNaver.err((Exception)((Object)e));
                        }
                    }
                });
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ViewNaver.instance.mainWindow.container.removeContent(MessageContentView.this.messageContent);
            }
        });
        this.updateButton.setAction(this.updateAction);
        this.serverPopup.add(saveServerMenu);
        this.serverPopup.add(deleteServerMenu);
        this.toolbar.add(this.updateButton);
        this.toolbar.add(this.closeButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.serverButton);
        this.add((Component)this.toolbar, "North");
        ViewNaver.instance.multiSession.addSessionListener(new SessionListener(){

            @Override
            public void loginChanged(String userName, boolean nowLogin) {
                if (MessageContentView.this.messageContent != null && !MessageContentView.this.messageContent.userName.equals(userName)) {
                    ViewNaver.instance.mainWindow.container.removeContent(MessageContentView.this.messageContent);
                }
            }
        });
    }

    protected abstract void saveServerMessage(int[] var1) throws NetException;

    protected abstract void deleteServerMessage(int[] var1) throws NetException;

    public abstract void beginTask(JButton var1, TaskFlow var2);

    public abstract void beginUpdateTask(TaskFlow var1);

    @Override
    public void setClientContent(TabContent content) {
        this.messageContent = (MessageContent)content;
        MessageTitleList summaryTarget = this.messageContent.messageTitles;
        if (summaryTarget != null) {
            this.infoLabel.setText(String.valueOf(this.messageContent.userName) + " \u9001\u4fe1: " + summaryTarget.sendNum + " \u53d7\u4fe1: " + summaryTarget.receivedNum + " (\u672a\u8aad: " + summaryTarget.preReceivedNum + ")");
        } else {
            this.infoLabel.setText(String.valueOf(this.messageContent.userName) + " ---");
        }
        this.messageListView.setMessageList(this.messageContent.messageTitles);
    }

    public String getReplyMessageText(MessageTitle src) throws ParsingException, NetException {
        ReplyMessageParser parser = new ReplyMessageParser("http://bbs.enjoykorea.jp/memo/memo_write.php?receive_id=" + src.person + "&id_national=" + src.country.toChar() + "&st=" + src.messageId);
        return parser.parse((NaverSession)ViewNaver.instance.multiSession);
    }
}

