/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.content.thread;

import com.aibonware.nvrlib.model.Poster;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.browser.Browser;
import com.aibonware.viewnaver.browser.BrowserListener;
import com.aibonware.viewnaver.command.BoardTitleProvider;
import com.aibonware.viewnaver.command.DefaultPosterSelection;
import com.aibonware.viewnaver.command.OpenURLCommand;
import com.aibonware.viewnaver.command.PosterMenuItems;
import com.aibonware.viewnaver.component.ButtonBar;
import com.aibonware.viewnaver.content.TabContainerView;
import com.aibonware.viewnaver.content.TabContent;
import com.aibonware.viewnaver.content.TabContentCategory;
import com.aibonware.viewnaver.content.TabContentView;
import com.aibonware.viewnaver.content.favorite.FavoriteContent;
import com.aibonware.viewnaver.content.thread.ThreadContent;
import com.aibonware.viewnaver.format.DefaultFormatter;
import com.aibonware.viewnaver.model.Article;
import com.aibonware.viewnaver.model.ArticleList;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.CompositeThread;
import com.aibonware.viewnaver.model.FavoriteThread;
import com.aibonware.viewnaver.model.FilterType;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.model.SessionType;
import com.aibonware.viewnaver.net.SessionListener;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.PostArticleView;
import com.aibonware.viewnaver.window.ModifyThreadWindow;
import com.aibonware.viewnaver.window.PublishableThreadWindow;
import com.aibonware.viewnaver.window.ReplyArticleWindow;
import com.aibonware.viewnaver.window.ReplyThreadWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

public class ThreadView
extends TabContentView {
    public PostArticleView postArticleView;
    ReplyArticleWindow replyArticleWindow;
    public Browser browser;
    private ThreadContent clientContent = null;
    public CompositeThread compositeThread = null;
    private Article selectedArticle = null;
    private DefaultPosterSelection posterSelection = new DefaultPosterSelection();
    private JButton replyThreadButton = new JButton("\u8fd4\u4fe1\u30b9\u30ec");
    private JButton modifyThreadButton = new JButton("\u30b9\u30ec\u4fee\u6b63");
    private JButton deleteThreadButton = new JButton("\u30b9\u30ec\u524a\u9664");
    public JButton favoriteButton = new JButton("\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0");
    public JButton moveNewButton = new JButton("\u65b0\u7740\u306b\u79fb\u52d5");
    public JButton publishButton = new JButton("\u516c\u958b\u7528\u8868\u793a");
    JButton updateButton = new JButton("\u66f4\u65b0");
    JButton closeButton = new JButton("\u9589\u3058\u308b");
    JMenuItem replyArticleMenu;
    JMenuItem deleteArticleMenu;
    private PosterMenuItems posterItems = new PosterMenuItems(this, this.posterSelection, new BoardTitleProvider(){

        @Override
        public BoardTitle getBoardTitle() {
            return (BoardTitle)ViewNaver.instance.boardTitles.getBoardTitle(ThreadView.this.compositeThread.boardName);
        }
    });
    private DefaultFormatter threadFormatter = null;
    private int currentTaskStatus = 1;
    private boolean nowLogin = false;
    AbstractAction updateAction = new AbstractAction("\u66f4\u65b0"){

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(ThreadView.this.compositeThread.boardName, ((NThread)ThreadView.this.compositeThread.thread).nid);
            taskFlow.addStatusReceiver(ThreadView.this.createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    ThreadView.this.updateThread();
                }
            });
        }
    };
    AbstractAction replyThreadAction = new AbstractAction("\u8fd4\u4fe1\u30b9\u30ec"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ReplyThreadWindow replyThreadWindow = new ReplyThreadWindow(ViewNaver.instance.mainWindow, ThreadView.this.compositeThread.boardName, (NThread)ThreadView.this.compositeThread.thread, ThreadView.this.compositeThread.contents);
            replyThreadWindow.setVisible(true);
        }
    };
    AbstractAction modifyThreadAction = new AbstractAction("\u30b9\u30ec\u4fee\u6b63"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ModifyThreadWindow modifyThreadWindow = new ModifyThreadWindow(ViewNaver.instance.mainWindow, ThreadView.this.compositeThread.boardName, (NThread)ThreadView.this.compositeThread.thread, ThreadView.this.compositeThread.contents);
            modifyThreadWindow.setVisible(true);
        }
    };
    AbstractAction favoriteAction = new AbstractAction("\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ViewNaver.instance.favoriteThreads.exists(ThreadView.this.compositeThread.boardName, ((NThread)ThreadView.this.compositeThread.thread).nid)) {
                return;
            }
            ViewNaver.instance.favoriteThreads.addThread(new FavoriteThread(ThreadView.this.compositeThread.boardName, ((NThread)ThreadView.this.compositeThread.thread).nid, ((NThread)ThreadView.this.compositeThread.thread).poster, ((NThread)ThreadView.this.compositeThread.thread).country, ((NThread)ThreadView.this.compositeThread.thread).createDate, ((NThread)ThreadView.this.compositeThread.thread).title));
            ViewNaver.instance.favoriteThreads.save("favorite.xml");
            ViewNaver.println("'" + ((NThread)ThreadView.this.compositeThread.thread).poster + ": " + ((NThread)ThreadView.this.compositeThread.thread).title + "'\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0\u3057\u307e\u3057\u305f\u3002");
            TabContainerView containerView = ViewNaver.instance.mainWindow.containerView;
            TabContentCategory category = FavoriteContent.getConstantCategory();
            containerView.update(category);
        }
    };
    AbstractAction deleteThreadAction = new AbstractAction("\u30b9\u30ec\u524a\u9664"){

        @Override
        public void actionPerformed(ActionEvent e) {
            int confirm = JOptionPane.showConfirmDialog(ThreadView.this, "\u30b9\u30ec\u30c3\u30c9\u3092\u524a\u9664\u3057\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b?", "\u78ba\u8a8d", 0);
            if (confirm != 0) {
                return;
            }
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow(ThreadView.this.compositeThread.boardName, ((NThread)ThreadView.this.compositeThread.thread).nid);
            taskFlow.addStatusReceiver(ThreadView.this.createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    try {
                        ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u524a\u9664\u958b\u59cb..");
                        ViewNaver.instance.multiSession.deleteThread((this).ThreadView.this.compositeThread.boardName, ((NThread)(this).ThreadView.this.compositeThread.thread).nid);
                        ViewNaver.println("\u30b9\u30ec\u30c3\u30c9\u524a\u9664\u5b8c\u4e86");
                    }
                    catch (NetException e) {
                        ViewNaver.err((Exception)((Object)e));
                    }
                }
            });
        }
    };
    AbstractAction moveNewAction = new AbstractAction("\u65b0\u7740\u306b\u79fb\u52d5"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Article art = null;
            int i = 0;
            while (i < ((ArticleList)ThreadView.this.compositeThread.articleList).getArticleCount()) {
                FilterType filter;
                Article a = (Article)((ArticleList)ThreadView.this.compositeThread.articleList).getArticle(i);
                if (a.isNew && ((filter = ViewNaver.instance.config.getFilterConfig().filters.get(new Poster(a.author, a.country))) == null || !filter.equals((Object)FilterType.Hidden))) {
                    art = a;
                    break;
                }
                ++i;
            }
            if (art != null) {
                ThreadView.this.browser.scrollTop("comment:" + art.articleId);
            } else {
                int lastIndex = ((ArticleList)ThreadView.this.compositeThread.articleList).getArticleCount() - 1;
                if (lastIndex >= 0) {
                    ThreadView.this.browser.scrollTop("comment:" + ((Article)((ArticleList)ThreadView.this.compositeThread.articleList).getArticle((int)lastIndex)).articleId);
                }
            }
        }
    };
    AbstractAction publishAction = new AbstractAction("\u516c\u958b\u7528\u8868\u793a"){

        @Override
        public void actionPerformed(ActionEvent e) {
            PublishableThreadWindow publishWindow = new PublishableThreadWindow(ViewNaver.instance.mainWindow, ThreadView.this.compositeThread);
            publishWindow.setVisible(true);
        }
    };
    AbstractAction replyArticleAction = new AbstractAction("\u3053\u306e\uff9a\uff7d\uff8c\uff9e\uff9b\uff6f\uff78\u306b\u8fd4\u4fe1"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
            ThreadView.this.replyArticleWindow.setLocation(mousePoint.x - 100, mousePoint.y);
            ThreadView.this.replyArticleWindow.setVisible(true);
        }
    };
    AbstractAction deleteArticleAction = new AbstractAction("\uff9a\uff7d\u524a\u9664"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ViewNaver.instance.multiSession.nowLogin()) {
                ViewNaver.println("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            int confirm = JOptionPane.showConfirmDialog(ThreadView.this, "\uff9a\uff7d\u3092\u524a\u9664\u3057\u307e\u3059\u3002\u3088\u308d\u3057\u3044\u3067\u3059\u304b?", "\u78ba\u8a8d", 0);
            if (confirm != 0) {
                return;
            }
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getArticleFlow(ThreadView.this.compositeThread.boardName, ((NThread)ThreadView.this.compositeThread.thread).nid, ((ThreadView)ThreadView.this).selectedArticle.articleId);
            taskFlow.addStatusReceiver(ThreadView.this.createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    try {
                        ViewNaver.println("\uff9a\uff7d\u524a\u9664...");
                        ViewNaver.instance.multiSession.deleteArticle((this).ThreadView.this.compositeThread.boardName, ((NThread)(this).ThreadView.this.compositeThread.thread).nid, ((ThreadView)(this).ThreadView.this).selectedArticle.articleId);
                        ThreadView.this.updateThread();
                    }
                    catch (NetException e) {
                        ViewNaver.println(e.getMessage());
                    }
                }
            });
        }
    };
    AbstractAction closeAction = new AbstractAction("\u9589\u3058\u308b"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewNaver.instance.threadWindow.container.removeContent(ThreadView.this.clientContent);
        }
    };
    private SessionListener sessionListener = new SessionListener(){

        @Override
        public void loginChanged(String userName, boolean nowLogin) {
            ThreadView.this.nowLogin = nowLogin;
            ThreadView.this.updateButtonStatus();
        }
    };

    private void updateButtonStatus() {
        if (this.currentTaskStatus == 0) {
            this.replyThreadAction.setEnabled(false);
            this.modifyThreadAction.setEnabled(false);
            this.deleteThreadAction.setEnabled(false);
            this.favoriteAction.setEnabled(false);
            this.moveNewAction.setEnabled(false);
            this.closeAction.setEnabled(false);
            this.publishAction.setEnabled(false);
        } else if (this.currentTaskStatus == 1) {
            this.updateButton.setAction(this.updateAction);
            this.replyThreadAction.setEnabled(this.nowLogin);
            this.modifyThreadAction.setEnabled(this.nowLogin);
            this.deleteThreadAction.setEnabled(this.nowLogin);
            this.favoriteAction.setEnabled(true);
            this.moveNewAction.setEnabled(true);
            this.closeAction.setEnabled(true);
            this.publishAction.setEnabled(true);
        }
    }

    public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
        return new TaskStatusReceiver(){

            @Override
            public void statusChanged(int status) {
                if (status == 0) {
                    ThreadView.this.updateButton.setAction(new AbstractAction("\u4e2d\u6b62"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            taskFlow.cancel();
                        }
                    });
                } else if (status == 1) {
                    ThreadView.this.updateButton.setAction(ThreadView.this.updateAction);
                }
                ThreadView.this.currentTaskStatus = status;
                ThreadView.this.updateButtonStatus();
            }
        };
    }

    @Override
    public void disposeTab() {
        this.posterItems.endListen();
        ViewNaver.instance.multiSession.removeSessionListener(this.sessionListener);
        super.disposeTab();
    }

    public ThreadView(TabContentCategory category) {
        super(category);
        this.threadFormatter = ViewNaver.instance.formatter;
        this.setLayout(new BorderLayout());
        this.postArticleView = new PostArticleView(new Runnable(){

            @Override
            public void run() {
                ThreadView.this.updateThread();
            }
        }, false);
        this.replyArticleWindow = ViewNaver.instance.windowFactory.createReplyArticleWindow(ViewNaver.instance.threadWindow, new Runnable(){

            @Override
            public void run() {
                ThreadView.this.updateThread();
            }
        });
        this.replyArticleWindow.setSize(600, 120);
        this.browser = ViewNaver.instance.getBrowserFactory().createBrowser(this.threadFormatter.getInitialHtml());
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public boolean isOpaque() {
                return true;
            }
        };
        panel.setBorder(new BevelBorder(1));
        panel.add(this.browser.getComponent());
        this.updateButton.addActionListener(this.updateAction);
        this.replyThreadButton.setAction(this.replyThreadAction);
        this.modifyThreadButton.setAction(this.modifyThreadAction);
        this.deleteThreadButton.setAction(this.deleteThreadAction);
        this.favoriteButton.setAction(this.favoriteAction);
        this.moveNewButton.setAction(this.moveNewAction);
        this.publishButton.setAction(this.publishAction);
        ButtonBar toolbar = new ButtonBar();
        toolbar.add(this.updateButton);
        toolbar.add(this.moveNewButton);
        toolbar.addSeparator();
        toolbar.add(this.closeButton);
        toolbar.addSeparator();
        toolbar.add(this.replyThreadButton);
        toolbar.add(this.modifyThreadButton);
        toolbar.add(this.deleteThreadButton);
        toolbar.addSeparator();
        toolbar.add(this.favoriteButton);
        toolbar.add(this.publishButton);
        this.add((Component)toolbar, "North");
        this.add((Component)panel, "Center");
        this.add((Component)this.postArticleView, "South");
        final JPopupMenu popup = new JPopupMenu();
        this.replyArticleMenu = new JMenuItem(this.replyArticleAction);
        popup.add(this.replyArticleMenu);
        this.replyArticleMenu.setEnabled(false);
        this.deleteArticleMenu = new JMenuItem(this.deleteArticleAction);
        popup.add(this.deleteArticleMenu);
        popup.addSeparator();
        this.posterItems.addAllto(popup);
        popup.addSeparator();
        popup.add(new JMenuItem(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
            }
        }));
        this.browser.addBrowserListener(new BrowserListener(){

            @Override
            public boolean beforeNavigate(final String url) {
                if (url.startsWith("comment:")) {
                    int artId = Integer.valueOf(url.substring("comment:".length()));
                    ThreadView.this.selectedArticle = (Article)((ArticleList)ThreadView.this.compositeThread.articleList).getArticle(((ArticleList)ThreadView.this.compositeThread.articleList).getArticleIndexByArticleID(artId));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ThreadView.this.posterSelection.setCurrentPoster(new Poster(((ThreadView)(this).ThreadView.this).selectedArticle.author, ((ThreadView)(this).ThreadView.this).selectedArticle.country));
                            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
                            Point compPoint = (this).ThreadView.this.browser.getComponent().getLocationOnScreen();
                            popup.show((this).ThreadView.this.browser.getComponent(), mousePoint.x - compPoint.x, mousePoint.y - compPoint.y);
                        }
                    });
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            (this).ThreadView.this.postArticleView.setSelectedArticle(ThreadView.this.selectedArticle);
                            (this).ThreadView.this.replyArticleWindow.setSelectedArticle(ThreadView.this.selectedArticle);
                            if (ViewNaver.instance.multiSession.getUserName().equals(((ThreadView)(this).ThreadView.this).selectedArticle.author) && ((ThreadView)(this).ThreadView.this).selectedArticle.country.equals((Object)ViewNaver.instance.multiSession.getCountry())) {
                                (this).ThreadView.this.deleteArticleMenu.setEnabled(true);
                            } else {
                                (this).ThreadView.this.deleteArticleMenu.setEnabled(false);
                            }
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new OpenURLCommand(ThreadView.this, url, false).run();
                        }
                    });
                }
                return false;
            }
        });
        this.closeButton.setAction(this.closeAction);
        ViewNaver.instance.multiSession.addSessionListener(this.sessionListener);
    }

    @Override
    public void setClientContent(TabContent content) {
        this.clientContent = (ThreadContent)content;
        CompositeThread newWebThreadContents = (CompositeThread)((Object)this.clientContent.target);
        if (this.compositeThread != null && this.compositeThread.sessionType.equals((Object)newWebThreadContents.sessionType)) {
            this.updateThread(newWebThreadContents);
        } else {
            if (this.compositeThread != null && !this.compositeThread.sessionType.equals((Object)newWebThreadContents.sessionType)) {
                ViewNaver.println("DEBUG:\u30ed\u30b0\u30a4\u30f3\u72b6\u614b\u306e\u5909\u66f4\u3092\u691c\u51fa\u3057\u305f\u305f\u3081\u3001\u30ed\u30b0\u3092\u7834\u68c4\u3057\u307e\u3059\u3002");
            }
            this.postArticleView.compositeThread = this.compositeThread = newWebThreadContents;
            this.replyArticleWindow.replyArticleView.compositeThread = this.compositeThread;
            this.browser.setBodyHtml(String.valueOf(this.threadFormatter.formatThreadContent(this.compositeThread)) + this.threadFormatter.formatThreadContentFooter(this.compositeThread) + this.threadFormatter.formatArticleList(this.compositeThread) + this.threadFormatter.formatArticleFooter(this.compositeThread));
        }
        if (this.compositeThread.sessionType.equals((Object)SessionType.LOGIN)) {
            this.replyArticleMenu.setEnabled(true);
        } else {
            this.replyArticleMenu.setEnabled(false);
        }
    }

    private void updateThread() {
        CompositeThread newThread;
        if (this.replyArticleWindow.isVisible()) {
            this.replyArticleWindow.setVisible(false);
        }
        if ((newThread = ViewNaver.instance.cache.getCompositeThread(this.compositeThread.boardName, ((NThread)this.compositeThread.thread).nid, true)) != null && this.compositeThread.sessionType.equals((Object)newThread.sessionType)) {
            this.updateThread(newThread);
        } else {
            if (this.compositeThread != null && !this.compositeThread.sessionType.equals((Object)newThread.sessionType)) {
                ViewNaver.println("DEBUG:\u30ed\u30b0\u30a4\u30f3\u72b6\u614b\u306e\u5909\u66f4\u3092\u691c\u51fa\u3057\u305f\u305f\u3081\u3001\u30ed\u30b0\u3092\u7834\u68c4\u3057\u307e\u3059\u3002");
            }
            this.postArticleView.compositeThread = this.compositeThread = newThread;
            this.replyArticleWindow.replyArticleView.compositeThread = this.compositeThread;
            this.browser.setBodyHtml(String.valueOf(this.threadFormatter.formatThreadContent(this.compositeThread)) + this.threadFormatter.formatThreadContentFooter(this.compositeThread) + this.threadFormatter.formatArticleList(this.compositeThread) + this.threadFormatter.formatArticleFooter(this.compositeThread));
        }
        if (this.compositeThread.sessionType.equals((Object)SessionType.LOGIN)) {
            this.replyArticleMenu.setEnabled(true);
        } else {
            this.replyArticleMenu.setEnabled(false);
        }
    }

    private void updateThread(CompositeThread newThread) {
        this.browser.replaceBodyHtml("thread:header", this.threadFormatter.formatThreadHeader(newThread));
        if (!this.compositeThread.contents.equals(newThread.contents)) {
            this.compositeThread.contents = newThread.contents;
            this.browser.replaceBodyHtml("thread:content", ViewNaver.instance.threadDecorator.decorate(newThread.contents));
        }
        ((ArticleList)this.compositeThread.articleList).merge((ArticleList)newThread.articleList);
        ViewNaver.instance.cache.putCompositeThread(this.compositeThread);
        ViewNaver.instance.threadStorage.storeThread(this.compositeThread);
        int lastVisibleSno = -1;
        int i = 0;
        while (i < ((ArticleList)this.compositeThread.articleList).getArticleCount()) {
            Article art = (Article)((ArticleList)this.compositeThread.articleList).getArticle(i);
            FilterType filterType = ViewNaver.instance.config.getFilterConfig().filters.get(new Poster(art.author, art.country));
            if (filterType == null) {
                filterType = FilterType.NOAction;
            }
            boolean isFavoritePerson = ViewNaver.instance.config.getFavoritePersonConfig().persons.contains(new Poster(art.author, art.country));
            int prevId = -1;
            if (i > 0) {
                prevId = ((Article)((ArticleList)this.compositeThread.articleList).getArticle((int)(i - 1))).articleId;
            }
            if (art.isNew) {
                String articleHtml = this.threadFormatter.formatArticle(lastVisibleSno, art, filterType, isFavoritePerson);
                this.browser.insertBodyHtml("comment:" + prevId, articleHtml);
            } else if (art.prevIsNew || art.isDeleted) {
                this.browser.replaceBodyHtml("comment:" + art.articleId, this.threadFormatter.formatInnerArticle(lastVisibleSno, art, filterType, isFavoritePerson));
            }
            if (!filterType.equals((Object)FilterType.Hidden)) {
                lastVisibleSno = art.sno;
            }
            ++i;
        }
    }

    @Override
    public void refreshContent() {
    }
}

