/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.movie;

import com.aibonware.viewnaver.server.UserSession;
import com.aibonware.viewnaver.server.movie.MovieWorker;

public class Movie {
    public final int no;
    public final String srcUrl;
    public MovieWorker worker;
    public byte[] contents = null;
    public String msg = "";

    public Movie(UserSession user, int no, String url) {
        this.no = no;
        this.srcUrl = url;
        this.worker = new MovieWorker(user, this);
    }

    public String getCaption() {
        String statusText = this.getStatusText();
        if (statusText == null) {
            return "\u52d5\u753b";
        }
        return "\u52d5\u753b(" + statusText + ")";
    }

    private String getStatusText() {
        switch (this.worker.getStatus()) {
            case 0: {
                return null;
            }
            case 1: {
                return "\uff80\uff9e\uff73\uff9d\uff9b\uff70\uff84\uff9e\u4e2d:" + this.toShortBytes(this.worker.processedBytes);
            }
            case 2: {
                return "\uff74\uff9d\uff7a\uff70\uff84\uff9e\u4e2d";
            }
            case 3: {
                return "\u5b8c\u4e86:" + this.toShortBytes(this.contents.length);
            }
            case 4: {
                return "\u5931\u6557";
            }
        }
        return "unknown status";
    }

    private String toShortBytes(int len) {
        if (len < 1024) {
            return String.valueOf(len) + "B";
        }
        if (len < 0x100000) {
            return String.valueOf(len / 1024) + "KB";
        }
        return String.valueOf(len / 1024 / 1024) + "MB";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        MovieWorker movieWorker = this.worker;
        synchronized (movieWorker) {
            if (this.worker.getState() == Thread.State.NEW) {
                this.worker.start();
            }
        }
    }
}

