/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.server.servlet;

import Acme.Serve.servlet.ServletOutputStream;
import Acme.Serve.servlet.http.HttpServletRequest;
import Acme.Serve.servlet.http.HttpServletResponse;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.model.Board;
import com.aibonware.viewnaver.model.BoardTitle;
import com.aibonware.viewnaver.model.NThread;
import com.aibonware.viewnaver.parser.BoardParser;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;
import com.aibonware.viewnaver.server.servlet.BaseServlet;
import com.aibonware.viewnaver.server.servlet.WriteNewThreadServlet;

public class BoardServlet
extends BaseServlet {
    @Override
    public String getName() {
        return "board";
    }

    public static String createUrl(UserSession user, String boardName, int page) {
        String url = "board?sid=" + user.sid + "&b=" + boardName;
        if (page < 1) {
            page = 1;
        }
        url = String.valueOf(url) + "&p=" + page;
        return url;
    }

    private void showTools(ServletOutputStream out, boolean header, UserSession user, String boardName, int pageNo) throws Exception {
        out.print(" <a href=\"main?sid=" + user.sid + "\">\u5165\u53e3</a>");
        if (header) {
            out.print("<a href=\"#bottom\">\u4e0b</a>");
        } else {
            out.print("<a href=\"#top\">\u4e0a</a>");
        }
        if (pageNo > 1) {
            out.print("<a href=\"" + BoardServlet.createUrl(user, boardName, pageNo - 1) + "\">\u524d</a>");
        }
        out.print("<a href=\"" + BoardServlet.createUrl(user, boardName, pageNo + 1) + "\">\u6b21</a>");
        out.print("<a href=\"" + WriteNewThreadServlet.createUrl(user, boardName) + "\">\u6295</a>");
        out.print(" <a href=\"logout?sid=" + user.sid + "\">\uff9b\uff78\uff9e\uff71\uff73\uff84</a>");
    }

    @Override
    public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
        String boardName = request.getParameter("b");
        String sPage = request.getParameter("p");
        int pageNo = Integer.parseInt(sPage);
        out.println("<a name=\"top\">");
        out.print("P" + pageNo);
        this.showTools(out, true, user, boardName, pageNo);
        out.println("<hr>");
        BoardTitle boardTitle = (BoardTitle)ViewNaver.instance.boardTitles.getBoardTitle(boardName);
        BoardParser parser = new BoardParser(ViewNaver.instance.modelProvider);
        Board board = (Board)parser.parse(ViewNaver.instance.multiSession, ViewNaver.instance.web.getBoardPageUrl(boardName, pageNo), boardTitle.boardName, boardTitle.dispName, boardTitle.boardType, pageNo);
        int i = 0;
        while (i < board.getThreadCount()) {
            NThread thread = (NThread)board.getThread(i);
            String baseTitle = thread.title;
            if (baseTitle.trim().length() == 0) {
                baseTitle = "<i>(\u7a7a\u6b04\u306e\uff80\uff72\uff84\uff99)</i>";
            }
            String title = "";
            int j = 0;
            while (j < thread.depth) {
                title = String.valueOf(title) + "\u3000";
                ++j;
            }
            if (thread.depth > 0) {
                title = String.valueOf(title) + "\u2514";
            }
            title = String.valueOf(title) + baseTitle;
            out.print("<a href=\"thread?sid=" + user.sid + "&b=" + board.boardName + "&t=" + thread.nid + "&s=0\">+</a> ");
            out.print(String.valueOf(title) + " " + thread.country.toHtml() + " <b>" + thread.poster + "</b> ");
            out.println("[" + thread.articleNum + "]<hr>");
            ++i;
        }
        this.showTools(out, false, user, boardName, pageNo);
        out.println("<a name=\"bottom\">");
    }
}

