/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.window;

import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.viewnaver.ViewNaver;
import com.aibonware.viewnaver.content.message.SentMessageContent;
import com.aibonware.viewnaver.task.GUITask;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.TaskStatusReceiver;
import com.aibonware.viewnaver.task.WorkerTask;
import com.aibonware.viewnaver.view.WriteMessageView;
import com.aibonware.viewnaver.window.ChildWindow;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class WriteMessageWindow
extends JDialog
implements ChildWindow {
    public WriteMessageView writeMessageView;
    JButton okButton = new JButton();
    JButton cancelButton = new JButton("Cancel");
    AbstractAction okAction = new AbstractAction("OK"){

        @Override
        public void actionPerformed(ActionEvent e) {
            final String receiver = WriteMessageWindow.this.writeMessageView.receiverText.getText();
            final Country country = (Country)WriteMessageWindow.this.writeMessageView.countryCombo.getSelectedItem();
            final String messageText = WriteMessageWindow.this.writeMessageView.messageTextView.getText();
            final boolean saveServer = WriteMessageWindow.this.writeMessageView.saveServerCheck.isSelected();
            if (messageText.length() > 400) {
                ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u5236\u9650\u5024\u3092\u8d85\u3048\u3066\u3044\u307e\u3059");
            }
            TaskFlow taskFlow = ViewNaver.instance.taskFlowList.createNewFlow();
            taskFlow.addStatusReceiver(WriteMessageWindow.this.createTaskStatusReceiver(taskFlow));
            taskFlow.execute(new WorkerTask(ViewNaver.instance.appTools){

                @Override
                public void exec() {
                    try {
                        ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u958b\u59cb..");
                        ViewNaver.instance.multiSession.sendMessage(receiver, country, messageText, saveServer);
                        ViewNaver.println("\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u7d42\u4e86\u3002");
                        WriteMessageWindow.this.dispose();
                        this.taskFlow.execute(new GUITask(ViewNaver.instance.appTools){

                            @Override
                            public void exec() {
                                ViewNaver.instance.mainWindow.containerView.update(SentMessageContent.getConstantCategory());
                            }
                        });
                    }
                    catch (NetException e) {
                        ViewNaver.err((Exception)((Object)e));
                    }
                }
            });
        }
    };

    public TaskStatusReceiver createTaskStatusReceiver(final TaskFlow taskFlow) {
        return new TaskStatusReceiver(){

            @Override
            public void statusChanged(int status) {
                if (status == 0) {
                    WriteMessageWindow.this.okButton.setAction(new AbstractAction("\u4e2d\u6b62"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            taskFlow.cancel();
                        }
                    });
                    WriteMessageWindow.this.cancelButton.setEnabled(false);
                } else if (status == 1) {
                    WriteMessageWindow.this.okButton.setAction(WriteMessageWindow.this.okAction);
                    WriteMessageWindow.this.cancelButton.setEnabled(true);
                }
            }
        };
    }

    public WriteMessageWindow(JFrame parent, String receiver, Country country, String initialText) {
        super(parent);
        this.setDefaultCloseOperation(2);
        this.setTitle(String.valueOf(receiver) + " \u3078\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1");
        this.writeMessageView = new WriteMessageView();
        this.writeMessageView.receiverText.setText(receiver);
        this.writeMessageView.countryCombo.setSelectedItem(country);
        this.writeMessageView.messageTextView.setText(initialText);
        this.writeMessageView.setReceiverEditable(false);
        Box buttonBox = new Box(2);
        buttonBox.add(Box.createGlue());
        buttonBox.add(this.okButton);
        buttonBox.add(this.cancelButton);
        this.add((Component)this.writeMessageView, "Center");
        this.add((Component)buttonBox, "South");
        this.setBounds(200, 200, 500, 400);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WriteMessageWindow.this.dispose();
            }
        });
        this.okButton.setAction(this.okAction);
        ViewNaver.instance.childWindowActivator.addChildWindow(this);
    }
}

