/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.nvrlib.parser;

import com.aibonware.nvrlib.BaseInstantiator;
import com.aibonware.nvrlib.model.BaseArticle;
import com.aibonware.nvrlib.model.BaseArticleList;
import com.aibonware.nvrlib.model.BaseBoard;
import com.aibonware.nvrlib.model.BaseCompositeThread;
import com.aibonware.nvrlib.model.BaseFoundThreads;
import com.aibonware.nvrlib.model.BaseThread;
import com.aibonware.nvrlib.model.BoardType;
import com.aibonware.nvrlib.model.Country;
import com.aibonware.nvrlib.net.NaverSession;
import com.aibonware.nvrlib.net.NetException;
import com.aibonware.nvrlib.parser.BaseThreadParser;
import com.aibonware.nvrlib.parser.ParsingContext;
import com.aibonware.nvrlib.parser.ParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BaseBoardParser<TBoard extends BaseBoard<TThread>, TCompositeThread extends BaseCompositeThread<TArticle, TArticleList, TThread>, TArticle extends BaseArticle<TArticle>, TArticleList extends BaseArticleList<TArticle>, TFoundThreads extends BaseFoundThreads<TThread>, TThread extends BaseThread, TBoardParser extends BaseBoardParser<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator>, TThreadParser extends BaseThreadParser<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator>, TInstantiator extends BaseInstantiator<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator>> {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yy.MM.dd");
    private BaseInstantiator<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator> modelProvider;

    public BaseBoardParser(BaseInstantiator<TBoard, TCompositeThread, TArticle, TArticleList, TFoundThreads, TThread, TBoardParser, TThreadParser, TInstantiator> modelProvider) {
        this.modelProvider = modelProvider;
    }

    public TBoard parse(NaverSession naverSession, String urlString, String boardName, String dispName, BoardType boardType, int pageNo) throws ParsingException, NetException {
        return this.parse(naverSession.open(urlString), boardName, dispName, boardType, pageNo);
    }

    public TBoard parse(BufferedReader reader, String boardName, String dispName, BoardType boardType, int pageNo) throws ParsingException, NetException {
        TBoard page = this.parse(boardName, dispName, boardType, reader, pageNo);
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("URL\u30af\u30ed\u30fc\u30ba\u5931\u6557", e);
        }
        return page;
    }

    private TBoard parse(String boardName, String dispName, BoardType boardType, BufferedReader reader, int pageNo) throws ParsingException, NetException {
        ParsingContext ct = new ParsingContext(reader);
        ct.seek("BBS TOP");
        int totalPages = 0;
        ct.seek("<!-- List -->");
        TBoard page = this.modelProvider.createBoard(boardName, dispName, boardType, pageNo, totalPages);
        this.parseThreadSummaries(ct, page);
        return page;
    }

    private void parseThreadSummaries(ParsingContext ct, TBoard page) throws ParsingException, NetException {
        while (ct.seek("<td", "</table>")) {
            Date createDate;
            String poster;
            int articleNum;
            int depth;
            int end;
            boolean isHot;
            boolean isAdminThread;
            String dispId;
            String dispIdText = ct.cut("'num02'>", "</td>");
            String imgText = ct.cut(null, "class='typo_ms02'");
            String depthText = ct.cut(null, "<a ");
            String nidText = ct.cut("href='", "'");
            String titleText = ct.cut(">", "</a>");
            String artNumText = ct.cut(null, "class='num03'>");
            String countryAndAuthorText = ct.cut(null, "class='num01'>");
            String dateText = ct.cut(null, "</td>");
            String viewNumText = ct.cut("class='num01'>", "</td>");
            if (dispIdText.contains("bbs_kokuchi")) {
                dispId = "";
                isAdminThread = true;
                isHot = false;
            } else if (dispIdText.contains("add_hot_icon1")) {
                dispId = "";
                isAdminThread = false;
                isHot = true;
            } else {
                dispId = dispIdText;
                isAdminThread = false;
                isHot = false;
            }
            String imgUrl = null;
            int start = imgText.indexOf("<img src='");
            if (start != -1) {
                end = imgText.indexOf(39, start += "<img src='".length());
                imgUrl = imgText.substring(start, end);
            }
            start = 0;
            int depthEnd = depthText.indexOf("<img");
            if (depthEnd == -1) {
                depth = 0;
            } else {
                int depthCount = 2;
                while ((start = depthText.indexOf("&nbsp;", start)) != -1 && start <= depthEnd) {
                    start += 5;
                    ++depthCount;
                }
                depth = depthCount / 2;
            }
            nidText = nidText.substring(nidText.indexOf("nid=") + 4);
            end = nidText.indexOf(38);
            if (end == -1) {
                end = nidText.length();
            }
            int nid = Integer.parseInt(nidText.substring(0, end));
            String title = titleText;
            start = artNumText.indexOf("<strong>");
            if (start == -1) {
                articleNum = 0;
            } else {
                end = artNumText.indexOf("</strong>");
                articleNum = Integer.parseInt(artNumText.substring(start + "<strong>".length(), end));
            }
            if (countryAndAuthorText.contains("javascript:ui")) {
                start = countryAndAuthorText.indexOf("num03\">") + "num03\">".length();
                end = countryAndAuthorText.indexOf("</a>");
                poster = countryAndAuthorText.substring(start, end);
            } else {
                poster = countryAndAuthorText.contains("\u904b\u55b6\u8005") ? "enjoymaster" : "";
            }
            int japan = countryAndAuthorText.indexOf("alt='JAPAN'");
            int korea = countryAndAuthorText.indexOf("alt='KOREA'");
            japan = japan >= 0 ? japan : Integer.MAX_VALUE;
            korea = korea >= 0 ? korea : Integer.MAX_VALUE;
            Country country = japan < korea ? Country.JAPAN : Country.KOREA;
            try {
                createDate = dateFormat.parse(dateText);
            }
            catch (ParseException e) {
                throw new ParsingException(e, ct.toString());
            }
            int viewNum = Integer.parseInt(viewNumText);
            ((BaseBoard)page).addThread(this.modelProvider.createThread(depth, dispId, isAdminThread, nid, country, title, articleNum, poster, createDate, createDate, viewNum, null, new Date(), isHot, imgUrl));
            if (ct.seek("<tr align='center'>", "</table>")) continue;
        }
    }
}

