#define DFMOD_ALT      0x00010000
#define DFMOD_CTRL     0x00020000
#define DFMOD_SHIFT    0x00040000
#define DFMOD_CHAR     0x00080000
#define DFMOD_MASK     0xFFFF0000
#define DFMOD_KEYMASK  0x0000FFFF

enum{
  NOP = 0,
  OPEN,
  CURUP,
  CURDOWN,
  PAGEUP,
  PAGEDOWN,
  TOP,
  BOTTOM,
  MARK,
  MULTIMARK,
  CLEARMARK,
  REVMARK,
  FILTER,
  IFILTER,
  SHOWDOTS,
  GOTO,
  GOTOPARENT,
  CANCEL,
  COPY,
  MOVE,
  LINK,
  SYMLINK,
  DELETE,
  CHMOD,
  CHOWN,
  CHGRP,
  MKFILE,
  MKDIR,
  RENAME,
  HORIZ_LEFT,
  HORIZ_RIGHT,
  RELOAD,
  REFRESH,
  INFO,
  EXECUTE,
  QUIT,
  ISEARCH,
  SORTNAME,
  SORTSIZE,
  SORTTIME,
  SORTEXT,
  SORTATTR,
  CMDLIST,
  PATHLIST,
  BUFLIST,
  SPLIT_H,
  SPLIT_V,
  ENLARGE_H,
  ENLARGE_V,
  SHRINK_H,
  SHRINK_V,
  CLOSE,
  KILL,
  KILLOTHER,
  NEWBUFFER,
  SWITCHBUFFER,
  NEXTFRAME,
  PREVFRAME,
  VIEW,
  CHCHARSET,
  CHNEWLINE,
  VIEWFIND,
  VIEWFINDNEXT,
  VIEWFINDPREV,
  CFGRELOAD,
  DUMPMEMINFO,
  DUMPBUFFERINFO,
}builtin_cmd;

enum{
  CREQ_DONE,
  CREQ_IGNORE,
  CREQ_TOPARENT,
}cmd_result;

#define CMD_ANY           (0)
#define CMD_FILER         (1)
#define CMD_VIEWER   (1 << 1)
#define CMD_CMDLIST  (1 << 2)
#define CMD_PATHLIST (1 << 3)
#define CMD_BUFLIST  (1 << 4)
#define CMD_CANDI    (1 << 5)

void CmdReset(void);
void CmdSetTable(int type);
const DfCmdStr *CmdTypeAheadGetAnchor(void);
const DfCmdStr *CmdTypeAhead(KeySym ksym, char ch, const DfCmdStr *anchor);
void CmdCandNext(void);
int LoadKeyDefine(void);
int findCommand(const char *cmd);
const char *CmdNoToStr(int cmd);

int CommandHandler(void *ptr, Widget w, const DfCmdStr *c, int macro);



