typedef struct _tagCharConv CharConv;

struct line{
  int pos;
  int len;
};

struct lines{
  struct line *index;
  int num;
  int alloced;
};

struct _tagCharConv{
  int (*conv)(CharConv *);
#ifdef HAVE_ICONV
  iconv_t ictx;
#endif
  enum CHARSET charset;
  int state;
  int pre_state;       /* for rollback state in illegal seq. */
  DfStr *src;
  int offset;
  int left;
  DfStr *dst;
  int newline;         /* type of newline */
  int newline_offset;  /* offset for detect newline */
  unsigned int pre_ch; /* for detecting newline CR/LF */
};

#define ALLOC_LINES (4096 / sizeof(struct line))

int CharsetConvert(CharConv *ctx, struct lines *l);
void ConvertClose(CharConv *ctx);
void SetupEncoding(CharConv *ctx, DfStr *src, DfStr *dst);

void SetupXXXX(CharConv *ctx);
void SetupNewline(CharConv *ctx);

