#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <strings.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <X11/Intrinsic.h>
#include <X11/keysym.h>
#include <X11/StringDefs.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "task.h"
#include "dialog.h"
#include "extmacro.h"
#include "cmd.h"
#include "mem.h"
#include "dfxfunc.h"
#include "debug.h"

#define MODE_MACRO 1
#define MODE_MARK (1 << 1)
#define MODE_NEXT (1 << 2)

static char *storeFile(DfFileList *b, DfStr *cmd, char *store, MbStr *mb, int mode);
static char *storePath(DfFileList *b, DfStr *cmd, char *store, MbStr *mb);
static task_result parseMacro(DfTask *t);
static task_result parseDone(DfTask *t);
static task_result applyInput(DfTask *t);

task_vtable vtable_extmacro = {
  parseMacro,
  commonNotify,
  parseDone,
  NULL,
  NULL,
  NULL,
  NULL,
};

task_vtable vtable_macroinput = {
  applyInput,
  NULL,
};


int ParseMacro2(Widget w, DfStr *cmd, DfBuf *b, void (*done)(DfTask*), void *arg)
{
  DfTask *t;
  struct parse_extention *pe;

  t = MakeTask(w, b, DO_COPY, DLG_COPY_FAIL, sizeof(*pe));
  if(!t){
    return 1;
  }

  t->list = GetFilerBuffer(b);
  Str_InitStr(&t->cwd, t->list->cwd);
  t->now_proc = t->files;

  pe = t->extend;
  InitMbStr(&pe->mb, Str_Get(cmd));
  Str_Move(&pe->cmd, cmd);
  pe->immediate = 0;
  pe->done = done;
  pe->arg = arg;

  t->v = &vtable_extmacro;

  parseMacro(t);

  return 0;
}

static task_result parseMacro(DfTask *t)
{
  char *p;
  char *store;
  int mode;
  struct parse_extention *pe = t->extend;
  DfInputDialog *d;

  dprintf("parseMacro: %s\n", pe->mb.str);

  p = (char *)pe->mb.str;
  mode = 0;

  while(*p){
    if(pe->mb.c_len != 1){
      if(mode & MODE_MARK){
	store = storeFile(t->list, &pe->cmd, store, &pe->mb, mode);
      }else if(mode & MODE_NEXT){
	store = storePath(t->list, &pe->cmd, store, &pe->mb);
      }
      goto NEXTCHAR;
    }
    switch(*p){
    case '$':
      store = p;
      p = MbNextChar(&pe->mb);
      dprintf("parseMacro: $%s\n", p);
      mode = MODE_MACRO;
      break;
    }
    if(mode == 0){
      goto NEXTCHAR;
    }
    switch(*p){
    case 'F':
      store = storeFile(t->list, &pe->cmd, store, &pe->mb, mode);
      mode = 0;
      p = store;;
      continue;
      break;
    case 'M':
      dprintf("$M: marked file\n");
      mode |= MODE_MARK;
      break;
    case 'T':
      dprintf("$T: next\n");
      mode |= MODE_NEXT;
      t->list = GetNextFileBuf(t->list);
      break;
    case 'P':
      store = storePath(t->list, &pe->cmd, store, &pe->mb);
      mode = 0;
      p = store;;
      dprintf("parseMacro: left %s\n", p);
      continue;
      break;
    case 'R':
      pe->immediate = 1;
      Str_Delete(&pe->cmd, (store - Str_Get(&pe->cmd)), p - store + 1);
      p = store;
      InitMbStr(&pe->mb, p);
      continue;
      break;
    case 'I':
      Str_Delete(&pe->cmd, (store - Str_Get(&pe->cmd)), p - store + 1);
      pe->store = store;

      t->v = &vtable_macroinput;
      Str_InitStr(&t->input, "");
      d = MakeInputDialog(t, "", inputKeyProc);
      ShowInputDialog(d, CAP_MACROINPUT);
      return TASK_LEAVE;

    default:
      if(mode & MODE_MARK){
	store = storeFile(t->list, &pe->cmd, store, &pe->mb, mode);
      }else if(mode & MODE_NEXT){
	store = storePath(t->list, &pe->cmd, store, &pe->mb);
      }
      mode = 0;
    }
  NEXTCHAR:
    p = MbNextChar(&pe->mb);
  }
  if(mode & MODE_MARK){
    storeFile(t->list, &pe->cmd, store, &pe->mb, mode);
  }else if(mode & MODE_NEXT){
    storePath(t->list, &pe->cmd, store, &pe->mb);
  }
  Str_SetLength(&pe->cmd, Str_Length(&pe->cmd));
  dprintf("parseMacro: finish %s immediate: %d\n", Str_Get(&pe->cmd), pe->immediate);

  DlgSendEvent(t, taskCbDone);

  return TASK_LEAVE;
}

static task_result parseDone(DfTask *t)
{
  struct parse_extention *pe = t->extend;

  dprintf("parseDone: pe->cmd %s immediate: %d\n", Str_Get(&pe->cmd), pe->immediate);
  (pe->done)(t);

  return TASK_FREE;
}

static task_result applyInput(DfTask *t)
{
  struct parse_extention *pe = t->extend;
  int idx;

  dprintf("apply input: %s\n", pe->store);

  idx = pe->store - Str_Get(&pe->cmd);
  Str_Insert(&pe->cmd, idx, Str_Get(&t->input));

  idx += Str_Length(&t->input);
  InitMbStr(&pe->mb, Str_Get(&pe->cmd) + idx);

  t->v = &vtable_extmacro;
  DlgSendEvent(t, taskCbInvoke);

  return TASK_LEAVE;
}


static char *storePath(DfFileList *b, DfStr *cmd, char *store, MbStr *mb)
{
  int idx;
  const char *p;

  dprintf("store path: store %s to %s\n", store, mb->str);
  p = mb->str;
  idx = store - Str_Get(cmd);
  dprintf("store path: 1. %s(%d)\n", Str_Get(cmd), Str_Length(cmd));
  Str_Delete(cmd, idx, p - store + 1);
  dprintf("store path: 2. %s(%d)\n", Str_Get(cmd), Str_Length(cmd));
  Str_InsertEscape(cmd, idx, b->cwd);
  dprintf("store path: 3. %s(%d)\n", Str_Get(cmd), Str_Length(cmd));

  idx += strlen(b->cwd);
  InitMbStr(mb, Str_Get(cmd) + idx);

  return Str_Get(cmd) + idx;
}

static char *storeFile(DfFileList *b, DfStr *cmd, char *store, MbStr *mb, int mode)
{
  int idx;
  const char *p;
  char *sel;
  DfFile *f;
  DfStr s;
  int len;

  p = mb->str;/* current point */
  idx = store - Str_Get(cmd);

  Str_Delete(cmd, idx, p - store + 1);
  if(mode & MODE_MARK){
    MakeSelectList(&s, b);
    sel = Str_Get(&s);
    while(*sel){
      Str_InsertEscape(cmd, idx, sel);
      len = strlen(sel);
      idx += len;
      Str_Insert(cmd, idx, " ");
      idx++;
      sel += (len + 1);
    }
    Str_Free(&s, 0);
  }else{
    f = b->files[b->b.nCur];
    Str_InsertEscape(cmd, idx, f->name);
    idx += strlen(f->name);
  }
  InitMbStr(mb, Str_Get(cmd) + idx);

  return Str_Get(cmd) + idx;
}
