#if MEMDEBUG
typedef struct _meminfo{
  void *p;
  int size;
  const char *file;
  const char *func;
  int line;
  int freed;
}MEMINFO;

#define bMalloc(A) dbgMalloc(A, __FILE__, __FUNCTION__, __LINE__)
#define bReAlloc(A,B) dbgReAlloc(A,B,__FILE__, __FUNCTION__, __LINE__)
#define bFree(A) dbgFree(A,__FILE__, __FUNCTION__, __LINE__)
void *dbgMalloc(int size, const char *file, const char *func, int line);
void *dbgReAlloc(void *ptr, int size, const char *file, const char *func, int line);
void dbgFree(void *ptr, const char *file, const char *func, int line);
void DumpMemInfo(void);
void MemModInfo(void *ptr, const char *file, const char *func, int line);
MEMINFO *FindMemInfo(void *p);
void trap_free(void *p);
int is_trap(void *trap);
#else
#define bMalloc(A) malloc(A)
#define bReAlloc(A,B) realloc(A,B)
#define bFree(A) free(A)
#define DumpMemInfo() ((void)(0))
#define trap_free(A) ((void)(0))
#define is_trap(A) ((void)(0))
#endif
