#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "dfxfunc.h"

static int compareName(DfFile **a, DfFile **b);
static int compareSize(DfFile **a, DfFile **b);
static int compareTime(DfFile **a, DfFile **b);
static int compareExt(DfFile **a, DfFile **b);
static int compareAttr(DfFile **a, DfFile **b);

static int compareIsDir(DfFile *a, DfFile *b);
#if 0
static void comb_sort(DfFile **base, int num, int size, int (*comp)(void *, void *));
static void comb_qsort(DfFile **base, int num, int size, int (*comp)(void *, void *));
#endif

void SortFileList(DfFileList *list)
{
  int (*pfnCompare)(const void*, const void*);

  if(list->b.nItems < 1){
    return;
  }

  switch(list->sort){
  case SORT_NONE:
    return;
    break;
  case SORT_NAME:
    pfnCompare = (int (*)(const void*,const void*))compareName;
    break;
  case SORT_SIZE:
    pfnCompare = (int (*)(const void*,const void*))compareSize;
    break;
  case SORT_TIME:
    pfnCompare = (int (*)(const void*,const void*))compareTime;
    break;
  case SORT_EXT:
    pfnCompare = (int (*)(const void*,const void*))compareExt;
    break;
  case SORT_ATTR:
    pfnCompare = (int (*)(const void*,const void*))compareAttr;
    break;
  default:
    return;
  }
  //comb_sort(list->files, list->nFiles, sizeof(DfFile*), (void*)compareItem);
  //comb_qsort(list->files, list->nFiles, sizeof(DfFile*), (void*)compareItem);
  qsort(list->files, list->b.nItems, sizeof(DfFile*), pfnCompare);
}

#if 0
void comb_sort(DfFile **base, int num, int size, int (*comp)(void *, void *))
{
  static const int pre_gap[] = {1, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 11, 11, 11, 11, 12, 13};
  int gap;
  int a, b;
  int loop;
  DfFile *p;

  if(num < 1){
    return;
  }
  gap = num;
  do{
    loop = 0;
    if(gap < (sizeof(pre_gap) / sizeof(int)) ){
      gap = pre_gap[gap];
    }else if(104 <= gap && gap < 143){
      gap = 11;
    }else{
      gap = gap * 10 / 13;
    }

    b = a + gap;
    for(a = 0, b = gap; b < num; a++, b++){
      if(0 < compareItem(&base[a], &base[b])){
	p = base[a];
	base[a] = base[b];
	base[b] = p;
	loop = 1;
      }
    }
  }while(loop || 1 < gap);
}

void comb_qsort(DfFile **base, int num, int size, int (*comp)(void *, void *))
{
  static const int pre_gap[] = {1, 1, 1, 2, 3, 3, 4, 5, 6, 6, 7, 8, 11, 11, 11, 11, 12, 13};
  int gap;
  int a, b;
  int loop;
  DfFile *p;

  if(num < 1){
    return;
  }
  gap = num;
  do{
    loop = 0;
    if(gap < 8){
      return qsort(base, num, size, comp);
    }else if(gap < (sizeof(pre_gap) / sizeof(int)) ){
      gap = pre_gap[gap];
    }else if(104 <= gap && gap < 143){
      gap = 11;
    }else{
      gap = gap * 10 / 13;
    }

    b = a + gap;
    for(a = 0, b = gap; b < num; a++, b++){
      if(0 < compareItem(&base[a], &base[b])){
	p = base[a];
	base[a] = base[b];
	base[b] = p;
	loop = 1;
      }
    }
  }while(loop || 1 < gap);
}

#endif
static int compareName(DfFile **a, DfFile **b)
{
  int n;

  n = compareIsDir(*a, *b);
  if(n){
    return n;
  }

  return strcmp(a[0]->name, b[0]->name);
}

static int compareSize(DfFile **a, DfFile **b)
{
  int n;

  n = compareIsDir(*a, *b);
  if(n){
    return n;
  }

  n = a[0]->size - b[0]->size;
  if(n){
    return n;
  }

  return strcmp(a[0]->name, b[0]->name);
}

static int compareTime(DfFile **a, DfFile **b)
{
  int n;

  n = compareIsDir(*a, *b);
  if(n){
    return n;
  }

  n = a[0]->mtime - b[0]->mtime;
  if(n){
    return n;
  }

  return strcmp(a[0]->name, b[0]->name);
}

static int compareExt(DfFile **a, DfFile **b)
{
  int n;

  n = compareIsDir(*a, *b);
  if(n){
    return n;
  }
  n = strcmp(a[0]->ext, b[0]->ext);
  if(n){
    return n;
  }

  return strcmp(a[0]->name, b[0]->name);
}

static int compareAttr(DfFile **a, DfFile **b)
{
  int n;

  n = compareIsDir(*a, *b);
  if(n){
    return n;
  }

  n = a[0]->attr - b[0]->attr;
  if(n){
    return n;
  }

  return strcmp(a[0]->name, b[0]->name);
}


static int compareIsDir(DfFile *a, DfFile *b)
{
  char *a_name;
  char *b_name;
  int n;

  a_name = a->name;
  b_name = b->name;

  n  = S_ISDIR(a->r_attr) ? 2 : 0;
  n |= S_ISDIR(b->r_attr) ? 1 : 0;

  switch(n){
  case 0:/* both are not directory */
    break;
  case 1:/* b is directory */
    return 1;
    break;
  case 2:/* a is directory */
    return -1;
    break;
  case 3:/* both are directory */
    break;
  }

  n  = a_name[0] == '.' ? 2 : 0;
  n |= b_name[0] == '.' ? 1 : 0;

  switch(n){
  case 0:/* both isn't dot file */
    break;
  case 1:/* b is dot file */
    return 1;
    break;
  case 2:/* a is dot file */
    return -1;
    break;
  case 3:/* both is dot file */
    break;
  }

  return 0;
}
