#include <stdio.h>
#include <string.h>
#include "config.h"
#include "str.h"

static void skip(MbStr *p)
{
  while(p->str[0]){
    if(p->c_len == 1 && p->str[0] == ':'){
      MbNextChar(p);
      break;
    }
    MbNextChar(p);
  }
}

static const char *backtrack(MbStr *pat, const char *pre_wild, MbStr *str, const char *str_wild)
{
  InitMbStr(pat, pre_wild);
  InitMbStr(str, str_wild);
  return NULL;
}


int procBrackets(MbStr *pat, MbStr *str)
{
  int match;
  int ban;

  MbNextChar(pat);
  ban = 0;
  switch(pat->str[0]){
  case '\0':
  case ']':
    return 1;
  case '!':
    MbNextChar(pat);
    ban = 1;
  }

  match = ban;
  while(pat->str[0] && pat->str[0] != ']'){
    if(StrEqChar(pat, str)){
      match = 1 - ban;
      do{
	MbNextChar(pat);
      }while(pat->str[0] && pat->str[0] != ']');
      break;
    }
    MbNextChar(pat);
  }

  return match;
}


int IsMatch(const char *s_pat, const char *s_str)
{
  MbStr pat;
  MbStr str;
  int c;
  int wild;
  int result = MATCH;
  const char *pre_wild;
  const char *str_wild;
  int escaped;

  if(s_pat[0] == '\0'){
    /* pattern is empty, make it to agree. */
    return MATCH;
  }
  InitMbStr(&pat, s_pat);
  while(pat.str[0]){
    wild = 0;
    pre_wild = NULL;
    escaped = 0;
    InitMbStr(&str, s_str);
    while(str.str[0]){
      c = EOF;
      if(pat.c_len <= 1){
	c = pat.str[0];
      }

      if(!escaped){
	switch(c){
	case '*':
	  pre_wild = pat.str;
	  str_wild = str.str;
	  wild = 1;
	  break;

	case '?':
	  /* is next str's char not NUL? */
	  MbNextChar(&str);
	  wild = 0;
	  break;

	case '[':
	  if(procBrackets(&pat, &str) == 0){
	    result = UNMATCH;
	    goto NEXT_PATERN;
	  }
	  MbNextChar(&str);
	  break;
	case '\\':
	  escaped = 1;
	  break;

	case '\0':
	case ':':
	  result = wild ? MATCH : HALFMATCH;
	  goto NEXT_PATERN;
	  break;
	default:
	  goto NORMAL_CHAR;
	}
      }else{
NORMAL_CHAR:
	escaped = 0;
	if(wild){
	  wild = 0;
	  if(MbFind(&str, &pat)){
	    MbNextChar(&str);
	    str_wild = str.str;
	  }else{
	    result = UNMATCH;
	    goto NEXT_PATERN;
	  }
	}else{
	  if(StrEqChar(&pat, &str)){
	    /* match */
	    MbNextChar(&str);
	  }else{
	    /* unmatch */
	    if(!pre_wild){
	      /* unmatch */
	      result = UNMATCH;
	      goto NEXT_PATERN;
	    }
	    /* backtrack */
	    backtrack(&pat, pre_wild, &str, str_wild);
	    wild = 1;
	  }
	}
      }
      MbNextChar(&pat);
    }/* while(str); */
    switch(pat.str[0]){
    case '\0':
    case ':':
      return MATCH;
    default:
      result = UNMATCH;
    }
NEXT_PATERN:
    skip(&pat);
  }/* while(pat); */
  return result;
}

#if 0
int main(int argc, char **argv)
{
  int n;
  if(argc < 3)
  {
    return 0;
  }

  n = IsMatch(argv[1], argv[2]);
  printf("\n result\n");
  switch(n){
  case 0:
    printf("all match\n");
    break;
  case 1:
    printf("half match\n");
    break;
  default:
    printf("unmatch\n");
    break;
  }

  return 0;
}
#endif
