
/* basic structure */
struct DfDrawInfo;
typedef struct _dfBufComon DfBufCommon;

typedef struct _dfVerb{
  int (*free)(void *);
  int (*activate)(Widget, void *);
  int (*inactivate)(Widget, void *);
  int (*keybd_event)(Widget, void *, KeySym, char, Boolean *);
  int (*resize)(Widget, void *);
  int (*draw)(void *, struct DfDrawInfo *);
}DfVerb;

typedef struct _dfVerb2{
  DfVerb v;
  void (*draw_caption)(Widget, void *, Display *, GC);
  void (*draw_singleitem)(void *, struct DfDrawInfo *, int);
  int (*proc)(Widget, void *, const DfCmdStr *, const char **);
  int (*setcursor)(Widget, DfBufCommon *, int);
}DfVerb2;

#define BS_VISIBLE         1
#define BS_ENABLE         (1 << 1)
#define BS_DRAWBOTTOMEDGE (1 << 2)
#define BS_DRAWRIGHTEDGE  (1 << 3)
#define BS_PROMPTMARKED   (1 << 4)
#define BS_NEEDREDRAW     (1 << 5)

typedef struct _dfBuf DfBuf;
struct _dfBuf{
  DfList list;
  DfList focus;
  DfBuf *parent;
  DfBuf *active;
  df_type type;
  int stat;
  XRectangle rc;
  const DfVerb *v;
};

#define IS_VISIBLE(BUF) (((DfBuf*)(BUF))->stat & BS_VISIBLE)
#define IS_ENABLE(BUF)  (((DfBuf*)(BUF))->stat & BS_ENABLE)

struct _dfBufComon{
  DfBuf b;
  int nStart;
  int nOffset;
  int nCur;
  int nItems;
  int nDrawable;
  int scroll;
  int usable;
  DfStr caption;
};

typedef struct _dfWindow{
  DfBuf *lists;
  DfBuf *active;
  Widget w;
  int nBuf;
  int nFiler;
  int width;
  int height;
  int frame_y;
  int frame_bottom;
  Widget text;
  int text_height;
  int flags;
  XRectangle clip;
}DfWindow;

#define DFX_CLIPPING       1
#define DFX_SCHED_DRAW     2

struct DfDrawInfo{
  Display *d;
  Widget w;
  GC gc;
  XRectangle clip;
};

void *MakeBuffer(size_t sz, DfBuf *parent, df_type type, const DfVerb2 *v);

void DfBufCommon_Init(DfBufCommon *cb);
void BufComon_Free(DfBufCommon *b);

int BF_KeyPress(Widget w, void *ptr, KeySym k, char ch, Boolean *cond);
int BF_ResizeNop(Widget w, void *ptr);

int BF2_KeyPress(Widget w, void *ptr, KeySym k, char ch, Boolean *cond);
int BF2_Draw(void *ptr, struct DfDrawInfo *di);
void BF2_DrawCaption(Widget w, void *ptr, Display *display, GC gc);
int BF2_ProcessBusy(Widget w, void *ptr, const DfCmdStr *c, const char **argv);
int BF2_ResizeDraw(Widget w, void *ptr);
void BF2_CalcCursors(DfBufCommon *b);
int SetCursor(Widget w, DfBufCommon *b, int n);
int SetCursor2(Widget w, DfBufCommon *b, int n);
int CalcBufferOffset(Widget w, DfBufCommon *b, int n);
int DrawGap(struct DfDrawInfo *di, DfBufCommon *b, XRectangle *rc, XRectangle *rc_draw);
int upCursor(Widget w, DfBufCommon *b);
int downCursor(Widget w, DfBufCommon *b);
int cursorToTop(Widget w, DfBufCommon *b);
int cursorToBottom(Widget w, DfBufCommon *b);
int upPage(Widget w, DfBufCommon *b);
int downPage(Widget w, DfBufCommon *b);

void ScrollRect(struct DfDrawInfo *di, XRectangle *rc, XRectangle *rc_part, int offset);

void *NextBuffer(void *buf);
void *PrevBuffer(void *buf);
void *NextFrame(void *buf);
void *PrevFrame(void *buf);
int IsSingleBuffer(void);

void UnlinkBuffer(Widget w, DfBuf *b);

void SwitchBuffer(Widget w, DfBuf *b, DfBuf *org);
void SetModalBuffer(Widget w, DfBuf *parent, DfBuf *b);
DfBuf *GetNextEnableHiddenBuffer(DfBuf *cur);
DfBuf *GetNextEnableBuffer(DfBuf *cur);
int EnumBuffers(DfBuf *top, int (*callback)(DfBuf *, void *), void *param);
void SetFocusLink(DfBuf *ina, DfBuf *act);
void ChangeFrameSize(Widget w, DfBuf *b, int fVirt, int size);
void RedrawFrame(Widget w, DfBuf *b, XRectangle *rc);
void RedrawFrames(Widget w, DfBuf *b);
void UpdateFrames(Widget w, DfBuf *b);
void RefreshFrames(Widget w, DfBuf *b);
void SetupDelayedDraw(Widget w, DfBuf *b);

#ifdef DEBUG
void DumpBufInfo(void);
#else
#define DumpBufInfo() ((void)(0))
#endif
