extern int vInUTF8;

int (*dfx_mblen)(int);
int (*dfx_mbbacklen)(char *, int);
int (*dfx_leadbyte)(int);


int euc_leadbyte(int ch)
{
  if(ch & 0x80){
    return 1;
  }
  return 0;
}

int sjis_leadbyte(int ch)
{
  if((unsigned char)((ch ^ 0x20) - 0xa1) < 0x3c){
    return 1;
  }
  return 0;
}

int utf8_leadbyte(int ch)
{
  if((ch & 0xd0) == 0xd0){
    return 1;
  }
  return 0;
}

int sjis_halfkana(char ch)
{
  unsigned int n = ch;
  return (n - '\xa1') <= (0xdf - 0xa1);
}

int euc_mblen(int ch)
{
  if(euc_leadbyte(ch)){
    return 2;
  }
  return 1;
}

int sjis_mblen(int ch)
{
  if(sjis_leadbyte(ch)){
    return 2;
  }
  return 1;
}

int utf8_mblen(int ch)
{
  if((ch & 0x80) == 0){
    return 1;
  }
  if((ch & 0xe0) == 0xd0){
    return 2;
  }
  if((ch & 0xf0) == 0xe0){
    return 3;
  }
  if((ch & 0xf8) == 0xf0){
    return 4;
  }
  if((ch & 0xf8) == 0xf0){
    return 5;
  }
  if((ch & 0xfd) == 0xf8){
    return 6;
  }
  if((ch & 0xfe) == 0xfd){
    return 7;
  }
  return 1;
}

int euc_mbbacklen(char *p, int pos)
{
  if(pos == 0){
    return 0;
  }

  if(pos < 2){
    return 1;
  }

  if(euc_leadbyte(p[-2])){
    return 2;
  }
  return 1;
}

int sjis_mbbacklen(char *p, int pos)
{
  if(pos == 0){
    return 0;
  }

  if(pos < 2){
    return 1;
  }

  if(sjis_leadbyte(p[-2])){
    return 2;
  }
  return 1;
}

int utf8_mbbacklen(char *p, int pos)
{
  int n;

  if(pos == 0){
    return 0;
  }

  if(pos < 2){
    return 1;
  }

  n = pos - 1;
  while(n){
    switch(p[n] & 0xd0){
    case 0x80:
      break;
    case 0xd0:
    case 0x40:
    case 0x00:
      return pos - n;
    }
    --n;
  }
  return 1;
}


void chcode_init(void)
{
  if(vInUTF8){
    dfx_mblen = utf8_mblen;
    dfx_mbbacklen = utf8_mbbacklen;
    dfx_leadbyte = utf8_leadbyte;
  }else{
    dfx_mblen = euc_mblen;
    dfx_mbbacklen = euc_mbbacklen;
    dfx_leadbyte = euc_leadbyte;
  }
}

