#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pthread.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <X11/Xaw/Toggle.h>

#include "config.h"
#include "dftype.h"
#include "str.h"
#include "list.h"
#include "buffer.h"
#include "filer.h"
#include "status.h"
#include "cmdlist.h"
#include "cmdinput.h"
#include "dialog.h"
#include "task.h"
#include "cmd.h"
#include "mem.h"
#include "extmacro.h"
#include "fop.h"
#include "dfxfunc.h"
#include "xutil.h"
#include "debug.h"
#include "dfval.h"


static int chmodFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st);

task_vtable vtable_chmod = {
  commonInvoke,
  commonNotify,
  commonDone,
  commonInit,
  commonProcSelectedFile,
  commonProcSubDirectories,
  chmodFileOp
};

static int chmodFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st)
{
  int ret;
  struct dftask_chmod_info *ext = t->extend;

  ret = ChMod(Str_Get(src), ext->mode);
  dprintf("chmod state is %d.\n", ret);
  if(ret != 0){
    dprintf("chmod fail.\n");
    t->state = STATE_FAIL;
  }

  return ret;
}


