#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pthread.h>

#include <X11/Intrinsic.h>
#include <X11/keysym.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "task.h"
#include "status.h"
#include "cmd.h"
#include "cmdlist.h"
#include "buflist.h"
#include "cmdinput.h"
#include "extmacro.h"
#include "dfxfunc.h"
#include "dfval.h"
#include "misc.h"
#include "mem.h"
#include "debug.h"


static int idx;
static const DfCmdStr *cand;
static const DfCmdStr *CmdTab;
static int buffer;

extern int mod_keys;

static int CommonCmdProc(void *ptr, Widget w, const DfCmdStr *c, const char **argv);

void CmdReset(void)
{
  idx = 0;
  cand = CmdTab;
}

void CmdSetTable(int type)
{
  buffer = type;
  CmdTab = FL_CmdTab;
  CmdReset();
}

static int isMatchKey(DfCmdKey k, DfCmdKey c)
{
  if(cand->allow && (cand->allow & buffer) == 0){
    return 0;
  }
  if(cand->key[idx] != k && cand->key[idx] != c){
    return 0;
  }

  return 1;
}

const DfCmdStr *CmdTypeAheadGetAnchor(void)
{
  return cand;
}

void CmdCandNext(void)
{
  cand++;
  if(!cand->key){
    /* wrap around. */
    cand = CmdTab;
  }
}


const DfCmdStr *CmdTypeAhead(KeySym ksym, char ch, const DfCmdStr *anchor)
{
  int n;
  DfCmdKey k;
  DfCmdKey c;

  k = mod_keys | ksym;
  c = 0;
  if(ch){
    c = DFMOD_CHAR | ch;
  }
#if DEBUG
  if(cand == NULL){
    dprintf("NOTE: cand is unset.\n");
    return NULL;
  }
#endif

  if(isMatchKey(k, c)){
    idx++;
    if(cand->key[idx] == 0){
      /* found */
      idx = 0;
      dprintf("cmd1 %d:%s\n", cand->builtin, CmdNoToStr(cand->builtin));
      return cand;
    }
    /* continue */
    dprintf("cmd1 contine.  %d:%s\n", cand->builtin, CmdNoToStr(cand->builtin));
    return NULL;
  }

  /* find next candidate */
  n = 0;
  for(;;){
    do{
      if(idx){
	if((!cand->allow || (cand->allow & buffer)) && memcmp(anchor->key + n, cand->key, sizeof(DfCmdKey) * idx) != 0){
	  goto skip;
	}
      }
      if(isMatchKey(k, c)){
	idx++;
	if(cand->key[idx] == 0){
	  idx = 0;
	  return cand;
	}
	return NULL;
      }
skip:
      cand++;
      if(!cand->key){
	/* wrap around */
	cand = CmdTab;
      }
    }while(cand != anchor);
    if(idx == 0){
      break;
    }
    idx--;
    n++;
  }

  idx = 0;
  return NULL;
}

/* 
 * ToDo: ޥŸ뤫ɤΥѥ᡼ɲá
 * DfxExec()ƤӽФȤˤϥޥŸʤ
 */

int afterWork(Widget w, void *ptr, DfStr *cmdstr, const DfCmdStr *c, int immediate, int flg);

static void callbackExecmacro(DfTask *t)
{
  struct parse_extention *pe = t->extend;
  afterWork(t->w, t->owner, &pe->cmd, pe->arg, pe->immediate, 1);
}

int CommandHandler(void *ptr, Widget w, const DfCmdStr *c, int macro)
{
  DfFileList *list;
  const char *cmdline = c->cmd;
  DfStr cmdstr;

  list = GetFilerBuffer(ptr);
  if(macro){
    if(list){
      if(cmdline && cmdline[0]){
	Str_InitStr(&cmdstr, cmdline);
	ParseMacro2(w, &cmdstr, ptr, callbackExecmacro, (void *)c);
	return CREQ_DONE;
      }
    }
  }

  return afterWork(w, ptr, &cmdstr, c, 0, 0);
}

int afterWork(Widget w, void *ptr, DfStr *cmdstr, const DfCmdStr *c, int immediate, int flg)
{
  DfBuf *b = ptr;
  DfFileList *list = GetFilerBuffer(b);
  char *cmdline = c->cmd;
  InputCmd *arg =NULL;
  const char **argv = NULL;
  int (*proc)(Widget, void *, const DfCmdStr *, const char **);
  int ret;
  int builtin;

  if(!c->builtin){
    if(immediate){
      DfxExec(w, b, list->cwd, cmdline, &builtin);
      Str_Free(cmdstr, 0);/* when immediate is on, macro is parsed. */
      if(!builtin){
        KillChildren(w, GetBuffer(list));
      }
    }else{
      if(flg == 0){
	Str_InitStr(cmdstr, cmdline);
      }
      DoExecStr(w, b, cmdstr);
    }
    return CREQ_DONE;
  }

  if(cmdline && cmdline[0]){
    arg = BuildArgs(cmdline);
    argv = (const char **)(arg->argv + 1);
  }

  if(CommonCmdProc(b, w, c, argv)){
    ret = CREQ_DONE;
  }else{
    do{
      proc = ((DfVerb2*)(b->v))->proc;
      ret = (*proc)(w, b, c, argv);
    }while(ret == CREQ_TOPARENT && (b = b->parent) != NULL);
    if(b != ptr){
      KillChildren(w, b);
    }
  }

  if(argv){
    FreeInputCmd(arg);
  }

  return ret;
}

static int CommonCmdProc(void *ptr, Widget w, const DfCmdStr *c, const char **argv)
{
  DfBuf *b;
  DfBuf *l;

  switch(c->builtin){
  case CANCEL:
    dprintf("cancel.\n");
    OpCancelOperate();
    break;
  case SWITCHBUFFER:
    b = GetNextEnableHiddenBuffer(GetBuffer(ptr));
    dprintf("Current: %p. Next: %p.\n", ptr, b);
    DumpBufInfo();
    if(ptr != b){
      SwitchBuffer(w, b, ptr);
    }
    break;
  case ENLARGE_H:
    ChangeFrameSize(w, GetBuffer(ptr), 0, vnFontHeight);
    break;
  case ENLARGE_V:
    ChangeFrameSize(w, GetBuffer(ptr), 1, vnFontHeight);
    break;
  case SHRINK_H:
    ChangeFrameSize(w, GetBuffer(ptr), 0, -vnFontHeight);
    break;
  case SHRINK_V:
    ChangeFrameSize(w, GetBuffer(ptr), 1, -vnFontHeight);
    break;
  case NEXTFRAME:
    b = NextFrame(ptr);
    if(b != ptr){
      SetActiveFrame(w, b);
    }
    break;
  case PREVFRAME:
    b = PrevFrame(ptr);
    if(b != ptr){
      SetActiveFrame(w, b);
    }
    break;
  case CMDLIST:
    l = GetBuffer(ptr);
    b = MakeCmdList(l, argv ? argv[0] : NULL);
    if(!b){
      St_SetMsg(w, vOptions.msg[STM_NOCFGFILE]);
      break;
    }
    SetModalBuffer(w, l, b);
    break;
  case REFRESH:
    RedrawFrames(w, GetBuffer(ptr));
    break;

  case PATHLIST:
    l = GetBuffer(ptr);
    b = MakePathList(l, argv ? argv[0] : NULL);
    if(!b){
      St_SetMsg(w, vOptions.msg[STM_NOCFGFILE]);
      break;
    }
    SetModalBuffer(w, l, b);
    break;

  case BUFLIST:
    dprintf("make buflist.\n");
    l = GetBuffer(ptr);
    b = MakeBufList(l);
    if(b){
      dprintf("make buflist: success.\n");
      SwitchBuffer(w, b, l);
    }else{
      dprintf("make buflist: failed.\n");
      St_SetMsg(w, vOptions.msg[STM_NOCFGFILE]);
    }
    break;

  case CFGRELOAD:
    ReloadConfig();
    break;

#ifdef MEMDEBUG
  case DUMPMEMINFO:
    DumpMemInfo();
    break;
#endif
#ifdef DEBUG
  case DUMPBUFFERINFO:
    DumpBufInfo();
    break;
#endif
  default:
    return 0;
  }

  return 1;
}
