#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pthread.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "status.h"
#include "cmdlist.h"
#include "cmdinput.h"
#include "task.h"
#include "cmd.h"
#include "misc.h"
#include "mem.h"
#include "extmacro.h"
#include "fop.h"
#include "dfxfunc.h"
#include "dfval.h"
#include "debug.h"

static int copyFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st);
static int copyPreDir(DfTask *t, DfStr *src, DfStr *dst);
static int moveFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st);
static int movePreDir(DfTask *t, DfStr *src, DfStr *dst);

task_vtable vtable_copy = {
  commonThreadedInvoke,
  commonNotify,
  commonDone,
  commonInit,
  commonProcSelectedFile,
  commonProcSubDirectories,
  copyFileOp,
  copyPreDir
};

task_vtable vtable_move = {
  commonThreadedInvoke,
  commonNotify,
  commonDone,
  commonInit,
  commonProcSelectedFile,
  commonProcSubDirectories,
  moveFileOp,
  movePreDir,
  PostDirDelete
};


static int copyFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st)
{
  int ret;

  if(S_ISLNK(st->st_mode)){
    ret = CopyLink(Str_Get(src), Str_Get(dst));
  }else{
    ret = CopyFile(Str_Get(src), Str_Get(dst), &t->break_flg);
  }

  if(ret != 0){
    t->state = STATE_FAIL;
  }

  return ret;
}

static int copyPreDir(DfTask *t, DfStr *src, DfStr *dst)
{
  int ret = CreateNestDirectory(Str_Get(dst));
  if(ret){
    t->state = STATE_FAIL;
    t->err = ret;
  }
  return ret;
}


/* */
static int moveFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st)
{
  int ret;

  ret = rename(Str_Get(src), Str_Get(dst));
  if(ret == 0){
    return 0;
  }

  if(S_ISLNK(st->st_mode)){
    ret = CopyLink(Str_Get(src), Str_Get(dst));
  }else{
    ret = CopyFile(Str_Get(src), Str_Get(dst), &t->break_flg);
  }

  if(ret != 0){
    t->state = STATE_FAIL;
    return ret;
  }

  ret = DeleteFile(Str_Get(src));
  if(ret){
    t->state = STATE_DELETEONMOVEFAIL;
  }

  return ret;
}

static int movePreDir(DfTask *t, DfStr *src, DfStr *dst)
{
  int ret;

  dprintf("mv: %s to %s.\n", Str_Get(src), Str_Get(dst));
  ret = rename(Str_Get(src), Str_Get(dst));

  if(ret == 0){
    t->err = 0;
    t->state = STATE_NONE;
  }else{
    dprintf("mv: failed.\n");
    t->err = ret;
    t->state = STATE_FAIL;
  }
  return 1;
}

