#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pthread.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>

#include "config.h"
#include "dftype.h"
#include "list.h"
#include "str.h"
#include "buffer.h"
#include "filer.h"
#include "status.h"
#include "cmdlist.h"
#include "cmdinput.h"
#include "task.h"
#include "cmd.h"
#include "misc.h"
#include "mem.h"
#include "extmacro.h"
#include "fop.h"
#include "dfxfunc.h"
#include "dfval.h"
#include "debug.h"

static int deleteFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st);

task_vtable vtable_delete ={
  commonThreadedInvoke,
  commonNotify,
  commonDone,
  commonInit,
  commonProcSelectedFile,
  commonProcSubDirectories,
  deleteFileOp,
  PreDirDelete,
  PostDirDelete
};

static int deleteFileOp(DfTask *t, DfStr *src, DfStr *dst, struct stat *st)
{
  int ret;

  ret = DeleteFile(Str_Get(src));

  if(ret != 0){
    t->state = STATE_FAIL;
  }

  return ret;
}

