#include <config.h>
#include "auth.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "intl.h"
#include "klist.h"
#include "list.h"
#include "cache.h"
#include "web.h"
#include "interface.h"
#include "nav.h"
#include "history.h"

void Auth_confirmed(DilloDoc *dd);
void Auth_refused(DilloDoc *dd);
void Auth_load_authenticated(DilloDoc *dd, DilloUrl *url);
unsigned char *base64_encode(const unsigned char *);

typedef struct _Realm Realm;

struct _Realm {
   DilloUrl *base_url;
   GString *auth;
};

static Realm *realms = NULL;
static gint num_realms;
static gint realms_max = 16;

void a_Auth_byrealm(GString *auth_realm, DilloUrl *NewUrl, DilloDoc *dd)
{
   /* we already have a password dialogue open */
   if (NULL != dd->auth_await_url)
      return;

   dd->auth_await_url = a_Url_dup(NewUrl);
   if(strstr(auth_realm->str, "realm"))
       memcpy(strstr(auth_realm->str, "realm"), _("realm"), 5);
   //auth_realm = g_string_append(auth_realm, "\n");
   a_Interface_passwd_dialog(dd->bw, auth_realm->str,
                             Auth_confirmed, dd,
                             Auth_refused, dd);
   return;
}

GString *a_Auth_byurl(DilloUrl *n)
{
   gchar *offset;
   int i, longest = -1, len = 0, longlen = 0;
   gchar *ptr;

   if (n == NULL)
      return NULL;

   for (i=0; i < num_realms; i++) {
      ptr = URL_STR(realms[i].base_url);
      if (NULL == (offset = strrchr(ptr, '/')))
         offset = ptr + strlen(ptr);
      if (strncmp(URL_STR(n), ptr, (char*) offset - (char*) ptr) == 0) {
         len = (gchar *) offset - (gchar *) ptr;
         if (longlen <= len) {
            longlen=len;
            longest=i;
         }
      }
   }
   return longest == -1 ? NULL : realms[longest].auth;
}

void Auth_confirmed(DilloDoc *dd)
{
   DilloUrl *NewUrl;
   GString *new_auth;
   GtkEntry *uentry,*pentry;
   GString *up = g_string_new("");
   gchar *encoded;

   if (NULL == dd->auth_await_url)
      return;

   NewUrl = dd->auth_await_url;

   /* are we still trying to browse the url that wants authentication? */

   if (a_Url_cmp(a_History_get_url(NAV_TOP(dd)), NewUrl) != 0) {
      printf("Browser Url has changed\n");
      /* free the url here, maybe ? */
      a_Url_free(NewUrl);
      dd->auth_await_url = NULL;
      return;
   }

   /* fetch and encode authorization */
   uentry = GTK_ENTRY(dd->bw->passwd_dialog_uentry);
   pentry = GTK_ENTRY(dd->bw->passwd_dialog_pentry);
   /* ... */
   g_string_sprintfa(up, "%s:%s", gtk_entry_get_text(uentry),
                     gtk_entry_get_text(pentry));
   new_auth = g_string_new("");
   g_string_sprintfa(new_auth, "Basic %s", encoded = base64_encode(up->str));
   g_free(encoded);
   a_List_add(realms, num_realms, realms_max);
   realms[num_realms].base_url = a_Url_dup(NewUrl);
   realms[num_realms].auth = new_auth;
   num_realms++;
   Auth_load_authenticated(dd, NewUrl);
   dd->auth_await_url = NULL;
}

void Auth_refused(DilloDoc *dd)
{
   DilloUrl *NewUrl;

   if (NULL == dd->auth_await_url)
      return;
   NewUrl = dd->auth_await_url;
   a_Url_free(NewUrl);
   dd->auth_await_url = NULL;
}

void Auth_load_authenticated(DilloDoc *dd, DilloUrl *NewUrl)
{
   a_Url_set_flags(NewUrl, URL_FLAGS(NewUrl) | URL_E2EReload);
   a_Nav_push(dd, NewUrl);
   a_Url_free(NewUrl);
}
  
void a_Auth_freeall(void)
{
}

unsigned char *base64_encode(const unsigned char *src) {
   static char base64[] =
      "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
   const unsigned char *s;
   unsigned char *c, *d;
   int l, bufsize;

   c = d = (unsigned char *)malloc((bufsize = (l = strlen(src)) * 4 / 3 + 1) + 6);
   for(s = src; l > 0 && c - d < bufsize; s += 3, c += 4, l -= 3) {
      c[0] = base64[s[0] >> 2];
      c[1] = base64[((s[0] & 03) << 4) | (l>1 ? s[1] >> 4 : 0)];
      c[2] = l>1 ? base64[((s[1] & 15) << 2) | (l>2 ? s[2] >> 6 : 0)] : '=';
      c[3] = l>2 ? base64[s[2] & 63] : '=';
   }
   *c = 0;
   return d;
}

