/*
 * File: gtkframeset.h
 * Copyright (C) 2003 Frank de Lange <frank@unternet.org>
 *
 *   a frameset widget for GTK - The GIMP Toolkit
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_FRAMESET_H__
#define __GTK_FRAMESET_H__
/* this ifdef is Dillo-specific... */
#ifdef XHTML_DTD_FRAMESET

#include <gdk/gdk.h>
#include <gtk/gtkcontainer.h>


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_FRAMESET(obj)	     (GTK_CHECK_CAST ((obj), GTK_TYPE_FRAMESET, GtkFrameset))
#define GTK_TYPE_FRAMESET	     (gtk_frameset_get_type ())
#define GTK_FRAMESET_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_FRAMESET, GtkFramesetClass))
#define GTK_IS_FRAMESET(obj)	     (GTK_CHECK_TYPE ((obj), GTK_TYPE_FRAMESET))
#define GTK_IS_FRAMESET_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_FRAMESET))


typedef struct _GtkFrameset	     GtkFrameset;
typedef struct _GtkFramesetClass     GtkFramesetClass;
typedef struct _GtkFramesetChild     GtkFramesetChild;
typedef struct _GtkFramesetRowCol    GtkFramesetRowCol;
typedef gint32 Length;

/* (adapted from dw_style.h) Lengths */
#define LENGTH_CREATE_ABSOLUTE(n)     (((n) << 2) | 1)
#define LENGTH_CREATE_PERCENTAGE(n)   ((LENGTH_FLOAT_TO_REAL (n) << 3) | 2)
#define LENGTH_CREATE_RELATIVE(n)     ((LENGTH_FLOAT_TO_REAL (n) << 3) | 6)
#define LENGTH_UNDEF_LENGTH           0

#define LENGTH_IS_ABSOLUTE(l)         ((l) & 1)
#define LENGTH_IS_PERCENTAGE(l)       (((l) & 7) == 2)
#define LENGTH_IS_RELATIVE(l)         (((l) & 7) == 6)

#define LENGTH_GET_ABSOLUTE(l)        ((l) >> 2)
#define LENGTH_GET_PERCENTAGE(l)      LENGTH_REAL_TO_FLOAT ((l) >> 3)
#define LENGTH_GET_RELATIVE(l)        LENGTH_REAL_TO_FLOAT ((l) >> 3)

#define LENGTH_REAL_TO_FLOAT(v)       ((gfloat)(v) / 0x10000)
#define LENGTH_FLOAT_TO_REAL(v)       ((gint)((v) * 0x10000))

/* used in frame resize */
#define RESIZE_NONE                   -1

/* default border size */
#define GTKFRAMESET_DEFAULT_BORDER_SIZE 2

struct _GtkFrameset
{
  GtkContainer container;
  
  GList *children;
  GtkFramesetRowCol *rows;
  GtkFramesetRowCol *cols;
  guint row_total_absolute, col_total_absolute;
  guint16 nrows;
  guint16 ncols;
  guint16 current_frame;
  gboolean in_drag : 1;
  gint16 resize_row, resize_col;
  GdkCursor *cursor_rowcol, *cursor_row, *cursor_col;
};

struct _GtkFramesetClass
{
  GtkContainerClass parent_class;
};

struct _GtkFramesetChild
{
  GtkWidget *widget;
  guint16 row_attach;
  guint16 col_attach;
  guint16 xpadding;
  guint16 ypadding;
  gboolean border : 1;
  gboolean noresize : 1;
};

struct _GtkFramesetRowCol
{
  guint16 location;
  guint16 allocation;
  gboolean noresize : 1;
  gboolean border: 1;
  Length length;
  guint16 spacing;
};


GtkType	   gtk_frameset_get_type        (void);
GtkWidget* gtk_frameset_new	        (gchar	       *rows,
					 gchar	       *columns);
void       gtk_frameset_resize          (GtkFrameset   *frameset,
					 gchar	       *rows,
					 gchar	       *columns);
void	   gtk_frameset_attach	        (GtkFrameset   *frameset,
					 GtkWidget     *child,
					 guint		row_attach,
					 guint		col_attach,
					 guint          xpadding,
					 guint          ypadding,
					 gboolean       border,
					 gboolean       noresize);

#ifdef __cplusplus
}
#endif /* __cplusplus */

/* this endif is Dillo-specific... */
#endif /* XHTML_DTD_FRAMESET */
#endif /* __GTK_FRAMESET_H__ */
