/* socket  */
#include <sys/socket.h>
#include <io.h>
#include <errno.h>

#undef	socket
#undef	connect

/*
need wrappter

SOCKET PASCAL accept(SOCKET,struct sockaddr*,int*);
int PASCAL bind(SOCKET,const struct sockaddr*,int);
int PASCAL closesocket(SOCKET);
int PASCAL connect(SOCKET,const struct sockaddr*,int);
int PASCAL ioctlsocket(SOCKET,long,u_long *);
int PASCAL getpeername(SOCKET,struct sockaddr*,int*);
int PASCAL getsockname(SOCKET,struct sockaddr*,int*);
int PASCAL getsockopt(SOCKET,int,int,char*,int*);
unsigned long PASCAL inet_addr(const char*);
DECLARE_STDCALL_P(char *) inet_ntoa(struct in_addr);
int PASCAL listen(SOCKET,int);
int PASCAL recv(SOCKET,char*,int,int);
int PASCAL recvfrom(SOCKET,char*,int,int,struct sockaddr*,int*);
int PASCAL send(SOCKET,const char*,int,int);
int PASCAL sendto(SOCKET,const char*,int,int,const struct sockaddr*,int);
int PASCAL setsockopt(SOCKET,int,int,const char*,int);
int PASCAL shutdown(SOCKET,int);
SOCKET PASCAL socket(int,int,int);

*/

static void set_errno(void)
{
	int herr = WSAGetLastError();
	switch(herr){
	case WSAEINTR: herr = EINTR; break;
	case WSAEBADF: herr = EBADF; break;
	case WSAEACCES: herr = EACCES; break;
	case WSAEFAULT: herr = EFAULT; break;
	case WSAEINVAL: herr = EINVAL; break;
	case WSAEMFILE: herr = EMFILE; break;
	case WSAEWOULDBLOCK: herr = EAGAIN; break;
	}
	errno = herr;
}

#define	WRAP(func)	do { int rval; if ((rval=func)==-1) set_errno(); return rval;} while(0)

int read(int fd,void *buf,unsigned int size)
{
	int rval = _read(fd,buf,size);
	if (rval!=-1 || errno != EBADF) return rval;
	errno = 0;
	WRAP(recv((SOCKET)fd,buf,size,0));
}

int write(int fd,const void *buf,unsigned int size)
{
	int rval;
	rval = _write(fd,buf,size);
	if (rval!=-1 || errno != EBADF)	return rval;
	errno = 0;
	WRAP(send((SOCKET)fd,buf,size,0));
}

int close(int fd)
{
	int rval;
	rval = _close(fd);
	if (rval!=-1 || errno != EBADF)	return rval;
	errno = 0;
	WRAP(closesocket((SOCKET)fd));
}
