<?php {
  /*
   * Smarty plugin
   * ------------------------------------------------------------
   * Type:     block
   * Name:     escape
   * Purpose:  Escape the string according to escapement type
   * ------------------------------------------------------------
   */
  function __do_escape($string,$esc_type){
    switch ($esc_type) {
    case 'html':
      return htmlspecialchars($string, ENT_QUOTES);
    
    case 'htmlall':
      return htmlentities($string, ENT_QUOTES);
    
    case 'url':
      return urlencode($string);
    
    case 'quotes':
      // escape unescaped single quotes
      return preg_replace("%(?<!\\\\)'%", "\\'", $string);
    
    case 'hex':
      // escape every character into hex
      for ($x=0; $x < strlen($string); $x++) {
	$return .= '%' . bin2hex($string[$x]);
      }
      return $return;
    
    case 'hexentity':
      for ($x=0; $x < strlen($string); $x++) {
	$return .= '&#x' . bin2hex($string[$x]) . ';';
      }
      return $return;
    
    case 'javascript':
      // escape quotes and backslashes and newlines
      return str_replace(array('\\','\'',"\r","\n"), array("\\\\", "\\'",'\r','\r'), $string);
    
    default:
      return $string;
    }
  }


  function smarty_function_dino_escape($params,&$smarty){
    $encoding=$params["encode"];
    $string=$params["string"];
    if(strlen($encoding)>0){
      $string = mb_convert_encoding($string,$encoding);
    }

    echo __do_escape($string,$params["type"]);
  }

  function smarty_block_dino_escape($params,$content,&$smarty){
    echo __do_escape($content,$params["type"]);
  }


} ?>
