unit ecma_type;

//^`
//2001/04/10 ~
//by Wolfy

interface                                                     
uses
  windows,sysutils,classes,hashtable,typinfo,myclasses,activex,contnrs,dynamiccall
{$IFDEF VER130}
  ;
{$ELSE}
  ,variants;
{$ENDIF}

const
  CR = #13;
  LF = #10;
  CRLF = #13#10;

type
  PJStatement = ^TJStatement;
  PJValue = ^TJValue;
  PJExpr = ^TJExpr;
  PJFunction = ^TJFunction;
  TJObject = class;
  TJHash = class;
  TJValueList = class;
  TJObjectFactory = class;

  //Cxg
  TStringEvent = procedure(Sender: TObject; S: String) of object;
  TStepEvent = procedure(Sender: TObject; var Abort: Boolean) of object;
  TNewObjectEvent = procedure(Sender: TObject; JObject: TJObject) of object;

  //ľ^
  TJValueType = (vtUndefined,vtNull,vtInteger,vtDouble,
                 vtString,vtObject,vtBool,vtFunction,vtInfinity,vtNaN,
                 vtDispatch,vtInt64);
  //lۑ郌R[h
  TJValue = record
    ValueType: TJValueType;      //l̎
    vString: String;            //ȉl̒g
{$IFNDEF AX}
    vDispatch: IDispatch;
{$ENDIF}
    case Integer of
      0: (vInteger: Integer);
      1: (vDouble: Double);
      2: (vBool: Boolean);
      3: (vNull: Pointer);
      4: (vObject: TJObject);   //Object͎QƃJEgŊǗ
      5: (vFunction: PJFunction);
      //6: (vInt64: Int64);
  end;

  //֐^
  TJFuncType = (ftStatement,ftMethod,
                ftActiveX,//ftActiveXPropertyGet,ftActivXPropertyPut,
                ftClass,ftImport,
                ftDynaCall);
  TJMethod = function (Param: TJValueList): TJValue of object;
  TJActivexMethodFlag = (axfMethod,axfGet,axfPut);
  TJActiveXMethod = record
    Parent: IDispatch;
    Dispid: Integer;
    Flag: TJActivexMethodFlag;
  end;

  TJFunction = record
    FuncType: TJFuncType;
    Parameter: PJStatement;
{$IFNDEF AX}
    AXMethod: TJActiveXMethod;
{$ENDIF}
    DynaDeclare: TDynaDeclare;
    This: TJObject;
    NameSpace: String;
    case Integer of
      0: (Statement: PJStatement);
      1: (Method: TJMethod);
      2: (Table: TObject);
  end; 

  //ANV
  TJOPCode = (opNone,
              opExpr,
              opAdd,opSub,opDiv,opMul,opMod,opDivInt,
              opAssign,
              opMulAssign,opDivAssign,opAddAssign,opSubAssign,opModAssign,
              opBitLeftAssign,opBitRightAssign,opBitRightZeroAssign,
              opBitAndAssign,opBitXorAssign,opBitOrAssign,
              opConstant,opVariable,
              opPlus,opMinus,
              opThis,opMember,opArray,opObjectElement,opSuper,
              opNew,opNewObject,opNewArray,
              opCall,opArg,
              opPreInc,opPreDec,opPostInc,opPostDec,
              opDelete,opVoid,opTypeof,
              opLogicalNot,opLogicalOr,opLogicalAnd,
              opBitLeft,opBitRight,opBitRightZero,
              opLS,opGT,opLSEQ,opGTEQ,
              opEQ,opNE,opEQEQEQ,opNEEQEQ,
              opBitAnd,opBitXor,opBitOr,opBitNot,
              opConditional);

  //͖   
  TJExpr = record
    Code: TJOPCode;            //
    Left,                       //
    Right: PJExpr;              //E
    Third: PJExpr;              //R
    Value: PJValue;             //萔l
    Symbol: String;             //ϐ
  end;

  TJStatementType = (stNone,stBlock,
                     stExpr,
                     stIf,stWhile,stFor,stForIn,stDo,
                     stFunctionDecl,stParamDecl,stClassDecl,stVarDecl,
                     stBreak,stContinue,stReturn,
                     stTry,stCatch,stFinally,stThrow,
                     stWith,
                     stImport,stVar);

  // linked list
  TJStatement = record
    SType: TJStatementType;
    Expr: PJExpr;
    Parent: PJStatement;
    Next: PJStatement;
    Sub1,Sub2: PJStatement;
  end;

  TJFunctionFactory = class(TObject)
  private
    FItems: TList;
  public
    constructor Create;
    destructor Destroy; override;
    function NewFunction: PJFunction;
    function BuildFunction(Func: TJFunction): TJValue;
    procedure Clear;
  end;

  //hash object
  TJHash = class(TCustomHashTable)
  private
    procedure HashOnItemDispose(Sender: TObject; P: PHashItem);
    function GetValue(Key: String): TJValue;
    procedure SetValue(Key: String; Value: TJValue);
  public
    constructor Create(ATableSize: DWord; AIgnoreCase: Boolean = False); override;
    destructor Destroy; override;
    property Value[Key: String]: TJValue read GetValue write SetValue; default;
  end;

  TJHashStack = class(TObject)
  private
    function Get(Index: Integer): TJHash;
  protected
    FStack: TObjectList;
    function GetHash: TJHash;
    procedure Clear;
  public
    constructor Create;
    destructor Destroy; override;
    procedure Push;
    procedure Pop;
    function Count: Integer;
    property Hash: TJHash read GetHash;
    property Items[Index: Integer]: TJHash read Get; 
  end;

  TJHashMembers = class(TJHashStack)
  private
    function GetValue(S: String): TJValue;
    procedure SetValue(S: String; const Value: TJValue);
    function GetKeys: String;
  public
    function HasKey(S: String): Boolean;

    property Value[S: String]: TJValue read GetValue write SetValue; default;
    property Keys: String read GetKeys;
  end; 


  TJValueList = class(TObject)
  private
    FItems: TListPlus;
    function GetItems(Index: Integer): TJValue;
    procedure SetItems(Index: Integer; const Value: TJValue);
    function GetCount: Integer;
    procedure SetCount(const Value: Integer);
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    procedure Delete(Index: Integer);
    function Add(Value: TJValue): Integer;
    procedure Insert(Index: Integer; Value: TJValue);     
    procedure Sort(Compare: TListSortCompareObj);

    property Items[Index: Integer]: TJValue read GetItems write SetItems; default;
    property Count: Integer read GetCount write SetCount;
  end;

  //{IuWFNg
  TJObject = class(TPersistent)
  private
    FMembers: TJHashMembers;
{$IFDEF USE_GC}
    FRefCount: Integer;
{$ENDIF}
    FNames: TStringList;
    FName: String;       

    function GetName: String;

    function GetKeys: String;
    function GetMethods: String;
    function GetProperties: String;
    function GetMembers: TJHash;

  protected
    FFactory: TJObjectFactory;
    FFuncfactory: TJFunctionFactory;
    FDefaultProperties: TStringList;

    procedure RegistMethod(MethodName: String; Method: TJMethod);
    procedure RegistMethods; virtual;
    function GetDefaultProperty(Prop: String; var Value: TJValue): Boolean;
    function SetDefaultProperty(Prop: String; Value: TJValue): Boolean;
    function HasDefaultProperty(Prop: String): Boolean;
    procedure GetDefaultProperties(PropNames: TStrings);

    procedure ClearMembers;
    procedure ClearProperties;
    procedure DecRefMembers;

    function DoHasKey(Param: TJValueList): TJValue;
    function DoToString(Param: TJValueList): TJValue;
    function DoGetKeys(Param: TJValueList): TJValue;
    function DoGetProperties(Param: TJValueList): TJValue;
    function DoGetMethods(Param: TJValueList): TJValue;

    function GetPropertyList: String; virtual;
    function GetMethodList: String; virtual;
  public
    procedure RegistProperty(PropName: String; Value: TJValue);
    procedure RegistName(AName: String);

    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); virtual;
    destructor Destroy; override;
{ QƃJEg𑝂₷Ƃ
    (Assign)
    Object̏L
    ֐̈
    ֐̖߂l?
    RXgN^}
    function IncRefCount: Integer;
{ QƃJEg炷Ƃ
    Object̏LI
    ֐̏I
    ObjectjɏLObject
    delete}
    function DecRefCount: Integer;
    function HasKey(S: String): Boolean; virtual;
    function GetValue(S: String; ArrayStyle: Boolean): TJValue; virtual;
    procedure SetValue(S: String; Value: TJValue; ArrayStyle: Boolean); virtual;
    function ToString(Value: PJValue = nil): String; virtual;
    function ToInteger: Integer; virtual;
    function ToDouble: Double; virtual;
    function ToBool: Boolean; virtual;
    function ToChar: Char; virtual;
    function Equal(Obj: TJObject): Boolean; virtual;

{$IFDEF USE_GC}
    property RefCount: Integer read FRefCount;
{$ENDIF}
    property Name: String read GetName;
    property PropertyList: String read GetPropertyList;
    property MethodList: String read GetMethodList;
    property Members: TJHash read GetMembers;
  published
    //property keys: String read GetKeys;
    //property properties: String read GetProperties;
    //property methods: String read GetMethods;
  end;

  PJObjectClass = ^TJObjectClass;
  TJObjectClass = class of TJObject;

  
  //object쐬NX
  TJObjectFactory = class(TObject)
  private
    FEngine: TObject;
    FHash: TPointerHashTable;
    FItems: TObjectList;
    FOnNewObject: TNewObjectEvent;

    procedure HashOnItemDispose(Sender: TObject; P: PHashItem);
    function GetObjectNames: String;
    function GetObjectCount: Integer;
  public
    function _NewObject(ObjectName: String; Init: TJValueList): TJObject;

    constructor Create(AEngine: TObject);
    destructor Destroy; override;

    procedure Clear;
    procedure GarbageCollect;
    function HasObject(ObjectName: String): Boolean;
    procedure ImportObject(ObjectName: String; ObjectClass: TJObjectClass);
    function ExportObject(ObjectName: String): PJObjectClass;
    procedure DeleteObject(ObjectName: String);

    function Add(Obj: TJObject): Integer;
    function Remove(Obj: TJObject): Integer;

    property Engine: TObject read FEngine;
    property ObjectNames: String read GetObjectNames;
    property ObjectCount: Integer read GetObjectCount;
    property OnNewObject: TNewObjectEvent read FOnNewObject write FOnNewObject;
  end;

  //{O
  EJException = class(Exception);
  //EJRegExpError = class(EJException);
  EJAbort = class(EJException);
  EJBreak = class(EJException);
  EJContinue = class(EJException);
  //֐return
  EJReturn = class(EJException)
  private
    FValue: TJValue;
  public
    constructor Create(AValue: TJValue);
    property Value: TJValue read FValue;
  end;
  EJExit = class(EJException)
  private
    FStatus: Integer;
  public
    constructor Create(AStatus: Integer);
    property Status: Integer read FStatus;
  end;

  //sG[
  EJThrow = class(EJException)
  private
    FErrorMsg: String;
    FValue: TJValue;
    FExceptName: String;
  public
    constructor Create(AExceptName,AErrorMsg: String; AValue: PJValue = nil);
    property ExceptName: String read FExceptName;
    property ErrorMsg: String read FErrorMsg;
    property Value: TJValue read FValue;
  end;

const
  //O
  E_EXCEPTION = 'Exception';
  E_THROW = 'EThrow';
  E_CALL = 'ECallError';
  E_INDEX = 'EIndexError';
  E_KEY = 'EKeyError';
  E_IO = 'EIOError';
  E_FILE = 'EFileError';
  E_DIR = 'EDirectoryError';
  E_NAME = 'ENameError';
  E_TYPE = 'ETypeError';
  E_MATHR = 'EMathError';
  E_ZD = 'EZDError';
  E_EOF = 'EEOFError';
  E_SOCKET = 'ESocketError';
  E_REGEXP = 'ERegExp';
  E_STRINGS = 'EStringsError';
  E_WIN32 = 'EWin32Error';
  E_INI = 'EIniError';
  E_CRC = 'ECRCError';
  E_BASE64 = 'EBase64Error';
  E_PROP = 'EPropertyError';
  E_ACTIVEX = 'EActiveXError';
  E_SYNTAX = 'ESyntaxError';
  E_DLL = 'EDLLLoadError';
  E_DYNACALL = 'EDynaCalError';
  E_STRING = 'EStringError';
  E_DELETE = 'EDeleteError';



//⏕֐
function IsConstant(P: PJExpr): Boolean;
function IsVariable(P: PJExpr): Boolean;
function ConstantValueInt(P: PJExpr): Integer;

procedure EmptyValue(var V: TJValue);
function TypeOf(P: PJValue): String;

function IsUndefined(P: PJValue): Boolean;
function IsNull(P: PJValue): Boolean;
function IsInteger(P: PJValue): Boolean;
function IsDouble(P: PJValue): Boolean;
function IsString(P: PJValue): Boolean;
function IsObject(P: PJValue): Boolean;
function IsNumberObject(P: PJValue): Boolean;
function IsStringObject(P: PJValue): Boolean;

function IsBool(P: PJValue): Boolean;
function IsFunction(P: PJValue): Boolean;
function IsInfinity(P: PJValue): Boolean;
function IsNaN(P: PJValue): Boolean;
function IsDispatch(P: PJValue): Boolean;

function TryAsNumber(P: PJValue): Boolean;
function EqualFunction(L,R: PJValue): Boolean;
function EqualType(L,R: PJValue): Boolean;

function AsInteger(P: PJValue): Integer;
function AsDouble(P: PJValue): Double;
function AsString(P: PJValue): String;
function AsBool(P: PJValue): Boolean;
function AsDispatch(P: PJValue): IDispatch;
function AsSingle(P: PJValue): Single;
function AsChar(P: PJValue): Char;

function BuildUndefined: TJValue;
function BuildString(V: String): TJValue;
function BuildNull: TJValue;
function BuildInteger(V: Integer): TJValue;
function BuildDouble(V: Double): TJValue;
function BuildObject(V: TJObject): TJValue;
function BuildBool(V: Boolean): TJValue;
function BuildInfinyty: TJValue;
function BuildNaN: TJValue;
function BuildDispatch(V: IDispatch): TJValue;

function IncRefObject(var V: TJValue): Integer;
function DecRefObject(var V: TJValue): Integer;

function VariantToValue(V: OleVariant; Factory: TJObjectFactory = nil): TJValue;
function ValueToVariant(V: TJValue): OleVariant;

function VarRecToValue(V: TVarRec): TJValue;

function IsParam1(Param: TJValueList): Boolean;
function IsParam2(Param: TJValueList): Boolean;
function IsParam3(Param: TJValueList): Boolean;
function IsParam4(Param: TJValueList): Boolean;

procedure HashToJObject(Hash: TStringHashTable; JObject: TJObject);
procedure JObjectToHash(Hash: TStringHashTable; JObject: TJObject);

function AXMethodFlagToDisp(A: TJActiveXMethodFlag): Word;
function AXMethodFlagToString(A: TJActiveXMethodFlag): String;

function ValueListToDynaValueArray(Format: String; Param: TJValueList): TDynaValueArray;
function DynaResultToValue(Format: String; DynaResult: TDynaResult): TJValue;

implementation

uses
  ecma_engine,ecma_activex,ecma_object;


function IsParam1(Param: TJValueList): Boolean;
begin
  Result := (Assigned(Param) and (Param.Count > 0))
end;

function IsParam2(Param: TJValueList): Boolean;
begin
  Result := (Assigned(Param) and (Param.Count > 1))
end;

function IsParam3(Param: TJValueList): Boolean;
begin
  Result := (Assigned(Param) and (Param.Count > 2))
end;

function IsParam4(Param: TJValueList): Boolean;
begin
  Result := (Assigned(Param) and (Param.Count > 3))
end;

function IsConstant(P: PJExpr): Boolean;
//萔ǂH
begin
  Result := (Assigned(P) and (P^.Code = opConstant))
end;

function IsVariable(P: PJExpr): Boolean;
//ϐǂH
begin
  Result := (Assigned(P) and (P^.Code = opVariable))
end;

function ConstantValueInt(P: PJExpr): Integer;
//萔̐l𓾂
begin
  Result := 0;
  if IsConstant(P) and (P^.Value.ValueType = vtInteger) then
    Result := P^.Value.vInteger;
end;

procedure EmptyValue(var V: TJValue);
//ϐ
begin 
  V.ValueType := vtUndefined;
  V.vObject := nil;
end;

function AsInteger(P: PJValue): Integer;
//lԂ
begin
  Result := 0;
  if not Assigned(P) then
    Exit;

  case P^.ValueType of
    vtUndefined: Result := 0;
    vtInteger: Result := P^.vInteger;
    vtDouble: Result := Round(P^.vDouble);
    vtString: Result := StrToIntDef(P^.vString,0);
    vtBool: Result := Integer(P^.vBool);
    vtNull: Result := 0;
    vtObject: Result := P^.vObject.ToInteger;
    vtFunction:;
  end;
end;

function AsChar(P: PJValue): Char;
begin
  Result := #0;
  if not Assigned(P) then
    Exit;

  case P^.ValueType of
    vtUndefined: Result := #0;
    vtInteger: Result := Char(P^.vInteger);
    vtDouble: Result := Char(Round(P^.vDouble));
    vtBool: Result := Char(P^.vBool);
    vtNull: Result := #0;
    vtString:
    begin
      if Length(P^.vString) > 0 then
        Result := P^.vString[1];
    end;
    vtObject: Result := P^.vObject.ToChar;
  end;
end;

function AsSingle(P: PJValue): Single;
begin
  Result := AsDouble(P);
end;

function AsDouble(P: PJValue): Double;
//doubleԂ
var
  i: Integer;
begin
  Result := 0;
  if not Assigned(P) then
    Exit;

  case P^.ValueType of
    vtInteger: Result := P^.vInteger;
    vtDouble: Result := P^.vDouble;
    vtBool: Result := Integer(P^.vBool);
    vtString:
    begin
      try
        Result := StrToFloat(P^.vString);
      except
        try
          i := StrToInt(P^.vString);
          Result := i;
        except
        end;
      end;
    end;

    vtObject: Result := P^.vObject.ToDouble;
  end;

end;

function TryAsNumber(P: PJValue): Boolean;
//lɏoH
begin
  Result := False;
  if not Assigned(P) then
    Exit;

  case P^.ValueType of
    vtInteger: Result := True;
    vtDouble: Result := True;
    vtBool: Result := True;
    vtString:
    begin
      try
        StrToFloat(P^.vString);
        Result := True;
      except
        try
          StrToInt(P^.vString);
          Result := True;
        except
        end;
      end;
    end;
  end;      
end;

function AsString(P: PJValue): String;
//ɂĕԂ
var
  p1,p2: Pointer;
begin
  Result := '';
  if not Assigned(P) then
    Exit;

  case P^.ValueType of
    vtUndefined: Result := 'undefined';
    vtInteger: Result := IntToStr(P^.vInteger);
    vtDouble: Result := FloatToStr(P^.vDouble);
    vtString: Result := P^.vString;
    vtNull: Result := 'null';
    vtBool:
    begin
      if P^.vBool then
        Result := 'true'
      else
        Result := 'false';
    end;
    vtObject: Result := P^.vObject.ToString;
    vtFunction:
    begin
      if P^.vFunction.FuncType = ftStatement then
        Result := 'function' + IntToStr(Integer(P^.vFunction.Statement))
      else begin
        p1 := TMethod(P^.vFunction.Method).Code;
        p2 := TMethod(P^.vFunction.Method).Data;
        Result := 'function' + IntToStr(Integer(p1)) + IntToStr(Integer(p2));
      end;
    end;
    vtInfinity: Result := 'infinity';
    vtNaN: Result := 'NaN';
{$IFNDEF AX}
    vtDispatch: Result := 'dispatch' + IntToStr(Integer(P^.vDispatch));
{$ENDIF}
  end;
end;

function AsBool(P: PJValue): Boolean;
//boollԂ
begin
  Result := False;
  if not Assigned(P) then
    Exit;

  case P^.ValueType of
    vtUndefined: Result := False;
    vtInteger: Result := (P^.vInteger <> 0);
    vtDouble: Result := (Trunc(P^.vDouble) <> 0);
    vtString: Result := (P^.vString <> '');
    vtNull: Result := False;
    vtBool: Result := P^.vBool;
    vtFunction: Result := True;
    vtInfinity: Result := True;
    vtNaN: Result := True;
    vtObject: Result := P^.vObject.ToBool;
{$IFNDEF AX}
    vtDispatch: Result := Assigned(P^.vDispatch);
{$ENDIF}
  end;
end;

function AsDispatch(P: PJValue): IDispatch;
begin
  Result := nil;
  if not Assigned(P) then
    Exit;

{$IFNDEF AX}
  if IsDispatch(P) then
    Result := P^.vDispatch;
{$ENDIF}
end;

function TypeOf(P: PJValue): String;
begin
  if IsInteger(P) or IsDouble(P) then
    Result := 'number'
  else if IsString(P) then
    Result := 'string'
  else if IsBool(P) then
    Result := 'boolean'
  else if IsObject(P) then
    Result := 'object'
  else if IsFunction(P) then
    Result := 'function'
  else if IsUndefined(P) then
    Result := 'undefined'
  else if IsNull(P) then
    Result := 'null'
  else if IsDispatch(P) then
    Result := 'dispatch'
  else
    Result := '';
end;

function IsUndefined(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtUndefined));
end;

function IsNull(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtNull));
end;

function IsInteger(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtInteger));
end;

function IsDouble(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtDouble));
end;

function IsString(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtString));
end;

function IsObject(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtObject));
end;

function IsNumberObject(P: PJValue): Boolean;
begin
  Result := IsObject(P) and (P^.vObject is TJNumberObject);
end;

function IsStringObject(P: PJValue): Boolean;
begin
  Result := IsObject(P) and (P^.vObject is TJStringObject);
end;

function IsBool(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtBool));
end;

function IsFunction(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtFunction));
end;

function IsInfinity(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtInfinity));
end;

function IsNaN(P: PJValue): Boolean;
//ł͂Ȃ
begin
  Result := not TryAsNumber(P);
end;

function IsDispatch(P: PJValue): Boolean;
begin
  Result := (Assigned(P) and (P^.ValueType = vtDispatch));
end;

function BuildUndefined: TJValue;
begin
  EmptyValue(Result);
end;

function BuildString(V: String): TJValue;
begin
  Result.ValueType := vtString;
  Result.vString := V;
end;

function BuildNull: TJValue;
begin
  Result.ValueType := vtNull;
  Result.vNull := nil;
end;

function BuildInteger(V: Integer): TJValue;
begin
  Result.ValueType := vtInteger;
  Result.vInteger := V;
end;

function BuildDouble(V: Double): TJValue;
begin
  Result.ValueType := vtDouble;
  Result.vDouble := V;
end;

function BuildObject(V: TJObject): TJValue;
begin
  Result.ValueType := vtObject;
  Result.vObject := V;
end;

function BuildBool(V: Boolean): TJValue;
begin
  Result.ValueType := vtBool;
  Result.vBool := V;
end;

function BuildInfinyty: TJValue;
begin
  Result.ValueType := vtInfinity;
  Result.vInteger := MAXINT;
end;

function BuildNaN: TJValue;
begin
  Emptyvalue(Result);
  Result.ValueType := vtNaN;
end;

function BuildDispatch(V: IDispatch): TJValue;
begin
  Result.ValueType := vtDispatch;
{$IFNDEF AX}
  Result.vDispatch := V;
{$ENDIF}
end;

function IncRefObject(var V: TJValue): Integer;
//QƃJEg𑝂₷
begin
  Result := -1;
  if IsObject(@V) and Assigned(V.vObject) then
    Result := V.vObject.IncRefCount;
end;

function DecRefObject(var V: TJValue): Integer;
//QƃJEg炷
begin
  Result := -1;
  if IsObject(@V) and Assigned(V.vObject) then
    Result := V.vObject.DecRefCount;
end;

function VariantToValue(V: OleVariant; Factory: TJObjectFactory): TJValue;
//variantϊ
var
  obj: TJActiveXObject;
begin
  EmptyValue(Result);
  case VarType(V) of
    varNull: Result := BuildNull;
    varSmallint,varInteger,varByte: Result := BuildInteger(V);
    varSingle,varDouble: Result := BuildDouble(V);
    varOleStr,varString: Result := BuildString(V);
    varBoolean: Result := BuildBool(V);
    varDispatch:
    begin
      //ActiveXObjectɕϊ
      if Assigned(Factory) then
      begin
        obj := TJActiveXObject.Create(Factory,nil);
        obj.disp := V;
        Result := BuildObject(obj);
      end
      else
        Result := BuildDispatch(V);
    end;
  end;
end;

function ValueToVariant(V: TJValue): OleVariant;
//variant֕ϊ
var
  ws: WideString;
begin
  //VarClear(Result);  varClear̓oOĂ
  VariantInit(Result);
  case V.ValueType of
    vtNull: Result := VarAsType(Result,varNull);
    vtInteger: Result := V.vInteger;
    vtDouble: Result := V.vDouble;
    vtBool: Result := V.vBool;
    vtString:
    begin
      ws := V.vString;
      Result := ws;
    end;
{$IFNDEF AX}
    vtDispatch: Result := V.vDispatch;
{$ENDIF}
    vtObject:
    begin
      if V.vObject is TJActiveXObject then
        Result := (V.vObject as TJActiveXObject).disp;
    end;
  end;
end;

function VarRecToValue(V: TVarRec): TJValue;
//TVarRecϊ
begin
  EmptyValue(Result);
  case V.VType of
    system.vtInteger: Result := BuildInteger(V.VInteger);
    system.vtInt64: Result := BuildInteger(Integer(V.VInt64));

    system.vtBoolean: Result := BuildBool(V.VBoolean);

    system.vtExtended: Result := BuildDouble(V.VExtended^);

    system.vtString: Result := BuildString(V.VString^);
    system.vtChar: Result := BuildString(V.VChar);
    system.vtWideChar: Result := BuildString(V.VWideChar);
    system.vtAnsiString: Result := BuildString(AnsiString(V.VAnsiString));
    system.vtWideString: Result := BuildString(WideString(V.VWideString));
    system.vtPChar: Result := BuildString(V.VPChar);
    system.vtPWideChar: Result := BuildString(V.VWideChar);

    system.vtObject:
    begin
      if V.VObject is TJObject then
        Result := BuildObject(V.VObject as TJObject); 
    end;

    system.vtVariant: Result := VariantToValue(V.VVariant^);

    //system.vtInterface:
    //system.vtPointer:
    //system.vtClass:
    //system.vtCurrency:
  end;

end;

function EqualFunction(L,R: PJValue): Boolean;
//֐ǂ
begin
  Result := False;
  if IsFunction(L) and IsFunction(R) then
  begin
    if L^.vFunction.FuncType = R^.vFunction.FuncType then
    begin
      if L^.vFunction.FuncType = ftStatement then
        Result := (L^.vFunction.Statement = R^.vFunction.Statement)
      else if L^.vFunction.FuncType = ftMethod then
        Result := (TMethod(L^.vFunction.Method).Code = TMethod(R^.vFunction.Method).Code) and
                  (TMethod(L^.vFunction.Method).Data = TMethod(R^.vFunction.Method).Data)
      else if L^.vFunction.FuncType = ftActiveX then
      begin
{$IFNDEF AX}
        Result := (L^.vFunction.AXMethod.Parent = R^.vFunction.AXMethod.Parent) and
                  (L^.vFunction.AXMethod.DispId = R^.vFunction.AXMethod.DispId);
{$ENDIF}
      end;
    end;
  end;
end;

function EqualType(L,R: PJValue): Boolean;
//^ǂ
begin
  Result := False;
  if Assigned(L) and Assigned(R) then
    Result := L^.ValueType = R^.ValueType;
end;


procedure HashToJObject(Hash: TStringHashTable; JObject: TJObject);
//hashobject
var
  keys: TStringList;
  i: Integer;
begin
  keys := Hash.KeyList;
  JObject.ClearProperties;
  for i := 0 to keys.Count - 1 do
    JObject.SetValue(keys[i],BuildString(Hash[keys[i]]),True);
end;

procedure JObjectToHash(Hash: TStringHashTable; JObject: TJObject);
//objecthash
var
  keys: TStringList;
  i: Integer;
  v: TJValue;
begin
  keys := JObject.Members.KeyList;
  Hash.Clear;
  for i := 0 to keys.Count - 1 do
  begin
    v := JObject.Members[keys[i]];
    Hash[keys[i]] := AsString(@v);
  end;
end;

function AXMethodFlagToDisp(A: TJActiveXMethodFlag): Word;
//ActveX̃\bhtOϊ
begin
  Result := DISPATCH_METHOD;
  case A of
    axfGet: Result := DISPATCH_PROPERTYGET;
    axfPut: Result := DISPATCH_PROPERTYPUT;
  end;
end;

function AXMethodFlagToString(A: TJActiveXMethodFlag): String;
//activex̕Ԃ
begin
  Result := 'DISPATCH_METHOD';
  case A of
    axfGet: Result := 'DISPATCH_PROPERTYGET';
    axfPut: Result := 'DISPATCH_PROPERTYPUT';
  end;
end;

function ValueListToDynaValueArray(
  Format: String; Param: TJValueList): TDynaValueArray;
//valuelsitϊ
var
  len,i: Integer;
  v: TJValue;
begin      
  len := Length(Format);
  if len > 0 then
  begin
    Format := LowerCase(Format);
    SetLength(Result,len);
    for i := 1 to len do
    begin
      try
        v := Param[i - 1];
      except
        on EListError do
          v := BuildNull;
      end;

      case Format[i] of
        'c':
        begin
          Result[i - 1].VType := dvtChar;
          Result[i - 1]._char := AsChar(@v);
        end;

        '1':
        begin
          Result[i - 1].VType := dvtRefChar;
          Result[i - 1]._char := AsChar(@v);
        end;

        't':
        begin
          Result[i - 1].VType := dvtShort;
          Result[i - 1]._short := AsInteger(@v);
        end;

        '2':
        begin
          Result[i - 1].VType := dvtRefShort;
          Result[i - 1]._short := AsInteger(@v);
        end;

        'l','h','p','u','b':
        begin
          Result[i - 1].VType := dvtLong;
          Result[i - 1]._long := AsInteger(@v);
        end;

        'i':
        begin
          Result[i - 1].VType := dvtInt64;
          Result[i - 1]._int64 := AsInteger(@v);
        end;

        '4':
        begin
          Result[i - 1].VType := dvtRefLong;
          Result[i - 1]._long := AsInteger(@v);
        end;

        's':
        begin
          Result[i - 1].VType := dvtString;
          Result[i - 1]._string := AsString(@v);
        end;

        'w':
        begin
          Result[i - 1].VType := dvtWideString;
          Result[i - 1]._widestring := AsString(@v);
        end;

        'f':
        begin
          Result[i - 1].VType := dvtFloat;
          Result[i - 1]._float := AsSingle(@v);
        end;

        'd':
        begin
          Result[i - 1].VType := dvtDouble;
          Result[i - 1]._double := AsDouble(@v);
        end;

        'a':
        begin
          Result[i - 1].VType := dvtIDispatch;
          Result[i - 1]._idispatch := AsDispatch(@v);
        end;

        'k':
        begin
          Result[i - 1].VType := dvtIUnknown;
          Result[i - 1]._iunknown := AsDispatch(@v);
        end;
      else
        //Ă͂܂Ȃꍇ͗O
        raise EJThrow.Create(E_DYNACALL,'arguments flag error');        
      end;
    end;
  end
  else
    Result := nil;
end;

function DynaResultToValue(Format: String; DynaResult: TDynaResult): TJValue;
//dynacall̖߂l
var
  len: Integer;
begin
  Result := BuildNull;

  len := Length(Format);
  if len > 0 then
  begin
    Format := LowerCase(Format);
    case Format[1] of
      'c','t','l','h','p','u': Result := BuildInteger(DynaResult._long);
      'b': Result := BuildBool(Boolean(DynaResult._long));
      'i': Result := BuildInteger(DynaResult._int64);
      'a','k': Result := BuildDispatch(IDispatch(DynaResult._long));
      's': Result := BuildString(PChar(DynaResult._pointer));
      'w': Result := BuildString(PWideChar(DynaResult._pointer));
      'd': Result := BuildDouble(DynaResult._double);
      'f': Result := BuildDouble(DynaResult._float);
    end;
  end;
end;


{ TJHash }

constructor TJHash.Create(ATableSize: DWord; AIgnoreCase: Boolean);
//쐬
begin
  inherited Create(ATableSize,AIgnoreCase);
  OnFreeItem := HashOnItemDispose;
end;

destructor TJHash.Destroy;
//J
begin
  Clear;
  inherited;
end;

function TJHash.GetValue(Key: String): TJValue;
var
  p: PJValue;
begin
  EmptyValue(Result);
  p := GetValuePointer(Key);
  if Assigned(p) then
    Result := p^;
end;

procedure TJHash.HashOnItemDispose(Sender: TObject; P: PHashItem);
//value
var
  value: PJValue;
begin
  if P^.ValueType = hvPointer then
  begin
    value := P^.vPointer;
    Dispose(value);
    P^.vPointer := nil;
  end;
end;

procedure TJHash.SetValue(Key: String; Value: TJValue);
//VăZbg
var
  p: PJValue;
begin
  New(p);
  p^ := Value;
  SetValuePointer(Key,p);
end;

{ TJObject }

procedure TJObject.RegistName(AName: String);
//objectclassname
begin
  FName := AName;
  FNames.Insert(0,AName);
  //O̓o^Ɠhashtable𑝂₷
  FMembers.Push;
end;

procedure TJObject.ClearMembers;
//f[^NA
var
  i: Integer;
begin
  for i := 0 to FMembers.Count - 1 do
    FMembers.Items[i].Clear;
end;

constructor TJObject.Create(AFactory: TJObjectFactory; Param: TJValueList);
//object쐬
begin
  inherited Create;
{$IFDEF USE_GC}
  FRefCount := 0;
{$ENDIF}
  FFactory := AFactory;
  FMembers := TJHashMembers.Create;
  FNames := TStringList.Create;
  FFuncFactory := TJFunctionFactory.Create;
  FDefaultProperties := TStringList.Create;
  FDefaultProperties.Sorted := True;
  FDefaultProperties.Duplicates := dupIgnore;
  GetDefaultProperties(FDefaultProperties);

  RegistName('Object');
  RegistMethods;

  //factoryɒǉ
  if Assigned(AFactory) then
    AFactory.Add(Self);
  //else
  //  raise EJException.Create('objectfactory is required');
end;

function TJObject.DecRefCount: Integer;
//QƃJEg炷
begin
  Result := 1;
{$IFDEF USE_GC}
  Dec(FRefCount);
  Result := FRefCount;
{$ENDIF}
end;

destructor TJObject.Destroy;
//j
begin
  //QƃJEg炷
  DecRefMembers;
  FMembers.Clear;

  FreeAndNil(FFuncFactory);
  FreeAndNil(FDefaultProperties);
  FreeAndNil(FNames);
  FreeAndNil(FMembers);

  inherited Destroy;
end;

function TJObject.GetValue(S: String; ArrayStyle: Boolean): TJValue;
//o𓾂
begin
  EmptyValue(Result);
  if GetDefaultProperty(S,Result) then
    Exit
  else begin
    if ArrayStyle then
    begin
      //z
      if FMembers.HasKey(S) then
        Result := FMembers.Value[S]
      else
        raise EJThrow.Create(E_KEY,S);
    end
    else begin
      //o
      if FMembers.HasKey(S) then
        Result := FMembers.Value[S]
      else
        raise EJThrow.Create(E_NAME,S);
    end;
  end;
end;

function TJObject.GetPropertyList: String;
//SĂproperty𓾂
var
  sl: TStringList;
  i: Integer;
  v: TJValue;
begin
  sl := TStringList.Create;
  try
    sl.Text := FMembers.Keys;
    for i := sl.Count - 1 downto 0 do
    begin
      //\bh͍폜
      v := FMembers[sl[i]];
      if IsFunction(@v) then
        sl.Delete(i);
    end;

    sl.AddStrings(FDefaultProperties);
    Result := Trim(sl.Text);
  finally
    sl.Free;
  end;
end;

function TJObject.GetName: String;
//classnameԂ
begin
  if FNames.Count > 0 then
    Result := FNames[0]
  else
    Result := 'Object';
end;

procedure TJObject.GetDefaultProperties(PropNames: TStrings);
//property𒲂ׂ
//vpeB̒lԂ
var
  Count, i: Integer;
  PropInfo: PPropInfo;
  PropList: PPropList;
begin
  PropNames.Clear;
  // vpeB̐擾
  Count := GetTypeData(ClassInfo)^.PropCount;
  if Count > 0 then
  begin
    GetMem(PropList, Count * SizeOf(Pointer));
    try
      // SẴvpeB擾
      GetPropInfos(ClassInfo, PropList);
      // ꂼ̃vpeBׂ
      for i := 0 to Count - 1 do
      begin
        PropInfo := PropList^[i];
        //name͖
        if (PropInfo^.Name = 'Tag') or (PropInfo^.Name = 'Name') then
          Continue;

        PropNames.Add(PropInfo^.Name);
      end;
    finally
      FreeMem(PropList, Count * SizeOf(Pointer));
    end;
  end;
end;

function TJObject.GetDefaultProperty(Prop: String; var Value: TJValue): Boolean;
//vpeB̒lԂ
var
  Count, i: Integer;
  PropInfo: PPropInfo;
  PropList: PPropList;
  o: TObject;
begin
  Result := False;
  // vpeB̐擾
  Count := GetTypeData(ClassInfo)^.PropCount;
  if Count > 0 then
  begin
    GetMem(PropList, Count * SizeOf(Pointer));
    try
      // SẴvpeB擾
      GetPropInfos(ClassInfo, PropList);
      // ꂼ̃vpeBׂ
      for i := 0 to Count - 1 do
      begin
        PropInfo := PropList^[i];

        if  (PropInfo^.Name = 'Tag') or (PropInfo^.Name = 'Name') then
          Continue;
        //Ov(P[X𖳎)
        if AnsiSameText(PropInfo^.Name,Prop) then
        begin
          //ANZX\bhꍇ͗O
          if not Assigned(PropInfo^.GetProc) then
          begin
            //Break;
            EJThrow.Create(E_PROP,'set only');
          end;

          //
          if PropInfo^.PropType^.Kind = tkInteger then
          begin
            Value := BuildInteger(GetOrdProp(Self,PropInfo));
            Result := True;
          end
          else if PropInfo^.PropType^.Kind = tkEnumeration then
          begin
            Value := BuildBool(Boolean(GetOrdProp(Self,PropInfo)));
            Result := True;
          end
          //double
          else if PropInfo^.PropType^.Kind = tkFloat then
          begin
            Value := BuildDouble(GetFloatProp(Self,PropInfo));
            Result := True;
          end
          //
          else if (PropInfo^.PropType^.Kind = tkString) or
                  (PropInfo^.PropType^.Kind = tkLString)or
                  (PropInfo^.PropType^.Kind = tkWString) then
          begin
            Value := BuildString(GetStrProp(Self,PropInfo));
            Result := True;
          end
          //object
          else if PropInfo^.PropType^.Kind = tkClass then
          begin
            o := GetObjectProp(Self,PropInfo);
            if o is TJObject then
            begin
              Value := BuildObject(TJObject(o));
              Result := True;
            end;
          end
          else if PropInfo^.PropType^.Kind = tkInterface then
          begin
            Value := BuildDispatch(IDispatch( GetOrdProp(Self,PropInfo)) );
            Result := True;
          end;
        end;
      end;
    finally
      FreeMem(PropList, Count * SizeOf(Pointer));
    end;
  end;

end;

function TJObject.HasKey(S: String): Boolean;
//memberĂH
begin
  if HasDefaultProperty(S) then
    Result := True
  else begin
    Result := FMembers.HasKey(S);
  end;
end;

function TJObject.HasDefaultProperty(Prop: String): Boolean;
//propertyĂ邩`FbN
var
  i: Integer;
begin
  Result := FDefaultProperties.Find(Prop,i);
end;

function TJObject.IncRefCount: Integer;
//QƃJEg𑝂₷
begin
  Result := 1;
{$IFDEF USE_GC}
  Inc(FRefCount);
  Result := FRefCount;
{$ENDIF}
end;

procedure TJObject.RegistMethod(MethodName: String; Method: TJMethod);
//֐o^
var
  f: TJFunction;
begin
  f.FuncType := ftMethod;
  f.Method := Method;
  FMembers[MethodName] := FFuncFactory.BuildFunction(f);
end;

procedure TJObject.SetValue(S: String; Value: TJValue; ArrayStyle: Boolean);
//oZbg
begin
  if SetDefaultProperty(S,Value) then
    Exit
  else begin
    if ArrayStyle then
    begin
      //œo^
      FMembers.Value[S] := Value;
    end
    else begin
      //oƂ̂
      if FMembers.HasKey(S) then
        FMembers.Value[S] := Value
      else
        raise EJThrow.Create(E_NAME,S);
    end;
  end;
end;     

function TJObject.SetDefaultProperty(Prop: String; Value: TJValue): Boolean;
//vpeBɒlZbg
var
  Count, i: Integer;
  PropInfo: PPropInfo;
  PropList: PPropList;
  o: TObject;
begin
  Result := False;
  // vpeB̐擾
  Count := GetTypeData(ClassInfo)^.PropCount;
  if Count > 0 then
  begin
    GetMem(PropList, Count * SizeOf(Pointer));
    try try
      // SẴvpeB擾
      GetPropInfos(ClassInfo, PropList);
      // ꂼ̃vpeBׂ
      for i := 0 to Count - 1 do
      begin
        PropInfo := PropList^[i];

        if  (PropInfo^.Name = 'Tag') or (PropInfo^.Name = 'Name') then
          Continue;
        //Ov
        if AnsiSameText(PropInfo^.Name,Prop) then
        begin
          //ANZX\bhꍇ͏I
          if not Assigned(PropInfo^.SetProc) then
          begin
            //Break;
            EJThrow.Create(E_PROP,'get only');
          end;

          //
          if (PropInfo^.PropType^.Kind = tkInteger) or
             (PropInfo^.PropType^.Kind = tkEnumeration) then
          begin
            SetOrdProp(Self,PropInfo,AsInteger(@Value));
            Result := True;
          end
          //double
          else if PropInfo^.PropType^.Kind = tkFloat then
          begin
            SetFloatProp(Self,PropInfo,AsDouble(@Value));
            Result := True;
          end
          //
          else if (PropInfo^.PropType^.Kind = tkString) or
                  (PropInfo^.PropType^.Kind = tkLString)or
                  (PropInfo^.PropType^.Kind = tkWString) then
          begin
            SetStrProp(Self,PropInfo,AsString(@Value));
            Result := True;
          end
          //object
          else if PropInfo^.PropType^.Kind = tkClass then
          begin
            if Value.ValueType = vtObject then
            begin
              o := Value.vObject;
              SetObjectProp(Self,PropInfo,o);
              Result := True;
            end;
          end
          //IDispatch
          else if PropInfo^.PropType^.Kind = tkInterface then
          begin
            if IsDispatch(@Value) then
            begin
              SetOrdProp(Self,PropInfo,Integer(AsDispatch(@Value)));
              Result := True;
            end;
          end;

        end;
      end;       

    finally
      FreeMem(PropList, Count * SizeOf(Pointer));
    end;

    except
      EJThrow.Create(E_PROP,'get only');
    end;
  end;

end;

procedure TJObject.RegistProperty(PropName: String; Value: TJValue);
//proeprtyo^
begin
  FMembers.Value[PropName] := Value;
  //SetValue(PropName,Value,True);
end;

function TJObject.DoHasKey(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  Result := BuildBool(False);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildBool(HasKey(AsString(@v)));
  end;
end;

function TJObject.DoToString(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildString(ToString(@v));
  end
  else
    Result := BuildString(ToString);
end;

function TJObject.ToString(Value: PJValue): String;
begin
  Result := '[' + Name + ']';
end;

function TJObject.GetMethodList: String;
//SĂmethod𓾂
var
  sl: TStringList;
  i: Integer;
  v: TJValue;
begin
  sl := TStringList.Create;
  try
    sl.Text := FMembers.Keys;
    for i := sl.Count - 1 downto 0 do
    begin
      //\bhȊO͍폜
      v := FMembers[sl[i]];
      if not IsFunction(@v) then
        sl.Delete(i);
    end;

    Result := Trim(sl.Text);
  finally
    sl.Free;
  end;
end;

function TJObject.GetKeys: String;
begin
  Result := PropertyList + CRLF + MethodList;
end;

function TJObject.GetMethods: String;
begin
  Result := MethodList;
end;

function TJObject.GetProperties: String;
begin
  Result := PropertyList;
end;

function TJObject.DoGetKeys(Param: TJValueList): TJValue;
begin
  Result := BuildString(GetKeys);
end;

function TJObject.DoGetMethods(Param: TJValueList): TJValue;
begin
  Result := BuildString(GetMethods);
end;

function TJObject.DoGetProperties(Param: TJValueList): TJValue;
begin
  Result := BuildString(GetProperties);
end;

function TJObject.GetMembers: TJHash;
begin
  Result := FMembers.Hash;
end;

procedure TJObject.RegistMethods;
//\bho^
begin
  RegistMethod('hasKey',DoHasKey);
  RegistMethod('toString',DoToString);
  RegistMethod('getKeys',DoGetKeys);
  RegistMethod('getProperties',DoGetProperties);
  RegistMethod('getMethods',DoGetMethods);
end;

procedure TJObject.ClearProperties;
//property(֐Ȃ)
var
  keys: TStringList;
  i: Integer;
  v: TJValue;
begin
  //͍̂property
  keys := FMembers.Hash.KeyList;
  for i := 0 to keys.Count - 1 do
  begin
    v := FMembers.Hash[keys[i]];
    if not IsFunction(@v) then
      FMembers.Hash.Remove(keys[i]);
  end;
end;

function TJObject.Equal(Obj: TJObject): Boolean;
begin
  Result := Obj = Self;
end;

procedure TJObject.DecRefMembers;
//members̎QƃJEg炷
var
  i: Integer;
  keys: TStringList;
  v: TJValue;
begin
  keys := FMembers.Hash.KeyList;
  for i := 0 to keys.Count - 1 do
  begin
    v := FMembers.Hash[keys[i]];
    DecRefObject(v);
  end;
end;

function TJObject.ToDouble: Double;
begin
  Result := 0;
end;

function TJObject.ToInteger: Integer;
begin
  Result := 0;
end;

function TJObject.ToBool: Boolean;
begin
  Result := True;
end;

function TJObject.ToChar: Char;
begin
  Result := #0;
end;

{ EJReturn }

constructor EJReturn.Create(AValue: TJValue);
begin
  inherited Create('return');
  FValue := AValue
end;

{ TJValueList }

function TJValueList.Add(Value: TJValue): Integer;
//
var
  p: PJValue;
begin
  New(p);
  p^ := Value;
  Result := FItems.Add(p);
end;

procedure TJValueList.Clear;
//NA
var
  i: Integer;
begin
  for i := FItems.Count - 1 downto 0 do
    Delete(i);

  FItems.Clear;
end;

function TJValueList.GetCount: Integer;
//JEg
begin
  Result := FItems.Count;
end;

constructor TJValueList.Create;
//쐬
begin
  inherited Create;
  FItems := TListPlus.Create;
  FItems.SortType := stQuick;
end;

procedure TJValueList.Delete(Index: Integer);
//폜
var
  p: PJValue;
begin
  p := FItems[Index];
  Dispose(p);
  FItems.Delete(Index);
end;

destructor TJValueList.Destroy;
//j
begin
  Clear;
  FreeAndNil(FItems);
  inherited Destroy;
end;

function TJValueList.GetItems(Index: Integer): TJValue;
//Qbg
var
  p: PJValue;
begin
  EmptyValue(Result);
  p := FItems[Index];
  if Assigned(p) then
    Result := p^;
end;

procedure TJValueList.Insert(Index: Integer; Value: TJValue);
//}
var
  p: PJValue;
begin
  New(p);
  p^ := Value;
  FItems.Insert(Index,p);
end;

procedure TJValueList.SetItems(Index: Integer; const Value: TJValue);
//Zbg
var
  p: PJValue;
begin
  p := FItems[Index];
  p^ := Value;
end;

procedure TJValueList.Sort(Compare: TListSortCompareObj);
begin
  FItems.Sort(Compare);
end;

procedure TJValueList.SetCount(const Value: Integer);
var
  i,cnt: Integer;
  v: TJValue;
begin    
  if Value > FItems.Count then
  begin
    //傫
    EmptyValue(v);
    cnt := Value - FItems.Count;
    for i := 0 to cnt - 1 do
      Add(v);
  end
  else if Value < FItems.Count then
  begin
    //
    for i := FItems.Count - 1 downto (Value - 1) do
      Delete(i);
  end;
end;

{ TJObjectFactory }

procedure TJObjectFactory.ImportObject(ObjectName: String;
  ObjectClass: TJObjectClass);
//objectclasso^
var
  p: PJObjectClass;
begin
  New(p);
  //GetMem(p,SizeOf(TJObjectClass));
  p^ := ObjectClass;
  FHash[ObjectName] := p;
end;

procedure TJObjectFactory.Clear;
//쐬object
begin
  FItems.Clear;
end;

constructor TJObjectFactory.Create(AEngine: TObject);
//쐬
begin
  inherited Create;
  FEngine := AEngine;
  FHash := TPointerHashTable.Create(HASH_100);
  FHash.OnFreeItem := HashOnItemDispose;
  FItems := TObjectList.Create(True);

  ImportObject('Object',TJObject);
end;

destructor TJObjectFactory.Destroy;
//j
begin
  Clear;
  FreeAndNil(FItems);
  FreeAndNil(FHash);

  inherited;
end;

procedure TJObjectFactory.HashOnItemDispose(Sender: TObject; P: PHashItem);
//item̔j
var
  obj: PJObjectClass;
begin
  if P^.ValueType = hvPointer then
  begin
    obj := P^.vPointer;
    Dispose(obj);
    //FreeMem(obj);
    P^.vPointer := nil;
  end;
end;

function TJObjectFactory._NewObject(ObjectName: String; Init: TJValueList): TJObject;
//object쐬
begin
  if FHash.HasKey(ObjectName) then
    Result := PJObjectClass(FHash[ObjectName])^.Create(Self,Init)
  else
    Result := TJObject.Create(Self,Init);
  //Cxg
  if Assigned(FOnNewObject) then
    FOnNewObject(Self,Result);
end;

procedure TJObjectFactory.GarbageCollect;
//S~E
var
  i: Integer;
  o: TJObject;
begin
{$IFDEF USE_GC}
  for i := FItems.Count - 1 downto 0 do
  begin
    o := FItems[i] as TJObject;
    //t@XJEg`FbNĔj
    if o.RefCount <= 0 then
      FItems.Delete(i);
  end;
{$ENDIF}
end;

function TJObjectFactory.HasObject(ObjectName: String): Boolean;
//objectH
begin
  Result := FHash.HasKey(ObjectName);
end;

procedure TJObjectFactory.DeleteObject(ObjectName: String);
//object class폜
begin
  FHash.Remove(ObjectName);
end;

function TJObjectFactory.GetObjectNames: String;
begin
  Result := FHash.Keys;
end;

function TJObjectFactory.ExportObject(ObjectName: String): PJObjectClass;
begin
  Result := nil;
  if HasObject(ObjectName) then
    Result := FHash[ObjectName];
end;

function TJObjectFactory.GetObjectCount: Integer;
begin
  Result := FItems.Count;
end;

function TJObjectFactory.Remove(Obj: TJObject): Integer;
//objectj
begin
  Result := -1;
{$IFDEF USE_GC}
  Result := FItems.IndexOf(Obj);
  if Result > -1 then
  begin
    //t@XJEg`FbNĔj
    if Obj.RefCount <= 0 then
      FItems.Delete(Result);
  end;
{$ENDIF}
end;

function TJObjectFactory.Add(Obj: TJObject): Integer;
//
begin
  Result := FItems.Add(Obj);
end;

{ EJThrow }

constructor EJThrow.Create(AExceptName,AErrorMsg: String; AValue: PJValue);
begin
  inherited Create(AExceptName);
  FExceptName := AExceptName;
  FErrorMsg := AErrorMsg;
  EmptyValue(FValue);
  if Assigned(AValue) then
    FValue := AValue^;
end;


{ TJFunctionFactory }

function TJFunctionFactory.BuildFunction(Func: TJFunction): TJValue;
begin
  Result.ValueType := vtFunction;
  Result.vFunction := NewFunction;
  Result.vFunction^ := Func;
end;

procedure TJFunctionFactory.Clear;
//NA
var
  i: Integer;
  p: PJFunction;
begin
  for i := FItems.Count - 1 downto 0 do
  begin
    p := FItems[i];
    //if p^.FuncType = ftActiveX then
    //  p^.AXMethod.Parent := nil;

    Dispose(p);
    FItems.Delete(i);
  end;

  FItems.Clear;
end;

constructor TJFunctionFactory.Create;
//쐬
begin
  inherited Create;
  FItems := TList.Create;
end;

destructor TJFunctionFactory.Destroy;
//j
begin
  Clear;
  FreeAndNil(FItems);
  inherited;
end;

function TJFunctionFactory.NewFunction: PJFunction;
//VK쐬
begin
  New(Result);
  Result^.FuncType := ftStatement;
  Result^.Parameter := nil;
  Result^.Statement := nil;
  Result^.This := nil;
{$IFNDEF AX}
  Result^.AXMethod.Parent := nil;
  Result^.AXMethod.Dispid := 0;
  Result^.AXMethod.Flag := axfMethod;
{$ENDIF}
  Result^.NameSpace := '';
  ClearDynaDeclare(Result^.DynaDeclare);
  FItems.Add(Result);
end;

{ EJExit }

constructor EJExit.Create(AStatus: Integer);
begin
  FStatus := AStatus;
end;

{ TJHashStack }

procedure TJHashStack.Clear;
begin
  FStack.Clear;
end;

function TJHashStack.Count: Integer;
begin
  Result := FStack.Count;
end;

constructor TJHashStack.Create;
begin
  inherited Create;
  FStack := TObjectList.Create(True);
  Push;
end;

destructor TJHashStack.Destroy;
begin
  Clear;
  FreeAndNil(FStack);
  inherited;
end;

function TJHashStack.Get(Index: Integer): TJHash;
begin
  Result := FStack[Index] as TJHash;
end;

function TJHashStack.GetHash: TJHash;
begin
  Result := TObject(FStack.First) as TJHash;
end;

procedure TJHashStack.Pop;
begin
  FStack.Delete(0);
end;

procedure TJHashStack.Push;
begin
  FStack.Insert(0,TJHash.Create(HASH_100));
end;

{ TJHashMembers }

function TJHashMembers.GetKeys: String;
var
  i: Integer;
  h: TJHash;
  sl: TStringList;
begin
  Result := '';
  sl := TStringList.Create;
  try
    sl.Sorted := True;
    sl.Duplicates := dupIgnore;

    for i := 0 to FStack.Count - 1 do
    begin
      h := FStack[i] as TJHash;
      sl.AddStrings(h.KeyList);
    end;

    Result := Trim(sl.Text);
  finally
    sl.Free;
  end;  
end;

function TJHashMembers.GetValue(S: String): TJValue;
//SẴoT
var
  i: Integer;
  h: TJHash;
begin
  for i := 0 to FStack.Count - 1 do
  begin
    h := FStack[i] as TJHash;
    if h.HasKey(S) then
    begin
      Result := h[S];
      Break;
    end;
  end;
  
end;

function TJHashMembers.HasKey(S: String): Boolean;
//hashSČ
var
  i: Integer;
  h: TJHash;
begin
  Result := False;
  for i := 0 to FStack.Count - 1 do
  begin
    h := FStack[i] as TJHash;
    Result := h.HasKey(S);
    if Result then
      Break;
  end;
end;

procedure TJHashMembers.SetValue(S: String; const Value: TJValue);
//ŏ̃oɒǉ
begin
  Hash[S] := Value;
end;



end.
