unit FolderDialog;
  { tH_[I_CAOR|[lgȈՔ Ver 1.0
     Copyright(C) 1998 H-Triton  All Rights Reserved  }
interface

uses
  Windows, Messages, Classes, Controls, FileCtrl, ShlObj, ActiveX;

type
  TFolderDialog = class(TComponent)
  private
    FDirectory: string;
    FTitle: string;
    procedure SetDirectory(const Value: string);
  protected
    { Protected 錾 }
  public
    constructor Create( AOwner : TComponent ); override;
    property Directory: string read FDirectory write SetDirectory;
    function Execute: Boolean;
  published
    property Title: string read FTitle write FTitle;
    { Published 錾 }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('MyCompo', [TFolderDialog]);
end;

// RXgN^
constructor TFolderDialog.Create( AOwner : TComponent );
begin
  inherited Create( AOwner );
  FDirectory:= '';
  FTitle:= 'tH_[̑I';
end;

// _CAOݒR[obN֐
function BrowseCallbackProc(Wnd: HWND; uMsg: UINT; LParam, lpData: LPARAM): Integer stdCall;
var
  Path: array[0..511] of Char;
  aText: string;
begin
  Result:= 0;
  Path:= '';
  // \ߊJtH_[bZ[Wʒm
  with TFolderDialog(lpData) do
    if (uMsg = BFFM_INITIALIZED) and DirectoryExists(FDirectory) then
      SendMessage(Wnd, BFFM_SETSELECTION, 1, LongInt(PChar(FDirectory)));
  // [U[ύXtH_[pX擾
  if uMsg = BFFM_SELCHANGED then
    SHGetPathFromIDList(PItemIDList(lParam), Path);
  // ύXꂽtH_[pXbZ[Wʒmĕ\
  aText:= string(Path);
  SendMessage(Wnd, BFFM_SETSTATUSTEXT, 0, LongInt(PChar(aText)));
end;

// J\bh|_CAOJ
function TFolderDialog.Execute: Boolean;
var
  hRet: HResult;
  ppMalloc: IMalloc;
  bi: TBrowseInfo;
  pBuf: PChar;
  pidlRoot, pidlBrowse: PItemIDList;
begin
  Result:= False;
  SHGetMalloc(ppMalloc);
  try
    pBuf := ppMalloc.Alloc(MAX_PATH);
    if pBuf = nil then Exit;
    // uϲ ߭vtH_[̃P[V̎擾...
    hRet:= SHGetSpecialFolderLocation
      //((Owner as TWinControl).Handle, CSIDL_DRIVES, pidlRoot);
      ((Owner as TWinControl).Handle, CSIDL_DESKTOP, pidlRoot);
      //(HInstance, CSIDL_DESKTOP, pidlRoot);
    if not Succeeded(hRet) then
    begin
      ppMalloc.Free(pBuf);
      Exit;
    end;
    // Browse Information\̂̐ݒ
    bi.hwndOwner := (Owner as TWinControl).Handle;
    bi.pidlRoot  := pidlRoot;
    bi.pszDisplayName := pBuf;
    bi.lpszTitle := PChar(FTitle);
    bi.ulFlags   := BIF_STATUSTEXT;
    bi.lpfn      := BrowseCallbackProc;
    bi.lParam    := LongInt(Self);
    pidlBrowse := SHBrowseForFolder(bi);
    if pidlBrowse <> nil then
    begin
      Result:= True;
      if SHGetPathFromIDList(pidlBrowse, pBuf) then FDirectory:= string(pBuf);
      ppMalloc.Free(pidlBrowse); // ͖̉Yꂸ
    end;
    ppMalloc.Free(pidlRoot);  // ͖̉Yꂸ...
    ppMalloc.Free(pBuf);
  finally
    ppMalloc._Release; // VF̃^XNAP[^[̉
  end;
end;

procedure TFolderDialog.SetDirectory(const Value: string);
begin
  if (Value <> '') and
     (Value[Length(Value)] = '\') then
    FDirectory := Copy(Value,1,Length(Value) - 1)
  else
    FDirectory := Value;
end;

end.
