unit ecma_expr;

//͖̉؊֌W
//2001/04/10 ~
//by Wolfy

interface

uses
  windows,sysutils,classes,ecma_type;

type
  TJExprFactory = class(TObject)
  private
    FList: TList;
    procedure FreeExpr(P: PJExpr);
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear;

    //Vnode쐬
    function NewExpr: PJExpr;
    //1쐬
    function MakeExpr1(Code: TJOPCode;Left: PJExpr): PJExpr;
    //2쐬
    function MakeExpr2(Code: TJOPCode;Left,Right: PJExpr): PJExpr;
    //3쐬
    function MakeExpr3(Code: TJOPCode;Left,Right,Third: PJExpr): PJExpr;
    //萔쐬
    function MakeConstant(Value: TJValue): PJExpr;
    //ϐ쐬
    function MakeVariable(Symbol: String): PJExpr;
    //萔̐쐬
    function MakeNumberInt(Value: Integer): PJExpr;
    function MakeNumberFloat(Value: Double): PJExpr;
    function MakeNull: PJExpr;
    function MakeNaN: PJExpr;
    function MakeBoolean(Value: Boolean): PJExpr;
    function MakeString(S: String): PJExpr;
    function MakeUndefined: PJExpr;
    function MakeInfinity: PJExpr;
    function MakeThis: PJExpr;
    function MakeSuper(Expr: PJExpr): PJExpr;
    function MakeArguments(Prev,Next: PJExpr): PJExpr;
    function MakeObjectElement(Name,Value: PJExpr): PJExpr;

    //SĂNode
    //procedure FreeNodes(P: PJExpr);
    //node
    //procedure InitTree(var P: PJExpr);
  end;


//LŘvZʂԂ
function CalcValue1(Code: TJOPCode; L: TJValue): TJValue;
function CalcValue2(Code: TJOPCode; L,R: TJValue): TJValue;
function CalcValue3(Code: TJOPCode; L,R,T: TJValue): TJValue;
function AssignValue(Code: TJOPCode; Variable,Value: TJValue): TJValue;
function CompareValue(Code: TJOPCode; L,R: TJValue): TJValue;

implementation

constructor TJExprFactory.Create;
begin
  inherited Create;
  FList := TList.Create;
end;

destructor TJExprFactory.Destroy;
begin
  Clear;
  FList.Free;
  inherited;
end;

procedure TJExprFactory.FreeExpr(P: PJExpr);
begin
  //萔
  if (P^.Code = opConstant) and Assigned(P^.Value) then
  //if Assigned(P^.Value) then
    system.Dispose(P^.Value);

  system.Dispose(P);
end;

procedure TJExprFactory.Clear;
//NA
var
  i: Integer;
begin
  for i := FList.Count - 1 downto 0 do
  begin
    FreeExpr(FList[i]);
    FList.Delete(i);
  end;
  FList.Clear;
end;

{
procedure TJExprFactory.FreeNodes(P: PJExpr);
//nodeׂĉ
//A肪ɉ
begin
  if not Assigned(P) then
    Exit;

  //̍Ō܂ł
  if Assigned(P^.Left) then
    FreeNodes(P^.Left);
  //E̍Ō܂ł
  if Assigned(P^.Right) then
    FreeNodes(P^.Right);

  if Assigned(P^.Third) then
    FreeNodes(P^.Third);

  //萔
  if (P^.Code = opConstant) and Assigned(P^.Value) then
    Dispose(P^.Value);
  //Ōɉ
  Dispose(P);
end;

procedure TJExprFactory.InitTree(var P: PJExpr);
//node
begin
  FreeNodes(P);
  P := nil;
end; }

function TJExprFactory.NewExpr: PJExpr;
//V쐬
begin
  New(Result);
  //
  Result^.Code := opNone;
  Result^.Left := nil;
  Result^.Third := nil;
  Result^.Right := nil;
  Result^.Value := nil;
  Result^.Symbol := '';
  FList.Add(Result);
end;


function TJExprFactory.MakeExpr1(Code: TJOPCode; Left: PJExpr): PJExpr;
//1쐬
begin
  //VK쐬
  Result := NewExpr;
  Result^.Code := Code;
  Result^.Left := Left;
  Result^.Right := nil;
end;

function TJExprFactory.MakeExpr2(Code: TJOPCode; Left,Right: PJExpr): PJExpr;
//2쐬
begin
  //萔̐܂
  if IsConstant(Left) and IsConstant(Right) then
  begin
    case Code of
      opAdd,opSub,opMul,opDiv,opMod,opDivInt,opBitAnd,opBitOr,opBitXor,
      opBitLeft,opBitRight,opBitRightZero:
      begin
        Left^.Value^ := CalcValue2(Code,Left^.Value^,Right^.Value^);
        //Right
        //FreeNodes(Right);
        FList.Remove(Right);
        FreeExpr(Right);
        //leftԂ
        Result := Left;
      end;
      opLS,opGT,opLSEQ,opGTEQ,opEQ,opNE,opEQEQEQ,opNEEQEQ,
      opLogicalOr,opLogicalAnd:
      begin
        Left^.Value^ := CompareValue(Code,Left^.Value^,Right^.Value^);
        //Right
        //FreeNodes(Right);
        FList.Remove(Right);
        FreeExpr(Right);
        //leftԂ
        Result := Left;
      end;
      else
        //VK쐬
        Result := NewExpr;
        Result^.Code := Code;
        Result^.Left := Left;
        Result^.Right := Right;
    end;
  end
  else begin
    //VK쐬
    Result := NewExpr;
    Result^.Code := Code;
    Result^.Left := Left;
    Result^.Right := Right;
  end;
end;


function TJExprFactory.MakeExpr3(Code: TJOPCode;Left,Right,Third: PJExpr): PJExpr;
//3쐬
begin
  //VK쐬
  Result := NewExpr;
  Result^.Code := Code;
  Result^.Left := Left;
  Result^.Right := Right;
  Result^.Third := Third;
end;

function TJExprFactory.MakeConstant(Value: TJValue): PJExpr;
//萔쐬
begin
  Result := NewExpr;
  Result^.Code := opConstant;
  //萔VK쐬
  New(Result^.Value);
  Result^.Value^ := Value;
end;

function TJExprFactory.MakeVariable(Symbol: String): PJExpr;
//ϐ쐬
begin
  Result := NewExpr;
  Result^.Code := opVariable;
  Result^.Symbol := Symbol;
end;

function TJExprFactory.MakeNumberInt(Value: Integer): PJExpr;
//萔̐쐬
var
  v: TJValue;
begin
  EmptyValue(v);
  v.ValueType := vtInteger;
  v.vInteger := Value;
  Result := MakeConstant(v);
end;

function TJExprFactory.MakeNumberFloat(Value: Double): PJExpr;
//萔̕_쐬
var
  v: TJValue;
begin
  EmptyValue(v);
  v.ValueType := vtDouble;
  v.vDouble := Value;
  Result := MakeConstant(v)
end;

function TJExprFactory.MakeNull: PJExpr;
//null쐬
var
  v: TJValue;
begin
  EmptyValue(v);
  v.ValueType := vtNull;
  v.vNull := nil;
  Result := MakeConstant(v)
end;

function TJExprFactory.MakeBoolean(Value: Boolean): PJExpr;
//bool쐬
var
  v: TJValue;
begin
  EmptyValue(v);
  v.ValueType := vtBool;
  v.vBool := Value;
  Result := MakeConstant(v)
end;

function TJExprFactory.MakeString(S: String): PJExpr;
//쐬
var
  v: TJValue;
begin
  EmptyValue(v);
  v.ValueType := vtString;
  //NI[g菜
  //S := Copy(S,2,Length(S) - 2);
  //ꕶϊ
  //S := StringReplace(S,'\n',#13#10,[rfReplaceAll]);
  //S := StringReplace(S,'\f',#12,[rfReplaceAll]);
  //S := StringReplace(S,'\b',#8,[rfReplaceAll]);
  //S := StringReplace(S,'\r',#13,[rfReplaceAll]);
  //S := StringReplace(S,'\t',#9,[rfReplaceAll]);
  //S := StringReplace(S,'\'#39,#39,[rfReplaceAll]);
  //S := StringReplace(S,'\"','"',[rfReplaceAll]);
  //S := StringReplace(S,'\\','\',[rfReplaceAll]);

  v.vString := S;
  Result := MakeConstant(v)
end;

function TJExprFactory.MakeUndefined: PJExpr;
//`쐬
var
  v: TJValue;
begin
  EmptyValue(v);
  v.ValueType := vtUndefined;
  Result := MakeConstant(v)
end;

function TJExprFactory.MakeInfinity: PJExpr;
//쐬
var
  v: TJValue;
begin
  EmptyValue(v);
  v.ValueType := vtInfinity;
  Result := MakeConstant(v)
end;

function TJExprFactory.MakeThis: PJExpr;
//this쐬
begin
  Result := NewExpr;
  Result^.Code := opThis;
end;

function TJExprFactory.MakeArguments(Prev,Next: PJExpr): PJExpr;
//쐬
begin
  Result := NewExpr;
  Result^.Code := opArg;
  Result^.Left := Prev;
  Result^.Right := Next;

  //ԍsymbolɕۑĂiȂꂵcj
  //if not Assigned(Prev) then
  //  Result^.Symbol := IntToStr(0)
  //else
  //  Result^.Symbol := IntToStr(StrToIntDef(Prev^.Symbol,0) + 1);
end;

function CalcValue1(Code: TJOPCode; L: TJValue): TJValue;
//P
//ĽvZʂԂ
//^ɂĂ͌vZłȂꍇ
begin
  EmptyValue(Result);
  //^`FbN
  //`G[
  if IsUndefined(@L) then
    raise EJThrow.Create(E_NAME,'');
  //^G[
  if IsObject(@L) or IsFunction(@L) or IsInfinity(@L) then
    raise EJThrow.Create(E_TYPE,'');
  //vZ
  case Code of
    opMinus:
    begin
      if IsDouble(@L) then
        Result := BuildDouble(0 - AsDouble(@L))
      else
        Result := BuildInteger(0 - (AsInteger(@L)));
    end;
    opPlus:
    begin
      if IsDouble(@L) then
        Result := BuildDouble(Abs(AsDouble(@L)))
      else
        Result := BuildInteger(Abs(AsInteger(@L)));
    end;
    opBitNot:
    begin
      Result := BuildInteger(not (AsInteger(@L)));
    end; 
  end;

end;

function CalcValue2(Code: TJOPCode; L,R: TJValue): TJValue;
//Q
//LŘvZʂԂ
//^ɂĂ͌vZłȂꍇ
var
  dbl: Double;
  i: Integer;
begin
  EmptyValue(Result);
  //^`FbN
  //`G[
  if IsUndefined(@L) or IsUndefined(@R) then
    raise EJThrow.Create(E_NAME,'');
  //^G[
  if {IsObject(@L) or} IsFunction(@L) or IsInfinity(@L) or
     {IsObject(@R) or} IsFunction(@R) or IsInfinity(@R) then
    raise EJThrow.Create(E_TYPE,'');
  //vZ
  case Code of
    opAdd: //Z    +
    begin
      //ǂ炩̏ꍇ͕ɕϊ
      if IsString(@L) or IsString(@R) then
        Result := BuildString(AsString(@L) + AsString(@R))
      //ǂ炩doublȅꍇ͕ϊ
      else if IsDouble(@L) or IsDouble(@R) then
        Result := BuildDouble(AsDouble(@L) + AsDouble(@R))
      else //
        Result := BuildInteger(AsInteger(@L) + AsInteger(@R));
    end;
    opSub: //Z       -
    begin
      if IsDouble(@L) or IsDouble(@R) then
        Result := BuildDouble(AsDouble(@L) - AsDouble(@R))
      else //
        Result := BuildInteger(AsInteger(@L) - AsInteger(@R));
    end;
    opMul: //|Z    *
    begin
      if IsDouble(@L) or IsDouble(@R) then
        Result := BuildDouble(AsDouble(@L) * AsDouble(@R))
      else //
        Result := BuildInteger(AsInteger(@L) * AsInteger(@R));
    end;
    opDiv: //Z   /  0Z`FbN
    begin
      dbl := AsDouble(@R);
      if dbl = 0 then
        raise EJThrow.Create(E_ZD,'');

      Result := BuildDouble(AsDouble(@L) / dbl);
    end;
    opDivInt: //Z  mod  0Z`FbN
    begin
      i := AsInteger(@R);
      if i = 0 then
        raise EJThrow.Create(E_ZD,'');

      Result := BuildInteger(AsInteger(@L) div i);
    end;
    opMod: //܂ %     0Z`FbN
    begin
      i := AsInteger(@R);
      if i = 0 then
        raise EJThrow.Create(E_ZD,'');
        
      Result := BuildInteger(AsInteger(@L) mod AsInteger(@R));
    end;
    opBitAnd: // &
    begin
      Result := BuildInteger(AsInteger(@L) and AsInteger(@R));
    end;
    opBitOr:  // |
    begin
      Result := BuildInteger(AsInteger(@L) or AsInteger(@R));
    end;
    opBitXor: // ^
    begin
      Result := BuildInteger(AsInteger(@L) xor AsInteger(@R));
    end;
    opBitLeft: // <<
    begin
      Result := BuildInteger(AsInteger(@L) shl AsInteger(@R));
    end;
    opBitRight: // >>
    begin
      Result := BuildInteger(AsInteger(@L) shr AsInteger(@R));
    end;
    opBitRightZero: // >>>
    begin
      Result := BuildInteger(AsInteger(@L) shr AsInteger(@R));
    end;     
  end;
end;

function CalcValue3(Code: TJOPCode; L,R,T: TJValue): TJValue;
//3
begin
  EmptyValue(Result);
  case Code of
    opConditional:  //  l ? r : t
    begin
      if AsBool(@L) then
        Result := R
      else
        Result := T;
    end;
  end;

end;

function AssignValue(Code: TJOPCode; Variable,Value: TJValue): TJValue;
//
begin
  EmptyValue(Result);
  case Code of
    opMulAssign:
    begin
      Result := CalcValue2(opMul,Variable,Value);
    end;
    opDivAssign:
    begin
      Result := CalcValue2(opDiv,Variable,Value);
    end;
    opAddAssign:
    begin
      Result := CalcValue2(opAdd,Variable,Value);
    end;
    opSubAssign:
    begin
      Result := CalcValue2(opSub,Variable,Value);
    end;
    opModAssign:
    begin
      Result := CalcValue2(opMod,Variable,Value);
    end;
    opBitLeftAssign:
    begin
      Result := CalcValue2(opBitLeft,Variable,Value);
    end;
    opBitRightAssign:
    begin
      Result := CalcValue2(opBitRight,Variable,Value);
    end;
    opBitRightZeroAssign:
    begin
      Result := CalcValue2(opBitRightZero,Variable,Value);
    end;
    opBitAndAssign:
    begin
      Result := CalcValue2(opBitAnd,Variable,Value);
    end;
    opBitXorAssign:
    begin
      Result := CalcValue2(opBitXor,Variable,Value);
    end;
    opBitOrAssign:
    begin
      Result := CalcValue2(opBitOr,Variable,Value);
    end;
  end;
  
end;

function CompareValue(Code: TJOPCode; L,R: TJValue): TJValue;
//r쐬
  function IsEqual: Boolean;
  begin
    if IsInteger(@L) and IsInteger(@R) then
      Result := L.vInteger = R.vInteger
    else if IsDouble(@L) and IsDouble(@R) then
      Result := L.vDouble = R.vDouble
    else if IsUndefined(@L) and IsUndefined(@R) then
      Result := True
    else if IsNull(@L) and IsNull(@R) then
      Result := True
    else if IsString(@L) and IsString(@R) then
      Result := L.vString = R.vString
    else if IsObject(@L) and IsObject(@R) then
      Result := L.vObject = R.vObject
    else if IsBool(@L) and IsBool(@R) then
      Result := L.vBool = R.vBool
    else if IsFunction(@L) and IsFunction(@R) then
      Result := EqualFunction(@L,@R)
    else if IsInfinity(@L) and IsInfinity(@R) then
      Result := True
{$IFNDEF AX}
    else if IsDispatch(@L) and IsDispatch(@R) then
      Result := L.vDispatch = R.vDispatch
{$ENDIF}
    else
      Result := False;
  end;

begin
  Result := BuildBool(False);
  case Code of
    //_r
    opLogicalOr: Result := BuildBool(AsBool(@L) or AsBool(@R));
    opLogicalAnd: Result := BuildBool(AsBool(@L) and AsBool(@R));
    opLogicalNot: Result := BuildBool(not AsBool(@L));
    opLS,opLSEQ,opGT,opGTEQ:
    begin
      //܂lŔr
      if IsInteger(@L) and IsInteger(@R) then
      begin
        case Code of //Ŕr
          opLS: Result := BuildBool(AsInteger(@L) < AsInteger(@R));
          opLSEQ: Result := BuildBool(AsInteger(@L) <= AsInteger(@R));
          opGT: Result := BuildBool(AsInteger(@L) > AsInteger(@R));
          opGTEQ: Result := BuildBool(AsInteger(@L) >= AsInteger(@R));
        end;
      end
      else if IsDouble(@L) and IsDouble(@R) then
      begin
        case Code of //Ŕr
          opLS: Result := BuildBool(AsDouble(@L) < AsDouble(@R));
          opLSEQ: Result := BuildBool(AsDouble(@L) <= AsDouble(@R));
          opGT: Result := BuildBool(AsDouble(@L) > AsDouble(@R));
          opGTEQ: Result := BuildBool(AsDouble(@L) >= AsDouble(@R));
        end;
      end
      else if TryAsNumber(@L) and TryAsNumber(@R) then //lł
      begin
        case Code of //Ŕr
          opLS: Result := BuildBool(AsDouble(@L) < AsDouble(@R));
          opLSEQ: Result := BuildBool(AsDouble(@L) <= AsDouble(@R));
          opGT: Result := BuildBool(AsDouble(@L) > AsDouble(@R));
          opGTEQ: Result := BuildBool(AsDouble(@L) >= AsDouble(@R));
        end;
      end
      else if (L.ValueType = vtNaN) and (R.ValueType = vtNaN) then
        Result := BuildBool(False)
      else begin
        case Code of //ɂĔr
          opLS: Result := BuildBool(AsString(@L) < AsString(@R));
          opLSEQ: Result := BuildBool(AsString(@L) <= AsString(@R));
          opGT: Result := BuildBool(AsString(@L) > AsString(@R));
          opGTEQ: Result := BuildBool(AsString(@L) >= AsString(@R));
        end;
      end;
    end;
    opEQEQEQ,opNEEQEQ:
    begin
      if EqualType(@L,@R) then
      begin
        case Code of
          opEQEQEQ: Result := BuildBool(IsEqual);
          opNeEQEQ: Result := BuildBool(not IsEqual);
        end;
      end
    end;
    opEQ,opNE:
    begin
      if EqualType(@L,@R) then
      begin
        case Code of
          opEQ: Result := BuildBool(IsEqual);
          opNe: Result := BuildBool(not IsEqual);
        end;
      end
      else if (IsNull(@L) and IsUndefined(@R)) or
              (IsNull(@R) and IsUndefined(@L)) then
      begin
        case Code of
          opEQ: Result := BuildBool(True);
          opNe: Result := BuildBool(False);
        end;
      end
      else begin
        //ɂĔr
        case Code of
          opEQ: Result := BuildBool(AsString(@L) = AsString(@R));
          opNE: Result := BuildBool(AsString(@L) <> AsString(@R));
        end;
      end;
    end
  end;

end;





function TJExprFactory.MakeNaN: PJExpr;
//NaN쐬
var
  v: TJValue;
begin
  EmptyValue(v);
  v.ValueType := vtNaN;
  v.vNull := nil;
  Result := MakeConstant(v)
end;

function TJExprFactory.MakeObjectElement(Name, Value: PJExpr): PJExpr;
begin
  Result := NewExpr;
  Result^.Code := opObjectElement;
  Result^.Left := Name;
  Result^.Right := Value;
end;

function TJExprFactory.MakeSuper(Expr: PJExpr): PJExpr;
//super쐬
begin
  Result := NewExpr;
  Result^.Code := opSuper;
  Result^.Right := Expr;
end;

end.
