#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description: installer for globus-2.4.2 

imageroot="/var/lib/diskless/default/root"
drblhost="/var/lib/diskless/default"

if [ "$1" = "" ]; then ncpus=1; fi

trap 'rm -f apps.$$; exit 1' HUP INT QUIT TERM

## globus-2.4.2
echo -n "Compile/Configure globus-2.4.2 [Y|n]? "
read ANS
if [ "$ANS" != "N" -a "$ANS" != "n" ]; then

  ## download the package and put it in apps.$$
  mkdir apps.$$
  wget http://drbl.nchc.org.tw/debian/download/apps/gpt-2.2.10-src.tar.gz
  wget http://drbl.nchc.org.tw/debian/download/apps/globus-all-2.4.2-i686-pc-linux-gnu-bin.tar.gz
  mv gpt-2.2.10-src.tar.gz apps.$$/
  mv globus-all-2.4.2-i686-pc-linux-gnu-bin.tar.gz apps.$$/

  ## join NCHC Grid TestBed ?
  echo -n "Do you want to join NCHC Grid TestBed [Y|n]? "
  read ANS
  join_nchc_grid_testbed=0
  if [ "$ANS" = "Y" -o "$ANS" = "y" -o "$ANS" = "" ]; then
    join_nchc_grid_testbed=1
    wget http://drbl.nchc.org.tw/debian/download/apps/globus_simple_ca_9f0f4e68_setup-0.12.tar.gz
    mv globus_simple_ca_9f0f4e68_setup-0.12.tar.gz apps.$$
  fi
  ##
  ## environment variable
  ##
  export GLOBUS_LOCATION=/opt/Globus/globus-2.4.2
  export GPT_LOCATION=/opt/Globus/gpt-2.2.10
  ##
  ## gpt-2.2.10
  ##
  tar -C apps.$$ -xvzf apps.$$/gpt-2.2.10-src.tar.gz
  cd apps.$$/gpt-2.2.10
  ./build_gpt
  cd ../..
  ##
  ## globus-2.4.2
  ##
  /opt/Globus/gpt-2.2.10/sbin/gpt-install apps.$$/globus-all-2.4.2-i686-pc-linux-gnu-bin.tar.gz
  . /opt/Globus/globus-2.4.2/etc/globus-user-env.sh
  /opt/Globus/gpt-2.2.10/sbin/gpt-postinstall
  /opt/Globus/globus-2.4.2/setup/globus/setup-gsi

  ##
  ## ca (nchc demo ca, darwin.nchc.gov.tw)
  ##
  ##if [ -e apps.$$/globus_simple_ca_9f0f4e68_setup-0.12.tar.gz ]; then
  if [ $join_nchc_grid_testbed -eq 1 ]; then
    /opt/Globus/gpt-2.2.10/sbin/gpt-build -install-only apps.$$/globus_simple_ca_9f0f4e68_setup-0.12.tar.gz
    /opt/Globus/gpt-2.2.10/sbin/gpt-postinstall
    /opt/Globus/globus-2.4.2/setup/globus_simple_ca_9f0f4e68_setup/setup-gsi -default
  fi

  ##
  ## Blake, 2004/03/09, myproxy
  ##
  wget http://drbl.nchc.org.tw/debian/download/apps/myproxy-1.11.tar.gz
  /opt/Globus/gpt-2.2.10/sbin/gpt-build myproxy-1.11.tar.gz gcc32dbg
  /opt/Globus/gpt-2.2.10/sbin/gpt-postinstall
  rm -f myproxy-1.11.tar.gz

  ##
  ## globus pbs jobmanager
  ##
  ## Blake, 2003/09/04, ask to install pbs jobmanager only 
  ## when the $imageroot and /opt/Globus/openpbs_2_3_16 exist
  if [ "$(dpkg -l openpbs | grep "openpbs" | cut -d" " -f1)" = "ii" ]; then
    echo -n "  Do you want to install pbs jobmanager [Y|n]? "
    read ANS
  else
    ANS="N"
  fi

  if [ "$ANS" != "N" -a "$ANS" != "n" ]; then
    #tar -C apps.$$ -xvzf apps.$$/globus_gram_job_manager_setup_pbs-1.5.tar.gz
    #cd apps.$$/globus_gram_job_manager_setup_pbs-1.5
    #./configure
    #make
    #make install
    #cd ../..
    wget http://drbl.nchc.org.tw/debian/download/apps/globus_gram_job_manager_setup_pbs-1.5.tar.gz
    mv globus_gram_job_manager_setup_pbs-1.5.tar.gz apps.$$
    export PATH="$PATH:/opt/pbs/bin:/opt/pbs/sbin"

    /opt/Globus/gpt-2.2.10/sbin/gpt-build -install-only apps.$$/globus_gram_job_manager_setup_pbs-1.5.tar.gz
    # before execute the command "setup-globus-job-manager-pbs"
    # you should move the directory /opt/globus-2.4.2/setup/globus
    cp /opt/Globus/globus-2.4.2/etc/grid-services/jobmanager-fork /opt/Globus/globus-2.4.2/etc/grid-services/jobmanager-pbs
    rm /opt/Globus/globus-2.4.2/etc/grid-services/jobmanager
    ln -s jobmanager-pbs /opt/Globus/globus-2.4.2/etc/grid-services/jobmanager
    CPWD=$(pwd)
    cd /opt/Globus/globus-2.4.2/setup/globus/
    ./setup-globus-job-manager-pbs --service-name jobmanager --cpu-per-node=$ncpus --remote-shell=ssh
    cd ${CPWD}
    /opt/Globus/gpt-2.2.10/sbin/gpt-postinstall
  fi
  ## end globus pbs jobmanager 
  rm -rf BUILD
  ln -s /opt/Globus/globus-2.4.2 /opt/Globus/globus-current
  ln -s /opt/Globus/gpt-2.2.10 /opt/Globus/gpt-current
  
  ## profile.d
  cat <<-EOF > /etc/profile.d/globus.sh
#!/bin/sh
# globus 2.4.2
export GLOBUS_LOCATION=/opt/Globus/globus-current
export GPT_LOCATION=/opt/Globus/gpt-current
#export PATH="\$PATH:/opt/Globus/globus-current/bin"
#export MANPATH="\$MANPATH:/opt/Globus/globus-current/man"
source /opt/Globus/globus-current/etc/globus-user-env.sh
EOF
  chmod 755 /etc/profile.d/globus.sh
  . /etc/profile.d/globus.sh

  ## starting globus services
  perl -p -i -e "s/gsigatekeeper.*//g" /etc/services
  perl -p -i -e "s/gisftp.*//g" /etc/services
  echo "gsigatekeeper		2119/tcp			# globus gatekeeper" >> /etc/services
  echo "gsiftp		2811/tcp			# globus gisftp" >> /etc/services

  #perl -p -i -e "s/gsigatekeeper.*//g" /etc/inetd.conf
  #perl -p -i -e "s/gsiftp.*//g" /etc/inetd.conf
  #echo "gsigatekeeper	stream	tcp	nowait	root	/usr/bin/env	env LD_LIBRARY_PATH=/opt/Globus/globus-current/lib /opt/Globus/globus-current/sbin/globus-gatekeeper -conf /opt/Globus/globus-current/etc/globus-gatekeeper.conf" >> /etc/inetd.conf
  #echo "gsiftp	stream	tcp	nowait	root	/usr/bin/env	env LD_LIBRARY_PATH=/opt/Globus/globus-current/lib /opt/Globus/globus-current/sbin/in.ftpd -l -a -G /opt/Globus/globus-current" >> /etc/inetd.conf
  /usr/sbin/update-inetd --remove "gsigatekeeper"
  /usr/sbin/update-inetd --remove "gsiftp"
  /usr/sbin/update-inetd --add "gsigatekeeper	stream	tcp	nowait	root	/usr/bin/env	env LD_LIBRARY_PATH=/opt/Globus/globus-current/lib /opt/Globus/globus-current/sbin/globus-gatekeeper -conf /opt/Globus/globus-current/etc/globus-gatekeeper.conf"
  /usr/sbin/update-inetd --add "gsiftp	stream	tcp	nowait	root	/usr/bin/env	env LD_LIBRARY_PATH=/opt/Globus/globus-current/lib /opt/Globus/globus-current/sbin/in.ftpd -l -a -G /opt/Globus/globus-current"

  ln -s /opt/Globus/globus-current/sbin/globus-mds /etc/rc2.d/S99globus-mds
  if [ $join_nchc_grid_testbed -eq 1 ]; then
    /usr/bin/perl -p -i -e "s/^dn:.*/dn: Mds-Vo-Op-name=register, Mds-Vo-name=DRBL, o=grid/g" /opt/Globus/globus-current/etc/grid-info-resource-register.conf
    /usr/bin/perl -p -i -e "s/^reghn:.*/reghn: ase.nchc.org.tw/g" /opt/Globus/globus-current/etc/grid-info-resource-register.conf
  fi
  /etc/rc2.d/S99globus-mds start

  ln -s /opt/Globus/globus-current/var /var/log/globus

  ## notify user
  #echo "Vertify your installation"
  #/opt/gpt-2.2.10/sbin/gpt-verify

  #echo "You need gatekeeper and mds certificates for your host."
  echo "You need a gatekeeper certificate for your host."
  echo "Run the following command as root to get a gatekeeper certificate,"
  echo "replacing <FQDN> with the fully qualified hostname of your machine."
  echo
  echo "  # grid-cert-request -service host -host <FQDN>"
  #echo "  # grid-cert-request -service ldap -host <FQDN>"
  echo
  echo "After you get the certificate, "
  echo "run the following commands to start to globus services"
  echo 
  echo "  # /opt/Globus/globus-current/setup/globus/setup-globus-gram-job-manager"
  #echo "  # /opt/Globus/globus-current/sbin/globus-mds start"
  echo "  # /etc/init.d/inetd restart"
  echo
  echo "Press any key to continue.."
  read anykey

  echo "* To request a globus user certificate," >> /opt/drbl/etc/motd.globus-2.4.2
  echo "  simply run the command \"grid-cert-request\"" >> /opt/drbl/etc/motd.globus-2.4.2

  ## hoursekeeping
  rm -rf apps.$$
fi

