#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description: mpich-1.2.4 installer
#

imageroot="/var/lib/diskless/default/root"
drblhost="/var/lib/diskless/default"

trap 'rm -f apps.$$; exit 1' HUP INT QUIT TERM

# mpich-1.2.4 - for gnu compiler
echo -n "Compile/Configure mpich-1.2.4 (gcc) [Y|n]? "
read ANS
if [ "$ANS" != "N" -a "$ANS" != "n" ]; then

  ##
  if [ "$NCPUS" = "" ]; then
    echo -n "The number of cpus on each node [1]? "
    read NCPUS
    if [ "$NCPUS" = "" ]; then NCPUS="1"; fi
  fi

  # download the package 
  mkdir -p apps.$$
  wget http://drbl.nchc.org.tw/debian/download/apps/mpich-1.2.4.tar.gz
  mv mpich-1.2.4.tar.gz apps.$$ 

  # untar the package
  tar -C apps.$$ -xvzf apps.$$/mpich-1.2.4.tar.gz
  cd apps.$$/mpich-1.2.4
  ./configure --prefix=/opt/mpich-1.2.4/gnu -rsh="/usr/bin/ssh"
  make
  make install
  cd ../..
  rm -rf apps.$$/mpich-1.2.4

  cat <<-EOF > /opt/mpich-1.2.4/gnu/share/machines.LINUX
# Change this file to contain the machines that you want to use
# to run MPI jobs on.  The format is one host name per line, with either
#    hostname
# or
#    hostname:n
# where n is the number of processors in an SMP.  The hostname should
# be the same as the result from the command "hostname"
EOF
  if [ "$NCPUS" = "1" ]; then
    cat /etc/dhcp3/dhcpd.conf | grep "fixed-address" | cut -d';' -f1 | awk '{ print $2; }' >> /opt/mpich-1.2.4/gnu/share/machines.LINUX
  else 
    cat /etc/dhcp3/dhcpd.conf | grep "fixed-address" | cut -d';' -f1 | awk -v NCPUS=$NCPUS '{ print $2":"NCPUS; }' >> /opt/mpich-1.2.4/gnu/share/machines.LINUX
  fi

  cat <<-EOF > /etc/profile.d/mpich-1.2.4-gnu.sh
#!/bin/sh
# mpich-1.2.4
export PATH="\$PATH:/opt/mpich-1.2.4/gnu/bin"
export MANPATH="\$MANPATH:/opt/mpich-1.2.4/gnu/man"
EOF
  chmod 755 /etc/profile.d/mpich-1.2.4-gnu.sh
  . /etc/profile.d/mpich-1.2.4-gnu.sh
fi

# intel compiler 7.0 and mpich-1.2.4 - for intel compiler 7.0
# 
if [ -f /opt/intel/compiler70/ia32/bin/icc -a \
     -f /opt/intel/compiler70/ia32/bin/ifc ]; then
  
  echo -n "Compile/Configure mpich-1.2.4 (intel compiler 7.0) [Y|n]? "
  read ANS
  if [ "$ANS" != "N" -a "$ANS" != "n" ]; then
    source /opt/intel/compiler70/ia32/bin/iccvars.sh
    source /opt/intel/compiler70/ia32/bin/ifcvars.sh
    ICC="/opt/intel/compiler70/ia32/bin/icc"
    IFC="/opt/intel/compiler70/ia32/bin/ifc"
    tar -C apps.$$ -xvzf apps.$$/mpich-1.2.4.tar.gz
    cd apps.$$/mpich-1.2.4
    ./configure --prefix=/opt/mpich-1.2.4/intel70 -cc=$ICC -fc=$IFC -f90=$IFC -rsh="/usr/bin/ssh"
    make 
    make install
    cd ../..
    rm -rf apps.$$/mpich-1.2.4

    cat <<-EOF > /opt/mpich-1.2.4/intel70/share/machines.LINUX
# Change this file to contain the machines that you want to use
# to run MPI jobs on.  The format is one host name per line, with either
#    hostname
# or
#    hostname:n
# where n is the number of processors in an SMP.  The hostname should
# be the same as the result from the command "hostname"
EOF
    if [ "$NCPUS" = "1" ]; then
      cat /etc/dhcp3/dhcpd.conf | grep "fixed-address" | cut -d';' -f1 | awk '{ print $2; }' >> /opt/mpich-1.2.4/intel70/share/machines.LINUX
    else 
      cat /etc/dhcp3/dhcpd.conf | grep "fixed-address" | cut -d';' -f1 | awk -v NCPUS=$NCPUS '{ print $2":"NCPUS; }' >> /opt/mpich-1.2.4/intel70/share/machines.LINUX
    fi

    cat <<-EOF > /etc/profile.d/mpich-1.2.4-intel70.sh
#!/bin/sh
# intel compiler 7.0 and mpich-1.2.4 compiled using intel compiler
source /opt/intel/compiler70/ia32/bin/iccvars.sh
source /opt/intel/compiler70/ia32/bin/ifcvars.sh
export PATH="\$PATH:/opt/mpich-1.2.4/intel/bin"
export MANPATH="\$MANPATH:/opt/mpich-1.2.4/intel/man"
EOF
    chmod 755 /etc/profile.d/mpich-1.2.4-intel70.sh
    . /etc/profile.d/mpich-1.2.4-intel70.sh
  fi

  # hoursekeeping
  rm -rf apps.$$
fi

