#!/bin/sh
# Author: Blake, Kuo-Lien Huang
# License: GPL
# Description: installer for OpenPBS 2.3.16

imageroot="/var/lib/diskless/default/root"
drblhost="/var/lib/diskless/default"

trap 'rm -f apps.$$; exit 1' HUP INT QUIT TERM

# openpbs 2.3.16
## Blake, 2003/09/04, ask to install openpbs only when the $imageroot is exist
if [ -d $imageroot ]; then
  echo -n "Compile/Configure openpbs 2.3.16 [Y|n]? "
  read ANS
else
  echo "$imageroot does not exists. Abort!"
  ANS="N"
fi

if [ "$ANS" != "N" -a "$ANS" != "n" ]; then

  ##
  if [ "$NCPUS" = "" ]; then
    echo -n "The number of cpus on each node [1]? "
    read NCPUS
    if [ "$NCPUS" = "" ]; then NCPUS="1"; fi
  fi

  ## autosshkeygen (because we use scp to deliver file ...)
  #resshkeygen=0
  #if [ ! -f /root/.ssh/id_rsa ]; then
  #  apps/autosshkeygen root
  #  mv /root/.ssh/id_rsa.pub /root/.ssh/authorized_keys
  #  resshkeygen=1 
  #fi
  resshkeygen=0
  if [ ! -f /root/.ssh/id_rsa ]; then
    cat <<-EOF > autosshkeygen.$$
#!/bin/sh
# \\
exec expect "\$0" \${1+"\$@"}
set username [lindex \$argv 0]
spawn sudo -u \$username ssh-keygen -t rsa
expect "Enter file in which to save the key"
send "\r"
expect "Enter passphrase"
send "\r"
expect "Enter same passphrase again"
send "\r"
expect eof
EOF
    chmod 755 autosshkeygen.$$
    ./autosshkeygen.$$ root
    mv /root/.ssh/id_rsa.pub /root/.ssh/authorized_keys
    resshkeygen=1 
    rm -f ./autosshkeygen.$$
  fi

  for host in `ls $drblhost`
  do
    if [ "$host" = "." -o "$host" = ".." -o "$host" = "root" ]; then
      continue
    fi
    if [ $resshkeygen -eq 1 -o ! -f $drblhost/$host/root/.ssh/id_rsa ]; then
      mkdir -p $drblhost/$host/root/.ssh
      cp /root/.ssh/id_rsa $drblhost/$host/root/.ssh/id_rsa
      cp /root/.ssh/authorized_keys $drblhost/$host/root/.ssh/authorized_keys
    fi
  done
  ## end autosshkeygen

  apt-get -y install tcl8.3 tcl8.3-dev
  apt-get -y install tk8.3 tk8.3-dev

  # download the package
  mkdir apps.$$
  wget http://drbl.nchc.org.tw/debian/download/apps/pbs.tar.gz
  tar -C apps.$$ -xvzf pbs.tar.gz
  rm -f pbs.tar.gz
  more apps.$$/PBS_License.txt
  echo -n "Do you agree to the above license [yes or no]? "
  read reply leftover
  case reply in
    y* | Y*) ;;
    n* | N*)
      echo "If you don't agree to the license you can't install this software" 
      rm -rf apps.$$
      exit 0
      ;;   
  esac
  wget http://drbl.nchc.org.tw/debian/download/apps/OpenPBS_2_3_16.tar.gz
  mv OpenPBS_2_3_16.tar.gz apps.$$

  # stop the previous one
  apps.$$/pbs stop
  apps.$$/pbs_mom stop
 
  # untar the package
  tar -C apps.$$ -xvzf apps.$$/OpenPBS_2_3_16.tar.gz
  cd apps.$$/OpenPBS_2_3_16
  ./configure --with-scp --enable-syslog --disable-gui --enable-docs --prefix=/opt/gridbox/openpbs_2_3_16 --set-server-home=/var/spool/PBS --set-default-server=$(hostname)
  make
  make install
  cd ../..
  rm -rf apps.$$/OpenPBS_2_3_16
  ## create the "nodes" file in the central server's directory /var/spool/PBS/server_priv
  echo "$(hostname)" > /var/spool/PBS/server_priv/nodes
  if [ "$NCPUS" = "1" ]; then
    cat /etc/dhcp3/dhcpd.conf | grep -B2 "fixed-address" | grep "host" | awk '{ print $2; }' >> /var/spool/PBS/server_priv/nodes
  else
    cat /etc/dhcp3/dhcpd.conf | grep -B2 "fixed-address" | grep "host" | awk -v NCPUS=$NCPUS '{ print $2" np="NCPUS; }' >> /var/spool/PBS/server_priv/nodes
  fi
  ## initialize the pbs server daemon and scheduler
  /opt/gridbox/openpbs_2_3_16/sbin/pbs_server -t create
  /opt/gridbox/openpbs_2_3_16/sbin/pbs_sched
  cp apps.$$/pbs /etc/init.d/
  cp apps.$$/pbs_mom /etc/init.d/
  #cp apps.$$/pbs_mom $imageroot/etc/init.d
  #ln -fs ../init.d/pbs /etc/rc2.d/S60pbs
  #ln -fs ../init.d/pbs_mom /etc/rc2.d/S61pbs_mom
  /usr/sbin/update-rc.d pbs default 60
  /usr/sbin/update-rc.d pbs_mom default 61
  #ln -s ../init.d/pbs_mom $imageroot/etc/rc2.d/S60pbs_mom
  for host in `ls $drblhost`
  do
    if [ "$host" != "." -a "$host" != ".." ]; then
      cp apps.$$/pbs_mom $drblhost/$host/etc/init.d
      #ln -fs ../init.d/pbs $drblhost/$host/etc/rc2.d/S60pbs
      ln -fs ../init.d/pbs_mom $drblhost/$host/etc/rc2.d/S60pbs_mom
    fi
  done
  ## create queues using the "qmgr" command
  /opt/gridbox/openpbs_2_3_16/bin/qmgr < apps.$$/pbs_conf
  ## configure the PBS nodes so that they know the server
  echo "$(hostname)" > /var/spool/PBS/server_name
  echo "\$clienthost $(hostname)" > /var/spool/PBS/mom_priv/config
  echo "\$logevent 0x1ff" >> /var/spool/PBS/mom_priv/config
  #cp -r /var/spool/PBS $imageroot/var/spool
  #chmod o+t /var/spool/PBS/spool
  #chmod o+t $imageroot/var/spool/PBS/spool
  for host in `ls $drblhost`
  do
    if [ "$host" != "." -a "$host" != ".." ]; then
      cp -a /var/spool/PBS $drblhost/$host/var/spool
      #chmod 777 $drblhost/$host/var/spool/PBS/spool
      #chmod o+t $drblhost/$host/var/spool/PBS/spool
    fi
  done
  ## queues defined above do not work until you start them
  /opt/gridbox/openpbs_2_3_16/bin/qstart default
  /opt/gridbox/openpbs_2_3_16/bin/qenable default

  ## example pbs script
  mkdir -p /opt/gridbox/openpbs_2_3_16/examples
  cp apps.$$/pbsjob.sh /opt/gridbox/openpbs_2_3_16/examples
  cp apps.$$/pbs_command.txt /opt/gridbox/openpbs_2_3_16/examples
  echo "* To submit jobscript to PBS, refer the examples in /opt/gridbox/openpbs_2_3_16/examples" >> /opt/drbl/etc/motd.pbs-2.3.16

  cat <<-EOF > /etc/profile.d/openpbs-2.3.16.sh
#!/bin/sh
# openpbs 2.3.16
export PATH="\$PATH:/opt/gridbox/openpbs_2_3_16/bin"
export MANPATH="\$MANPATH:/opt/gridbox/openpbs_2_3_16/man"
EOF
  chmod 755 /etc/profile.d/openpbs-2.3.16.sh
  . /etc/profile.d/openpbs-2.3.16.sh

  # housekeeping
  rm -rf apps.$$
fi

