// CmbBase.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "FoundDoc.h"		// For g_pDoc.
#include "DynamicDrawView.h"	// For g_pView.
#include "UtilStr.h"		// For GetResString.
#include "UtilDlg.h"		// For RightByLeftHand.
#include "UtilGraph.h"		// For FCAutoDC.
#include "ToolBase.h"		// For GetCurrentTool().
#include "CmbBase.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define FDCB_ITEM_HEIGHT_MIN  20

/////////////////////////////////////////////////////////////////////////////
// CFCCmbBase

IMPLEMENT_DYNCREATE(CFCCmbBase, CFCCmbBoxOnKey)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::CFCCmbBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCmbBase::CFCCmbBase ()
{
	m_bDrawDetail = FALSE;
	m_bIsDetail = TRUE;
} // CFCCmbBase::CFCCmbBase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::CFCCmbBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsDetail	:_xZkqqHx_iPnKiNnHiDiBiDgKiDiFiBfLiCpAjFfMiOkGiClHiCoJiCkJiCmHiCkEiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCmbBase::CFCCmbBase (BOOL bIsDetail) : m_bIsDetail(bIsDetail)
{
	m_bDrawDetail = FALSE;
} // CFCCmbBase::CFCCmbBase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::~CFCCmbBase
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCmbBase::~CFCCmbBase ()
{
} // CFCCmbBase::~CFCCmbBase.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::MeasureItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNiCiClDiCkKiMmFjCoIiCkJiJmCjFmPiCkJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::MeasureItem (LPMEASUREITEMSTRUCT lpMIS)
{
	// _xZkqqHx_iClHiCnHiCmEiCmMiDeBiDeDiDgFiDiAiCmNiMmFjCoIiDfEiDeDiDfJiCmFiClHiBeC_xHqqkZx_
	lpMIS->itemHeight = FDCB_ITEM_HEIGHT_MIN;
} // CFCCmbBase::MeasureItem.


BEGIN_MESSAGE_MAP(CFCCmbBase, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCCmbBase)
	ON_CONTROL_REFLECT(CBN_CLOSEUP, OnCloseup)
	ON_CONTROL_REFLECT(CBN_DROPDOWN, OnDropdown)
	ON_WM_KEYDOWN()
	ON_CONTROL_REFLECT(CBN_SETFOCUS, OnSetfocus)
	ON_CONTROL_REFLECT(CBN_EDITCHANGE, OnEditchange)
	ON_CONTROL_REFLECT(CBN_SELCHANGE, OnSelchange)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iLkEjCmKiDiGiBfLiDfFiDeJiDhJiDiMiBfLiDfGiDiHiDjD_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::SetIsDetail
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiLiDfPiDeFiDjDiOjOiCmJiBhFiPnKiNnHiBhGiCmMjFfMiOkGiCpAiJmCjEfMiCmJiClHiCoJiCkJiCmHiCkEiCkJiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	bIsDetail	:_xZkqqHx_iBhFiPnKiNnHiBhGiCpAjFfMiOkGiClDiClJiCoJiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.06.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::SetIsDetail (BOOL bIsDetail)
{
	m_bIsDetail = bIsDetail;
} // CFCCmbBase::SetIsDetail.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::UpdateItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iMlLiNnNjBeJjBpAjCiGiCmMiDgGiBfLiDfOiCpAjFnLjBlGiClFiCmEiBeBiMpDjFoCiDiKiDfIiDgHiCpAiNfIjAfGiClHiCoJiBeCiClLiCmMiMoD_xHqqkZx_
 *			_xZkqqHx_iDgGiBfLiDfOiCpAjGnPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	SetFocus_xZkqqHx_jDjJiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeCjBlMiCmMiDeFiDeCiDjDiDgIiDeFjDjJiCmFiMpDjFoCiDiKiDfIiDgHiCkK_xHqqkZx_
 *			_xZkqqHx_iNfIjAfGiClDiCoKiClNiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.17 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::UpdateItem ()
{
	if (!IsWindow(m_hWnd)) return;
	INT	nSel = GetCurSel();
	ResetContent();
	SetItems();
	SetCurSel(nSel);
} // CFCCmbBase::UpdateItem.

/////////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiGiBfLiDfFiDeJiBfLiDgPiBfLiDiJiDeDiDgI_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::SetItems
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDhLiDhLiDgCiDeOiDfIiCmMiDiKiDfIiDgHiCmJjBfDiCmEiCmMiDeBiDeDiDgFiDiAiCpAjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgFiDjDiDgDiCpAiPmBiLiOiClFiClNiMoDiBeBiClBiCmMiKnGjAjEiCkKiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::SetItems ()
{
} // CFCCmbBase::SetItems.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::DrawItemSub
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCpAjFgAiJoGiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwID		:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMjCgMiBgJ_xHqqkZx_SColorID_xZkqqHx_jDjJiBgKiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wItem		:_xZkqqHx_iDeBiDeDiDgFiDiAiCmM_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			col			:_xZkqqHx_jEhHiMgJjAeGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			rBox		:_xZkqqHx_jFgAiJoGjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
 *			bIsDropped	:_xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiDiKiDfIiDgHjCiGiCmMjFgAiJoGiCkJiOhHjCoIiBeC_xHqqkZx_
 *			pDC			:_xZkqqHx_jFgAiJoGiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.07.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::DrawItemSub (DWORD dwID, UINT wItem, COLORREF col, CRect& rBox, BOOL bIsDropped, CDC* pDC)
{
} // CFCCmbBase::DrawItemSub.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::KeyToIndex
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDeMiBfLiCkKjDpMjHmNiClDiCoKiClNiCmGiCkLiCmJiBeBjBmOiJjOiClHiCoJiDeDiDjDiDgGiDgCiDeOiDfIiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcKey	:_xZkqqHx_iDeMiBfLiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiBeCjBmOiJjOiCkKjGlDiCkCiPoKiNiHiCmN_xHqqkZx_ CB_ERR_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
long CFCCmbBase::KeyToIndex (_TCHAR tcKey) const
{
	if (tcKey == ::RightByLeftHand(FD_CBKY_NOCHANGE))
	{
		return 0;
	} else
	if (tcKey == ::RightByLeftHand(FD_CBKY_NOUSE))
	{
		return 1;
	} else
	{
		return CB_ERR;
	}
} // CFCCmbBase::KeyToIndex.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::SelectOthers
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::SelectOthers ()
{
} // CFCCmbBase::SelectOthers.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::SelChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::SelChanged ()
{
} // CFCCmbBase::SelChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::EditChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::EditChanged ()
{
} // CFCCmbBase::EditChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::SetItemHeight
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNiCiClDiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	cyItemHeight	:_xZkqqHx_iDeBiDeDiDgFiDiAiCmMiNiCiClDiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCnMiClNiCmNiNiCiClDiCkKjAlDiClFiCkNiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ CB_ERR _xZkqqHx_iCpAiBeB_xHqqkZx_
 *			_xZkqqHx_iClLiCoKiImIiKePiCmMiPoKiNiHiCmN_xHqqkZx_ 0 _xZkqqHx_iCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
int CFCCmbBase::SetItemHeight (UINT cyItemHeight)
{
	// _xZkqqHx_iKgFiDeBiDeDiDgFiDiAiCmMiNmFjCoBiNiCiCmN_xHqqkZx_FDCB_ITEM_HEIGHT_MIN_xZkqqHx_iBeC_xHqqkZx_
	if (cyItemHeight < FDCB_ITEM_HEIGHT_MIN)
		BASE_CLASS::SetItemHeight(0, FDCB_ITEM_HEIGHT_MIN);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	// _xZkqqHx_iMmFjCoIiDfEiDeDiDfJiCmIiCmMiCmFiDeBiDeDiDgFiDiAiCmM_xHqqkZx_idx_xZkqqHx_iCmN_xHqqkZx_-1_xZkqqHx_iCkJ_xHqqkZx_0_xZkqqHx_iClFiCkJiOhHjCoIiCmFiCkLiCmIiCkCiBeC_xHqqkZx_
	return BASE_CLASS::SetItemHeight(-1, cyItemHeight);
} // CFCCmbBase::SetItemHeight.

int CFCCmbBase::GetCount () const
{
	return BASE_CLASS::GetCount();
} // CFCCmbBase::GetCount.

void CFCCmbBase::SetCurSel (int iIndex)
{
	BASE_CLASS::SetCurSel(iIndex);
} // CFCCmbBase::SetCurSel.

int CFCCmbBase::GetCurSel () const
{
	return BASE_CLASS::GetCurSel();
} // CFCCmbBase::GetCurSel.

DWORD CFCCmbBase::GetItemData (int nIndex) const
{
	return BASE_CLASS::GetItemData(nIndex);
} // CFCCmbBase::GetItemData.

int CFCCmbBase::SetItemData (int nIndex, DWORD dwItemData)
{
	return BASE_CLASS::SetItemData(nIndex, dwItemData);
} // CFCCmbBase::SetItemData.

int CFCCmbBase::AddString (LPCTSTR lpszString)
{
	return BASE_CLASS::AddString(lpszString);
} // CFCCmbBase::AddString.

int CFCCmbBase::InsertString (int nIndex, LPCTSTR lpszString)
{
	return BASE_CLASS::InsertString(nIndex, lpszString);
} // CFCCmbBase::InsertString.

int CFCCmbBase::DeleteString (UINT nIndex)
{
	return BASE_CLASS::DeleteString(nIndex);
} // CFCCmbBase::DeleteString.

void CFCCmbBase::ResetContent ()
{
	BASE_CLASS::ResetContent();
} // CFCCmbBase::ResetContent.


/////////////////////////////////////////////////////////////////////////////
// CFCCmbBase _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::DrawItem
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::DrawItem (LPDRAWITEMSTRUCT lpDIS)
{
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, FALSE, 0, 0);
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	// _xZkqqHx_iDgIiDiNiDgCiDhGiDfPiDeFiDjDiDiKiDfIiDgHiCmMjFgAiJoGiCkJiBeI_xHqqkZx_
	const BOOL bIsDropped = (lpDIS->itemState & ODS_COMBOBOXEDIT) ? FALSE : TRUE;
//----- 05.07.01 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	CRect rtBox(lpDIS->rcItem.left,
				lpDIS->rcItem.top,
				lpDIS->rcItem.right,
				lpDIS->rcItem.bottom);
	// "_xZkqqHx_iPnKiNnH_xHqqkZx_(D)..."_xZkqqHx_iCmMjFlGiOjKjHpBiCpAiNoMjAkMiBeC_xHqqkZx_
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	WString strDetail;
//	strDetail.Format(L"%s (%c)...", GetResWString(IDS_DETAIL_ETC),
//					::RightByLeftHand(FD_CBKY_DETAIL));
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	WString strDetail = FFMakeCommandText(GetResWString(IDS_DETAIL_ETC), ::RightByLeftHand(FD_CBKY_DETAIL));
	strDetail.Replace(L"&&", L"#AnD#");
	strDetail.Replace(L"&", L"");
	strDetail.Replace(L"#AnD#", L"&&");
	strDetail += L"...";
//----- 06.03.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

	DWORD	dwID   = lpDIS->itemData;
	UINT	wItem = lpDIS->itemID;
	atDC.SetBkMode(TRANSPARENT);
	if (lpDIS->itemAction & ODA_DRAWENTIRE)
	{
		if (wItem != static_cast<UINT>(CB_ERR))
		{
			// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
			FCAutoDC atDCSub(pDC, FALSE, 0, 0);
			atDCSub.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
			if (m_bDrawDetail && (wItem == 0))
			{
				atDCSub.DrawText(strDetail, CP_ACP, rtBox, DT_CENTER);
			} else
			{
				DrawItemSub(dwID, wItem, ::GetSysColor(COLOR_WINDOWTEXT),
							rtBox, bIsDropped, pDC);
			}
		}
	}

	if ((lpDIS->itemState & ODS_SELECTED) &&
		(lpDIS->itemAction & (ODA_SELECT | ODA_DRAWENTIRE)))
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		atDCSub.FillRect(rtBox, FCAtBrush(::GetSysColor(COLOR_HIGHLIGHT)));
		// _xZkqqHx_iDgFiDeMiDfIiDgHjElNjDfNjAeGiBeC_xHqqkZx_
		if (wItem != UINT(CB_ERR))
		{
			atDCSub.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
			if (m_bDrawDetail && (wItem == 0))
			{
				atDCSub.DrawText(strDetail, CP_ACP, rtBox, DT_CENTER);
			} else
			{
				DrawItemSub(dwID, wItem, ::GetSysColor(COLOR_HIGHLIGHTTEXT),
							rtBox, bIsDropped, pDC);
			}
		}
		atDCSub.DrawFocusRect(&rtBox);
	}

	if (!(lpDIS->itemState & ODS_SELECTED) &&
		(lpDIS->itemAction & ODA_SELECT))
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		//----- _xZkqqHx_jHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClH_xHqqkZx_ -----
		atDCSub.FillRect(rtBox, FCAtBrush(pDC->GetBkColor()));	// _xZkqqHx_jEhHiMgJjAeGiOoGjDlOiBeC_xHqqkZx_
		if (wItem != UINT(CB_ERR))
		{
			atDCSub.SetTextColor(::GetSysColor(COLOR_WINDOWTEXT));
			if (m_bDrawDetail && (wItem == 0))
			{
				atDCSub.DrawText(strDetail, CP_ACP, rtBox, DT_CENTER);
			} else
			{
				DrawItemSub(dwID, wItem, ::GetSysColor(COLOR_WINDOWTEXT),
							rtBox, bIsDropped, pDC);
			}
		}
	}

	if ((lpDIS->itemAction & ODA_DRAWENTIRE) &&
		(lpDIS->itemState & ODS_DISABLED))
	{
		// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeC_xHqqkZx_
		FCAutoDC atDCSub(pDC, FALSE, 0, 0);
		//----- _xZkqqHx_jHmMiIoGiCpAjEhHiMgJjAeGiCmFjDgIiCoIiCmCiCnEiClH_xHqqkZx_ -----
		atDCSub.FillRect(rtBox, FCAtBrush(pDC->GetBkColor()));	// _xZkqqHx_jEhHiMgJjAeGiOoGjDlOiBeC_xHqqkZx_
		if (wItem != UINT(CB_ERR))
		{
			atDCSub.SetTextColor(::GetSysColor(COLOR_GRAYTEXT));
			if (m_bDrawDetail && (wItem == 0))
			{
				atDCSub.DrawText(strDetail, CP_ACP, rtBox, DT_CENTER);
			} else
			{
				DrawItemSub(dwID, wItem, ::GetSysColor(COLOR_GRAYTEXT),
							rtBox, bIsDropped, pDC);
			}
		}
	}
} // CFCCmbBase::DrawItem.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::OnDropdown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::OnDropdown ()
{
	// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKiPjBiCkLiNjOiCnNiJmCiCmFiDeJiBfLiDhGiDjDiOjOiBeCiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDgCiDgHiOjOiCmNiCgOiCgKiBeC_xHqqkZx_
	if (m_bIsDetail && FFCanEditDocument())
	{
		m_bDrawDetail = TRUE;		// "_xZkqqHx_iPnKiNnH_xHqqkZx_"_xZkqqHx_iCpAjFfMiOkGiClHiCoJiCkJiBeI_xHqqkZx_
		InsertString(0, _T(""));	// "_xZkqqHx_iPnKiNnH_xHqqkZx_"_xZkqqHx_iCmMjIgHiCpAjBhNjDpMiBeC_xHqqkZx_
	} else
	{
		m_bDrawDetail = FALSE;
	}
} // CFCCmbBase::OnDropdown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::OnCloseup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::OnCloseup ()
{
	if (m_bDrawDetail)
	{
		m_bDrawDetail = FALSE;		// "_xZkqqHx_iPnKiNnH_xHqqkZx_"_xZkqqHx_iCpAjFfMiOkGiClHiCoJiCkJiBeI_xHqqkZx_
		DeleteString(0);			// "_xZkqqHx_iPnKiNnH_xHqqkZx_"_xZkqqHx_iCmMjIgHiCpAjGjFiPmBiBeC_xHqqkZx_
	}
	CWnd* pWnd = GetParent();
	if (pWnd == NULL) return;
	pWnd->SendMessage(WM_COMMAND, MAKELONG(GetDlgCtrlID(), CBBN_CLOSEUP),
						(LPARAM)m_hWnd);

} // CFCCmbBase::OnCloseup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::OnSelchange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::OnSelchange ()
{
//----- 02.06.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ (_xZkqqHx_jAeGiDhGiDiLiDfPiDeFiDjDiDiBiDgKiDiFiBfLiCpAiKeKiCkCiClNiCnMiCnMiBeB_xHqqkZx_PageUp_xZkqqHx_iClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
//	// "_xZkqqHx_iPnKiNnH_xHqqkZx_"_xZkqqHx_iCpAjBeJjBpAiClFiClNiPoKiNiHiBeC_xHqqkZx_
//	// OnCloseup_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_DeleteString_xZkqqHx_iClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_GetCurSel _xZkqqHx_iCmN_xHqqkZx_ CB_ERR _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
//	if (GetCurSel() == CB_ERR)
//----- 02.06.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ (_xZkqqHx_jAeGiDhGiDiLiDfPiDeFiDjDiDiBiDgKiDiFiBfLiCpAiKeKiCkCiClNiCnMiCnMiBeB_xHqqkZx_PageUp_xZkqqHx_iClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
	// _xZkqqHx_jAeGiDhGiDiLiDfPiDeFiDjDiDiBiDgKiDiFiBfLiCpAiKeKiCkCiClNiCnMiCnM_xHqqkZx_PageUp_xZkqqHx_iClFiClNiPoKiNiHiBeBiBhFiPnKiNnHiBhGiCkK_xHqqkZx_
	// _xZkqqHx_jFfMiOkGiClDiCoKiClNiCnMiCnMiBeBiBhFiPnKiNnHiBhGiCkKjBeJjBpAiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiPoKiNiHiBeBiIoKiCmCiJlKiBhFjFmPiNfIiClFiCmIiCkCiBhGiCpAjBeJjBpAiCpAiClDiClJiCoJiBeC_xHqqkZx_
	if (m_bDrawDetail && GetCurSel() == 0) SetCurSel(1);

	// "_xZkqqHx_iPnKiNnH_xHqqkZx_"_xZkqqHx_iCpAiDhNiDeFiDfIiCmFjBeJjBpAiClFiClNiPoKiNiHiBeB_xHqqkZx_OnCloseup_xZkqqHx_iKnGjAjEiCmF_xHqqkZx_DeleteString_xZkqqHx_iClDiCoKiCoJiClNiCnPiBeB_xHqqkZx_
	// GetCurSel _xZkqqHx_iCmN_xHqqkZx_ CB_ERR _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (!m_bDrawDetail && GetCurSel() == CB_ERR)
//----- 02.06.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ (_xZkqqHx_jAeGiDhGiDiLiDfPiDeFiDjDiDiBiDgKiDiFiBfLiCpAiKeKiCkCiClNiCnMiCnMiBeB_xHqqkZx_PageUp_xZkqqHx_iClHiCoJiCmGjHiOiClPiCoJ_xHqqkZx_)-----
	{
		// _xZkqqHx_iDgIiDeMiDiFiDiBiDjDiDgHiCkKiPjBiCkLiNjOiCnNiJmCiCmFiDeJiBfLiDhGiDjDiOjOiBeCiDgFiDeMiDfIiDgHiDeHiDgGiDeCiDgCiDgHiOjOiCmNiCgOiCgKiBeC_xHqqkZx_
		// _xZkqqHx_jBeJjBpAiDfPiDeDiDeBiDiNiDePiCpAiLeOjDkOiClHiCoJiBeC_xHqqkZx_
		if (FFCanEditDocument()) SelectOthers();
		// SelectOthers_xZkqqHx_iKnGjAjEjCiGiCmF_xHqqkZx_CBBN_SELCHANGE_xZkqqHx_iCpAjEkNiNhDiClFiCmIiCkPiCoKiCmOiCmIiCoHiCmIiCkCiBeC_xHqqkZx_
	} else
	{
		SelChanged();
		CWnd*	pWnd = GetParent();
		if (pWnd == NULL) return;
		pWnd->SendMessage(WM_COMMAND, MAKELONG(GetDlgCtrlID(), CBBN_SELCHANGE),
							(LPARAM)m_hWnd);
	}
} // CFCCmbBase::OnSelchange.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::OnKeyDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::OnKeyDown (UINT nChar, UINT nRepCnt, UINT nFlags)
{
	if (!FFCanEditDocument())
	{
		BASE_CLASS::OnKeyDown(nChar, nRepCnt, nFlags);
		return;
	}
	if (m_bIsDetail && nChar == ::RightByLeftHand(FD_CBKY_DETAIL))
	{
		SelectOthers();
	} else
	{
		long lIndex = KeyToIndex(nChar);
		if (lIndex != CB_ERR)
		{
			ShowDropDown(FALSE);
			SetCurSel(lIndex);
			OnSelchange();
		} else
		{
			BASE_CLASS::OnKeyDown(nChar, nRepCnt, nFlags);
		}
	}
} // CFCCmbBase::OnKeyDown.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::OnSetfocus
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCkKjDjGiClNiCmBiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::OnSetfocus ()
{
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnSetfocus();
	// _xZkqqHx_jBlMiCmF_xHqqkZx_Item_xZkqqHx_iCmJjCmHiJmBiCkKiCkAiCmBiClNiPoKiNiHiCmJjBmOiJjOiBeC_xHqqkZx_
	UpdateItem();
} // CFCCmbBase::OnSetfocus.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCmbBase::OnEditchange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	03.06.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCmbBase::OnEditchange ()
{
	EditChanged();

	CWnd*	pWnd = GetParent();
	if (pWnd == NULL) return;
	pWnd->SendMessage(WM_COMMAND, MAKELONG(GetDlgCtrlID(), CBBN_EDITCHANGE),
						(LPARAM)m_hWnd);
} // CFCCmbBase::OnEditchange.

