#include "stdafx.h"
#include "DynamicDraw.h"		// For IDR_XXX.
#include "UtilGraph.h"		// For FCAutoDC.
#include "UtilDlg.h"		// For FFGetUserAccelerator.
#include "UtilStr.h"		// For FFExtractUntil.
#include "RegData.h"		// For InitRegFont.
#include "FrameWnd.h"		// For FFGetMainWnd().
#include "PursuerText.h"	// For CFCPursuerText.
#include "CtlBrFunction.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNAMIC(CFCCtlBrFunction, CControlBar)

BEGIN_MESSAGE_MAP(CFCCtlBrFunction, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCCtlBrFunction)
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_PURSUER_TEXT_NEED_INFO, OnUserPursuerTextNeedInfo)
END_MESSAGE_MAP()

// _xZkqqHx_jFfMiOkGiClDiCoKiCoJiDgFiDeMiDfIiDgHiCmMiNhDjAjEiBeC_xHqqkZx_
#define FDBF_TEXT_LINE	3

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::CFCCtlBrFunction
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCtlBrFunction::CFCCtlBrFunction ()
{
	m_iControl = -1;	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiJjPiClFiBeI_xHqqkZx_
	m_iShift = -1;		// _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiJjPiClFiBeI_xHqqkZx_
	m_iAlt = -1;		// _xZkqqHx_iDeJiDiLiDgHiDeMiBfLiJjPiClFiBeI_xHqqkZx_
} // CFCCtlBrFunction::CFCCtlBrFunction.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::~CFCCtlBrFunction
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCCtlBrFunction::~CFCCtlBrFunction ()
{
} // CFCCtlBrFunction::~CFCCtlBrFunction.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::Create
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCmJiMiLiCnBjFhEiCkPiCoHiCoKiClNiOhBiDeFiDeCiDjDiDgIiDeFiCpAiNoMjAkMiClFiBeB_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pParentWnd	:_xZkqqHx_jAgFiDeFiDeCiDjDiDgIiDeFiCpAiOhHjCoI_xHqqkZx_.
 *			dwStyle		:Window_xZkqqHx_iCmMiDfIiDfOiDeDiDiLiCpAiOhHjCoI_xHqqkZx_.
 *			nID			:_xZkqqHx_iOhBiDeFiDeCiDjDiDgIiDeFiCmM_xHqqkZx_ ID _xZkqqHx_iCpAiOhHjCoI_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	:_xZkqqHx_jAlDiPoNiPeJjHlJ_xHqqkZx_
 *			FALSE	:_xZkqqHx_iInJiPoNiPeJjHlJ_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCCtlBrFunction::Create (CWnd* pParentWnd, DWORD dwStyle, UINT nID)
{
	ASSERT_VALID(pParentWnd);   // must have a parent

	dwStyle |= WS_CLIPSIBLINGS;
	// force WS_CLIPSIBLINGS (avoids SetWindowPos bugs)
	// create the HWND
	CRect rect;
	rect.SetRectEmpty();
	LPCTSTR lpszClass = AfxRegisterWndClass(0,
							::FFGetApp()->LoadStandardCursor(IDC_ARROW),
							(HBRUSH)(COLOR_BTNFACE+1), NULL);
	if (!CWnd::Create(lpszClass, NULL, dwStyle, rect, pParentWnd, nID))
		return FALSE;
	return TRUE;
} // CFCCtlBrFunction::Create.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::UpdateCommandInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeBiDeOiDfKiDiJiDiMiBfLiDfOiPoOjFpBiCkJiCoHiBeBiDhEiDeAiDjDiDeOiDfGiDiHiDjDiCfAiBgAiCfAiCfBiCmJiKiEiCoIjDjGiCmEiCoHiCoKiCmE_xHqqkZx_
 *			_xZkqqHx_iCkCiCoJiDeMiBfLiCmMiPoOjFpBiCpAiOoGjDlOiClFiCmEiLeMjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jCgMiCmJjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiHiCmN_xHqqkZx_TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCCtlBrFunction::UpdateCommandInfo ()
{
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiJjPiClFiBeI_xHqqkZx_
	const int iControl = (GetKeyState(VK_CONTROL) < 0);
	// _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiJjPiClFiBeI_xHqqkZx_
	const int iShift = (GetKeyState(VK_SHIFT) < 0);
	// _xZkqqHx_iDeJiDiLiDgHiDeMiBfLiJjPiClFiBeI_xHqqkZx_
	const int iAlt = (GetKeyState(VK_MENU) < 0);

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiBeFiDfGiDhEiDgHiBeFiDeJiDiLiDgHiDeMiBfLiCmJjFmPiNfIiCkKjGlDiCkCiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (m_iControl == iControl &&
		m_iShift == iShift &&
		m_iAlt == iAlt)
		return FALSE;

	// _xZkqqHx_jCgMiCpAiLeMjIfOiBeC_xHqqkZx_
	m_iControl = iControl;
	m_iShift = iShift;
	m_iAlt = iAlt;

	// _xZkqqHx_iDfCiDhNiDjDiDgIjEhKjHpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	memset(m_aCommandId, 0, sizeof(m_aCommandId));
	long lC;
	//----- _xZkqqHx_iDiGiBfLiDfFiDeBiDeOiDfKiDiJiDiMiBfLiDfOiCpAiOoGjDlO_xHqqkZx_ -----
	ACCEL accelUsr[200];
	HACCEL hAccelUsr = FFGetMainWnd()->GetUserAccelerator();
	int iAccelUsrSz = ::CopyAcceleratorTable(hAccelUsr, accelUsr, 200);
	for (lC = 0; lC != iAccelUsrSz; lC++)
	{
		if (VK_F1 <= accelUsr[lC].key && accelUsr[lC].key <= VK_F12)
		//----- _xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiDeMiBfL_xHqqkZx_F1_xZkqqHx_iBgA_xHqqkZx_F12_xZkqqHx_iCmMiKnEiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (m_iControl && !(accelUsr[lC].fVirt & FCONTROL)) continue;
			if (!m_iControl && (accelUsr[lC].fVirt & FCONTROL)) continue;
			if (m_iShift && !(accelUsr[lC].fVirt & FSHIFT)) continue;
			if (!m_iShift && (accelUsr[lC].fVirt & FSHIFT)) continue;
			if (m_iAlt && !(accelUsr[lC].fVirt & FALT)) continue;
			if (!m_iAlt && (accelUsr[lC].fVirt & FALT)) continue;
			m_aCommandId[accelUsr[lC].key - VK_F1] = accelUsr[lC].cmd;
		}
	}

	//----- _xZkqqHx_iDgGiDhEiDeIiDiLiDgHiDeBiDeOiDfKiDiJiDiMiBfLiDfOiCpAiOoGjDlO_xHqqkZx_ -----
	ACCEL accelDef[200];
	HACCEL hAccelDef = FFGetMainWnd()->GetWnd()->GetDefaultAccelerator();
	int iAccelDefSz = ::CopyAcceleratorTable(hAccelDef, accelDef, 200);
	for (lC = 0; lC != iAccelDefSz; lC++)
	{
		if (VK_F1 <= accelDef[lC].key && accelDef[lC].key <= VK_F12)
		//----- _xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiDeMiBfL_xHqqkZx_F1_xZkqqHx_iBgA_xHqqkZx_F12_xZkqqHx_iCmMiKnEiCmMiPoKiNiH_xHqqkZx_ -----
		{
			if (m_iControl && !(accelDef[lC].fVirt & FCONTROL)) continue;
			if (!m_iControl && (accelDef[lC].fVirt & FCONTROL)) continue;
			if (m_iShift && !(accelDef[lC].fVirt & FSHIFT)) continue;
			if (!m_iShift && (accelDef[lC].fVirt & FSHIFT)) continue;
			if (m_iAlt && !(accelDef[lC].fVirt & FALT)) continue;
			if (!m_iAlt && (accelDef[lC].fVirt & FALT)) continue;
			m_aCommandId[accelDef[lC].key - VK_F1] = accelDef[lC].cmd;
		}
	}
	return TRUE;
} // CFCCtlBrFunction::UpdateCommandInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::GetCommandRect
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiCePiBgAiCfAiCfBiCmMiImKjChFiCmMiLoJiMgAiCpAiOfKiPgPiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pRectArray	:_xZkqqHx_iCfAiCfBiMmCiCmMiLoJiMgAiNmAjFfHjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iLoJiMgAjHmMiIoGiCmNiBeBjHnHiCoIiCmMiLoJiMgAiCmGjAnKiClHiCoJiCoGiCkEiBeBjGnKiCkCiCmBiCmPiCkCjBoFiCkLiCkCiLoJiMgAiCpAiMhGiOfKiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrFunction::GetCommandRect (CRect* pRectArray) const
{
	CRect rtClient;
	GetClientRect(rtClient);
	CRect rtFrame;
	FFGetMainWnd()->GetWnd()->GetClientRect(rtFrame);
	double dWidth = double(rtFrame.Width()) / double(FUNCTION_COUNT);
	for (long lC = 0; lC != FUNCTION_COUNT; lC++)
	{
		pRectArray[lC].SetRect(	int(dWidth * lC),
								2,
								int(dWidth * (lC + 1)),
								rtClient.Height());
	}
} // CFCCtlBrFunction::GetCommandRect.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::DoPaint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmEjFgAiJoGiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pDC	:_xZkqqHx_jFgAiJoGjHhAiDgGiDgPiDeDiDfIiDfCiDjDiDgFiDeMiDfIiDgHiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrFunction::DoPaint (CDC* pDC)
{
	// _xZkqqHx_iDeBiDeOiDfKiDiJiDiMiBfLiDfOiCkJiCoHiDfCiDhNiDjDiDgIjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	UpdateCommandInfo();

	// CDC_xZkqqHx_iCpA_xHqqkZx_Auto_xZkqqHx_iCmFiDiJiDgCiDhGiBeCiDeOiDiKiDgCiDhGjFmPiNfIiCmJjBmOiJjOiClFiCmEiBeB_xHqqkZx_SaveDC_xZkqqHx_iCpAiOmAiNhDiBeC_xHqqkZx_
	FCAutoDC atDC(pDC, TRUE, 0, 0);
//----- 05.11.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	CRect rtClient;
//	GetClientRect(rtClient);
//	CRect rtFrame;
//	FFGetMainWnd()->GetWnd()->GetClientRect(rtFrame);
//----- 05.11.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	//----- _xZkqqHx_jAjEjCgMjFfMiOkGjHhAiDhEiDeIiDjDiDgHiCmMjAnNjCoI_xHqqkZx_ -----
	LOGFONT logFont;
	g_pReg->GetRegFontStatic(FDFT_FUNCTION_BAR)->GetLogFont(&logFont);
	int iHeight = labs(logFont.lfHeight);
	atDC.SetFont(&logFont);
	atDC.SetTextColor(::g_pReg->GetOptiRegColor(FDCL_RULER_TEXT));
	atDC.SetBkMode(TRANSPARENT);

//----- 05.11.24 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	ACCEL accelUsr[100];
//	HACCEL hAccelUsr = FFGetMainWnd()->GetUserAccelerator();
//	int iAccelUsrSz = ::CopyAcceleratorTable(hAccelUsr, accelUsr, 100);
//
//	ACCEL accelDef[100];
//	HACCEL hAccelDef = FFGetMainWnd()->GetWnd()->GetDefaultAccelerator();
//	int iAccelDefSz = ::CopyAcceleratorTable(hAccelDef, accelDef, 100);
//
//	DWORDVector vCmdId(FUNCTION_COUNT, 0);
//	long lC;
//	for (lC = 0; lC < iAccelUsrSz; lC++)
//	{
//		if (VK_F1 <= accelUsr[lC].key && accelUsr[lC].key <= VK_F12)
//		{
//			if (m_iControl && !(accelUsr[lC].fVirt & FCONTROL)) continue;
//			if (!m_iControl && (accelUsr[lC].fVirt & FCONTROL)) continue;
//			if (m_iShift && !(accelUsr[lC].fVirt & FSHIFT)) continue;
//			if (!m_iShift && (accelUsr[lC].fVirt & FSHIFT)) continue;
//			if (m_iAlt && !(accelUsr[lC].fVirt & FALT)) continue;
//			if (!m_iAlt && (accelUsr[lC].fVirt & FALT)) continue;
//			vCmdId[accelUsr[lC].key - VK_F1] = accelUsr[lC].cmd;
//		}
//	}
//	for (lC = 0; lC < iAccelDefSz; lC++)
//	{
//		if (VK_F1 <= accelDef[lC].key && accelDef[lC].key <= VK_F12)
//		{
//			if (m_iControl && !(accelDef[lC].fVirt & FCONTROL)) continue;
//			if (!m_iControl && (accelDef[lC].fVirt & FCONTROL)) continue;
//			if (m_iShift && !(accelDef[lC].fVirt & FSHIFT)) continue;
//			if (!m_iShift && (accelDef[lC].fVirt & FSHIFT)) continue;
//			if (m_iAlt && !(accelDef[lC].fVirt & FALT)) continue;
//			if (!m_iAlt && (accelDef[lC].fVirt & FALT)) continue;
//			vCmdId[accelDef[lC].key - VK_F1] = accelDef[lC].cmd;
//		}
//	}
//----- 05.11.24 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	CRect rtFunction[FUNCTION_COUNT];
	// _xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiCmMiLoJiMgAjHmMiIoGiCpAiMhGiOfKiBeC_xHqqkZx_
	GetCommandRect(rtFunction);

//	double dWidth = double(rtFrame.Width()) / double(FUNCTION_COUNT);
	WString strCmd;
	WString strMsg;
	WString strLeft;
	for (long lC = 0; lC != FUNCTION_COUNT; lC++)
	{
// 05.11.24 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		CRect rtText(int(dWidth * lC), 2, int(dWidth * (lC + 1)), rtClient.Height());
		CRect rtText = rtFunction[lC];
		atDC.DrawEdge(&rtText, EDGE_SUNKEN, BF_RECT);
		rtText.DeflateRect(4, 3);
		if (m_aCommandId[lC] != 0)
		{
			strCmd.LoadString(m_aCommandId[lC]);
			FFExtractUntil(strCmd, L"\n");
			strMsg.Format(L"F%d:%s", lC + 1, strCmd.c_str());
			for (int iLine = 0; iLine < 4 && !strMsg.IsEmpty(); iLine++)
			{
				long pxTextWidth;
				int iCount = FFCalcCharCount(pxTextWidth, pDC, strMsg, rtText.Width(), CP_ACP, FALSE, FALSE);
				if (iCount == 0) break;
				atDC.DrawText(strMsg.Left(iCount), CP_ACP, &rtText, DT_LEFT);
				strMsg = strMsg.Right(strMsg.length() - iCount);
				rtText.top += iHeight;
			}
		}
	}
} // CFCCtlBrFunction::DoPaint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::CalcFixedLayout
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDeBiDeFiDgHiMiIjCoIiOjOiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CSize CFCCtlBrFunction::CalcFixedLayout (BOOL bStretch, BOOL bHorz)
{
	ASSERT(bHorz);
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	CSize szThis = BASE_CLASS::CalcFixedLayout(bStretch, bHorz);
	LOGFONT logFont;
	g_pReg->GetRegFontStatic(FDFT_FUNCTION_BAR)->GetLogFont(&logFont);
	int iHeight = labs(logFont.lfHeight);
	szThis.cy = (iHeight * FDBF_TEXT_LINE) + 8;
	return szThis;
} // CFCCtlBrFunction::CalcFixedLayout.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::OnUpdateCmdUI
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDhNiDjDiDgIjHeMiMpIjAkLiCmMiPiIjHjNiKnGjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iPiIjHjNiCkKjGlDiCkNiCmEiCoAiLeMiPhBiCkKjFeLjHhGiBeCiPoDiImKjCiKiPnLiDeOiDiJiDfIiCmJiLpDiCmMiKnGjAjEiCmGiClFiCmE_xHqqkZx_
 *			_xZkqqHx_jCoIiLgAiClDiCoKiCmEiCkCiCoJiClNiCnPiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrFunction::OnUpdateCmdUI (CFrameWnd* /*pTarget*/, BOOL /*bDisableIfNoHndler*/)
{
//----- 02.06.11 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ (_xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiDgPiBfLiCmMjFfMiOkGiCkK_xHqqkZx_"ALT"_xZkqqHx_iDeMiBfLiCmNiJjPiClHjGiIiCmMiDgHiDePiDiLjFfMiOkGiBeCiDgHiDePiDiLjDkOiNoMiClFiCmIiCkCiCpBiClOiCkJiCoHiBeBiClBiCoKiCmNjFmP_xHqqkZx_)-----
//	// _xZkqqHx_iDhEiDiMiBfLiDiAiCkKjDpMjHmNiCpAiOjNiCmBiCmEiCkCiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeB_xHqqkZx_DynamicDraw_xZkqqHx_iCkK_xHqqkZx_
//	// _xZkqqHx_jEhHiMgJiCmJiCkAiCoJiCmGiCkLiCmFiCoAiBeBiDeMiBfLiCpAiJjPiClHiClNiCnBjFfMiOkGiCkKiClPiCoHiClPiCoHjFmPiCoNiCoJiBeC_xHqqkZx_
//	if (GetActiveWindow() != AfxGetMainWnd()) return;
//
//	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiDeMiBfLiJjPiClFiBeI_xHqqkZx_
//	BOOL iControl = GetKeyState(VK_CONTROL) < 0;
//	// _xZkqqHx_iDfGiDhEiDgHiDeMiBfLiJjPiClFiBeI_xHqqkZx_
//	BOOL iShift = GetKeyState(VK_SHIFT) < 0;
//	// _xZkqqHx_iDeJiDiLiDgHiDeMiBfLiJjPiClFiBeI_xHqqkZx_
//	BOOL iAlt = GetKeyState(VK_MENU) < 0;
//	if (m_iControl != iControl || m_iShift != iShift || m_iAlt != iAlt)
//	{
//		m_iControl = iControl;
//		m_iShift = iShift;
//		m_iAlt = iAlt;
//		Invalidate();
//	}
////	TRACE(_T("CFCCtlBrFunction::OnUpdateCmdUI %d %d %d\r\n"), m_iControl, m_iShift, m_iAlt);
//----- 02.06.11 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ (_xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiDgPiBfLiCmMjFfMiOkGiCkK_xHqqkZx_"ALT"_xZkqqHx_iDeMiBfLiCmNiJjPiClHjGiIiCmMiDgHiDePiDiLjFfMiOkGiBeCiDgHiDePiDiLjDkOiNoMiClFiCmIiCkCiCpBiClOiCkJiCoHiBeBiClBiCoKiCmNjFmP_xHqqkZx_)-----
//	TRACE(_T("CFCCtlBrFunction::OnUpdateCmdUI\n"));
} // CFCCtlBrFunction::OnUpdateCmdUI.

//----- 02.06.11 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ (_xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiDgPiBfLiCmMjFfMiOkGiCkK_xHqqkZx_"ALT"_xZkqqHx_iDeMiBfLiCmNiJjPiClHjGiIiCmMiDgHiDePiDiLjFfMiOkGiBeCiDgHiDePiDiLjDkOiNoMiClFiCmIiCkCiCpBiClOiCkJiCoHiBeBiClBiCoKiCmNjFmP_xHqqkZx_)-----
/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::OnSysKeyDownUp
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiDfIiDgFiDiAiKnGjIeBiCmMiDeMiBfLiCkKiJjPiClDiCoKiClNiBeFjHkDiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	CFCMainFrame::PreTranslateMessage _xZkqqHx_iCkJiCoHiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.06.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrFunction::OnSysKeyDownUp ()
{
	// _xZkqqHx_iDhEiDiMiBfLiDiAiCkKjDpMjHmNiCpAiOjNiCmBiCmEiCkCiCmIiCkCiPoKiNiHiCmNjFjMiLeBiBeCiClBiCoKiCpAiClFiCmIiCkCiCmGiBeB_xHqqkZx_DynamicDraw_xZkqqHx_iCkK_xHqqkZx_
	// _xZkqqHx_jEhHiMgJiCmJiCkAiCoJiCmGiCkLiCmFiCoAiBeBiDeMiBfLiCpAiJjPiClHiClNiCnBjFfMiOkGiCkKiClPiCoHiClPiCoHjFmPiCoNiCoJiBeC_xHqqkZx_
	if (GetActiveWindow() != AfxGetMainWnd()) return;
	// _xZkqqHx_iDeFiDeCiDjDiDgIiDeFjEpBjFfMiOkGiCmMiPoKiNiHiCmNjFjMiLeBiBeC_xHqqkZx_
	if (!IsWindowVisible()) return;
	// _xZkqqHx_iDeBiDeOiDfKiDiJiDiMiBfLiDfOiCkJiCoHiDfCiDhNiDjDiDgIjEhKjHpBiCpAiOoGjDlOiBeCjFmPiNfIiCkKiCkAiCmBiClNiPoKiNiHiCmMiCnNiNmEjFgAiJoGiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCoKiCpAiDgAiDeGiDgCiDeOiClFiCmIiCkCiCmGiBeBiDeMiBfLiJjPiClFiCmBiCmPiCmIiClFiCmFiJlNjDhIiCoAiNmEjFgAiJoGiClDiCoKiCmEiClFiCnMiCkEiBeC_xHqqkZx_
	if (UpdateCommandInfo())
		Invalidate();
} // CFCCtlBrFunction::OnSysKeyDownUp.
//----- 02.06.11 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ (_xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiDgPiBfLiCmMjFfMiOkGiCkK_xHqqkZx_"ALT"_xZkqqHx_iDeMiBfLiCmNiJjPiClHjGiIiCmMiDgHiDePiDiLjFfMiOkGiBeCiDgHiDePiDiLjDkOiNoMiClFiCmIiCkCiCpBiClOiCkJiCoHiBeBiClBiCoKiCmNjFmP_xHqqkZx_)-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::OnSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfEiDeDiDfJjFmPiNfIiClDiCoKiClNiCmGiCkLiMmEiCmOiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	:_xZkqqHx_iDiKiDfEiDeDiDfJiCmMiOoNjHnOiBeC_xHqqkZx_
 *			cx,cy	:_xZkqqHx_jAfGiClFiCkCiDeFiDeCiDjDiDgIiDeFiDfEiDeDiDfJ_xHqqkZx_.
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iOhBiDeFiDeCiDjDiDgIiDeFiCmMiDgAiDgCiDhGiDhCiDiFiBfLiDeBiBgJ_xHqqkZx_m_mtxpChipView_xZkqqHx_iBgKiCmMiDiKiDfEiDeDiDfJiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_iNhDiCkE_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrFunction::OnSize (UINT nType, int cx, int cy)
{
	BASE_CLASS::OnSize(nType, cx, cy);
} // CFCCtlBrFunction::OnSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::OnDestroy
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeFiDeCiDjDiDgIiDeFiCkKjEgKiJpDiClDiCoKiCoJiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.06 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrFunction::OnDestroy ()
{
	BASE_CLASS::OnDestroy();
} // CFCCtlBrFunction::OnDestroy.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::OnUserPursuerTextNeedInfo
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhMiDgCiDhGiDhBiDjDiDgHiCkKiDhBiDjDiDgHiPoOjFpBiCmMjAnNjCoIiCpAjHhGiLiBiClHiCoJiNnLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiDgOiDjDiDgIiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jFeLiClIiBeB_xHqqkZx_GetCursorPos_xZkqqHx_iKnGjAjEiCmFiDhNiDeFiDfIiImKjChFiCpAiOoGjDlOiClHiCoJiClBiCmGiBeC_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiNmAjFfHiCkK_xHqqkZx_WM_MOUSEMOVE_xZkqqHx_iCmJjHiKiCmBiCmEiCkCiCoJiCmGiBeBiDiBiDgKiDiFiBfLjFfMiOkGiOjOiCmIiCmHiCmJ_xHqqkZx_
 *			_xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiMlLiNnNiCmMiImKjChFiCmGjAeIiCkCiIoBiCmBiCmEiCkCiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_jCmHjAnFiDhBiDjDiDgHiCmNiBeBiDhNiDeFiDfIiImKjChFiCmMiDeFiDeCiDjDiDgIiDeFiCpAjClCiCnHiBeBiCnMiClIiClLiCmMiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			WM_USER_PURSUER_TEXT_NEED_INFO_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpA_xHqqkZx_SendMessage_xZkqqHx_iCmFjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHjGnPiCoIjCgMiCkKiCePiCmMiPoKiNiHiCmNiBeBiClLiCmMiDeFiDeCiDjDiDgIiDeFiCmMjAgFiDeFiDeCiDjDiDgIiDeFiCnG_xHqqkZx_
 *			_xZkqqHx_iDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClHiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_jGnPiCoIjCgMiCkKiCePiImIiKePiCmFiCkAiCoJiCkJjAgFiDeFiDeCiDjDiDgIiDeFiCkKjGlDiCkNiCmIiCoJiCnMiCmFiClBiCoKiCpAiMeKiCoIjFnEiClHiBeC_xHqqkZx_
 *			wParam _xZkqqHx_iCmJiCmNiBeBiNmFiPiJiCmJiDiBiDgCiDfKiBfLiDfHiCpAjBjHjFhEiClFiClNiDeFiDeCiDjDiDgIiDeFiCkKiOhHjCoIiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCCtlBrFunction::OnUserPursuerTextNeedInfo (WPARAM wParam, LPARAM)
{
	if (g_pReg->GetIsPopupHint() && g_pReg->GetIsPopupFunctionBarHint())
	//----- _xZkqqHx_iDhMiDgCiDhGiDeBiDgCiDhGiCpAjFfMiOkGiClHiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDeBiDeOiDfKiDiJiDiMiBfLiDfOiCkJiCoHiDfCiDhNiDjDiDgIjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
		UpdateCommandInfo();
		CRect rtFunction[FUNCTION_COUNT];
		// _xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiCmMiLoJiMgAjHmMiIoGiCpAiMhGiOfKiBeC_xHqqkZx_
		GetCommandRect(rtFunction);
		// _xZkqqHx_iDhNiDeFiDfIiDeKiBfLiDfMiDiLiCmMiMlLiNnNiCmMiImKjChFiCpAiBeBiDfIiDeOiDiKiBfLiDjDiNmAjFfHiCmFiOoGjDlOiBeC_xHqqkZx_
		CPoint dvptMouse;
		(void)::GetCursorPos(&dvptMouse);
		// _xZkqqHx_iDeOiDiJiDeDiDeBiDjDiDgHiNmAjFfHiCmJjFmPiKlHiBeC_xHqqkZx_
		ScreenToClient(&dvptMouse);
		for (long lC = 0; lC != FUNCTION_COUNT; lC++)
		{
			if (rtFunction[lC].PtInRect(dvptMouse))
			//----- _xZkqqHx_iDhNiDeFiDfIiImKjChFiCkKiLoJiMgAiCmJjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
			{
				// _xZkqqHx_iDfCiDhNiDjDiDgIiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiDhHiDiLiDhGjFfMiOkGiBeC_xHqqkZx_
				if (m_aCommandId[lC] != 0)
					FFGetApp()->GetPopHint()->SetTargetInfo(m_aCommandId[lC]);
				break;
			}
		}
	}
	return 1;
} // CFCCtlBrFunction::OnUserPursuerTextNeedInfo.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCCtlBrFunction::OnLButtonDown
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNlGiDhLiDfOiDjDiCkKiJjPiClDiCoKiClNiCmGiCkLiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.11.24 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCCtlBrFunction::OnLButtonDown (UINT nFlags, CPoint point)
{
	// _xZkqqHx_iDeBiDeOiDfKiDiJiDiMiBfLiDfOiCkJiCoHiDfCiDhNiDjDiDgIjEhKjHpBiCpAiOoGjDlOiBeC_xHqqkZx_
	UpdateCommandInfo();
	CRect rtFunction[FUNCTION_COUNT];
	// _xZkqqHx_iDhEiDeAiDjDiDeOiDfGiDiHiDjDiCmMiLoJiMgAjHmMiIoGiCpAiMhGiOfKiBeC_xHqqkZx_
	GetCommandRect(rtFunction);
	for (long lC = 0; lC != FUNCTION_COUNT; lC++)
	{
		if (rtFunction[lC].PtInRect(point))
		//----- _xZkqqHx_iDeOiDiKiDgCiDeOiImKjChFiCkKiLoJiMgAiCmJjDpMiCmBiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfCiDhNiDjDiDgIiCkKjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiHiCmNiOmAiNhDiBeC_xHqqkZx_
			if (m_aCommandId[lC] != 0)
				FFGetMainWnd()->PostMessage(WM_COMMAND, m_aCommandId[lC], LPARAM(0));
// 06.03.09 Fukushiro M. 1_xZkqqHx_iNhDjCmHiJmB_xHqqkZx_ ()
			break;
		}
	}
	// Baseclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnLButtonDown(nFlags, point);
} // CFCCtlBrFunction::OnLButtonDown.

