#ifndef __DBLLine_h
#define __DBLLine_h

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	DBLLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClMjApMiCpAjFfMiMlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.20 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *			98.11.20 Fukushiro M. Arrow_xZkqqHx_jFjEjFgJiCmFiBeBjAiFjFlNjGoOiIpDiCkKiDgNiBfLiDgIiInKjDkOiCmF_xHqqkZx_
 *				_xZkqqHx_jBoGjDpBjIeBiMiLjDfPiCkKiOkJjDkOjDeJiCmJiInKjDkOiClDiCoKiCmIiCkCiPoBiKfBiCkKjEkNjAlGiClFiClNiBeC_xHqqkZx_
 *				_xZkqqHx_iMlEiIpGiCmNiBeB_xHqqkZx_DynamicDrawView::LimitMP
 *			99.05.21 Fukushiro M. FFOPCalcNewP_xZkqqHx_iKnGjAjE_xHqqkZx_(ObjPoly.cpp)_xZkqqHx_iCmM_xHqqkZx_
 *				DBLLine::GetNearest_xZkqqHx_iKnGjAjEiCmJiCkIiCkCiCmEiBeBjBoFiCkLiCmIiMoLiNlHiCkKjAlGiClGiClNiBeC_xHqqkZx_
 *				DBLLine_xZkqqHx_iCmMiNoMjAkMiOjOiCmJiBeBjAiCjClMiCkJiCoHiLmJiCnPiCmEjEpHjHmKiCmJiClIiCoKiClNiCfBjDfPiCpA_xHqqkZx_
 *				_xZkqqHx_jAnNjCoIiClFiClNiClNiCnPiBeB_xHqqkZx_DBLLine::m_dA_xZkqqHx_iCkKiLmJiPkMjCgMiCmJiCmIiCmBiCmEiClFiCnMiCmBiClNiClNiCnPiBeC_xHqqkZx_
 *				_xZkqqHx_iClBiCoKiCmJjBmOiPiIiClHiCoJiClNiCnPiBeB_xHqqkZx_abouteq_xZkqqHx_iCpAjCoIiLgAiClFiBeBiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/

#include <crtdbg.h>		// For _ASSERT.

//;----- <EXPORT TO SDK> -----;

enum FDDLType
{
	FDDL_VERT,
	FDDL_HORIZ,
	FDDL_SLANT,
}; // enum FDDLType.

class DBLLine
{
public:
//;----- </EXPORT TO SDK> -----;

	DBLLine ();
	DBLLine (const DBLPoint& mmptP, const DBLPoint& mmptQ);
	DBLLine (const DBLPoint& mmptP, const DBLPoint& mmptQ, double mmW);
	void	SetPoints (const DBLPoint& mmptP, const DBLPoint& mmptQ);
	void	SetPoints (const DBLPoint& mmptP, const DBLPoint& mmptQ, double mmW);

	BOOL	IsVertical () const;
	BOOL	IsHorizontal () const;
// 05.05.09 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	BOOL	IsMostEqual (const DBLLine& L) const;
	BOOL	operator == (const DBLLine& L) const;
	// _xZkqqHx_iClBiCmMjClMjApMiCmGjClMjApM_xHqqkZx_L_xZkqqHx_iCkKjFlNiNhDiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
	BOOL	operator || (const DBLLine& L) const;
	// _xZkqqHx_iClBiCmMjClMjApMiCmGjClMjApM_xHqqkZx_L_xZkqqHx_iCkKjFhDjFlNiNhDiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
	BOOL	operator && (const DBLLine& L) const;
	// _xZkqqHx_iClBiCmMjClMjApMiCmGjClMjApM_xHqqkZx_L_xZkqqHx_iCkKiMpAiNlHiClHiCoJjDfPiCpAjFnEiClHiBeC_xHqqkZx_
	DBLPoint operator & (const DBLLine& L) const;

	double	GetX (double mmY) const;
	double	GetY (double mmX) const;
	// _xZkqqHx_jDfP_xHqqkZx_mmptQ_xZkqqHx_iCmJiNmFiCoAiLnPiCkCiBeBiClBiCmMjClMjApMiPoDiCmMjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
	DBLPoint GetNearest (const DBLPoint& mmptQ) const;
	// _xZkqqHx_iClBiCmMjClMjApMiCmG_xHqqkZx_90_xZkqqHx_jDhIiCmJiMpAiNlHiClHiCoJiBeBjDfP_xHqqkZx_mmpt_xZkqqHx_iPoDiCpAjCmKiCoJjClMjApMiCpAjFnEiClHiBeC_xHqqkZx_
	DBLLine	GetCrossLine (const DBLPoint& mmpt) const;
	// _xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCkJiCoHiLjHjHkDiCkK_xHqqkZx_Q_xZkqqHx_iCmFiCkAiCoJiBeBjClMjApM_xHqqkZx_GH_xZkqqHx_iPoDiCmMjDfP_xHqqkZx_ B0, B1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_DBLLine.mdrw _xZkqqHx_iOfBiPmGiBeC_xHqqkZx_
	void	GetDistancePoint (DBLPoint& mmptB0, DBLPoint& mmptB1,
								const DBLPoint& mmptO, double mmQ);
	// _xZkqqHx_jDfP_xHqqkZx_mmpt_xZkqqHx_iCkKiCnJiCnKjClMjApMiPoDiCmJiCkAiCoJiCkJiCmHiCkEiCkJiBeC_xHqqkZx_
	BOOL	IsMostOnLine (const DBLPoint& mmpt) const;

friend BOOL abouteq (const DBLLine& a, const DBLLine& b);
private:
//;----- <EXPORT TO SDK> -----;
	short	m_nType;
	double	m_dA;
	double	m_dB;
}; // class DBLLine.

//;----- </EXPORT TO SDK> -----;

inline BOOL abouteq (const DBLLine& a, const DBLLine& b);

//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_.

inline DBLLine::DBLLine () {}

inline DBLLine::DBLLine (const DBLPoint& mmptP, const DBLPoint& mmptQ)
{
	SetPoints(mmptP, mmptQ);
} // DBLLine::DBLLine.

inline DBLLine::DBLLine (const DBLPoint& mmptP, const DBLPoint& mmptQ, double mmW)
{
	SetPoints(mmptP, mmptQ, mmW);
} // DBLLine::DBLLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::SetPoints
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jClMjApMiCkKjCmKiJnPiClHiCoJjDpBiCmCiCmMjDfPiCpAiOhHjCoIiClHiCoJiClBiCmGiCmJiCoGiCoIiBeB_xHqqkZx_DBLLine_xZkqqHx_iCpA_xHqqkZx_
 *			_xZkqqHx_iPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptP, mmptQ :_xZkqqHx_iCfBiCmCiCmMjDfP_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.21 Fukushiro M. _xZkqqHx_jAiFjFlNjApMiCmJjBmOiJjO_xHqqkZx_.
 *			99.05.21 Fukushiro M. FFOPCalcNewP_xZkqqHx_iKnGjAjE_xHqqkZx_(ObjPoly.cpp)_xZkqqHx_iCmM_xHqqkZx_
 *				DBLLine::GetNearest_xZkqqHx_iKnGjAjEiCmJiCkIiCkCiCmEiBeBjBoFiCkLiCmIiMoLiNlHiCkKjAlGiClGiClNiBeC_xHqqkZx_
 *				DBLLine_xZkqqHx_iCmMiNoMjAkMiOjOiCmJiBeBjAiCjClMiCkJiCoHiLmJiCnPiCmEjEpHjHmKiCmJiClIiCoKiClNiCfBjDfPiCpA_xHqqkZx_
 *				_xZkqqHx_jAnNjCoIiClFiClNiClNiCnPiBeB_xHqqkZx_DBLLine::m_dA_xZkqqHx_iCkKiLmJiPkMjCgMiCmJiCmIiCmBiCmEiClFiCnMiCmBiClNiClNiCnPiBeC_xHqqkZx_
 *				_xZkqqHx_iClBiCoKiCmJjBmOiPiIiClHiCoJiClNiCnPiBeB_xHqqkZx_abouteq_xZkqqHx_iCpAjCoIiLgAiClFiBeBiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
inline void DBLLine::SetPoints (const DBLPoint& mmptP, const DBLPoint& mmptQ)
{
	if (abouteq(mmptP.x, mmptQ.x))
	/*----- _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		m_nType = FDDL_VERT;
		m_dA = 0.0;
		m_dB = mmptP.x;

	} else if (abouteq(mmptP.y, mmptQ.y))
	/*----- _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		m_nType = FDDL_HORIZ;
		m_dA = 0.0;
		m_dB = mmptP.y;

	} else
	/*----- _xZkqqHx_iOmOjApMiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		m_nType = FDDL_SLANT;
		m_dA = (mmptQ.y - mmptP.y) / (mmptQ.x - mmptP.x);
		m_dB = (mmptQ.x * mmptP.y - mmptQ.y * mmptP.x) / (mmptQ.x - mmptP.x);
	}
} // DBLLine::SetPoints.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::SetPoints
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_P_xZkqqHx_iCmGjDfP_xHqqkZx_Q_xZkqqHx_iCpAjCmKiCoJjApM_xHqqkZx_ L _xZkqqHx_iCmGjFlNiNhDiKiOiCmC_xHqqkZx_ L _xZkqqHx_iCmG_xHqqkZx_mmW_xZkqqHx_iCmMiLjHjHkDiCpAjChFiCkNjApM_xHqqkZx_ M _xZkqqHx_iCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *			X_xZkqqHx_iOlCiCkKiJeFjFpLiMpMiBeB_xHqqkZx_Y_xZkqqHx_iOlCiCkKiJlKjFpLiMpMiCmFiCkAiCoIiBeB_xHqqkZx_mmW_xZkqqHx_iCkKjAlDiCmMiOjOiBeB_xHqqkZx_M _xZkqqHx_iCmN_xHqqkZx_ L _xZkqqHx_iCpAjDfP_xHqqkZx_P_xZkqqHx_iCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jDfP_xHqqkZx_Q_xZkqqHx_iCnGiMpMiCkJiCkEiOjOiBeBiJeFjBkEiCmJiMkJiCkGiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptP	:_xZkqqHx_jDfP_xHqqkZx_
 *			mmptQ	:_xZkqqHx_jDfP_xHqqkZx_
 *			mmW		:_xZkqqHx_iLjHjHkD_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.21 Fukushiro M. _xZkqqHx_jAiFjFlNjApMiCmJjBmOiJjO_xHqqkZx_.
 *			99.05.21 Fukushiro M. FFOPCalcNewP_xZkqqHx_iKnGjAjE_xHqqkZx_(ObjPoly.cpp)_xZkqqHx_iCmM_xHqqkZx_
 *				DBLLine::GetNearest_xZkqqHx_iKnGjAjEiCmJiCkIiCkCiCmEiBeBjBoFiCkLiCmIiMoLiNlHiCkKjAlGiClGiClNiBeC_xHqqkZx_
 *				DBLLine_xZkqqHx_iCmMiNoMjAkMiOjOiCmJiBeBjAiCjClMiCkJiCoHiLmJiCnPiCmEjEpHjHmKiCmJiClIiCoKiClNiCfBjDfPiCpA_xHqqkZx_
 *				_xZkqqHx_jAnNjCoIiClFiClNiClNiCnPiBeB_xHqqkZx_DBLLine::m_dA_xZkqqHx_iCkKiLmJiPkMjCgMiCmJiCmIiCmBiCmEiClFiCnMiCmBiClNiClNiCnPiBeC_xHqqkZx_
 *				_xZkqqHx_iClBiCoKiCmJjBmOiPiIiClHiCoJiClNiCnPiBeB_xHqqkZx_abouteq_xZkqqHx_iCpAjCoIiLgAiClFiBeBiOgHjHhAiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
inline void DBLLine::SetPoints (const DBLPoint& mmptP, const DBLPoint& mmptQ, double mmW)
{
	if (abouteq(mmptP.x, mmptQ.x))
	/*----- _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		m_nType = FDDL_VERT;
		m_dA = 0.0;
		if (mmptP.y < mmptQ.y)	// _xZkqqHx_iJlKjFpLiMpMiCmMjApMiCmMiPoKiNiHiBeC_xHqqkZx_
			m_dB = mmptQ.x - mmW;
		else					// _xZkqqHx_iPoDjFpLiMpMiCmMjApMiCmMiPoKiNiHiBeC_xHqqkZx_
			m_dB = mmptQ.x + mmW;

	} else if (abouteq(mmptP.y, mmptQ.y))
	/*----- _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		m_nType = FDDL_HORIZ;
		m_dA = 0.0;
		if (mmptP.x < mmptQ.x)	// _xZkqqHx_iJeFjFpLiMpMiCmMjApMiCmMiPoKiNiHiBeC_xHqqkZx_
			m_dB = mmptQ.y + mmW;
		else					// _xZkqqHx_iNlGjFpLiMpMiCmMjApMiCmMiPoKiNiHiBeC_xHqqkZx_
			m_dB = mmptQ.y - mmW;

	} else
	/*----- _xZkqqHx_iOmOjApMiCmMiPoKiNiH_xHqqkZx_ -----*/
	{
		m_nType = FDDL_SLANT;
		DBLPoint mmptT = mmptQ - mmptP;
		m_dA = mmptT.y / mmptT.x;
		m_dB = (mmptT.Len() * mmW +
				mmptQ.x * mmptP.y - mmptQ.y * mmptP.x) / mmptT.x;
	}
} // DBLLine::SetPoints.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::IsVertical
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMiCkKjAiCjClMiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_jAiCjClM_xHqqkZx_
 *			FALSE	: _xZkqqHx_jAiCjClMiCmFiCmNiCmIiCkC_xHqqkZx_
 *************************************************************************/
inline BOOL DBLLine::IsVertical () const
{
	return m_nType == FDDL_VERT;
} // DBLLine::IsVertical.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::IsHorizontal
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jApMiCkKjAiFjFlNiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: _xZkqqHx_jAiFjFlN_xHqqkZx_
 *			FALSE	: _xZkqqHx_jAiFjFlNiCmFiCmNiCmIiCkC_xHqqkZx_
 *************************************************************************/
inline BOOL DBLLine::IsHorizontal () const
{
	return m_nType == FDDL_HORIZ;
} // DBLLine::IsHorizontal.

//----- 05.05.09 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::IsMostEqual
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfBjApMiCkKiCnJiCnKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	L	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMjApMiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCnKjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCkEiCmFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCObjWidePoly::OmitAxisPoly_xZkqqHx_iCmMiClNiCnPiCmJjDlBjDpMiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
// *************************************************************************/
//inline BOOL DBLLine::IsMostEqual (const DBLLine& L) const
//{
//	return (m_nType == L.m_nType) &&
//			abouteq(m_dA, L.m_dA) && abouteq(m_dB, L.m_dB);
//} // DBLLine::IsMostEqual.
//----- 05.05.09 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::operator == (const DBLLine& L) const
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiCmCiCmMjApMiCkKjDkPiClGiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeBiClLiCkEiCmFiCmIiCkCiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	L	: _xZkqqHx_iCoAiCkEiIoKjFpLiCmMjApMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfOiLfFiBeC_xHqqkZx_
 *************************************************************************/
inline BOOL DBLLine::operator == (const DBLLine& L) const
{
// 99.06.14 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return (m_nType == L.m_nType) && (m_dA == L.m_dA) && (m_dB == L.m_dB);
	return (m_nType == L.m_nType) &&
			almosteq(m_dA, L.m_dA) && almosteq(m_dB, L.m_dB);
} // DBLLine::operator ==.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::operator || (const DBLLine& L) const
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiCmCiCmMjApMiCkKjFlNiNhDiCmIiCoHiCmO_xHqqkZx_TRUE_xZkqqHx_iBeBjFhDjFlNiNhDiCmIiCoHiCmO_xHqqkZx_FALSE_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	L	: _xZkqqHx_iCoAiCkEiIoKjFpLiCmMjApMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfOiLfFiBeC_xHqqkZx_
 *************************************************************************/
inline BOOL DBLLine::operator || (const DBLLine& L) const
{
	if (m_nType != L.m_nType) return FALSE;
	if (m_nType == FDDL_VERT || m_nType == FDDL_HORIZ) return TRUE;
// 99.06.14 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	return m_dA == L.m_dA;
	return almosteq(m_dA, L.m_dA);
} // DBLLine::operator ||.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::operator && (const DBLLine& L) const
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiCmCiCmMjApMiCkKjFlNiNhDiCmIiCoHiCmOiLfFiBeBjFhDjFlNiNhDiCmIiCoHiCmOjAfOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	L	: _xZkqqHx_iCoAiCkEiIoKjFpLiCmMjApMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAfOiLfFiBeC_xHqqkZx_
 *************************************************************************/
inline BOOL DBLLine::operator && (const DBLLine& L) const
{
//----- 01.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	return !operator || (L);
//----- 01.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (m_nType != L.m_nType) return TRUE;
	if (m_nType == FDDL_VERT || m_nType == FDDL_HORIZ) return FALSE;
	return !almosteq(m_dA, L.m_dA);
//----- 01.04.01 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // DBLLine::operator &&.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::operator & (const DBLLine& L) const
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpBiCmCiCmMjApMiCmMiMpAiNlHiClHiCoJjDfPiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	L	: _xZkqqHx_iCoAiCkEiIoKjFpLiCmMjApMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iMpAiNlHiClHiCoJjDfPiCmMiNmAjFfHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iClBiCmMiKnGjAjEiOmAiNhDjBePiCmJiCfBiCmCiCmMjApMiCkKjFhDjFlNiNhDiCmFiCkAiCoJiClBiCmGiCpAiKgNjEeGiClHiCoJjFeLjHhGiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.21 Fukushiro M. _xZkqqHx_jAiFjFlNjApMiCmJjBmOiJjO_xHqqkZx_.
 *************************************************************************/
inline DBLPoint DBLLine::operator & (const DBLLine& L) const
{
	DBLLine mmlnSlant;	// _xZkqqHx_iOmOjApM_xHqqkZx_.
	DBLLine mmlnAny;	// _xZkqqHx_iOmOjApMiImIiKePiCmMjApM_xHqqkZx_.

	if (m_nType == FDDL_SLANT)
	{
		mmlnSlant = *this;
		mmlnAny = L;
	} else if (L.m_nType == FDDL_SLANT)
	{
		mmlnSlant = L;
		mmlnAny = *this;
	} else
	{
		if (m_nType == FDDL_VERT)
			return DBLPoint(m_dB, L.m_dB);
		else
			return DBLPoint(L.m_dB, m_dB);
	}

	switch (mmlnAny.m_nType)
	{
	case FDDL_VERT:
		return DBLPoint(mmlnAny.m_dB, mmlnSlant.GetY(mmlnAny.m_dB));

	case FDDL_HORIZ:
		return DBLPoint(mmlnSlant.GetX(mmlnAny.m_dB), mmlnAny.m_dB);

	default: // FDDL_SLANT:
//----- 00.09.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		_ASSERT(!almost0(mmlnSlant.m_dA - mmlnAny.m_dA));
//----- 00.09.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		return DBLPoint(
			(mmlnAny.m_dB - mmlnSlant.m_dB) / (mmlnSlant.m_dA - mmlnAny.m_dA),
			(mmlnSlant.m_dA * mmlnAny.m_dB - mmlnSlant.m_dB * mmlnAny.m_dA) /
										(mmlnSlant.m_dA - mmlnAny.m_dA));
	}
}	// DBLLine::operator &.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::GetX
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Y_xZkqqHx_iCmMjCgMiCmJjBmOiJjOiClHiCoJ_xHqqkZx_X_xZkqqHx_iCpAiMhGiOfKiClFiBeBjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmY	: Y
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	X
 *************************************************************************/
inline double DBLLine::GetX (double mmY) const
{
	_ASSERT(m_nType != FDDL_HORIZ);
	if (m_nType == FDDL_VERT) return m_dB;
//----- 00.09.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	_ASSERT(!almost0(m_dA));
//----- 00.09.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
	return (mmY - m_dB) / m_dA;
} // DBLLine::GetX.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::GetY
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	X_xZkqqHx_iCmMjCgMiCmJjBmOiJjOiClHiCoJ_xHqqkZx_Y_xZkqqHx_iCpAiMhGiOfKiClFiBeBjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmX	: X
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	Y
 *************************************************************************/
inline double DBLLine::GetY (double mmX) const
{
	_ASSERT(m_nType != FDDL_VERT);
	if (m_nType == FDDL_HORIZ) return m_dB;
	return m_dA * mmX + m_dB;
} // DBLLine::GetY.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::GetNearest
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNjDfPiCmJiNmFiCoAiLnPiCkCjClMjApMiPoDiCmMjDfPiCmMiNmAjFfHiCpAjFnEiClHiBeC_xHqqkZx_
 *			_xZkqqHx_jAnNiMhGiDgNiBfLiDgH_xHqqkZx_P229,P228.
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmptP	: _xZkqqHx_iClBiCmMjDfPiCmJiNmFiCoAiLnPiCkCjDfPiCpAiLiBiCnPiCoJ_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	mmptP_xZkqqHx_iCmJiNmFiCoAiLnPiCkCjClMjApMiPoDiCmMjDfP_xHqqkZx_.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.10.09 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline DBLPoint DBLLine::GetNearest (const DBLPoint& mmptP) const
{
	// _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiH_xHqqkZx_.
	if (m_nType == FDDL_VERT) return DBLPoint(GetX(mmptP.y), mmptP.y);
	// _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiH_xHqqkZx_.
	if (m_nType == FDDL_HORIZ) return DBLPoint(mmptP.x, GetY(mmptP.x));
	// P_xZkqqHx_iPoDiCpAjCmKiCoJjAiFjFlNjApMiCmGjClMjApMiCkKiMpAiCoNiCoJjDfP_xHqqkZx_O_xZkqqHx_iCpAiLiBiCnPiCoJiBeC_xHqqkZx_
	DBLPoint mmptO(GetX(mmptP.y), mmptP.y);
	// P_xZkqqHx_iPoDiCpAjCmKiCoJjAiCjClMjApMiCmGjClMjApMiCkKiMpAiCoNiCoJjDfP_xHqqkZx_A_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
	DBLPoint mmptA(mmptP.x, GetY(mmptP.x));
//----- 01.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// P_xZkqqHx_iCkKjClMjApMiPoDiCmJiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
////----- 01.01.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////	if (mmptO == mmptP) return mmptP;
////----- 01.01.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//	if (almosteq(mmptO, mmptP)) return mmptP;
////----- 01.01.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 01.04.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	double mmL2 = (mmptP.x - mmptO.x) * (mmptP.x - mmptO.x);
	double mmM2 = (mmptA.y - mmptP.y) * (mmptA.y - mmptP.y);
//----- 01.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
////----- 00.09.20 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
//	ASSERT(!almost0(mmL2 + mmM2));
////----- 00.09.20 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
//----- 01.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// l^2 + m^2 == 0_xZkqqHx_iCmIiCoHiCmOiBeB_xHqqkZx_P == S_xZkqqHx_iBeCjAlDiKgNiCmJjApMiPoDiCmJiCkAiCoJiClBiCmGiCpAiKpKiClHiClNiCnPiBeBjDfP_xHqqkZx_O_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (about0(mmL2 + mmM2)) return mmptO;
//----- 01.04.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	return (mmptA - mmptO) * mmL2 / (mmL2 + mmM2) + mmptO;

}	// DBLLine::GetNearest.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::GetCrossLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMjClMjApMiCmG_xHqqkZx_90_xZkqqHx_jDhIiCmJiMpAiNlHiClHiCoJiBeBjDfP_xHqqkZx_mmpt_xZkqqHx_iPoDiCpAjCmKiCoJjClMjApMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	mmpt	:_xZkqqHx_jDfPiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jClMjApMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline DBLLine DBLLine::GetCrossLine (const DBLPoint& mmpt) const
{
	DBLLine L;
	switch (m_nType)
	{
	case FDDL_VERT:		//----- _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
		L.m_nType = FDDL_HORIZ;
		L.m_dA = 0.0;
		L.m_dB = mmpt.y;
		break;

	case FDDL_HORIZ:	//----- _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiH_xHqqkZx_ -----
		L.m_nType = FDDL_VERT;
		L.m_dA = 0.0;
		L.m_dB = mmpt.x;
		break;

	default:			//----- _xZkqqHx_iOmOjApMiCmMiPoKiNiH_xHqqkZx_ -----
		L.m_nType = FDDL_SLANT;
		L.m_dA = -1.0 / m_dA;
		L.m_dB = mmpt.y - L.m_dA * mmpt.x;
	}
	return L;
} // DBLLine::GetCrossLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::GetDistancePoint
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_O_xZkqqHx_iCkJiCoHiLjHjHkDiCkK_xHqqkZx_Q_xZkqqHx_iCmFiCkAiCoJiBeBjClMjApM_xHqqkZx_GH_xZkqqHx_iPoDiCmMjDfP_xHqqkZx_ B0, B1 _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *			DBLLine.mdrw _xZkqqHx_iOfBiPmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline void DBLLine::GetDistancePoint (DBLPoint& mmptB0, DBLPoint& mmptB1,
										const DBLPoint& mmptO, double mmQ)
{
	DBLPoint mmptS = GetNearest(mmptO);
	double mmU = sqrt((mmQ * mmQ) - (mmptS - mmptO).PowLen());
	double mmTmp;
	switch (m_nType)
	{
	case FDDL_VERT:		//----- _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
		mmptB0.x = mmptS.x;
		mmptB1.x = mmptS.x;
		mmptB0.y = mmptS.y + mmU;
		mmptB1.y = mmptS.y - mmU;
		break;

	case FDDL_HORIZ:	//----- _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiH_xHqqkZx_ -----
		mmptB0.x = mmptS.x + mmU;
		mmptB1.x = mmptS.x - mmU;
		mmptB0.y = mmptS.y;
		mmptB1.y = mmptS.y;
		break;

	default:			//----- _xZkqqHx_iOmOjApMiCmMiPoKiNiH_xHqqkZx_ -----
		mmTmp = mmU / sqrt(1 + m_dA * m_dA);
		mmptB0.x = mmptS.x + mmTmp;
		mmptB1.x = mmptS.x - mmTmp;
		mmptB0.y = GetY(mmptB0.x);
		mmptB1.y = GetY(mmptB1.x);
	}
} // DBLLine::GetDistancePoint.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DBLLine::IsMostOnLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDfP_xHqqkZx_mmpt_xZkqqHx_iCkKiCnJiCnKjClMjApMiPoDiCmJiCkAiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL DBLLine::IsMostOnLine (const DBLPoint& mmpt) const
{
	switch (m_nType)
	{
	case FDDL_VERT:		//----- _xZkqqHx_jAiCjClMjApMiCmMiPoKiNiH_xHqqkZx_ -----
		return almosteq(m_dB, mmpt.x);

	case FDDL_HORIZ:	//----- _xZkqqHx_jAiFjFlNjApMiCmMiPoKiNiH_xHqqkZx_ -----
		return almosteq(m_dB, mmpt.y);

	default:			//----- _xZkqqHx_iOmOjApMiCmMiPoKiNiH_xHqqkZx_ -----
		// _xZkqqHx_jAiFjFlNiCmJiLnPiCkCiOmOjApMiBeFjAiCjClMiCmJiLnPiCkCiOmOjApMiCmMiCmHiClPiCoHiCmFiCoAjBmOiJjOiCmFiCkLiCoJiCoGiCkEiCmJiBeB_xHqqkZx_
		// _xZkqqHx_jDpBiCmCiCmMjCgMiCmMiCkCiClIiCoKiCkJiCkKiIoKjChGiClHiCoKiCmOiCoGiCkCiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
		return almosteq(GetY(mmpt.x), mmpt.y) ||
				almosteq(GetX(mmpt.y), mmpt.x);
	}
} // DBLLine::IsMostOnLine.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	abouteq
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfBjApMiCkKiCnJiCnKjDjJiClFiCkCiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	a, b	:_xZkqqHx_jClCiCnHiCoJjBmOiPnLiCmMjApMiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iCnJiCnKjDjJiClFiCkCiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeBiClLiCkEiCmFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	FCObjWidePoly::OmitAxisPoly_xZkqqHx_iCmMiClNiCnPiCmJjDlBjDpMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.01.04 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
inline BOOL abouteq (const DBLLine& a, const DBLLine& b)
{
	return (a.m_nType == b.m_nType) &&
			abouteq(a.m_dA, b.m_dA) && abouteq(a.m_dB, b.m_dB);
} // abouteq.

#endif//__DBLLine_h
