// DlgChipGroupOrder.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "DynamicDraw.h"
#include "FoundDoc.h"			// For g_pDoc.
#include "CommonDrawFrame.h"	// For FFCommonDrawFrame().
#include "UtilDlg.h"			// For FFJustifyWindow.
#include "DlgChipGroupOrder.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFCDlgChipGroupOrder _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::CFCDlgChipGroupOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CFCDlgChipGroupOrder::CFCDlgChipGroupOrder (CWnd* pParent /*=NULL*/)
	: BASE_CLASS(CFCDlgChipGroupOrder::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFCDlgChipGroupOrder)
		// _xZkqqHx_iDiBiDiC_xHqqkZx_ - ClassWizard _xZkqqHx_iCmNiClBiCmMiImKjChFiCmJiDhNiDgCiDhDiDjDiDePjHhAiCmMiDhNiDeOiDiNiCpAjCmHiJmBiCnMiClNiCmNiNoNiPjMiClFiCnMiClHiBeC_xHqqkZx_
	//}}AFX_DATA_INIT
} // CFCDlgChipGroupOrder::CFCDlgChipGroupOrder.

void CFCDlgChipGroupOrder::DoDataExchange(CDataExchange* pDX)
{
	BASE_CLASS::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFCDlgChipGroupOrder)
	DDX_Control(pDX, IDC_SGO_LSV_SHEET, m_listCtrl);
	//}}AFX_DATA_MAP
} // CFCDlgChipGroupOrder::DoDataExchange.

/////////////////////////////////////////////////////////////////////////////
// CFCDlgChipGroupOrder _xZkqqHx_iDiGiBfLiDfFiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::InitControl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgChipGroupOrder::InitControl ()
{
	DWORDSet stSelected;
	long lTopPos;
	BOOL bRecorded = (0 < m_listCtrl.GetItemCount());
	if (bRecorded)
	//----- _xZkqqHx_iKpJiCmJjAnNjCoIiClDiCoKiCmEiCkCiCoJiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_jBeJjBpAiDiKiDfIiDgHiCpAjFnLjBlGiBeC_xHqqkZx_
		POSITION pos = m_listCtrl.GetFirstSelectedItemPosition();
		while (pos)
			stSelected.insert(m_listCtrl.GetNextSelectedItem(pos));
		lTopPos = m_listCtrl.GetItemHeight() * m_listCtrl.GetTopIndex();
	}
	//----- _xZkqqHx_iMiLiJmKjFfMiOkGiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjAnNjCoI_xHqqkZx_ -----
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_listCtrl.ClearContents();
	for (ChipGroupID cgid = 0; cgid < g_pEnv->GetChipGroupIDSize(); cgid++)
	{
		if (g_pEnv->GetChipGroupRec(cgid) != NULL)
		{
			// _xZkqqHx_iDiMiDfCiBfLiDgIjAnNjCoIiBeC_xHqqkZx_m_vFreqChip_xZkqqHx_iDiBiDjDiDgPiBfLiCmNiDfCiDhDiBfLiClFiCmIiCkCiBeC_xHqqkZx_
			m_listCtrl.AppendRec(cgid, FCChipGroupRec(g_pEnv->GetChipGroupRec(cgid)->m_szName));
		} else
		{
			m_listCtrl.AddFreeId(cgid);
		}
	}
	// _xZkqqHx_iDfGiBfLiDgHjBhNjDpMiOjOiCmMiDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMiPiJiKpKjCgMiCpAiOhHjCoIiBeC_xHqqkZx_
	m_listCtrl.SetNextFreeId(g_pEnv->GetChipGroupIDSize());
	// _xZkqqHx_iDiMiDfCiBfLiDgIjFfMiOkGiPiHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_listCtrl.SetIdOrder(g_pEnv->GetFreqChipGroupVector().size(),
							g_pEnv->GetFreqChipGroupVector().begin());
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
	m_listCtrl.SetCurrentChipGroupId(FFCommonDrawFrame()->GetCurrentChipGroupId());
	if (bRecorded)
	//----- _xZkqqHx_iKpJiCmJjAnNjCoIiClDiCoKiCmEiCkCiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iMlDiCmMjBeJjBpAiDiKiDfIiDgHiCpAjAnNjCoIiBeC_xHqqkZx_
		DWORDSet::iterator iSt;
		for (iSt = stSelected.begin(); iSt != stSelected.end(); iSt++)
			m_listCtrl.SetItemState(*iSt, LVIS_SELECTED, LVIS_SELECTED);
		m_listCtrl.Scroll(CSize(0, lTopPos));
	} else
	//----- _xZkqqHx_jAnNjCoIiClDiCoKiCmEiCkCiCmIiCkJiCmBiClNiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmMjFjNiCmJiNiHiCoNiClJiCmEiDeKiDiJiDiAiCpAjAnNjCoIiBeC_xHqqkZx_
		m_listCtrl.UpdateColumnWidth();
	}
	// _xZkqqHx_iDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiBeC_xHqqkZx_
	m_listCtrl.SetFocus();
} // CFCDlgChipGroupOrder::InitControl.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::IsChipGroupChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiPoOjFpBiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgChipGroupOrder::IsChipGroupChanged () const
{
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCkKjFmPiNfIiClDiCoKiCmEiCkCiCoJiCkJiBeI_xHqqkZx_
	if (m_listCtrl.GetCurrentChipGroupId() != FFCommonDrawFrame()->GetCurrentChipGroupId())
		return TRUE;
	if (!m_listCtrl.GetInsertedIdSet().empty()) return TRUE;
	if (!m_listCtrl.GetRemovedIdSet().empty()) return TRUE;
	if (!m_listCtrl.GetChangedIdSet().empty()) return TRUE;
	FDChipGroupIDVector vcgid;
	m_listCtrl.GetIdOrder(vcgid);
	if (vcgid != g_pEnv->GetFreqChipGroupVector()) return TRUE;
	return FALSE;
} // CFCDlgChipGroupOrder::IsChipGroupChanged.

BEGIN_MESSAGE_MAP(CFCDlgChipGroupOrder, BASE_CLASS)
	//{{AFX_MSG_MAP(CFCDlgChipGroupOrder)
	ON_BN_CLICKED(ID_APPLY_NOW, OnApplyNow)
	ON_BN_CLICKED(IDC_SGO_BTN_CHIP_GROUP_MODIFY, OnSgoBtnChipGroupModify)
	ON_BN_CLICKED(IDC_SGO_BTN_CHIP_GROUP_ADD, OnSgoBtnChipGroupAdd)
	ON_BN_CLICKED(IDC_SGO_BTN_CHIP_GROUP_DELETE, OnSgoBtnChipGroupDelete)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_USER_MULTICTRL_CHANGED, OnUserMultictrlChanged)
	ON_MESSAGE(WM_USER_LISTCTRL_SELCHANGED, OnUserListctrlSelchanged)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFCDlgChipGroupOrder _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::OnInitDialog
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfPiDeDiDeBiDiNiDePiPiJiKpKiJlLiPiIjHjNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL CFCDlgChipGroupOrder::OnInitDialog ()
{
	// Superclass_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	BASE_CLASS::OnInitDialog();
	// _xZkqqHx_iDfGiBfLiDgHiDiKiDfIiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMiPiJiKpKiJlLiBeC_xHqqkZx_
	m_listCtrl.Initialize();

	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	InitControl();

	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCfAiImKjFfMiOkGiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	::SetUnitString(m_hWnd);
	// _xZkqqHx_jHjIiCkLjIhCjBmOiJjOjFlGiOjKjHpBiCmMjAnNjCoIiCpAiNhDiCkEiBeC_xHqqkZx_
	::RightByLeftHand(m_hWnd);
	// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCpAiDhNiDeFiDfIiImKjChFiCmJiInKjDkOiBeC_xHqqkZx_
	FFJustifyWindow(m_hWnd);
	// _xZkqqHx_iDfGiBfLiDgHiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
	PostMessage(WM_USER_MULTICTRL_CHANGED, 0, 0);
	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
} // CFCDlgChipGroupOrder::OnInitDialog.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::OnOK
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCgOiCgKiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgChipGroupOrder::OnOK ()
{
	// _xZkqqHx_jFmPiNfIiCkAiCoKiCmOiBeBjFmPiNfIiPiIjHjNiBeC_xHqqkZx_
	if (IsChipGroupChanged() && FFCanEditDocumentEnv()) OnApplyNow();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	BASE_CLASS::OnOK();
} // CFCDlgChipGroupOrder::OnOK.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::OnApplyNow
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iBhFjDeLjHhAiDhLiDfOiDjDiBhGiCkKiJjPiClDiCoKiClNiCmGiCkLiCmJiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgChipGroupOrder::OnApplyNow ()
{
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiKeKiOgOiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->SessionBegin();

	//----- _xZkqqHx_iNoNiPjMiDeBiDeDiDgFiDiAiDiKiDfIiDgHiCpAiOoGiCoIiPgPiClFiBeBiDeBiDeDiDgFiDiAiCpAiNoNiPjMiClHiCoJ_xHqqkZx_ -----
	DWORDSet::const_reverse_iterator rSt;
	for (rSt = m_listCtrl.GetRemovedIdSet().rbegin();
		 rSt != m_listCtrl.GetRemovedIdSet().rend(); rSt++)
	{
		g_pDoc->CmdDelete1ChipGroup(*rSt);
	}
	//-----	_xZkqqHx_jBhNjDpMiDeBiDeDiDgFiDiAiDiKiDfIiDgHiCpAiOoGiCoIiPgPiClFiBeBiDeBiDeDiDgFiDiAiCpAjBhNjDpMiClHiCoJ_xHqqkZx_ -----
	DWORDSet::const_iterator iSt;
	for (iSt = m_listCtrl.GetInsertedIdSet().begin();
		 iSt != m_listCtrl.GetInsertedIdSet().end(); iSt++)
	{
		ChipGroupID cgidNew;
		g_pDoc->CmdInsert1ChipGroup(cgidNew, *m_listCtrl.GetRec(*iSt), *iSt);
	}
	//-----	_xZkqqHx_jFmPiNfIiDeBiDeDiDgFiDiAiDiKiDfIiDgHiCpAiOoGiCoIiPgPiClFiBeBiDeBiDeDiDgFiDiAiCpAjFmPiNfIiClHiCoJ_xHqqkZx_ -----
	for (iSt = m_listCtrl.GetChangedIdSet().begin();
		 iSt != m_listCtrl.GetChangedIdSet().end(); iSt++)
	{
		g_pDoc->CmdModify1ChipGroup(*m_listCtrl.GetRec(*iSt), *iSt);
	}
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	if (!m_listCtrl.GetChangedIdSet().empty())
//	{
//		// _xZkqqHx_iDhCiDiFiBfLiCpAiNmEjFgAiJoGiBeC_xHqqkZx_
//		g_pView->SetClientToRgn();
//		g_pView->SendRgnRedraw();
//	}
//----- 01.03.25 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	//----- _xZkqqHx_iDeBiDeDiDgFiDiAjFfMiOkGiPiHiPjIiCpAjFmPiNfIiClHiCoJ_xHqqkZx_ -----
	FDChipGroupIDVector vcgid;
	m_listCtrl.GetIdOrder(vcgid);
	g_pDoc->CmdReOrderChipGroup(vcgid.begin(), vcgid.size());
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDfGiBfLiDgHiCmMjFmPiNfIiBeC_xHqqkZx_
	FFGetMainWnd()->PostMessage(WM_USER_UPDATE_CHIP_STORE,
								0,
								LPARAM(m_listCtrl.GetCurrentChipGroupId()));
//----- 01.09.16 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfKiDgCiDfGiDiHiDjDiPeJjHlJiPiIjHjNiBeC_xHqqkZx_
	g_pDoc->SessionEnd();
//----- 01.03.25 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	InitControl();
	// _xZkqqHx_iDfGiBfLiDgHiCmMjFmPiNfIiCpAjCmKjCgNiBeC_xHqqkZx_
	PostMessage(WM_USER_MULTICTRL_CHANGED, 0, 0);
} // CFCDlgChipGroupOrder::OnApplyNow.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::OnUserMultictrlChanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmJjFmPiNfIiCkKiCkAiCmBiClNiCmGiCkLjCmKjCgNiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jGkCiOgHjHhAiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iPoNiCmJ_xHqqkZx_1.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCDlgChipGroupOrder::OnUserMultictrlChanged (WPARAM wParam, LPARAM lParam)
{
	GetDlgItem(ID_APPLY_NOW)->EnableWindow(IsChipGroupChanged() && FFCanEditDocumentEnv());
	GetDlgItem(IDC_SGO_BTN_CHIP_GROUP_MODIFY)->EnableWindow(m_listCtrl.CanChangeItem());
	GetDlgItem(IDC_SGO_BTN_CHIP_GROUP_ADD)->EnableWindow(m_listCtrl.CanInsertItemNext());
	GetDlgItem(IDC_SGO_BTN_CHIP_GROUP_DELETE)->EnableWindow(m_listCtrl.CanDeleteItem());
	return 1;
} // CFCDlgChipGroupOrder::OnUserMultictrlChanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::OnUserListctrlSelchanged
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDfCiDjDiDgHiDiNiBfLiDiLiCmMjBeJjBpAiCkKjFmPiNfIiClDiCoKiClNiOjOiCmJiOmAiNhDiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wParam	:_xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
 *			lParam	:_xZkqqHx_jBeJjBpAiClDiCoKiClNiDeBiDeDiDgFiDiAiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
LRESULT CFCDlgChipGroupOrder::OnUserListctrlSelchanged (WPARAM wParam, LPARAM lParam)
{
	return OnUserMultictrlChanged(0,0);
} // CFCDlgChipGroupOrder::OnUserListctrlSelchanged.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::OnSgoBtnChipGroupModify
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFmPiNfIiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgChipGroupOrder::OnSgoBtnChipGroupModify ()
{
	m_listCtrl.PostMessage(WM_COMMAND, ID_RBTN_ITEM_CHANGE);
} // CFCDlgChipGroupOrder::OnSgoBtnChipGroupModify.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::OnSgoBtnChipGroupAdd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jCmHiJmBiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgChipGroupOrder::OnSgoBtnChipGroupAdd ()
{
	m_listCtrl.PostMessage(WM_COMMAND, ID_RBTN_ITEM_INSERT_NEXT);
} // CFCDlgChipGroupOrder::OnSgoBtnChipGroupAdd.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CFCDlgChipGroupOrder::OnSgoBtnChipGroupDelete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNoNiPjMiDhLiDfOiDjDiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.03.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void CFCDlgChipGroupOrder::OnSgoBtnChipGroupDelete ()
{
	m_listCtrl.PostMessage(WM_COMMAND, ID_RBTN_ITEM_DELETE);
} // CFCDlgChipGroupOrder::OnSgoBtnChipGroupDelete.
